import { Service } from '../../core/nqs/Services';
import VideoAnalyticsRequest from './VideoAnalyticsRequest';
import { Method } from '../../common/Constants';
import ExpirationManager from '../../common/ExpirationManager';
export default class VideoAnalyticsRequestHandler {
    private pluginRef;
    private _requests;
    private _waitingForToken;
    private _waitingForMetadata;
    private readyToSend;
    private servicesToWait;
    onWillSendVideoRequestListeners: ((serviceName: string, videoKey: string, params: Map<string, string>) => void)[];
    /**
     * Npaw Communication implements an abstraction layer over API requests.
     * Internally, Communication implements queues of {@link Request} objects.
     * This queue can be blocked using {@link Transform}
     *
     * @param plugin Reference to video analytics plugin
     */
    constructor(plugin: any);
    shouldSendStats(): boolean;
    /**
     * Enqueues the provided request
     *
     * @param {VideoAnalyticsRequest} request Request to be enqueued
     */
    sendRequest(request: VideoAnalyticsRequest): void;
    prepareParams(request: VideoAnalyticsRequest): void;
    /**
     * Build a generic request to the given host.
     *
     * @param {Service} service A string with the service to be called. ie...
     * @param {Object} [params] Object of key:value params.
     * @param {string} method Type of request (GET, POST, ...)
     * @param {any} body body of the request
     * @param {function} [onSuccessCallback] The defined onSuccess callback to the request
     * @param {function} [onFailCallback] The defined onFail callback to the request
     * @param {ExpirationManager} [expirationManager] Expiration Manager
     */
    buildRequest(service: Service, params: any, method?: Method, body?: any, onSuccessCallback?: () => void, onFailCallback?: () => void, expirationManager?: ExpirationManager): VideoAnalyticsRequest;
    /**
     * Execute pending requests in the queue. Returns rejected ones to the queue.
     */
    private _processRequests;
}
