/**
 * @class
 * @description This class connect to cdn the cdb balancer api and hepls to get data
 * @exports TestProfilesBusinessObject
 */
import Cdn from './../Loaders/Cdn';
import Loader from './../Loaders/Loader';
import { VideoSegment } from './../Storage/VideoSegment';
import PingTimeBean from './../Beans/PingTimeBean';
export default class TestProfilesBusinessObject {
    private static _instance;
    pingsTime: Map<string, PingTimeBean>;
    monitoring: Map<string, number>;
    private loader?;
    private _isMonitoring;
    private _cdns;
    private lastDownloadedSegment?;
    private shouldMonitor;
    private probeOnlyOnBanned;
    private noProbing;
    private constructor();
    static getInstance(loader?: Loader): TestProfilesBusinessObject;
    setLoader(loader: Loader): void;
    updateCdnList(cdns: Map<string, Cdn>): void;
    newDownloadedSegment(segment: VideoSegment): void;
    stopMonitor(): void;
    setHeadOnBannedOnly(onlyBanned?: boolean): void;
    setNoProbing(noProbing?: boolean): void;
    monitor(cdns: Map<string, Cdn>): Promise<void>;
    private getNextProbingSegment;
    private _afterCheck;
    private testCdn;
    private _performGetCheck;
    private _performHeadCheck;
    private _performCheck;
}
