/**
 * @class
 * @description Gives event emitting/listening functionalities to its extenders.
 * @exports Emitter
 * @abstract
 */
export default abstract class Emitter {
    private _listeners;
    /**
     * Sets a listener to a given event. Use emit(event) to trigger those events.
     * @param {string} eventName Name of the event.
     * @param {callback} callback Callback of the event. Receives event and data.
     * @return this
     * @public
     */
    on(eventName: string, callback: callback): Emitter;
    /**
     * Removes given callback from the listeners of this object.
     * @param {string} eventName Name of the event.
     * @param {callback} callback Callback of the event.
     * @return this
     * @public
     */
    off(eventName: string, callback?: callback): Emitter;
    /**
     * Emits given event, triggering all the associated callbacks.
     * @param {string} eventName Name of the event.
     * @param {object} data Custom data to be sent to the callbacks.
     * @param {string} customDataName Replaces the name of the data object for custom purposes.
     * @return this
     * @protected
     */
    protected emit(eventName: string, data?: {}, customDataName?: string): Emitter;
}
