/**
 * @class
 * @description Object that stores the plugin settings.
 * @exports BalancerOptions
 */
export default class BalancerOptions {
    profileName?: string;
    bucketName?: string;
    isLive?: boolean;
    videoId?: string;
    resource?: string;
    updateTime?: number;
    reportTime?: number;
    debug?: boolean;
    isDev?: boolean;
    timeBetweenHeads?: number;
    host?: string;
    forceDecisionCall?: boolean;
    domainWhitelist?: string[];
    domainWhitelistRegex?: string[];
    probeOnlyOnBanned?: boolean;
    noProbing?: boolean;
    allowSpecialDelimitersInUrl?: boolean;
    signManifestUsingApi?: boolean;
    balanceManifests?: boolean;
    balanceAudio?: boolean;
    balanceSubtitles?: boolean;
    dynamicRules?: dynamicRules;
    jwtToken?: string;
    jwtAuthType?: string;
    stripPathForDomainRegex?: string[];
    stripPathRegex?: string;
    chunkExpirationProbingMs?: number;
    /**
     * Constructs options object.
     * @param {constructionOptions} options JSON with the options to construct the balancer.
     */
    constructor(options?: constructionOptions);
}
