import Emitter from './Emitter';
/**
 * @type {headers}
 * Request headers.
 */
type headers = {
    [key: string]: string;
};
/**
 * @type {messageParams}
 * JSON with valid options to be sent in a message.
 */
type messageParams = {
    [key: string]: string | number | boolean | null | undefined;
};
/**
 * @class
 * @description Communication class that uses XHR requests.
 * It has events for the different expected received messages and the method send.
 * @extends Emitter
 * @exports XhrRequest
 */
export default class XhrRequest extends Emitter {
    private readonly _req;
    private readonly _host;
    private readonly _service;
    private readonly _method;
    private static _isSecure;
    /**
     * Constructs XhrRequest.
     * @param {string} host Host url
     * @param {string} service Service (endpoint) URL.
     * @param {XMLHttpRequestResponseType} respType Optional response type.
     * @param {string} method Request method, by default GET.
     */
    constructor(host: string, service: string, respType?: XMLHttpRequestResponseType, method?: string);
    /**
     * Sends the request built.
     * @param {messageParams} message Optional object of parameters that will be sent as url parameters.
     * @param {Object} headers Optional headers for the request.
     * @param {Object} body Request body.
     * @param {boolean} secure Optional to force the request to be https.
     * @public
     */
    send(message?: messageParams | string, headers?: headers, body?: undefined, secure?: boolean): void;
    /**
     * Returns the XHR object.
     * @returns {XMLHttpRequest} XHR request object.
     * @public
     */
    getXHR(): XMLHttpRequest;
    /**
     * Given a messageParams object builds a string to send them as URL params.
     * @param {messageParams} message Params object.
     * @returns {string} URL parameters.
     * @private
     * @static
     */
    private static _buildParams;
}
export {};
