import CoreStorage from '../core/storage/CoreStorage';
export default class ExpirationManager {
    private timeoutMs;
    private maxDurationMs;
    private coreStorage?;
    private firstRequestTime?;
    private lastRequestTime?;
    private expired;
    constructor(timeoutMs: number, maxDurationMs: number, coreStorage?: CoreStorage | undefined);
    /**
     * Called when a request is sent. Sets the "firstRequestTime" if not already set,
     * and updates "lastRequestTime" to now.
     */
    onRequestSent(): void;
    reset(): void;
    /**
     * Checks whether the session should be marked as expired, either because
     * the elapsed time since last request exceeds timeoutMs, or because the total
     * duration since first request exceeds maxDurationMs.
     *
     * @param currentExpirationTimeoutMs If provided and different from the current
     *                                   timeoutMs, update the internal timeoutMs.
     */
    checkExpiration(currentExpirationTimeoutMs?: number): void;
    /**
     * Returns whether the session or view has expired. This also implicitly
     * calls checkExpiration() once more to ensure it’s up to date.
     */
    isExpired(): boolean;
    /**
     * Session/View was started
     */
    isStarted(): boolean;
    /**
     * Check if is Active Session
     */
    isActive(): boolean;
}
