import NpawPluginOptions from './NpawPluginOptions';
export default class CoreOptions {
    /**
     * If true the plugin will store the events and send them later when there's connection
     * Default: false
     */
    offline: boolean;
    /**
     * Host of the Fastdata service
     * Default: 'lma.npaw.com'
     */
    private host;
    /**
     * To disable cookies storage fallback after local/sessionstorage
     * Default: true
     */
    disableCookies: boolean;
    /**
     * To force the use of cookies storage instead of local/sessionstorage
     * Default: false
     */
    forceCookies: boolean;
    /**
     * To disable all possible storages usage (cookies, localStorage, sessionStorage)
     * CAUTION: enabling this option session tracking may stop to work properly
     * Default: false
     */
    disableStorage: boolean;
    /**
     * Optional auth token to validate all the requests
     */
    authToken: string | undefined;
    /**
     * Optional auth type. Used if authToken is set.
     * 'Bearer' by default.
     */
    authType: string;
    constructor();
    /**
     * Updates core options based on the received
     * @param options AnalyticsOptions object
     */
    updateOptions(options: object): void;
    /**
     * Sets NPAW Plugin options that belong to the core
     * @param options
     */
    setNpawPluginOptions(options: NpawPluginOptions): void;
    isRefreshLMAConfigurationEnabled(): any;
    refreshLMAConfigurationSeconds(): any;
    getHost(): string;
    /**
     * Returns the FastData host
     *
     */
    getFastDataHost(): string;
}
