type ServiceMap = typeof Constants.Service;
export type Service = ServiceMap[keyof ServiceMap];
declare class Constants {
    static VideoService: {
        INIT: string;
        START: string;
        JOIN: string;
        PAUSE: string;
        RESUME: string;
        SEEK: string;
        BUFFER: string;
        ERROR: string;
        STOP: string;
        PING: string;
        DATA_OBJECT: string;
    };
    static Service: {
        readonly CDN: "/cdn";
        readonly VIDEO_EVENT: "/infinity/video/event";
        readonly AD_INIT: "/adInit";
        readonly AD_START: "/adStart";
        readonly AD_JOIN: "/adJoin";
        readonly AD_PAUSE: "/adPause";
        readonly AD_RESUME: "/adResume";
        readonly AD_BUFFER: "/adBufferUnderrun";
        readonly AD_STOP: "/adStop";
        readonly AD_CLICK: "/adClick";
        readonly AD_ERROR: "/adError";
        readonly AD_MANIFEST: "/adManifest";
        readonly AD_POD_START: "/adBreakStart";
        readonly AD_POD_STOP: "/adBreakStop";
        readonly AD_QUARTILE: "/adQuartile";
        readonly EVENT: "/infinity/session/event";
        readonly SESSION_START: "/infinity/session/start";
        readonly SESSION_STOP: "/infinity/session/stop";
        readonly NAV: "/infinity/session/nav";
        readonly BEAT: "/infinity/session/beat";
        readonly OFFLINE_EVENTS: "/offlineEvents";
        readonly INIT: string;
        readonly START: string;
        readonly JOIN: string;
        readonly PAUSE: string;
        readonly RESUME: string;
        readonly SEEK: string;
        readonly BUFFER: string;
        readonly ERROR: string;
        readonly STOP: string;
        readonly PING: string;
        readonly DATA_OBJECT: string;
        readonly DATA: "/data";
        readonly ADAPTERS: "/adapters";
        readonly CONFIGURATION: "/configuration";
        readonly APP_ANALYTICS_PLUGIN_LOGS: "/infinity/session/pluginLogs";
        readonly VIDEO_PLUGIN_LOGS: "/infinity/video/pluginLogs";
    };
}
export default Constants;
