import { Method } from '../../common/Constants';
/**
 * This static class provides utility methods.
 *
 * @class
 * @static
 */
export default class Util {
    static toQueryString(obj: {
        [key: string]: any;
    }): string;
    /**
     * Adds specific protocol. ie: [http://]nqs.nice264.com
     *
     * @param {string} url Domain of the service. Without protocol. ie: 'nqs.nice264.com'.
     * @param {boolean|null} [httpSecure]
     * If true will add https, if false http.
     * Otherwise will add //
     * @return Return the complete service URL.
     */
    static addProtocol(url: string, httpSecure: boolean | undefined): string;
    /**
     * Parse Boolean (support strings)
     * @param booleanValue
     */
    static parseBoolean(booleanValue: boolean | string): boolean;
    static methodFromString(method?: string): Method;
    static generateRandomString(length: number): string;
}
