export function checkAudioOnlyContent(ctx) {
  ctx.container.removeAttribute("data-audio-only");
  if (ctx.removedControlsForAudio) {
    restoreVideoControls(ctx);
  }
  try {
    const trackManager = ctx.player?.getTrackManager();
    if (trackManager) {
      const videoTracks = trackManager.getVideoTracks ? trackManager.getVideoTracks() : [];
      const audioTracks = trackManager.getAudioTracks ? trackManager.getAudioTracks() : [];
      if (audioTracks.length > 0 && videoTracks.length === 0) {
        ctx.container.setAttribute("data-audio-only", "true");
        hideVideoContainer(ctx);
      }
      return;
    }
  } catch (e) {
    console.error("TrackManager check failed:", e.message);
  }
}

function hideVideoContainer(ctx) {
  if (ctx.videoContainerHidden) {
    console.log("Video container already hidden");
    return;
  }
  if (ctx.video && ctx.video.parentNode) {
    ctx.video.parentNode.removeChild(ctx.video);
  }
  const controlsHeight = 60;
  const padding = Math.round(controlsHeight * 0.1);
  if (ctx.container) {
    ctx.container.style.height = controlsHeight + padding * 2 + "px";
    ctx.container.style.paddingTop = padding + "px";
    ctx.container.style.paddingBottom = padding + "px";
    ctx.container.style.background = "linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%)";
    ctx.container.style.border = "1px solid #404040";
    forceControlsAlwaysVisible(ctx);
  }
  ctx.videoContainerHidden = true;
}

function forceControlsAlwaysVisible(ctx) {
  const controlsContainer = ctx.container.querySelector(
    ".prestoplay-custom-controls"
  );
  if (controlsContainer) {
    controlsContainer.style.opacity = "1";
    controlsContainer.style.pointerEvents = "auto";
    controlsContainer.style.height = "100%";
    ctx.container.classList.remove("hide-cursor");
    ctx.container.setAttribute("data-audio-only", "true");
    controlsContainer.classList.add("audio-only");
    hideAudioOnlyUnnecessaryControls(ctx);
    console.log("Controls now permanently visible for audio-only playback");
  } else {
    console.log("Custom controls container not found");
  }
}

function hideAudioOnlyUnnecessaryControls(ctx) {
  // Removing unnecessary controls for audio-only content
  ctx.removedControlsForAudio = true;
  const subtitleWrapper = ctx.container.querySelector(
    ".pp-subtitle-wrapper"
  );
  if (subtitleWrapper && subtitleWrapper.parentNode) {
    subtitleWrapper.parentNode.removeChild(subtitleWrapper);
  }
  const settingsWrapper = ctx.container.querySelector(
    ".pp-settings-wrapper"
  );
  if (settingsWrapper && settingsWrapper.parentNode) {
    settingsWrapper.parentNode.removeChild(settingsWrapper);
  }

  const fullscreenBtn = ctx.container.querySelector(".pp-fs-btn");
  if (fullscreenBtn && fullscreenBtn.parentNode) {
    fullscreenBtn.parentNode.removeChild(fullscreenBtn);
  }
  console.log("Unnecessary controls removed for audio-only playback");
}

function restoreVideoControls(ctx) {
  // Restoring video controls for video content
  if (!ctx.removedControlsForAudio) {
    // No controls were removed, nothing to restore
    return;
  }
  const existingControls = ctx.container.querySelector(
    ".prestoplay-custom-controls"
  );
  if (existingControls && existingControls.parentNode) {
    existingControls.parentNode.removeChild(existingControls);
  }
  if (typeof ctx.createCustomControls === "function") {
    ctx.createCustomControls(ctx.player, ctx.video, ctx.options.containerId);
    setTimeout(() => {
      if (typeof ctx.setupSubtitleDetection === "function") ctx.setupSubtitleDetection();
      if (typeof ctx.setupQualitySelector === "function") ctx.setupQualitySelector();
    }, 100);
  }
  ctx.removedControlsForAudio = false;
  console.log("Video controls restored successfully");
}
