// Play/Pause Button Component
import { createButton } from "../utils/button-factory.js";
import { playIcon, pauseIcon } from "../../assets/icons/index.js";

export function createPlayPauseButton(video, container) {
  // Create play/pause button
  const playPauseBtn = createButton("play", "Play / Pause", () => {
    if (video.paused) {
      video.play();
    } else {
      video.pause();
    }
  });

  // Play/Pause icon update function
  function updatePlayPauseButton() {
    const isPlaying = !video.paused && !video.ended;
    playPauseBtn.innerHTML = isPlaying ? pauseIcon : playIcon;
    playPauseBtn.title = isPlaying ? "Pause" : "Play";
  }

  // Add event listeners
  video.addEventListener("play", updatePlayPauseButton);
  video.addEventListener("pause", updatePlayPauseButton);
  video.addEventListener("ended", updatePlayPauseButton);
  
  // Initialize button state
  updatePlayPauseButton();

  // Add click handler for play/pause on container click
  // Skip for audio-only content
  if (container.getAttribute("data-audio-only") !== "true") {
    container.addEventListener("click", (e) => {
      // Check if click is on control bar or settings popup
      const controlsContainer = container.querySelector(".prestoplay-custom-controls");
      const settingsPopup = container.querySelector(".pp-settings-popup");
      
      // Don't toggle if clicking on controls or settings
      if (controlsContainer && controlsContainer.contains(e.target)) {
        return;
      }
      if (settingsPopup && settingsPopup.contains(e.target)) {
        return;
      }
      
      // Toggle play/pause
      if (video.paused) {
        video.play();
      } else {
        video.pause();
      }
    });
  }

  return {
    button: playPauseBtn,
    updateButton: updatePlayPauseButton
  };
} 