// Main Settings Component
import { settingIcon } from "../../assets/icons/index.js";
import { createSpeedControl } from "./speed-control/speed-control.js";
import { createSubtitleControl } from "./subtitle-control/subtitle-control.js";
import { createQualityControl } from "./quality-control/quality-control.js";

export function createSettingsComponent(video, player, container) {
  // Settings wrapper
  const settingsWrapper = document.createElement("div");
  settingsWrapper.className = "pp-settings-wrapper";

  // Settings button
  const settingsBtn = document.createElement("button");
  settingsBtn.className = "prestoplay-control-btn pp-btn-small pp-settings-btn";
  settingsBtn.title = "Settings";
  settingsBtn.innerHTML = settingIcon;

  // Settings popup (initially hidden)
  const settingsPopup = document.createElement("div");
  settingsPopup.className = "pp-settings-popup pp-display-none";

  // Settings popup logic
  function showSettingsPopup() {
    settingsPopup.classList.remove("pp-display-none");
    settingsPopup.classList.add("pp-display-block");
  }

  function hideSettingsPopup() {
    settingsPopup.classList.add("pp-display-none");
    settingsPopup.classList.remove("pp-display-block");
    // Also hide all submenus when settings popup is hidden
    const qualitySubmenu = settingsPopup.querySelector(".pp-quality-submenu");
    if (qualitySubmenu) {
      qualitySubmenu.classList.add("pp-display-none");
      qualitySubmenu.classList.remove("pp-display-block");
    }
    const speedSubmenu = settingsPopup.querySelector(".pp-speed-submenu");
    if (speedSubmenu) {
      speedSubmenu.classList.add("pp-display-none");
      speedSubmenu.classList.remove("pp-display-block");
    }
    const subtitleSubmenu = settingsPopup.querySelector(".pp-subtitle-submenu");
    if (subtitleSubmenu) {
      subtitleSubmenu.classList.add("pp-display-none");
      subtitleSubmenu.classList.remove("pp-display-block");
    }
  }

  settingsBtn.addEventListener("click", (e) => {
    e.stopPropagation();
    if (settingsPopup.classList.contains("pp-display-none")) {
      showSettingsPopup();
    } else {
      hideSettingsPopup();
    }
  });

  // Close settings popup when clicking outside
  document.addEventListener("click", (e) => {
    if (!settingsPopup.contains(e.target) && !settingsBtn.contains(e.target)) {
      hideSettingsPopup();
    }
  });

  // Create sub-components
  const speedComponent = createSpeedControl(video, settingsPopup);
  const subtitleComponent = createSubtitleControl(player, settingsPopup);
  const qualityComponent = createQualityControl(player, settingsPopup);

  // Add sub-components to settings popup
  settingsPopup.appendChild(speedComponent.item);
  settingsPopup.appendChild(subtitleComponent.item);
  settingsPopup.appendChild(qualityComponent.item);

  // Add submenus
  speedComponent.item.appendChild(speedComponent.submenu);
  subtitleComponent.item.appendChild(subtitleComponent.submenu);
  qualityComponent.item.appendChild(qualityComponent.submenu);

  // Assemble settings wrapper
  settingsWrapper.appendChild(settingsBtn);
  settingsWrapper.appendChild(settingsPopup);

  // Function to hide all submenus
  function hideAllSubmenus() {
    const qualitySubmenu = settingsPopup.querySelector(".pp-quality-submenu");
    if (qualitySubmenu) {
      qualitySubmenu.classList.add("pp-display-none");
      qualitySubmenu.classList.remove("pp-display-block");
    }
    const speedSubmenu = settingsPopup.querySelector(".pp-speed-submenu");
    if (speedSubmenu) {
      speedSubmenu.classList.add("pp-display-none");
      speedSubmenu.classList.remove("pp-display-block");
    }
    const subtitleSubmenu = settingsPopup.querySelector(".pp-subtitle-submenu");
    if (subtitleSubmenu) {
      subtitleSubmenu.classList.add("pp-display-none");
      subtitleSubmenu.classList.remove("pp-display-block");
    }
  }

  // Expose functions for external use
  window.hideAllSettingsSubmenus = hideAllSubmenus;

  return {
    wrapper: settingsWrapper,
    button: settingsBtn,
    popup: settingsPopup,
    speedComponent,
    subtitleComponent,
    qualityComponent,
    showPopup: showSettingsPopup,
    hidePopup: hideSettingsPopup,
    hideAllSubmenus
  };
} 