// Speed Control Component
import { playbackSpeedIcon, chevronLeftIcon } from "../../../assets/icons/index.js";

export function createSpeedControl(video, settingsPopup) {
  // Playback Speed item
  const speedItem = document.createElement("div");
  speedItem.className = "pp-settings-item";
  speedItem.innerHTML = `
    <div style="display: flex; align-items: center; gap: 12px;">
      ${chevronLeftIcon}
      <div style="width: 20px; height: 20px; display: flex; align-items: center; justify-content: center;">
        ${playbackSpeedIcon}
      </div>
      <span>Playback speed</span>
    </div>
    <div style="display: flex; align-items: center; gap: 8px;">
      <span class="pp-speed-current">Normal</span>
    </div>
  `;

  // Speed submenu
  const speedSubmenu = document.createElement("div");
  speedSubmenu.className = "pp-speed-submenu pp-display-none";

  // Speed options
  const speedOptions = [0.5, 0.75, 1, 1.25, 1.5, 2];
  const speedLabels = ["0.5x", "0.75x", "Normal", "1.25x", "1.5x", "2x"];

  speedOptions.forEach((speed, index) => {
    const option = document.createElement("div");
    option.className = "pp-speed-option" + (speed === 1 ? " selected" : "");
    option.innerHTML = `
      <span>${speedLabels[index]}</span>
      <span class="pp-speed-checkmark" style="visibility: ${
        speed === 1 ? "visible" : "hidden"
      }; color: #2196F3;">✓</span>
    `;

    option.addEventListener("click", (e) => {
      e.stopPropagation();
      video.playbackRate = speed;
      updateSpeedSelection(speedLabels[index], option);
      hideSpeedSubmenu();
    });

    speedSubmenu.appendChild(option);
  });

  // Speed item click handler
  speedItem.addEventListener("click", (e) => {
    e.stopPropagation();
    // Hide other submenus first
    const qualitySubmenu = settingsPopup.querySelector(".pp-quality-submenu");
    if (qualitySubmenu) {
      qualitySubmenu.classList.add("pp-display-none");
      qualitySubmenu.classList.remove("pp-display-block");
    }
    const subtitleSubmenu = settingsPopup.querySelector(".pp-subtitle-submenu");
    if (subtitleSubmenu) {
      subtitleSubmenu.classList.add("pp-display-none");
      subtitleSubmenu.classList.remove("pp-display-block");
    }
    
    if (speedSubmenu.classList.contains("pp-display-none")) {
      speedSubmenu.classList.remove("pp-display-none");
      speedSubmenu.classList.add("pp-display-block");
    } else {
      speedSubmenu.classList.add("pp-display-none");
      speedSubmenu.classList.remove("pp-display-block");
    }
  });

  // Helper functions
  function updateSpeedSelection(speedLabel, selectedOption) {
    const currentSpeed = speedItem.querySelector(".pp-speed-current");
    currentSpeed.textContent = speedLabel;

    // Clear all selections
    speedSubmenu.querySelectorAll(".pp-speed-option").forEach((option) => {
      option.classList.remove("selected");
      option.classList.remove("pp-menu-item-selected");
      option.classList.add("pp-menu-item-normal");
      const checkmark = option.querySelector(".pp-speed-checkmark");
      if (checkmark) {
        checkmark.classList.add("pp-checkmark-hidden");
        checkmark.classList.remove("pp-checkmark-visible");
      }
    });

    // Highlight selected option
    if (selectedOption) {
      selectedOption.classList.add("selected");
      selectedOption.classList.add("pp-menu-item-selected");
      selectedOption.classList.remove("pp-menu-item-normal");
      const checkmark = selectedOption.querySelector(".pp-speed-checkmark");
      if (checkmark) {
        checkmark.classList.add("pp-checkmark-visible");
        checkmark.classList.remove("pp-checkmark-hidden");
      }
    }
  }

  function hideSpeedSubmenu() {
    speedSubmenu.classList.add("pp-display-none");
    speedSubmenu.classList.remove("pp-display-block");
  }

  // Close submenus when clicking outside
  document.addEventListener("click", (e) => {
    if (!speedSubmenu.contains(e.target) && !speedItem.contains(e.target)) {
      speedSubmenu.classList.add("pp-display-none");
      speedSubmenu.classList.remove("pp-display-block");
    }
    // Also close subtitle and quality submenus
    const subtitleSubmenu = settingsPopup.querySelector(".pp-subtitle-submenu");
    if (
      subtitleSubmenu &&
      !subtitleSubmenu.contains(e.target) &&
      !settingsPopup.querySelector(".pp-settings-item:nth-child(2)").contains(e.target)
    ) {
      subtitleSubmenu.classList.add("pp-display-none");
      subtitleSubmenu.classList.remove("pp-display-block");
    }
    const qualitySubmenu = settingsPopup.querySelector(".pp-quality-submenu");
    if (
      qualitySubmenu &&
      !qualitySubmenu.contains(e.target) &&
      !settingsPopup.querySelector(".pp-settings-item:nth-child(3)").contains(e.target)
    ) {
      qualitySubmenu.classList.add("pp-display-none");
      qualitySubmenu.classList.remove("pp-display-block");
    }
  });

  return {
    item: speedItem,
    submenu: speedSubmenu,
    updateSpeedSelection,
    hideSpeedSubmenu
  };
} 