export function createTimeDisplayComponent(video, timelineComponent) {
  // Create time display element
  const timeDisplay = document.createElement("div");
  timeDisplay.className = "pp-time-display";
  timeDisplay.textContent = "0:00 / 0:00";

  // Update time display function
  function updateTimeDisplay() {
    const cur = video.currentTime;
    const dur = video.duration;
    timeDisplay.textContent = `${timelineComponent.formatTime(
      cur
    )} / ${timelineComponent.formatTime(dur)}`;
  }

  // Update time display continuously
  let timeDisplayRafId;
  function updateTimeDisplayRaf() {
    updateTimeDisplay();
    timeDisplayRafId = requestAnimationFrame(updateTimeDisplayRaf);
  }
  
  // Start time display updates
  updateTimeDisplayRaf();

  // Function to stop time display updates (for cleanup)
  function stopTimeDisplayUpdates() {
    if (timeDisplayRafId) {
      cancelAnimationFrame(timeDisplayRafId);
      timeDisplayRafId = null;
    }
  }

  return {
    element: timeDisplay,
    updateTimeDisplay,
    stopTimeDisplayUpdates,
  };
} 