export function createTooltipComponent() {
  // Function to setup tooltips for buttons
  function setupTooltips(buttons) {
    buttons.forEach((btn) => {
      btn.addEventListener("mouseenter", (e) => {
        const tip = document.createElement("div");
        tip.className = "pp-tooltip";
        tip.textContent =
          btn.title || btn.options?.[btn.selectedIndex]?.textContent;
        document.body.appendChild(tip);
        const rect = btn.getBoundingClientRect();
        tip.style.left = rect.left + rect.width / 2 - tip.offsetWidth / 2 + "px";
        tip.style.top = rect.top - 32 + "px";
        btn._tip = tip;
      });
      
      btn.addEventListener("mouseleave", (e) => {
        if (btn._tip) {
          btn._tip.remove();
          btn._tip = null;
        }
      });
      
      btn.addEventListener("click", (e) => {
        if (btn._tip) {
          btn._tip.remove();
          btn._tip = null;
        }
      });
      
      // Also hide tooltip on blur (for keyboard users)
      btn.addEventListener("blur", (e) => {
        if (btn._tip) {
          btn._tip.remove();
          btn._tip = null;
        }
      });
    });
  }

  return {
    setupTooltips,
  };
} 