export function setupSubtitleDetection(ctx) {
  // Skip subtitle detection for audio-only content
  if (ctx.container?.getAttribute("data-audio-only") === "true") {
    console.log("Skipping subtitle detection");
    return;
  }

  let checkCount = 0;
  const periodicCheck = setInterval(() => {
    checkCount++;
    detectPrestoPlaySubtitles(ctx, `periodic-${checkCount}`);
    if (ctx.subtitleProcessed || checkCount >= 8) {
      clearInterval(periodicCheck);
    }
  }, 1500);
}

async function detectPrestoPlaySubtitles(ctx, source) {
  console.log(`[${source}] Detecting PRESTOplay subtitles...`);
  // Prevent duplicate processing
  if (ctx.subtitleProcessed) {
    console.log("Subtitles already processed, skipping...");
    return;
  }
  try {
    const trackManager = ctx.player?.getTrackManager();
    if (trackManager?.getTextTracks) {
      const textTracks = trackManager.getTextTracks();
      if (textTracks?.length > 0) {
        handlePrestoPlayTracks(ctx, textTracks);
        ctx.subtitleProcessed = true;
        return;
      } else {
        console.log("No text tracks found in TrackManager");
      }
    } else {
      console.log("TrackManager.getTextTracks not available");
    }
  } catch (e) {
    console.log("TrackManager access failed:", e.message);
  }
}

function handlePrestoPlayTracks(ctx, prestoTracks) {
  console.log(`Handling ${prestoTracks.length} PRESTOplay tracks natively`);
  ctx.prestoTracks = prestoTracks;
  if (prestoTracks.length <= 0) return;
  const trackManager = ctx.player?.getTrackManager
    ? ctx.player.getTrackManager()
    : null;
  if (trackManager?.setTextTrack) {
    try {
      trackManager.setTextTrack(null);
    } catch (e) {
      console.log(`TrackManager.setTextTrack failed:`, e.message);
    }
  }
  if (typeof window.addSubtitleButtonToControls === "function") {
    window.addSubtitleButtonToControls(ctx.options.containerId, prestoTracks);
  }
}
