import Loader from '../Loaders/Loader';
/**
 * @class
 * @description This class reports current pluguin status to the DB
 * @exports StatsReportingBusinessObject
 */
export default class StatsReportingBusinessObject {
    private static _instance;
    private loader;
    private started;
    private stopped;
    private lastCdnStats;
    private lastP2pStats;
    private host;
    private token;
    private accountCode;
    private profileName;
    private resource;
    lastReportedCodavelBanTime?: number;
    lastReportedCodavelUnbanTime?: number;
    lastReportedCodavelBanCount?: number;
    lastReportedCodavelUnbanCount?: number;
    lastReportedCodavelSwitches?: number;
    lastReportedCodavelSwitchesDueToQuality?: number;
    lastReportedCodavelSwitchesDueToErrors?: number;
    lastReportedCodavelSwitchesDueToConnectivity?: number;
    static getInstance(loader?: Loader): StatsReportingBusinessObject;
    constructor(loader: Loader);
    updateData(host: string, token: string, accountCode: string, profileName: string | undefined, resource: string): Promise<void>;
    report(): {} | undefined;
    private hasValuesChanged;
    private takeIf;
    private takeMin;
    private takeMax;
    private reportRequest;
}
