import Interceptors from './Interceptors/Interceptors';
import BalancerOptions from './Utils/Options';
import Emitter from './Utils/Emitter';
import NpawPluginOptions from '../core/NpawPluginOptions';
declare global {
    interface XMLHttpRequest {
        isAsync: boolean;
    }
}
/**
 * @class
 * @description Core class for the p2p plugin. It includes the options, the websocket communication,
 * @exports CdnBalancer
 */
export default class CdnBalancer extends Emitter {
    interceptors: Interceptors;
    options: BalancerOptions;
    private loader;
    private readonly _accountCode;
    private isEnabled;
    private defaultChunkDownloadTimeout;
    private isBitmovin;
    private isTheoplayer;
    private responseHeader;
    private allResponseHeader;
    private abort;
    private overrideMimeType;
    private requestHeader;
    private send;
    private open;
    private lastDecisionTimestamp;
    private apiHost;
    /**
     * Constructs CdnBalancer.
     * @param {string} accountCode NPAW Suite account code
     * @param npawPluginOptions Plugin-wide options
     */
    constructor(accountCode: string, npawPluginOptions?: NpawPluginOptions);
    private openAndSend;
    enable(): void;
    disable(): void;
    getIsEnabled(): boolean;
}
