import { CdnRequestStatus } from '../Utils/Constants';
import { VideoSegment } from '../Storage/VideoSegment';
/**
 * @class
 * @description This class stores information about every CDN available for the played content.
 * It also keeps updated the estimated bandwidth value.
 * @exports Cdn
 */
export default class Cdn {
    static initialBw: number;
    provider: string;
    internal_provider: string;
    name: string;
    host: string;
    path: string;
    url: string;
    original: boolean;
    score: number;
    active: boolean;
    banned: boolean;
    private _parser?;
    price: number;
    weight: number;
    absolute: boolean;
    dnsEnabled: boolean;
    auth?: cdnAuthInfo;
    bannedCount: number;
    unBannedCount: number;
    downloadedChunks: number;
    downloadedBytes: number;
    downloadedBytesForScoring: number;
    downloadTimeForScoring: number;
    hugeChunks: number;
    firstHugeChunkSize: number;
    private bandwidthForScoring;
    private wBandwidthForScoring;
    failures: number;
    retries: number;
    totalFail: number;
    browserCacheHits: number;
    private numberOfCdnCacheHits;
    private numberOfCdnCacheMisses;
    private numberOfCdnCacheUnknowns;
    downloadMillis: number;
    usedOnce: boolean;
    downloadedBytesVideo: number;
    downloadMillisVideo: number;
    downloadedChunksVideo: number;
    sumResponseBytes?: number;
    minResponseBytes?: number;
    maxResponseBytes?: number;
    samplesResponseBytes?: number;
    sumResponseTime?: number;
    minResponseTime?: number;
    maxResponseTime?: number;
    samplesResponseTime?: number;
    sumNetworkLatency?: number;
    minNetworkLatency?: number;
    maxNetworkLatency?: number;
    samplesNetworkLatency?: number;
    sumThroughput?: number;
    minThroughput?: number;
    maxThroughput?: number;
    samplesThroughput?: number;
    http1xxResponses?: number;
    http2xxResponses?: number;
    http3xxResponses?: number;
    http4xxResponses?: number;
    http5xxResponses?: number;
    unbannedTime: number;
    bannedTime: number;
    bannedRefTicToc: number;
    compressedBytes?: number;
    uncompressedBytes?: number;
    switches?: number;
    switchesDueToConnectivity?: number;
    switchesDueToErrors?: number;
    switchesDueToQuality?: number;
    sumVideoBytes?: number;
    sumVideoTime?: number;
    lastUpdatedState: CdnRequestStatus;
    maxBandwidth: number;
    lastPreferedVideoBandwidth: number;
    private _lastsPreferedVideoBandwidth;
    highestRenditionBandwidth: number;
    lastPreferedVideoChunkSize: number;
    lastPreferedVideoChunkDownloadTime: number;
    lastPingTime: number;
    private _accumBw;
    private bandwidth;
    private wBandwidth;
    private _lastResponses;
    highestSegmentBandwidth: number;
    lowestSegmentBandwidth: number;
    highestPingTime: number;
    lowestPingTime: number;
    avgPingTime: number;
    isRangeCompatible: boolean;
    private _checked;
    private downloadedSegments;
    usedOrProbed: boolean;
    /**
     * Constructs Cdn definition class.
     * @param {string} provider CDN provider.
     * @param {string} name CDN name.
     * @param {string} host CDN URL host.
     * @param {string} path CDN URL path.
     * @param {String} url CDN URL (host and path).
     * @param {number} score Given score by the API.
     * @param {boolean} original If the CDN is the one used in the manifest URL provided by the customer.
     * @param {cdnHeaderParser} parser Object with information for CDN header parsing
     */
    constructor(provider: string, name: string, host: string, path: string, url: string, score: number, original: boolean, price: number, weight: number, absolute: boolean, dnsEnabled: boolean, auth?: cdnAuthInfo, parser?: cdnHeaderParser);
    private pushLastPreferedVideoBandwidth;
    getAvgLastVideoBandwidth(): number;
    getLastResponse(): responseStorageObject;
    setLastResponses(responses: responseStorageObject[]): void;
    addResponse(response: responseStorageObject): void;
    getAvgResponseTime(): number;
    getCdnCacheHits(): number;
    getCdnCacheMisses(): number;
    private _processCdnCache;
    private _updateCacheCounts;
    private _updateCacheCount;
    private _incrementCacheCount;
    /**
     * Add the data of a response, successful or not, of the defined CDN.
     * It stores the properties of the response in lastResponses list and calculates the future estimated bandwidth.
     * @param {VideoSegment} segment URL of the request.
     * @public
     */
    addResp(segment: VideoSegment): void;
    calculateEffectiveBandwidth(chunkBitrate: number, chunkDuration: number): number;
    getVideoBandwidth(): number;
    /**
     * Returns the the expected bandwidth for the following request, based on previous requests.
     * @returns {number} Bandwidth value.
     * @public
     */
    getBandwidth(): number;
    setBandwidth(bw: number): void;
    /**
     * Returns the the expected bandwidth in bits for the following request, based on previous requests.
     * @returns {number} Bandwidth in bits
     */
    getBandwidthInBits(): number;
    getAvgBandwidth(): number;
    getAvgRecentBandwidth(): number;
    getAvgWBandwidth(): number;
    getAvgRecentWBandwidth(): number;
    getWeightedBandwidth(): number;
    /**
     * Resets the bandwidth value of the CDN, to discard previous wrong values and restart algorythms.
     * @public
     */
    resetBandwidth(): void;
    /**
     * Returns the timestamp of the oldest request stored in the lastResponses object, or 0 if is empty.
     * @returns {number} Timestamp of the oldest stored request.
     * @public
     */
    getOldestRequestTS(): number;
    clone(): Cdn;
    addProbe(pingTime: number): void;
    private updateStatusCodeCounters;
    updateAvailability(): void;
    incrementSwitches(): void;
    incrementSwitchesDueToQuality(): void;
    incrementSwitchesDueToConnectivity(): void;
    incrementSwitchesDueToErrors(): void;
    resetOnPing(): void;
    isCodavel(): boolean;
    setChecked(): void;
    isChecked(): boolean;
}
