// Custom Controls for PRESTOplay
import { ProgressComponent } from "./progress/progress.js";
import { PlayPauseComponent } from "./play-pause/play-pause.js";
import { VolumeControlComponent } from "./volume-control/volume-control.js";
import { TimeDisplayComponent } from "./time-display/time-display.js";
import { SubtitleToggleComponent } from "./subtitle-toggle/subtitle-toggle.js";
import { SettingsComponent } from "./settings/settings.js";
import { FullscreenComponent } from "./fullscreen/fullscreen.js";

export class ControlBarComponent {
  constructor(player, video, playerContainer) {
    this.container = null;
    this.player = player;
    this.video = video;
    this.playerContainer = playerContainer;

    this.init();
  }

  init() {
    this.createElements();
  }

  createElements() {
    // Controls container
    this.container = document.createElement("div");
    this.container.className = "prestoplay-custom-controls";

    // --- Progress bar ---
    const progressComponent = new ProgressComponent(this.player);
    this.container.appendChild(progressComponent.container);

    // --- Controls row ---
    const controlsRow = document.createElement("div");
    controlsRow.className = "pp-controls-row";

    // --- Left controls ---
    const leftControls = document.createElement("div");
    leftControls.className = "pp-left-controls";

    // Play/Pause
    const playPauseComponent = new PlayPauseComponent(this.player);
    leftControls.appendChild(playPauseComponent.container);

    // --- Volume controls ---
    const volumeControlComponent = new VolumeControlComponent(this.player);
    leftControls.appendChild(volumeControlComponent.container);

    // --- Time display ---
    const timeDisplayComponent = new TimeDisplayComponent(this.player);
    leftControls.appendChild(timeDisplayComponent.container);

    // --- Right controls ---
    const rightControls = document.createElement("div");
    rightControls.className = "pp-right-controls";

    // Subtitle toggle component
    const subtitleToggleComponent = new SubtitleToggleComponent(this.player);
    rightControls.appendChild(subtitleToggleComponent.container);

    // Settings component
    const settingsComponent = new SettingsComponent(this.player);
    rightControls.appendChild(settingsComponent.container);

    // Fullscreen component
    const fullscreenComponent = new FullscreenComponent(
      this.player,
      this.video,
      this.playerContainer,
      this.container
    );
    rightControls.appendChild(fullscreenComponent.container);

    controlsRow.appendChild(leftControls);
    controlsRow.appendChild(rightControls);

    // --- Assemble control bar ---
    this.container.appendChild(controlsRow);
  }
  catch(error) {
    console.error("Error creating custom controls:", error);
  }

  cleanup() {
    this.progressComponent?.cleanup();
    this.playPauseComponent?.cleanup();
    this.volumeControlComponent?.cleanup();
    this.timeDisplayComponent?.cleanup();
    this.subtitleToggleComponent?.cleanup();
    this.settingsComponent?.cleanup();
    this.fullscreenComponent?.cleanup();
  }
}
