// Time Display Component Class
import { formatTime } from "../../../utils/common.js";

export class TimeDisplayComponent {
  constructor(player) {
    this.player = player;

    this.container = null;
    this.currentTime = null;

    this.init();
  }

  init() {
    this.createElements();
    this.setupEventListeners();
    this.updateTimeDisplay();
  }

  createElements() {
    // Create time display element
    this.container = document.createElement("div");
    this.container.className = "pp-time-display-container";

    this.currentTime = document.createElement("span");
    this.currentTime.className = "pp-time-display-current-time";
    this.currentTime.textContent = "00:00";

    this.duration = document.createElement("span");
    this.duration.className = "pp-time-display-duration";
    this.duration.textContent = "00:00";

    this.container.appendChild(this.currentTime);
    this.container.appendChild(document.createTextNode(" / "));
    this.container.appendChild(this.duration);
  }

  updateTimeDisplay() {
    const cur = this.player.getPosition();
    const dur = this.player.getDuration();
    this.currentTime.textContent = formatTime(cur);
    this.duration.textContent = formatTime(dur);
  }

  setupEventListeners() {
    this.player.on("timeupdate", this.updateTimeDisplay.bind(this));
    this.player.on("loadedmetadata", this.updateTimeDisplay.bind(this));
    this.player.on("durationchange", this.updateTimeDisplay.bind(this));
  }

  cleanup() {
    this.player.off("timeupdate", this.updateTimeDisplay.bind(this));
    this.player.off("loadedmetadata", this.updateTimeDisplay.bind(this));
    this.player.off("durationchange", this.updateTimeDisplay.bind(this));
  }
}
