// Button Factory Utility
import {
  playIcon,
  subtitleToggleIcon,
  settingIcon,
  fullScreenIcon,
} from "../assets/icons/index.js";

export function createButton(type, title, onClick) {
  const button = document.createElement("button");
  button.className = `prestoplay-control-btn prestoplay-${type}-btn`;
  button.title = title;

  // Set icon based on type
  switch (type) {
    case "play":
      button.innerHTML = playIcon;
      break;
    case "stop":
      button.innerHTML = `<svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
        <path d="M6 6h12v12H6z"/>
      </svg>`;
      break;
    case "rewind":
      button.innerHTML = `<svg fill="currentColor" viewBox="0 0 32 32" sfill="currentColor" width="24" height="24">
        <path d="M0 16q0 1.12 0.896 1.664l12 8q0.448 0.32 0.992 0.352t1.056-0.224q0.48-0.288 0.768-0.768t0.288-1.024v-16q0-0.544-0.288-1.024t-0.768-0.736-1.056-0.224-0.992 0.32l-12 8q-0.896 0.608-0.896 1.664zM16 16q0 1.12 0.896 1.664l12 8q0.448 0.32 0.992 0.352t1.056-0.224q0.48-0.288 0.768-0.768t0.288-1.024v-16q0-0.544-0.288-1.024t-0.768-0.736-1.056-0.224-0.992 0.32l-12 8q-0.896 0.608-0.896 1.664z"></path>
      </svg>`;
      break;
    case "forward":
      button.innerHTML = `<svg fill="currentColor" width="24" height="24"" viewBox="0 0 32 32" stroke="currentColor">
        <path d="M0 24q0 0.544 0.288 1.056t0.768 0.736q0.48 0.256 1.056 0.224t0.992-0.32l12-8q0.896-0.608 0.896-1.696t-0.896-1.632l-12-8q-0.448-0.32-0.992-0.352t-1.056 0.224q-0.48 0.256-0.768 0.736t-0.288 1.024v16zM16 24q0 0.544 0.288 1.056t0.768 0.736q0.48 0.256 1.056 0.224t0.992-0.32l12-8q0.896-0.608 0.896-1.696t-0.896-1.632l-12-8q-0.448-0.32-0.992-0.352t-1.056 0.224q-0.48 0.256-0.768 0.736t-0.288 1.024v16z"></path>
      </svg>`;
      break;
    case "subtitle-toggle":
      button.innerHTML = subtitleToggleIcon;
      break;
    case "settings":
      button.innerHTML = settingIcon;
      break;
    case "fullscreen":
      button.innerHTML = fullScreenIcon;
      break;
  }

  button.addEventListener("click", onClick);
  // Hover effects are now handled by CSS
  // Removed JavaScript hover classes as they're now handled by CSS :hover pseudo-class

  return button;
}
