export function formatTime(seconds) {
  if (isNaN(seconds) || seconds < 0) {
    seconds = 0;
  }
  const date = new Date(null);
  date.setSeconds(seconds);
  const result = date.toISOString().substr(11, 8);
  return result.startsWith("00:") ? result.substr(3) : result;
}

// export function formatTime(seconds) {
//   if (isNaN(seconds) || !isFinite(seconds)) {
//     return "00:00";
//   }

//   const hours = Math.floor(seconds / 3600);
//   const minutes = Math.floor((seconds % 3600) / 60);
//   const secs = Math.floor(seconds % 60);

//   if (hours > 0) {
//     return `${hours.toString().padStart(2, "0")}:${minutes
//       .toString()
//       .padStart(2, "0")}:${secs.toString().padStart(2, "0")}`;
//   } else {
//     return `${minutes.toString().padStart(2, "0")}:${secs
//       .toString()
//       .padStart(2, "0")}`;
//   }
// }
