/*! @name videojs-contrib-eme @version 5.5.1 @license Apache-2.0 */
(function (QUnit, videojs, sinon) {
	'use strict';

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var QUnit__default = /*#__PURE__*/_interopDefaultLegacy(QUnit);
	var videojs__default = /*#__PURE__*/_interopDefaultLegacy(videojs);
	var sinon__default = /*#__PURE__*/_interopDefaultLegacy(sinon);

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getAugmentedNamespace(n) {
		if (n.__esModule) return n;
		var a = Object.defineProperty({}, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var win;

	if (typeof window !== "undefined") {
	  win = window;
	} else if (typeof commonjsGlobal !== "undefined") {
	  win = commonjsGlobal;
	} else if (typeof self !== "undefined") {
	  win = self;
	} else {
	  win = {};
	}

	var window_1 = win;

	function cov_1l0no6s9gj() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/cdm.js";
	  var hash = "5fd5ba416f7bccf61d5966620606ac7e3e97aa74";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/cdm.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 3,
	          column: 22
	        },
	        end: {
	          line: 11,
	          column: 2
	        }
	      },
	      "1": {
	        start: {
	          line: 13,
	          column: 19
	        },
	        end: {
	          line: 40,
	          column: 1
	        }
	      },
	      "2": {
	        start: {
	          line: 44,
	          column: 35
	        },
	        end: {
	          line: 67,
	          column: 1
	        }
	      },
	      "3": {
	        start: {
	          line: 45,
	          column: 18
	        },
	        end: {
	          line: 45,
	          column: 32
	        }
	      },
	      "4": {
	        start: {
	          line: 46,
	          column: 18
	        },
	        end: {
	          line: 51,
	          column: 3
	        }
	      },
	      "5": {
	        start: {
	          line: 53,
	          column: 2
	        },
	        end: {
	          line: 55,
	          column: 3
	        }
	      },
	      "6": {
	        start: {
	          line: 54,
	          column: 4
	        },
	        end: {
	          line: 54,
	          column: 36
	        }
	      },
	      "7": {
	        start: {
	          line: 57,
	          column: 2
	        },
	        end: {
	          line: 66,
	          column: 5
	        }
	      },
	      "8": {
	        start: {
	          line: 58,
	          column: 4
	        },
	        end: {
	          line: 58,
	          column: 100
	        }
	      },
	      "9": {
	        start: {
	          line: 60,
	          column: 4
	        },
	        end: {
	          line: 60,
	          column: 41
	        }
	      },
	      "10": {
	        start: {
	          line: 61,
	          column: 4
	        },
	        end: {
	          line: 61,
	          column: 43
	        }
	      },
	      "11": {
	        start: {
	          line: 62,
	          column: 4
	        },
	        end: {
	          line: 62,
	          column: 41
	        }
	      },
	      "12": {
	        start: {
	          line: 63,
	          column: 4
	        },
	        end: {
	          line: 63,
	          column: 41
	        }
	      },
	      "13": {
	        start: {
	          line: 65,
	          column: 4
	        },
	        end: {
	          line: 65,
	          column: 19
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 44,
	            column: 35
	          },
	          end: {
	            line: 44,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 44,
	            column: 41
	          },
	          end: {
	            line: 67,
	            column: 1
	          }
	        },
	        line: 44
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 57,
	            column: 36
	          },
	          end: {
	            line: 57,
	            column: 37
	          }
	        },
	        loc: {
	          start: {
	            line: 57,
	            column: 70
	          },
	          end: {
	            line: 59,
	            column: 3
	          }
	        },
	        line: 57
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 58,
	            column: 90
	          },
	          end: {
	            line: 58,
	            column: 91
	          }
	        },
	        loc: {
	          start: {
	            line: 58,
	            column: 96
	          },
	          end: {
	            line: 58,
	            column: 98
	          }
	        },
	        line: 58
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 59,
	            column: 11
	          },
	          end: {
	            line: 59,
	            column: 12
	          }
	        },
	        loc: {
	          start: {
	            line: 59,
	            column: 58
	          },
	          end: {
	            line: 66,
	            column: 3
	          }
	        },
	        line: 59
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        }],
	        line: 53
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 53,
	            column: 6
	          },
	          end: {
	            line: 53,
	            column: 72
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 53,
	            column: 6
	          },
	          end: {
	            line: 53,
	            column: 23
	          }
	        }, {
	          start: {
	            line: 53,
	            column: 27
	          },
	          end: {
	            line: 53,
	            column: 72
	          }
	        }],
	        line: 53
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "5fd5ba416f7bccf61d5966620606ac7e3e97aa74"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_1l0no6s9gj = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_1l0no6s9gj();
	const genericConfig = (cov_1l0no6s9gj().s[0]++, [{
	  initDataTypes: ['cenc'],
	  audioCapabilities: [{
	    contentType: 'audio/mp4;codecs="mp4a.40.2"'
	  }],
	  videoCapabilities: [{
	    contentType: 'video/mp4;codecs="avc1.42E01E"'
	  }]
	}]);
	const keySystems = (cov_1l0no6s9gj().s[1]++, [// Fairplay
	// Requires different config than other CDMs
	{
	  keySystem: 'com.apple.fps',
	  supportedConfig: [{
	    initDataTypes: ['sinf'],
	    videoCapabilities: [{
	      contentType: 'video/mp4'
	    }]
	  }]
	}, // Playready
	{
	  keySystem: 'com.microsoft.playready.recommendation',
	  supportedConfig: genericConfig
	}, // Widevine
	{
	  keySystem: 'com.widevine.alpha',
	  supportedConfig: genericConfig
	}, // Clear
	{
	  keySystem: 'org.w3.clearkey',
	  supportedConfig: genericConfig
	}]); // Asynchronously detect the list of supported CDMs by requesting key system access
	// when possible, otherwise rely on browser-specific EME API feature detection.

	cov_1l0no6s9gj().s[2]++;
	const detectSupportedCDMs = () => {
	  cov_1l0no6s9gj().f[0]++;
	  const Promise = (cov_1l0no6s9gj().s[3]++, window_1.Promise);
	  const results = (cov_1l0no6s9gj().s[4]++, {
	    fairplay: Boolean(window_1.WebKitMediaKeys),
	    playready: false,
	    widevine: false,
	    clearkey: false
	  });
	  cov_1l0no6s9gj().s[5]++;

	  if ((cov_1l0no6s9gj().b[1][0]++, !window_1.MediaKeys) || (cov_1l0no6s9gj().b[1][1]++, !window_1.navigator.requestMediaKeySystemAccess)) {
	    cov_1l0no6s9gj().b[0][0]++;
	    cov_1l0no6s9gj().s[6]++;
	    return Promise.resolve(results);
	  } else {
	    cov_1l0no6s9gj().b[0][1]++;
	  }

	  cov_1l0no6s9gj().s[7]++;
	  return Promise.all(keySystems.map(({
	    keySystem,
	    supportedConfig
	  }) => {
	    cov_1l0no6s9gj().f[1]++;
	    cov_1l0no6s9gj().s[8]++;
	    return window_1.navigator.requestMediaKeySystemAccess(keySystem, supportedConfig).catch(() => {
	      cov_1l0no6s9gj().f[2]++;
	    });
	  })).then(([fairplay, playready, widevine, clearkey]) => {
	    cov_1l0no6s9gj().f[3]++;
	    cov_1l0no6s9gj().s[9]++;
	    results.fairplay = Boolean(fairplay);
	    cov_1l0no6s9gj().s[10]++;
	    results.playready = Boolean(playready);
	    cov_1l0no6s9gj().s[11]++;
	    results.widevine = Boolean(widevine);
	    cov_1l0no6s9gj().s[12]++;
	    results.clearkey = Boolean(clearkey);
	    cov_1l0no6s9gj().s[13]++;
	    return results;
	  });
	};

	const IS_CHROMIUM = videojs__default["default"].browser.IS_CHROMIUM || /Chrome|CriOS/i.test(window_1.navigator.userAgent);
	const IS_WINDOWS = videojs__default["default"].browser.IS_WINDOWS || /Windows/i.test(window_1.navigator.userAgent);
	QUnit__default["default"].module('videojs-contrib-eme CDM Module');
	QUnit__default["default"].skip('detectSupportedCDMs() returns a Promise', function (assert) {
	  const promise = detectSupportedCDMs();
	  assert.ok(promise.then);
	}); // NOTE: This test is not future-proof. It verifies that the CDM detect function
	// works as expected given browser's *current* CDM support. If that support changes,
	// this test may need updating.

	QUnit__default["default"].test('detectSupportedCDMs() promise resolves correctly on different browsers', function (assert) {
	  const done = assert.async();
	  const promise = detectSupportedCDMs();
	  promise.then(result => {
	    // Currently, widevine and clearkey don't work in headless Chrome, so we can't verify cdm support in
	    // the remote Video.js test environment. However, it can be verified if testing locally in a real browser.
	    // Headless Chrome bug: https://bugs.chromium.org/p/chromium/issues/detail?id=788662
	    if (videojs__default["default"].browser.IS_CHROME) {
	      assert.equal(result.fairplay, false, 'fairplay not supported in Chrome');
	      assert.equal(result.playready, false, 'playready not supported in Chrome'); // Uncomment if testing locally in actual browser
	      // assert.equal(result.clearkey, true, 'clearkey is supported in Chrome');
	      // assert.equal(result.widevine, true, 'widevine is supported in Chrome');
	    } // Widevine requires a plugin in Ubuntu Firefox so it also does not work in the remote Video.js test environment


	    if (videojs__default["default"].browser.IS_FIREFOX) {
	      assert.equal(result.fairplay, false, 'fairplay not supported in FF');
	      assert.equal(result.playready, false, 'playready not supported in FF');
	      assert.equal(result.clearkey, true, 'clearkey is supported in FF'); // Uncomment if testing locally in actual browser
	      // assert.equal(result.widevine, true, 'widevine is supported in Chrome and FF');
	    }

	    if (videojs__default["default"].browser.IS_ANY_SAFARI) {
	      assert.deepEqual(result, {
	        fairplay: true,
	        clearkey: true,
	        playready: false,
	        widevine: false
	      }, 'fairplay support reported in Safari');
	    }

	    if (videojs__default["default"].browser.IS_EDGE && IS_CHROMIUM && !IS_WINDOWS) {
	      assert.deepEqual(result, {
	        fairplay: false,
	        playready: false,
	        widevine: true,
	        clearkey: true
	      }, 'widevine support reported in non-Windows Chromium Edge');
	    }

	    if (videojs__default["default"].browser.IS_EDGE && IS_CHROMIUM && IS_WINDOWS) {
	      assert.deepEqual(result, {
	        fairplay: false,
	        playready: true,
	        widevine: true,
	        clearkey: true
	      }, 'widevine and playready support reported in Windows Chromium Edge');
	    }

	    done();
	  }).catch(done);
	});

	var _nodeResolve_empty = {};

	var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': _nodeResolve_empty
	});

	var require$$0 = /*@__PURE__*/getAugmentedNamespace(_nodeResolve_empty$1);

	var topLevel = typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : {};
	var minDoc = require$$0;
	var doccy;

	if (typeof document !== 'undefined') {
	  doccy = document;
	} else {
	  doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'];

	  if (!doccy) {
	    doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'] = minDoc;
	  }
	}

	var document_1 = doccy;

	function _extends() {
	  _extends = Object.assign ? Object.assign.bind() : function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };
	  return _extends.apply(this, arguments);
	}

	function cov_n0zvjkcx1() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/utils.js";
	  var hash = "398f6ab1ffdb66009e6290a7a7e4a1791b425ee7";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/utils.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 5,
	          column: 35
	        },
	        end: {
	          line: 15,
	          column: 1
	        }
	      },
	      "1": {
	        start: {
	          line: 7,
	          column: 17
	        },
	        end: {
	          line: 7,
	          column: 51
	        }
	      },
	      "2": {
	        start: {
	          line: 8,
	          column: 16
	        },
	        end: {
	          line: 8,
	          column: 39
	        }
	      },
	      "3": {
	        start: {
	          line: 10,
	          column: 2
	        },
	        end: {
	          line: 12,
	          column: 3
	        }
	      },
	      "4": {
	        start: {
	          line: 10,
	          column: 15
	        },
	        end: {
	          line: 10,
	          column: 16
	        }
	      },
	      "5": {
	        start: {
	          line: 11,
	          column: 4
	        },
	        end: {
	          line: 11,
	          column: 36
	        }
	      },
	      "6": {
	        start: {
	          line: 14,
	          column: 2
	        },
	        end: {
	          line: 14,
	          column: 15
	        }
	      },
	      "7": {
	        start: {
	          line: 17,
	          column: 34
	        },
	        end: {
	          line: 19,
	          column: 1
	        }
	      },
	      "8": {
	        start: {
	          line: 18,
	          column: 2
	        },
	        end: {
	          line: 18,
	          column: 80
	        }
	      },
	      "9": {
	        start: {
	          line: 21,
	          column: 35
	        },
	        end: {
	          line: 23,
	          column: 1
	        }
	      },
	      "10": {
	        start: {
	          line: 22,
	          column: 2
	        },
	        end: {
	          line: 22,
	          column: 81
	        }
	      },
	      "11": {
	        start: {
	          line: 25,
	          column: 34
	        },
	        end: {
	          line: 30,
	          column: 1
	        }
	      },
	      "12": {
	        start: {
	          line: 26,
	          column: 15
	        },
	        end: {
	          line: 26,
	          column: 42
	        }
	      },
	      "13": {
	        start: {
	          line: 28,
	          column: 2
	        },
	        end: {
	          line: 28,
	          column: 18
	        }
	      },
	      "14": {
	        start: {
	          line: 29,
	          column: 2
	        },
	        end: {
	          line: 29,
	          column: 23
	        }
	      },
	      "15": {
	        start: {
	          line: 32,
	          column: 33
	        },
	        end: {
	          line: 51,
	          column: 1
	        }
	      },
	      "16": {
	        start: {
	          line: 33,
	          column: 2
	        },
	        end: {
	          line: 35,
	          column: 3
	        }
	      },
	      "17": {
	        start: {
	          line: 34,
	          column: 4
	        },
	        end: {
	          line: 34,
	          column: 16
	        }
	      },
	      "18": {
	        start: {
	          line: 37,
	          column: 2
	        },
	        end: {
	          line: 39,
	          column: 3
	        }
	      },
	      "19": {
	        start: {
	          line: 38,
	          column: 4
	        },
	        end: {
	          line: 38,
	          column: 17
	        }
	      },
	      "20": {
	        start: {
	          line: 41,
	          column: 20
	        },
	        end: {
	          line: 41,
	          column: 46
	        }
	      },
	      "21": {
	        start: {
	          line: 42,
	          column: 20
	        },
	        end: {
	          line: 42,
	          column: 46
	        }
	      },
	      "22": {
	        start: {
	          line: 44,
	          column: 2
	        },
	        end: {
	          line: 48,
	          column: 3
	        }
	      },
	      "23": {
	        start: {
	          line: 44,
	          column: 15
	        },
	        end: {
	          line: 44,
	          column: 16
	        }
	      },
	      "24": {
	        start: {
	          line: 45,
	          column: 4
	        },
	        end: {
	          line: 47,
	          column: 5
	        }
	      },
	      "25": {
	        start: {
	          line: 46,
	          column: 6
	        },
	        end: {
	          line: 46,
	          column: 19
	        }
	      },
	      "26": {
	        start: {
	          line: 50,
	          column: 2
	        },
	        end: {
	          line: 50,
	          column: 14
	        }
	      },
	      "27": {
	        start: {
	          line: 53,
	          column: 31
	        },
	        end: {
	          line: 60,
	          column: 1
	        }
	      },
	      "28": {
	        start: {
	          line: 54,
	          column: 2
	        },
	        end: {
	          line: 57,
	          column: 3
	        }
	      },
	      "29": {
	        start: {
	          line: 56,
	          column: 4
	        },
	        end: {
	          line: 56,
	          column: 37
	        }
	      },
	      "30": {
	        start: {
	          line: 59,
	          column: 2
	        },
	        end: {
	          line: 59,
	          column: 28
	        }
	      },
	      "31": {
	        start: {
	          line: 63,
	          column: 21
	        },
	        end: {
	          line: 68,
	          column: 1
	        }
	      },
	      "32": {
	        start: {
	          line: 64,
	          column: 18
	        },
	        end: {
	          line: 64,
	          column: 40
	        }
	      },
	      "33": {
	        start: {
	          line: 65,
	          column: 13
	        },
	        end: {
	          line: 65,
	          column: 50
	        }
	      },
	      "34": {
	        start: {
	          line: 67,
	          column: 2
	        },
	        end: {
	          line: 67,
	          column: 33
	        }
	      },
	      "35": {
	        start: {
	          line: 70,
	          column: 34
	        },
	        end: {
	          line: 81,
	          column: 1
	        }
	      },
	      "36": {
	        start: {
	          line: 71,
	          column: 17
	        },
	        end: {
	          line: 71,
	          column: 31
	        }
	      },
	      "37": {
	        start: {
	          line: 74,
	          column: 2
	        },
	        end: {
	          line: 78,
	          column: 5
	        }
	      },
	      "38": {
	        start: {
	          line: 75,
	          column: 4
	        },
	        end: {
	          line: 77,
	          column: 5
	        }
	      },
	      "39": {
	        start: {
	          line: 76,
	          column: 6
	        },
	        end: {
	          line: 76,
	          column: 23
	        }
	      },
	      "40": {
	        start: {
	          line: 80,
	          column: 2
	        },
	        end: {
	          line: 80,
	          column: 16
	        }
	      },
	      "41": {
	        start: {
	          line: 89,
	          column: 47
	        },
	        end: {
	          line: 98,
	          column: 1
	        }
	      },
	      "42": {
	        start: {
	          line: 90,
	          column: 17
	        },
	        end: {
	          line: 90,
	          column: 19
	        }
	      },
	      "43": {
	        start: {
	          line: 92,
	          column: 2
	        },
	        end: {
	          line: 96,
	          column: 5
	        }
	      },
	      "44": {
	        start: {
	          line: 93,
	          column: 33
	        },
	        end: {
	          line: 93,
	          column: 96
	        }
	      },
	      "45": {
	        start: {
	          line: 95,
	          column: 4
	        },
	        end: {
	          line: 95,
	          column: 38
	        }
	      },
	      "46": {
	        start: {
	          line: 97,
	          column: 2
	        },
	        end: {
	          line: 97,
	          column: 16
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 5,
	            column: 35
	          },
	          end: {
	            line: 5,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 5,
	            column: 47
	          },
	          end: {
	            line: 15,
	            column: 1
	          }
	        },
	        line: 5
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 17,
	            column: 34
	          },
	          end: {
	            line: 17,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 17,
	            column: 45
	          },
	          end: {
	            line: 19,
	            column: 1
	          }
	        },
	        line: 17
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 21,
	            column: 35
	          },
	          end: {
	            line: 21,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 21,
	            column: 46
	          },
	          end: {
	            line: 23,
	            column: 1
	          }
	        },
	        line: 21
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 25,
	            column: 34
	          },
	          end: {
	            line: 25,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 25,
	            column: 43
	          },
	          end: {
	            line: 30,
	            column: 1
	          }
	        },
	        line: 25
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 32,
	            column: 33
	          },
	          end: {
	            line: 32,
	            column: 34
	          }
	        },
	        loc: {
	          start: {
	            line: 32,
	            column: 65
	          },
	          end: {
	            line: 51,
	            column: 1
	          }
	        },
	        line: 32
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 53,
	            column: 31
	          },
	          end: {
	            line: 53,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 53,
	            column: 55
	          },
	          end: {
	            line: 60,
	            column: 1
	          }
	        },
	        line: 53
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 63,
	            column: 21
	          },
	          end: {
	            line: 63,
	            column: 22
	          }
	        },
	        loc: {
	          start: {
	            line: 63,
	            column: 34
	          },
	          end: {
	            line: 68,
	            column: 1
	          }
	        },
	        line: 63
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 70,
	            column: 34
	          },
	          end: {
	            line: 70,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 70,
	            column: 47
	          },
	          end: {
	            line: 81,
	            column: 1
	          }
	        },
	        line: 70
	      },
	      "8": {
	        name: "(anonymous_8)",
	        decl: {
	          start: {
	            line: 74,
	            column: 30
	          },
	          end: {
	            line: 74,
	            column: 31
	          }
	        },
	        loc: {
	          start: {
	            line: 74,
	            column: 35
	          },
	          end: {
	            line: 78,
	            column: 3
	          }
	        },
	        line: 74
	      },
	      "9": {
	        name: "(anonymous_9)",
	        decl: {
	          start: {
	            line: 89,
	            column: 47
	          },
	          end: {
	            line: 89,
	            column: 48
	          }
	        },
	        loc: {
	          start: {
	            line: 89,
	            column: 63
	          },
	          end: {
	            line: 98,
	            column: 1
	          }
	        },
	        line: 89
	      },
	      "10": {
	        name: "(anonymous_10)",
	        decl: {
	          start: {
	            line: 92,
	            column: 34
	          },
	          end: {
	            line: 92,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 92,
	            column: 49
	          },
	          end: {
	            line: 96,
	            column: 3
	          }
	        },
	        line: 92
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 18,
	            column: 56
	          },
	          end: {
	            line: 18,
	            column: 77
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 18,
	            column: 56
	          },
	          end: {
	            line: 18,
	            column: 68
	          }
	        }, {
	          start: {
	            line: 18,
	            column: 72
	          },
	          end: {
	            line: 18,
	            column: 77
	          }
	        }],
	        line: 18
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 22,
	            column: 57
	          },
	          end: {
	            line: 22,
	            column: 78
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 22,
	            column: 57
	          },
	          end: {
	            line: 22,
	            column: 69
	          }
	        }, {
	          start: {
	            line: 22,
	            column: 73
	          },
	          end: {
	            line: 22,
	            column: 78
	          }
	        }],
	        line: 22
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 33,
	            column: 2
	          },
	          end: {
	            line: 35,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 33,
	            column: 2
	          },
	          end: {
	            line: 35,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 33,
	            column: 2
	          },
	          end: {
	            line: 35,
	            column: 3
	          }
	        }],
	        line: 33
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 37,
	            column: 2
	          },
	          end: {
	            line: 39,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 37,
	            column: 2
	          },
	          end: {
	            line: 39,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 37,
	            column: 2
	          },
	          end: {
	            line: 39,
	            column: 3
	          }
	        }],
	        line: 37
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 45,
	            column: 4
	          },
	          end: {
	            line: 47,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 45,
	            column: 4
	          },
	          end: {
	            line: 47,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 45,
	            column: 4
	          },
	          end: {
	            line: 47,
	            column: 5
	          }
	        }],
	        line: 45
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 54,
	            column: 2
	          },
	          end: {
	            line: 57,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 54,
	            column: 2
	          },
	          end: {
	            line: 57,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 54,
	            column: 2
	          },
	          end: {
	            line: 57,
	            column: 3
	          }
	        }],
	        line: 54
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 54,
	            column: 6
	          },
	          end: {
	            line: 55,
	            column: 47
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 54,
	            column: 6
	          },
	          end: {
	            line: 54,
	            column: 46
	          }
	        }, {
	          start: {
	            line: 55,
	            column: 6
	          },
	          end: {
	            line: 55,
	            column: 47
	          }
	        }],
	        line: 54
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 64,
	            column: 18
	          },
	          end: {
	            line: 64,
	            column: 40
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 64,
	            column: 18
	          },
	          end: {
	            line: 64,
	            column: 29
	          }
	        }, {
	          start: {
	            line: 64,
	            column: 33
	          },
	          end: {
	            line: 64,
	            column: 40
	          }
	        }],
	        line: 64
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 65,
	            column: 13
	          },
	          end: {
	            line: 65,
	            column: 50
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 65,
	            column: 13
	          },
	          end: {
	            line: 65,
	            column: 26
	          }
	        }, {
	          start: {
	            line: 65,
	            column: 30
	          },
	          end: {
	            line: 65,
	            column: 50
	          }
	        }],
	        line: 65
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 75,
	            column: 4
	          },
	          end: {
	            line: 77,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 75,
	            column: 4
	          },
	          end: {
	            line: 77,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 75,
	            column: 4
	          },
	          end: {
	            line: 77,
	            column: 5
	          }
	        }],
	        line: 75
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "398f6ab1ffdb66009e6290a7a7e4a1791b425ee7"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_n0zvjkcx1 = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_n0zvjkcx1();
	cov_n0zvjkcx1().s[0]++;
	const stringToUint16Array = string => {
	  cov_n0zvjkcx1().f[0]++; // 2 bytes for each char

	  const buffer = (cov_n0zvjkcx1().s[1]++, new ArrayBuffer(string.length * 2));
	  const array = (cov_n0zvjkcx1().s[2]++, new Uint16Array(buffer));
	  cov_n0zvjkcx1().s[3]++;

	  for (let i = (cov_n0zvjkcx1().s[4]++, 0); i < string.length; i++) {
	    cov_n0zvjkcx1().s[5]++;
	    array[i] = string.charCodeAt(i);
	  }

	  cov_n0zvjkcx1().s[6]++;
	  return array;
	};
	cov_n0zvjkcx1().s[7]++;
	const uint8ArrayToString = array => {
	  cov_n0zvjkcx1().f[1]++;
	  cov_n0zvjkcx1().s[8]++;
	  return String.fromCharCode.apply(null, new Uint8Array((cov_n0zvjkcx1().b[0][0]++, array.buffer) || (cov_n0zvjkcx1().b[0][1]++, array)));
	};
	cov_n0zvjkcx1().s[9]++;
	const uint16ArrayToString = array => {
	  cov_n0zvjkcx1().f[2]++;
	  cov_n0zvjkcx1().s[10]++;
	  return String.fromCharCode.apply(null, new Uint16Array((cov_n0zvjkcx1().b[1][0]++, array.buffer) || (cov_n0zvjkcx1().b[1][1]++, array)));
	};
	cov_n0zvjkcx1().s[11]++;
	const getHostnameFromUri = uri => {
	  cov_n0zvjkcx1().f[3]++;
	  const link = (cov_n0zvjkcx1().s[12]++, document_1.createElement('a'));
	  cov_n0zvjkcx1().s[13]++;
	  link.href = uri;
	  cov_n0zvjkcx1().s[14]++;
	  return link.hostname;
	};
	cov_n0zvjkcx1().s[15]++;
	const arrayBuffersEqual = (arrayBuffer1, arrayBuffer2) => {
	  cov_n0zvjkcx1().f[4]++;
	  cov_n0zvjkcx1().s[16]++;

	  if (arrayBuffer1 === arrayBuffer2) {
	    cov_n0zvjkcx1().b[2][0]++;
	    cov_n0zvjkcx1().s[17]++;
	    return true;
	  } else {
	    cov_n0zvjkcx1().b[2][1]++;
	  }

	  cov_n0zvjkcx1().s[18]++;

	  if (arrayBuffer1.byteLength !== arrayBuffer2.byteLength) {
	    cov_n0zvjkcx1().b[3][0]++;
	    cov_n0zvjkcx1().s[19]++;
	    return false;
	  } else {
	    cov_n0zvjkcx1().b[3][1]++;
	  }

	  const dataView1 = (cov_n0zvjkcx1().s[20]++, new DataView(arrayBuffer1));
	  const dataView2 = (cov_n0zvjkcx1().s[21]++, new DataView(arrayBuffer2));
	  cov_n0zvjkcx1().s[22]++;

	  for (let i = (cov_n0zvjkcx1().s[23]++, 0); i < dataView1.byteLength; i++) {
	    cov_n0zvjkcx1().s[24]++;

	    if (dataView1.getUint8(i) !== dataView2.getUint8(i)) {
	      cov_n0zvjkcx1().b[4][0]++;
	      cov_n0zvjkcx1().s[25]++;
	      return false;
	    } else {
	      cov_n0zvjkcx1().b[4][1]++;
	    }
	  }

	  cov_n0zvjkcx1().s[26]++;
	  return true;
	};
	cov_n0zvjkcx1().s[27]++;
	const arrayBufferFrom = bufferOrTypedArray => {
	  cov_n0zvjkcx1().f[5]++;
	  cov_n0zvjkcx1().s[28]++;

	  if ((cov_n0zvjkcx1().b[6][0]++, bufferOrTypedArray instanceof Uint8Array) || (cov_n0zvjkcx1().b[6][1]++, bufferOrTypedArray instanceof Uint16Array)) {
	    cov_n0zvjkcx1().b[5][0]++;
	    cov_n0zvjkcx1().s[29]++;
	    return bufferOrTypedArray.buffer;
	  } else {
	    cov_n0zvjkcx1().b[5][1]++;
	  }

	  cov_n0zvjkcx1().s[30]++;
	  return bufferOrTypedArray;
	}; // Normalize between Video.js 6/7 (videojs.mergeOptions) and 8 (videojs.obj.merge).

	cov_n0zvjkcx1().s[31]++;
	const merge = (...args) => {
	  cov_n0zvjkcx1().f[6]++;
	  const context = (cov_n0zvjkcx1().s[32]++, (cov_n0zvjkcx1().b[7][0]++, videojs__default["default"].obj) || (cov_n0zvjkcx1().b[7][1]++, videojs__default["default"]));
	  const fn = (cov_n0zvjkcx1().s[33]++, (cov_n0zvjkcx1().b[8][0]++, context.merge) || (cov_n0zvjkcx1().b[8][1]++, context.mergeOptions));
	  cov_n0zvjkcx1().s[34]++;
	  return fn.apply(context, args);
	};
	cov_n0zvjkcx1().s[35]++;
	const mergeAndRemoveNull = (...args) => {
	  cov_n0zvjkcx1().f[7]++;
	  const result = (cov_n0zvjkcx1().s[36]++, merge(...args)); // Any header whose value is `null` will be removed.

	  cov_n0zvjkcx1().s[37]++;
	  Object.keys(result).forEach(k => {
	    cov_n0zvjkcx1().f[8]++;
	    cov_n0zvjkcx1().s[38]++;

	    if (result[k] === null) {
	      cov_n0zvjkcx1().b[9][0]++;
	      cov_n0zvjkcx1().s[39]++;
	      delete result[k];
	    } else {
	      cov_n0zvjkcx1().b[9][1]++;
	    }
	  });
	  cov_n0zvjkcx1().s[40]++;
	  return result;
	};
	/**
	* Transforms the keySystems object into a MediaKeySystemConfiguration Object array.
	*
	* @param {Object} keySystems object from the options.
	* @return {Array} of MediaKeySystemConfiguration objects.
	*/

	cov_n0zvjkcx1().s[41]++;
	const getMediaKeySystemConfigurations = keySystems => {
	  cov_n0zvjkcx1().f[9]++;
	  const config = (cov_n0zvjkcx1().s[42]++, []);
	  cov_n0zvjkcx1().s[43]++;
	  Object.keys(keySystems).forEach(keySystem => {
	    cov_n0zvjkcx1().f[10]++;
	    const mediaKeySystemConfig = (cov_n0zvjkcx1().s[44]++, getSupportedConfigurations(keySystem, keySystems[keySystem])[0]);
	    cov_n0zvjkcx1().s[45]++;
	    config.push(mediaKeySystemConfig);
	  });
	  cov_n0zvjkcx1().s[46]++;
	  return config;
	};

	function cov_dxrfrp6d5() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/http-handler.js";
	  var hash = "7c379fc0257b8857bbbb9cdcc2c507c5d0f2d1ef";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/http-handler.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 3,
	          column: 26
	        },
	        end: {
	          line: 3,
	          column: 49
	        }
	      },
	      "1": {
	        start: {
	          line: 7,
	          column: 0
	        },
	        end: {
	          line: 29,
	          column: 1
	        }
	      },
	      "2": {
	        start: {
	          line: 8,
	          column: 2
	        },
	        end: {
	          line: 28,
	          column: 4
	        }
	      },
	      "3": {
	        start: {
	          line: 8,
	          column: 58
	        },
	        end: {
	          line: 28,
	          column: 3
	        }
	      },
	      "4": {
	        start: {
	          line: 9,
	          column: 4
	        },
	        end: {
	          line: 12,
	          column: 5
	        }
	      },
	      "5": {
	        start: {
	          line: 10,
	          column: 6
	        },
	        end: {
	          line: 10,
	          column: 20
	        }
	      },
	      "6": {
	        start: {
	          line: 11,
	          column: 6
	        },
	        end: {
	          line: 11,
	          column: 13
	        }
	      },
	      "7": {
	        start: {
	          line: 15,
	          column: 4
	        },
	        end: {
	          line: 24,
	          column: 5
	        }
	      },
	      "8": {
	        start: {
	          line: 16,
	          column: 18
	        },
	        end: {
	          line: 16,
	          column: 30
	        }
	      },
	      "9": {
	        start: {
	          line: 18,
	          column: 6
	        },
	        end: {
	          line: 20,
	          column: 7
	        }
	      },
	      "10": {
	        start: {
	          line: 19,
	          column: 8
	        },
	        end: {
	          line: 19,
	          column: 78
	        }
	      },
	      "11": {
	        start: {
	          line: 22,
	          column: 6
	        },
	        end: {
	          line: 22,
	          column: 24
	        }
	      },
	      "12": {
	        start: {
	          line: 23,
	          column: 6
	        },
	        end: {
	          line: 23,
	          column: 13
	        }
	      },
	      "13": {
	        start: {
	          line: 27,
	          column: 4
	        },
	        end: {
	          line: 27,
	          column: 33
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 8,
	            column: 24
	          },
	          end: {
	            line: 8,
	            column: 25
	          }
	        },
	        loc: {
	          start: {
	            line: 8,
	            column: 58
	          },
	          end: {
	            line: 28,
	            column: 3
	          }
	        },
	        line: 8
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 8,
	            column: 58
	          },
	          end: {
	            line: 8,
	            column: 59
	          }
	        },
	        loc: {
	          start: {
	            line: 8,
	            column: 91
	          },
	          end: {
	            line: 28,
	            column: 3
	          }
	        },
	        line: 8
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 7,
	            column: 0
	          },
	          end: {
	            line: 29,
	            column: 1
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 7,
	            column: 0
	          },
	          end: {
	            line: 29,
	            column: 1
	          }
	        }, {
	          start: {
	            line: 7,
	            column: 0
	          },
	          end: {
	            line: 29,
	            column: 1
	          }
	        }],
	        line: 7
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 9,
	            column: 4
	          },
	          end: {
	            line: 12,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 9,
	            column: 4
	          },
	          end: {
	            line: 12,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 9,
	            column: 4
	          },
	          end: {
	            line: 12,
	            column: 5
	          }
	        }],
	        line: 9
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 15,
	            column: 4
	          },
	          end: {
	            line: 24,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 15,
	            column: 4
	          },
	          end: {
	            line: 24,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 15,
	            column: 4
	          },
	          end: {
	            line: 24,
	            column: 5
	          }
	        }],
	        line: 15
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 15,
	            column: 8
	          },
	          end: {
	            line: 15,
	            column: 64
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 15,
	            column: 8
	          },
	          end: {
	            line: 15,
	            column: 34
	          }
	        }, {
	          start: {
	            line: 15,
	            column: 38
	          },
	          end: {
	            line: 15,
	            column: 64
	          }
	        }],
	        line: 15
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 18,
	            column: 6
	          },
	          end: {
	            line: 20,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 18,
	            column: 6
	          },
	          end: {
	            line: 20,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 18,
	            column: 6
	          },
	          end: {
	            line: 20,
	            column: 7
	          }
	        }],
	        line: 18
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "7c379fc0257b8857bbbb9cdcc2c507c5d0f2d1ef"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_dxrfrp6d5 = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_dxrfrp6d5();
	let httpResponseHandler = (cov_dxrfrp6d5().s[0]++, videojs__default["default"].xhr.httpHandler); // to make sure this doesn't break with older versions of Video.js,
	// do a super simple wrapper instead

	cov_dxrfrp6d5().s[1]++;

	if (!httpResponseHandler) {
	  cov_dxrfrp6d5().b[0][0]++;
	  cov_dxrfrp6d5().s[2]++;

	  httpResponseHandler = (callback, decodeResponseBody) => {
	    cov_dxrfrp6d5().f[0]++;
	    cov_dxrfrp6d5().s[3]++;
	    return (err, response, responseBody) => {
	      cov_dxrfrp6d5().f[1]++;
	      cov_dxrfrp6d5().s[4]++;

	      if (err) {
	        cov_dxrfrp6d5().b[1][0]++;
	        cov_dxrfrp6d5().s[5]++;
	        callback(err);
	        cov_dxrfrp6d5().s[6]++;
	        return;
	      } else {
	        cov_dxrfrp6d5().b[1][1]++;
	      } // if the HTTP status code is 4xx or 5xx, the request also failed


	      cov_dxrfrp6d5().s[7]++;

	      if ((cov_dxrfrp6d5().b[3][0]++, response.statusCode >= 400) && (cov_dxrfrp6d5().b[3][1]++, response.statusCode <= 599)) {
	        cov_dxrfrp6d5().b[2][0]++;
	        let cause = (cov_dxrfrp6d5().s[8]++, responseBody);
	        cov_dxrfrp6d5().s[9]++;

	        if (decodeResponseBody) {
	          cov_dxrfrp6d5().b[4][0]++;
	          cov_dxrfrp6d5().s[10]++;
	          cause = String.fromCharCode.apply(null, new Uint8Array(responseBody));
	        } else {
	          cov_dxrfrp6d5().b[4][1]++;
	        }

	        cov_dxrfrp6d5().s[11]++;
	        callback({
	          cause
	        });
	        cov_dxrfrp6d5().s[12]++;
	        return;
	      } else {
	        cov_dxrfrp6d5().b[2][1]++;
	      } // otherwise, request succeeded


	      cov_dxrfrp6d5().s[13]++;
	      callback(null, responseBody);
	    };
	  };
	} else {
	  cov_dxrfrp6d5().b[0][1]++;
	}

	function cov_1jp3z7j48a() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/playready.js";
	  var hash = "032254b82a75cb7201161be170d85e77a585bd71";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/playready.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 14,
	          column: 34
	        },
	        end: {
	          line: 53,
	          column: 1
	        }
	      },
	      "1": {
	        start: {
	          line: 16,
	          column: 20
	        },
	        end: {
	          line: 16,
	          column: 77
	        }
	      },
	      "2": {
	        start: {
	          line: 17,
	          column: 14
	        },
	        end: {
	          line: 18,
	          column: 50
	        }
	      },
	      "3": {
	        start: {
	          line: 19,
	          column: 25
	        },
	        end: {
	          line: 19,
	          column: 67
	        }
	      },
	      "4": {
	        start: {
	          line: 20,
	          column: 16
	        },
	        end: {
	          line: 20,
	          column: 18
	        }
	      },
	      "5": {
	        start: {
	          line: 22,
	          column: 2
	        },
	        end: {
	          line: 30,
	          column: 3
	        }
	      },
	      "6": {
	        start: {
	          line: 23,
	          column: 24
	        },
	        end: {
	          line: 23,
	          column: 67
	        }
	      },
	      "7": {
	        start: {
	          line: 24,
	          column: 25
	        },
	        end: {
	          line: 24,
	          column: 69
	        }
	      },
	      "8": {
	        start: {
	          line: 26,
	          column: 4
	        },
	        end: {
	          line: 29,
	          column: 5
	        }
	      },
	      "9": {
	        start: {
	          line: 26,
	          column: 17
	        },
	        end: {
	          line: 26,
	          column: 18
	        }
	      },
	      "10": {
	        start: {
	          line: 27,
	          column: 6
	        },
	        end: {
	          line: 28,
	          column: 48
	        }
	      },
	      "11": {
	        start: {
	          line: 32,
	          column: 27
	        },
	        end: {
	          line: 32,
	          column: 67
	        }
	      },
	      "12": {
	        start: {
	          line: 35,
	          column: 2
	        },
	        end: {
	          line: 37,
	          column: 3
	        }
	      },
	      "13": {
	        start: {
	          line: 36,
	          column: 4
	        },
	        end: {
	          line: 36,
	          column: 70
	        }
	      },
	      "14": {
	        start: {
	          line: 41,
	          column: 2
	        },
	        end: {
	          line: 47,
	          column: 3
	        }
	      },
	      "15": {
	        start: {
	          line: 42,
	          column: 4
	        },
	        end: {
	          line: 45,
	          column: 6
	        }
	      },
	      "16": {
	        start: {
	          line: 46,
	          column: 4
	        },
	        end: {
	          line: 46,
	          column: 24
	        }
	      },
	      "17": {
	        start: {
	          line: 49,
	          column: 2
	        },
	        end: {
	          line: 52,
	          column: 4
	        }
	      },
	      "18": {
	        start: {
	          line: 55,
	          column: 39
	        },
	        end: {
	          line: 74,
	          column: 1
	        }
	      },
	      "19": {
	        start: {
	          line: 56,
	          column: 26
	        },
	        end: {
	          line: 56,
	          column: 59
	        }
	      },
	      "20": {
	        start: {
	          line: 57,
	          column: 18
	        },
	        end: {
	          line: 57,
	          column: 41
	        }
	      },
	      "21": {
	        start: {
	          line: 59,
	          column: 18
	        },
	        end: {
	          line: 63,
	          column: 3
	        }
	      },
	      "22": {
	        start: {
	          line: 65,
	          column: 2
	        },
	        end: {
	          line: 73,
	          column: 42
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 14,
	            column: 34
	          },
	          end: {
	            line: 14,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 14,
	            column: 47
	          },
	          end: {
	            line: 53,
	            column: 1
	          }
	        },
	        line: 14
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 55,
	            column: 39
	          },
	          end: {
	            line: 55,
	            column: 40
	          }
	        },
	        loc: {
	          start: {
	            line: 55,
	            column: 109
	          },
	          end: {
	            line: 74,
	            column: 1
	          }
	        },
	        line: 55
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 22,
	            column: 2
	          },
	          end: {
	            line: 30,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 22,
	            column: 2
	          },
	          end: {
	            line: 30,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 22,
	            column: 2
	          },
	          end: {
	            line: 30,
	            column: 3
	          }
	        }],
	        line: 22
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 35,
	            column: 2
	          },
	          end: {
	            line: 37,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 35,
	            column: 2
	          },
	          end: {
	            line: 37,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 35,
	            column: 2
	          },
	          end: {
	            line: 37,
	            column: 3
	          }
	        }],
	        line: 35
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 41,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 41,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 41,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        }],
	        line: 41
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "032254b82a75cb7201161be170d85e77a585bd71"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_1jp3z7j48a = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_1jp3z7j48a();
	/**
	* Parses the EME key message XML to extract HTTP headers and the Challenge element to use
	* in the PlayReady license request.
	*
	* @param {ArrayBuffer} message key message from EME
	* @return {Object} an object containing headers and the message body to use in the
	* license request
	*/

	cov_1jp3z7j48a().s[0]++;
	const getMessageContents = message => {
	  cov_1jp3z7j48a().f[0]++; // TODO do we want to support UTF-8?

	  const xmlString = (cov_1jp3z7j48a().s[1]++, String.fromCharCode.apply(null, new Uint16Array(message)));
	  const xml = (cov_1jp3z7j48a().s[2]++, new window_1.DOMParser().parseFromString(xmlString, 'application/xml'));
	  const headersElement = (cov_1jp3z7j48a().s[3]++, xml.getElementsByTagName('HttpHeaders')[0]);
	  let headers = (cov_1jp3z7j48a().s[4]++, {});
	  cov_1jp3z7j48a().s[5]++;

	  if (headersElement) {
	    cov_1jp3z7j48a().b[0][0]++;
	    const headerNames = (cov_1jp3z7j48a().s[6]++, headersElement.getElementsByTagName('name'));
	    const headerValues = (cov_1jp3z7j48a().s[7]++, headersElement.getElementsByTagName('value'));
	    cov_1jp3z7j48a().s[8]++;

	    for (let i = (cov_1jp3z7j48a().s[9]++, 0); i < headerNames.length; i++) {
	      cov_1jp3z7j48a().s[10]++;
	      headers[headerNames[i].childNodes[0].nodeValue] = headerValues[i].childNodes[0].nodeValue;
	    }
	  } else {
	    cov_1jp3z7j48a().b[0][1]++;
	  }

	  const challengeElement = (cov_1jp3z7j48a().s[11]++, xml.getElementsByTagName('Challenge')[0]);
	  let challenge;
	  cov_1jp3z7j48a().s[12]++;

	  if (challengeElement) {
	    cov_1jp3z7j48a().b[1][0]++;
	    cov_1jp3z7j48a().s[13]++;
	    challenge = window_1.atob(challengeElement.childNodes[0].nodeValue);
	  } else {
	    cov_1jp3z7j48a().b[1][1]++;
	  } // If we failed to parse the xml the soap message might be encoded already.
	  // set the message data as the challenge and add generic SOAP headers.


	  cov_1jp3z7j48a().s[14]++;

	  if (xml.querySelector('parsererror')) {
	    cov_1jp3z7j48a().b[2][0]++;
	    cov_1jp3z7j48a().s[15]++;
	    headers = {
	      'Content-Type': 'text/xml; charset=utf-8',
	      'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	    };
	    cov_1jp3z7j48a().s[16]++;
	    challenge = message;
	  } else {
	    cov_1jp3z7j48a().b[2][1]++;
	  }

	  cov_1jp3z7j48a().s[17]++;
	  return {
	    headers,
	    message: challenge
	  };
	};
	cov_1jp3z7j48a().s[18]++;
	const requestPlayreadyLicense = (keySystem, keySystemOptions, messageBuffer, emeOptions, callback) => {
	  cov_1jp3z7j48a().f[1]++;
	  const messageContents = (cov_1jp3z7j48a().s[19]++, getMessageContents(messageBuffer));
	  const message = (cov_1jp3z7j48a().s[20]++, messageContents.message);
	  const headers = (cov_1jp3z7j48a().s[21]++, mergeAndRemoveNull(messageContents.headers, emeOptions.emeHeaders, keySystemOptions.licenseHeaders));
	  cov_1jp3z7j48a().s[22]++;
	  videojs__default["default"].xhr({
	    uri: keySystemOptions.url,
	    method: 'post',
	    headers,
	    body: message,
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem
	    }
	  }, httpResponseHandler(callback, true));
	};

	function cov_4rt6evt8b() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/consts/errors.js";
	  var hash = "d0d40e104bcbb4cbe84c04c3eb1c434047da34c8";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/consts/errors.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 1,
	          column: 14
	        },
	        end: {
	          line: 12,
	          column: 1
	        }
	      }
	    },
	    fnMap: {},
	    branchMap: {},
	    s: {
	      "0": 0
	    },
	    f: {},
	    b: {},
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "d0d40e104bcbb4cbe84c04c3eb1c434047da34c8"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_4rt6evt8b = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_4rt6evt8b();
	const Error$1 = (cov_4rt6evt8b().s[0]++, {
	  EMEFailedToRequestMediaKeySystemAccess: 'eme-failed-request-media-key-system-access',
	  EMEFailedToCreateMediaKeys: 'eme-failed-create-media-keys',
	  EMEFailedToAttachMediaKeysToVideoElement: 'eme-failed-attach-media-keys-to-video',
	  EMEFailedToCreateMediaKeySession: 'eme-failed-create-media-key-session',
	  EMEFailedToSetServerCertificate: 'eme-failed-set-server-certificate',
	  EMEFailedToGenerateLicenseRequest: 'eme-failed-generate-license-request',
	  EMEFailedToUpdateSessionWithReceivedLicenseKeys: 'eme-failed-update-session',
	  EMEFailedToCloseSession: 'eme-failed-close-session',
	  EMEFailedToRemoveKeysFromSession: 'eme-failed-remove-keys',
	  EMEFailedToLoadSessionBySessionId: 'eme-failed-load-session'
	});

	function cov_1a1lzszcbn() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/fairplay.js";
	  var hash = "8a30dbbc2056d37a1ac893a2b10d08eb8548e49a";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/fairplay.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 15,
	          column: 42
	        },
	        end: {
	          line: 15,
	          column: 61
	        }
	      },
	      "1": {
	        start: {
	          line: 17,
	          column: 39
	        },
	        end: {
	          line: 52,
	          column: 1
	        }
	      },
	      "2": {
	        start: {
	          line: 18,
	          column: 2
	        },
	        end: {
	          line: 20,
	          column: 3
	        }
	      },
	      "3": {
	        start: {
	          line: 19,
	          column: 4
	        },
	        end: {
	          line: 19,
	          column: 33
	        }
	      },
	      "4": {
	        start: {
	          line: 28,
	          column: 15
	        },
	        end: {
	          line: 28,
	          column: 16
	        }
	      },
	      "5": {
	        start: {
	          line: 29,
	          column: 17
	        },
	        end: {
	          line: 29,
	          column: 95
	        }
	      },
	      "6": {
	        start: {
	          line: 30,
	          column: 19
	        },
	        end: {
	          line: 30,
	          column: 39
	        }
	      },
	      "7": {
	        start: {
	          line: 31,
	          column: 24
	        },
	        end: {
	          line: 31,
	          column: 75
	        }
	      },
	      "8": {
	        start: {
	          line: 33,
	          column: 2
	        },
	        end: {
	          line: 33,
	          column: 30
	        }
	      },
	      "9": {
	        start: {
	          line: 34,
	          column: 2
	        },
	        end: {
	          line: 34,
	          column: 32
	        }
	      },
	      "10": {
	        start: {
	          line: 36,
	          column: 2
	        },
	        end: {
	          line: 36,
	          column: 50
	        }
	      },
	      "11": {
	        start: {
	          line: 37,
	          column: 2
	        },
	        end: {
	          line: 37,
	          column: 14
	        }
	      },
	      "12": {
	        start: {
	          line: 39,
	          column: 18
	        },
	        end: {
	          line: 39,
	          column: 60
	        }
	      },
	      "13": {
	        start: {
	          line: 41,
	          column: 2
	        },
	        end: {
	          line: 41,
	          column: 18
	        }
	      },
	      "14": {
	        start: {
	          line: 42,
	          column: 2
	        },
	        end: {
	          line: 42,
	          column: 31
	        }
	      },
	      "15": {
	        start: {
	          line: 44,
	          column: 2
	        },
	        end: {
	          line: 44,
	          column: 52
	        }
	      },
	      "16": {
	        start: {
	          line: 45,
	          column: 2
	        },
	        end: {
	          line: 45,
	          column: 14
	        }
	      },
	      "17": {
	        start: {
	          line: 47,
	          column: 20
	        },
	        end: {
	          line: 47,
	          column: 67
	        }
	      },
	      "18": {
	        start: {
	          line: 49,
	          column: 2
	        },
	        end: {
	          line: 49,
	          column: 22
	        }
	      },
	      "19": {
	        start: {
	          line: 51,
	          column: 2
	        },
	        end: {
	          line: 51,
	          column: 54
	        }
	      },
	      "20": {
	        start: {
	          line: 54,
	          column: 15
	        },
	        end: {
	          line: 142,
	          column: 1
	        }
	      },
	      "21": {
	        start: {
	          line: 55,
	          column: 2
	        },
	        end: {
	          line: 141,
	          column: 5
	        }
	      },
	      "22": {
	        start: {
	          line: 56,
	          column: 4
	        },
	        end: {
	          line: 69,
	          column: 5
	        }
	      },
	      "23": {
	        start: {
	          line: 57,
	          column: 6
	        },
	        end: {
	          line: 68,
	          column: 7
	        }
	      },
	      "24": {
	        start: {
	          line: 58,
	          column: 8
	        },
	        end: {
	          line: 58,
	          column: 89
	        }
	      },
	      "25": {
	        start: {
	          line: 60,
	          column: 25
	        },
	        end: {
	          line: 63,
	          column: 9
	        }
	      },
	      "26": {
	        start: {
	          line: 65,
	          column: 8
	        },
	        end: {
	          line: 65,
	          column: 34
	        }
	      },
	      "27": {
	        start: {
	          line: 66,
	          column: 8
	        },
	        end: {
	          line: 66,
	          column: 45
	        }
	      },
	      "28": {
	        start: {
	          line: 67,
	          column: 8
	        },
	        end: {
	          line: 67,
	          column: 15
	        }
	      },
	      "29": {
	        start: {
	          line: 73,
	          column: 4
	        },
	        end: {
	          line: 87,
	          column: 5
	        }
	      },
	      "30": {
	        start: {
	          line: 74,
	          column: 6
	        },
	        end: {
	          line: 77,
	          column: 8
	        }
	      },
	      "31": {
	        start: {
	          line: 79,
	          column: 23
	        },
	        end: {
	          line: 82,
	          column: 7
	        }
	      },
	      "32": {
	        start: {
	          line: 84,
	          column: 6
	        },
	        end: {
	          line: 84,
	          column: 32
	        }
	      },
	      "33": {
	        start: {
	          line: 85,
	          column: 6
	        },
	        end: {
	          line: 85,
	          column: 45
	        }
	      },
	      "34": {
	        start: {
	          line: 86,
	          column: 6
	        },
	        end: {
	          line: 86,
	          column: 13
	        }
	      },
	      "35": {
	        start: {
	          line: 89,
	          column: 4
	        },
	        end: {
	          line: 92,
	          column: 7
	        }
	      },
	      "36": {
	        start: {
	          line: 94,
	          column: 4
	        },
	        end: {
	          line: 94,
	          column: 37
	        }
	      },
	      "37": {
	        start: {
	          line: 96,
	          column: 4
	        },
	        end: {
	          line: 124,
	          column: 7
	        }
	      },
	      "38": {
	        start: {
	          line: 97,
	          column: 6
	        },
	        end: {
	          line: 100,
	          column: 9
	        }
	      },
	      "39": {
	        start: {
	          line: 101,
	          column: 6
	        },
	        end: {
	          line: 123,
	          column: 9
	        }
	      },
	      "40": {
	        start: {
	          line: 102,
	          column: 8
	        },
	        end: {
	          line: 105,
	          column: 9
	        }
	      },
	      "41": {
	        start: {
	          line: 104,
	          column: 10
	        },
	        end: {
	          line: 104,
	          column: 79
	        }
	      },
	      "42": {
	        start: {
	          line: 106,
	          column: 8
	        },
	        end: {
	          line: 115,
	          column: 9
	        }
	      },
	      "43": {
	        start: {
	          line: 107,
	          column: 27
	        },
	        end: {
	          line: 110,
	          column: 11
	        }
	      },
	      "44": {
	        start: {
	          line: 112,
	          column: 10
	        },
	        end: {
	          line: 112,
	          column: 34
	        }
	      },
	      "45": {
	        start: {
	          line: 113,
	          column: 10
	        },
	        end: {
	          line: 113,
	          column: 22
	        }
	      },
	      "46": {
	        start: {
	          line: 114,
	          column: 10
	        },
	        end: {
	          line: 114,
	          column: 17
	        }
	      },
	      "47": {
	        start: {
	          line: 117,
	          column: 8
	        },
	        end: {
	          line: 117,
	          column: 51
	        }
	      },
	      "48": {
	        start: {
	          line: 119,
	          column: 8
	        },
	        end: {
	          line: 122,
	          column: 11
	        }
	      },
	      "49": {
	        start: {
	          line: 126,
	          column: 4
	        },
	        end: {
	          line: 128,
	          column: 7
	        }
	      },
	      "50": {
	        start: {
	          line: 127,
	          column: 6
	        },
	        end: {
	          line: 127,
	          column: 16
	        }
	      },
	      "51": {
	        start: {
	          line: 131,
	          column: 4
	        },
	        end: {
	          line: 140,
	          column: 7
	        }
	      },
	      "52": {
	        start: {
	          line: 132,
	          column: 20
	        },
	        end: {
	          line: 132,
	          column: 36
	        }
	      },
	      "53": {
	        start: {
	          line: 133,
	          column: 23
	        },
	        end: {
	          line: 136,
	          column: 7
	        }
	      },
	      "54": {
	        start: {
	          line: 138,
	          column: 6
	        },
	        end: {
	          line: 138,
	          column: 32
	        }
	      },
	      "55": {
	        start: {
	          line: 139,
	          column: 6
	        },
	        end: {
	          line: 139,
	          column: 85
	        }
	      },
	      "56": {
	        start: {
	          line: 144,
	          column: 37
	        },
	        end: {
	          line: 169,
	          column: 1
	        }
	      },
	      "57": {
	        start: {
	          line: 145,
	          column: 2
	        },
	        end: {
	          line: 168,
	          column: 4
	        }
	      },
	      "58": {
	        start: {
	          line: 146,
	          column: 20
	        },
	        end: {
	          line: 149,
	          column: 5
	        }
	      },
	      "59": {
	        start: {
	          line: 151,
	          column: 4
	        },
	        end: {
	          line: 167,
	          column: 8
	        }
	      },
	      "60": {
	        start: {
	          line: 158,
	          column: 6
	        },
	        end: {
	          line: 161,
	          column: 7
	        }
	      },
	      "61": {
	        start: {
	          line: 159,
	          column: 8
	        },
	        end: {
	          line: 159,
	          column: 22
	        }
	      },
	      "62": {
	        start: {
	          line: 160,
	          column: 8
	        },
	        end: {
	          line: 160,
	          column: 15
	        }
	      },
	      "63": {
	        start: {
	          line: 166,
	          column: 6
	        },
	        end: {
	          line: 166,
	          column: 46
	        }
	      },
	      "64": {
	        start: {
	          line: 171,
	          column: 35
	        },
	        end: {
	          line: 173,
	          column: 1
	        }
	      },
	      "65": {
	        start: {
	          line: 172,
	          column: 2
	        },
	        end: {
	          line: 172,
	          column: 44
	        }
	      },
	      "66": {
	        start: {
	          line: 175,
	          column: 33
	        },
	        end: {
	          line: 193,
	          column: 1
	        }
	      },
	      "67": {
	        start: {
	          line: 176,
	          column: 2
	        },
	        end: {
	          line: 192,
	          column: 4
	        }
	      },
	      "68": {
	        start: {
	          line: 177,
	          column: 20
	        },
	        end: {
	          line: 181,
	          column: 5
	        }
	      },
	      "69": {
	        start: {
	          line: 183,
	          column: 4
	        },
	        end: {
	          line: 191,
	          column: 44
	        }
	      },
	      "70": {
	        start: {
	          line: 195,
	          column: 17
	        },
	        end: {
	          line: 230,
	          column: 1
	        }
	      },
	      "71": {
	        start: {
	          line: 196,
	          column: 26
	        },
	        end: {
	          line: 196,
	          column: 72
	        }
	      },
	      "72": {
	        start: {
	          line: 197,
	          column: 25
	        },
	        end: {
	          line: 198,
	          column: 70
	        }
	      },
	      "73": {
	        start: {
	          line: 199,
	          column: 23
	        },
	        end: {
	          line: 199,
	          column: 74
	        }
	      },
	      "74": {
	        start: {
	          line: 200,
	          column: 21
	        },
	        end: {
	          line: 201,
	          column: 66
	        }
	      },
	      "75": {
	        start: {
	          line: 203,
	          column: 2
	        },
	        end: {
	          line: 229,
	          column: 5
	        }
	      },
	      "76": {
	        start: {
	          line: 204,
	          column: 4
	        },
	        end: {
	          line: 217,
	          column: 7
	        }
	      },
	      "77": {
	        start: {
	          line: 205,
	          column: 6
	        },
	        end: {
	          line: 214,
	          column: 7
	        }
	      },
	      "78": {
	        start: {
	          line: 206,
	          column: 25
	        },
	        end: {
	          line: 209,
	          column: 9
	        }
	      },
	      "79": {
	        start: {
	          line: 211,
	          column: 8
	        },
	        end: {
	          line: 211,
	          column: 32
	        }
	      },
	      "80": {
	        start: {
	          line: 212,
	          column: 8
	        },
	        end: {
	          line: 212,
	          column: 20
	        }
	      },
	      "81": {
	        start: {
	          line: 213,
	          column: 8
	        },
	        end: {
	          line: 213,
	          column: 15
	        }
	      },
	      "82": {
	        start: {
	          line: 216,
	          column: 6
	        },
	        end: {
	          line: 216,
	          column: 20
	        }
	      },
	      "83": {
	        start: {
	          line: 219,
	          column: 4
	        },
	        end: {
	          line: 228,
	          column: 7
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 17,
	            column: 39
	          },
	          end: {
	            line: 17,
	            column: 40
	          }
	        },
	        loc: {
	          start: {
	            line: 17,
	            column: 65
	          },
	          end: {
	            line: 52,
	            column: 1
	          }
	        },
	        line: 17
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 54,
	            column: 15
	          },
	          end: {
	            line: 54,
	            column: 16
	          }
	        },
	        loc: {
	          start: {
	            line: 54,
	            column: 96
	          },
	          end: {
	            line: 142,
	            column: 1
	          }
	        },
	        line: 54
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 55,
	            column: 21
	          },
	          end: {
	            line: 55,
	            column: 22
	          }
	        },
	        loc: {
	          start: {
	            line: 55,
	            column: 42
	          },
	          end: {
	            line: 141,
	            column: 3
	          }
	        },
	        line: 55
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 96,
	            column: 52
	          },
	          end: {
	            line: 96,
	            column: 53
	          }
	        },
	        loc: {
	          start: {
	            line: 96,
	            column: 63
	          },
	          end: {
	            line: 124,
	            column: 5
	          }
	        },
	        line: 96
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 101,
	            column: 52
	          },
	          end: {
	            line: 101,
	            column: 53
	          }
	        },
	        loc: {
	          start: {
	            line: 101,
	            column: 70
	          },
	          end: {
	            line: 123,
	            column: 7
	          }
	        },
	        line: 101
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 126,
	            column: 50
	          },
	          end: {
	            line: 126,
	            column: 51
	          }
	        },
	        loc: {
	          start: {
	            line: 126,
	            column: 56
	          },
	          end: {
	            line: 128,
	            column: 5
	          }
	        },
	        line: 126
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 131,
	            column: 50
	          },
	          end: {
	            line: 131,
	            column: 51
	          }
	        },
	        loc: {
	          start: {
	            line: 131,
	            column: 56
	          },
	          end: {
	            line: 140,
	            column: 5
	          }
	        },
	        line: 131
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 144,
	            column: 37
	          },
	          end: {
	            line: 144,
	            column: 38
	          }
	        },
	        loc: {
	          start: {
	            line: 144,
	            column: 69
	          },
	          end: {
	            line: 169,
	            column: 1
	          }
	        },
	        line: 144
	      },
	      "8": {
	        name: "(anonymous_8)",
	        decl: {
	          start: {
	            line: 145,
	            column: 9
	          },
	          end: {
	            line: 145,
	            column: 10
	          }
	        },
	        loc: {
	          start: {
	            line: 145,
	            column: 35
	          },
	          end: {
	            line: 168,
	            column: 3
	          }
	        },
	        line: 145
	      },
	      "9": {
	        name: "(anonymous_9)",
	        decl: {
	          start: {
	            line: 157,
	            column: 27
	          },
	          end: {
	            line: 157,
	            column: 28
	          }
	        },
	        loc: {
	          start: {
	            line: 157,
	            column: 45
	          },
	          end: {
	            line: 167,
	            column: 5
	          }
	        },
	        line: 157
	      },
	      "10": {
	        name: "(anonymous_10)",
	        decl: {
	          start: {
	            line: 171,
	            column: 35
	          },
	          end: {
	            line: 171,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 171,
	            column: 67
	          },
	          end: {
	            line: 173,
	            column: 1
	          }
	        },
	        line: 171
	      },
	      "11": {
	        name: "(anonymous_11)",
	        decl: {
	          start: {
	            line: 175,
	            column: 33
	          },
	          end: {
	            line: 175,
	            column: 34
	          }
	        },
	        loc: {
	          start: {
	            line: 175,
	            column: 65
	          },
	          end: {
	            line: 193,
	            column: 1
	          }
	        },
	        line: 175
	      },
	      "12": {
	        name: "(anonymous_12)",
	        decl: {
	          start: {
	            line: 176,
	            column: 9
	          },
	          end: {
	            line: 176,
	            column: 10
	          }
	        },
	        loc: {
	          start: {
	            line: 176,
	            column: 58
	          },
	          end: {
	            line: 192,
	            column: 3
	          }
	        },
	        line: 176
	      },
	      "13": {
	        name: "(anonymous_13)",
	        decl: {
	          start: {
	            line: 195,
	            column: 17
	          },
	          end: {
	            line: 195,
	            column: 18
	          }
	        },
	        loc: {
	          start: {
	            line: 195,
	            column: 69
	          },
	          end: {
	            line: 230,
	            column: 1
	          }
	        },
	        line: 195
	      },
	      "14": {
	        name: "(anonymous_14)",
	        decl: {
	          start: {
	            line: 203,
	            column: 21
	          },
	          end: {
	            line: 203,
	            column: 22
	          }
	        },
	        loc: {
	          start: {
	            line: 203,
	            column: 42
	          },
	          end: {
	            line: 218,
	            column: 3
	          }
	        },
	        line: 203
	      },
	      "15": {
	        name: "(anonymous_15)",
	        decl: {
	          start: {
	            line: 204,
	            column: 28
	          },
	          end: {
	            line: 204,
	            column: 29
	          }
	        },
	        loc: {
	          start: {
	            line: 204,
	            column: 43
	          },
	          end: {
	            line: 217,
	            column: 5
	          }
	        },
	        line: 204
	      },
	      "16": {
	        name: "(anonymous_16)",
	        decl: {
	          start: {
	            line: 218,
	            column: 10
	          },
	          end: {
	            line: 218,
	            column: 11
	          }
	        },
	        loc: {
	          start: {
	            line: 218,
	            column: 20
	          },
	          end: {
	            line: 229,
	            column: 3
	          }
	        },
	        line: 218
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 20,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 20,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 20,
	            column: 3
	          }
	        }],
	        line: 18
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 56,
	            column: 4
	          },
	          end: {
	            line: 69,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 56,
	            column: 4
	          },
	          end: {
	            line: 69,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 56,
	            column: 4
	          },
	          end: {
	            line: 69,
	            column: 5
	          }
	        }],
	        line: 56
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 102,
	            column: 8
	          },
	          end: {
	            line: 105,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 102,
	            column: 8
	          },
	          end: {
	            line: 105,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 102,
	            column: 8
	          },
	          end: {
	            line: 105,
	            column: 9
	          }
	        }],
	        line: 102
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 106,
	            column: 8
	          },
	          end: {
	            line: 115,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 106,
	            column: 8
	          },
	          end: {
	            line: 115,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 106,
	            column: 8
	          },
	          end: {
	            line: 115,
	            column: 9
	          }
	        }],
	        line: 106
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 158,
	            column: 6
	          },
	          end: {
	            line: 161,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 158,
	            column: 6
	          },
	          end: {
	            line: 161,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 158,
	            column: 6
	          },
	          end: {
	            line: 161,
	            column: 7
	          }
	        }],
	        line: 158
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 184,
	            column: 11
	          },
	          end: {
	            line: 184,
	            column: 60
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 184,
	            column: 11
	          },
	          end: {
	            line: 184,
	            column: 37
	          }
	        }, {
	          start: {
	            line: 184,
	            column: 41
	          },
	          end: {
	            line: 184,
	            column: 60
	          }
	        }],
	        line: 184
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 197,
	            column: 25
	          },
	          end: {
	            line: 198,
	            column: 70
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 197,
	            column: 25
	          },
	          end: {
	            line: 197,
	            column: 55
	          }
	        }, {
	          start: {
	            line: 198,
	            column: 4
	          },
	          end: {
	            line: 198,
	            column: 70
	          }
	        }],
	        line: 197
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 199,
	            column: 23
	          },
	          end: {
	            line: 199,
	            column: 74
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 199,
	            column: 23
	          },
	          end: {
	            line: 199,
	            column: 51
	          }
	        }, {
	          start: {
	            line: 199,
	            column: 55
	          },
	          end: {
	            line: 199,
	            column: 74
	          }
	        }],
	        line: 199
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 200,
	            column: 21
	          },
	          end: {
	            line: 201,
	            column: 66
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 200,
	            column: 21
	          },
	          end: {
	            line: 200,
	            column: 47
	          }
	        }, {
	          start: {
	            line: 201,
	            column: 4
	          },
	          end: {
	            line: 201,
	            column: 66
	          }
	        }],
	        line: 200
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 205,
	            column: 6
	          },
	          end: {
	            line: 214,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 205,
	            column: 6
	          },
	          end: {
	            line: 214,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 205,
	            column: 6
	          },
	          end: {
	            line: 214,
	            column: 7
	          }
	        }],
	        line: 205
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0,
	      "56": 0,
	      "57": 0,
	      "58": 0,
	      "59": 0,
	      "60": 0,
	      "61": 0,
	      "62": 0,
	      "63": 0,
	      "64": 0,
	      "65": 0,
	      "66": 0,
	      "67": 0,
	      "68": 0,
	      "69": 0,
	      "70": 0,
	      "71": 0,
	      "72": 0,
	      "73": 0,
	      "74": 0,
	      "75": 0,
	      "76": 0,
	      "77": 0,
	      "78": 0,
	      "79": 0,
	      "80": 0,
	      "81": 0,
	      "82": 0,
	      "83": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "8a30dbbc2056d37a1ac893a2b10d08eb8548e49a"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_1a1lzszcbn = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_1a1lzszcbn();
	const LEGACY_FAIRPLAY_KEY_SYSTEM = (cov_1a1lzszcbn().s[0]++, 'com.apple.fps.1_0');
	cov_1a1lzszcbn().s[1]++;

	const concatInitDataIdAndCertificate = ({
	  initData,
	  id,
	  cert
	}) => {
	  cov_1a1lzszcbn().f[0]++;
	  cov_1a1lzszcbn().s[2]++;

	  if (typeof id === 'string') {
	    cov_1a1lzszcbn().b[0][0]++;
	    cov_1a1lzszcbn().s[3]++;
	    id = stringToUint16Array(id);
	  } else {
	    cov_1a1lzszcbn().b[0][1]++;
	  } // layout:
	  //   [initData]
	  //   [4 byte: idLength]
	  //   [idLength byte: id]
	  //   [4 byte:certLength]
	  //   [certLength byte: cert]


	  let offset = (cov_1a1lzszcbn().s[4]++, 0);
	  const buffer = (cov_1a1lzszcbn().s[5]++, new ArrayBuffer(initData.byteLength + 4 + id.byteLength + 4 + cert.byteLength));
	  const dataView = (cov_1a1lzszcbn().s[6]++, new DataView(buffer));
	  const initDataArray = (cov_1a1lzszcbn().s[7]++, new Uint8Array(buffer, offset, initData.byteLength));
	  cov_1a1lzszcbn().s[8]++;
	  initDataArray.set(initData);
	  cov_1a1lzszcbn().s[9]++;
	  offset += initData.byteLength;
	  cov_1a1lzszcbn().s[10]++;
	  dataView.setUint32(offset, id.byteLength, true);
	  cov_1a1lzszcbn().s[11]++;
	  offset += 4;
	  const idArray = (cov_1a1lzszcbn().s[12]++, new Uint16Array(buffer, offset, id.length));
	  cov_1a1lzszcbn().s[13]++;
	  idArray.set(id);
	  cov_1a1lzszcbn().s[14]++;
	  offset += idArray.byteLength;
	  cov_1a1lzszcbn().s[15]++;
	  dataView.setUint32(offset, cert.byteLength, true);
	  cov_1a1lzszcbn().s[16]++;
	  offset += 4;
	  const certArray = (cov_1a1lzszcbn().s[17]++, new Uint8Array(buffer, offset, cert.byteLength));
	  cov_1a1lzszcbn().s[18]++;
	  certArray.set(cert);
	  cov_1a1lzszcbn().s[19]++;
	  return new Uint8Array(buffer, 0, buffer.byteLength);
	};

	cov_1a1lzszcbn().s[20]++;

	const addKey = ({
	  video,
	  contentId,
	  initData,
	  cert,
	  options,
	  getLicense,
	  eventBus,
	  emeError
	}) => {
	  cov_1a1lzszcbn().f[1]++;
	  cov_1a1lzszcbn().s[21]++;
	  return new Promise((resolve, reject) => {
	    cov_1a1lzszcbn().f[2]++;
	    cov_1a1lzszcbn().s[22]++;

	    if (!video.webkitKeys) {
	      cov_1a1lzszcbn().b[1][0]++;
	      cov_1a1lzszcbn().s[23]++;

	      try {
	        cov_1a1lzszcbn().s[24]++;
	        video.webkitSetMediaKeys(new window_1.WebKitMediaKeys(LEGACY_FAIRPLAY_KEY_SYSTEM));
	      } catch (error) {
	        const metadata = (cov_1a1lzszcbn().s[25]++, {
	          errorType: Error$1.EMEFailedToCreateMediaKeys,
	          keySystem: LEGACY_FAIRPLAY_KEY_SYSTEM
	        });
	        cov_1a1lzszcbn().s[26]++;
	        emeError(error, metadata);
	        cov_1a1lzszcbn().s[27]++;
	        reject('Could not create MediaKeys');
	        cov_1a1lzszcbn().s[28]++;
	        return;
	      }
	    } else {
	      cov_1a1lzszcbn().b[1][1]++;
	    }

	    let keySession;
	    cov_1a1lzszcbn().s[29]++;

	    try {
	      cov_1a1lzszcbn().s[30]++;
	      keySession = video.webkitKeys.createSession('video/mp4', concatInitDataIdAndCertificate({
	        id: contentId,
	        initData,
	        cert
	      }));
	    } catch (error) {
	      const metadata = (cov_1a1lzszcbn().s[31]++, {
	        errorType: Error$1.EMEFailedToCreateMediaKeySession,
	        keySystem: LEGACY_FAIRPLAY_KEY_SYSTEM
	      });
	      cov_1a1lzszcbn().s[32]++;
	      emeError(error, metadata);
	      cov_1a1lzszcbn().s[33]++;
	      reject('Could not create key session');
	      cov_1a1lzszcbn().s[34]++;
	      return;
	    }

	    cov_1a1lzszcbn().s[35]++;
	    safeTriggerOnEventBus(eventBus, {
	      type: 'keysessioncreated',
	      keySession
	    });
	    cov_1a1lzszcbn().s[36]++;
	    keySession.contentId = contentId;
	    cov_1a1lzszcbn().s[37]++;
	    keySession.addEventListener('webkitkeymessage', event => {
	      cov_1a1lzszcbn().f[3]++;
	      cov_1a1lzszcbn().s[38]++;
	      safeTriggerOnEventBus(eventBus, {
	        type: 'keymessage',
	        messageEvent: event
	      });
	      cov_1a1lzszcbn().s[39]++;
	      getLicense(options, contentId, event.message, (err, license) => {
	        cov_1a1lzszcbn().f[4]++;
	        cov_1a1lzszcbn().s[40]++;

	        if (eventBus) {
	          cov_1a1lzszcbn().b[2][0]++;
	          cov_1a1lzszcbn().s[41]++;
	          safeTriggerOnEventBus(eventBus, {
	            type: 'licenserequestattempted'
	          });
	        } else {
	          cov_1a1lzszcbn().b[2][1]++;
	        }

	        cov_1a1lzszcbn().s[42]++;

	        if (err) {
	          cov_1a1lzszcbn().b[3][0]++;
	          const metadata = (cov_1a1lzszcbn().s[43]++, {
	            errortype: Error$1.EMEFailedToGenerateLicenseRequest,
	            keySystem: LEGACY_FAIRPLAY_KEY_SYSTEM
	          });
	          cov_1a1lzszcbn().s[44]++;
	          emeError(err, metadata);
	          cov_1a1lzszcbn().s[45]++;
	          reject(err);
	          cov_1a1lzszcbn().s[46]++;
	          return;
	        } else {
	          cov_1a1lzszcbn().b[3][1]++;
	        }

	        cov_1a1lzszcbn().s[47]++;
	        keySession.update(new Uint8Array(license));
	        cov_1a1lzszcbn().s[48]++;
	        safeTriggerOnEventBus(eventBus, {
	          type: 'keysessionupdated',
	          keySession
	        });
	      });
	    });
	    cov_1a1lzszcbn().s[49]++;
	    keySession.addEventListener('webkitkeyadded', () => {
	      cov_1a1lzszcbn().f[5]++;
	      cov_1a1lzszcbn().s[50]++;
	      resolve();
	    }); // for testing purposes, adding webkitkeyerror must be the last item in this method

	    cov_1a1lzszcbn().s[51]++;
	    keySession.addEventListener('webkitkeyerror', () => {
	      cov_1a1lzszcbn().f[6]++;
	      const error = (cov_1a1lzszcbn().s[52]++, keySession.error);
	      const metadata = (cov_1a1lzszcbn().s[53]++, {
	        errorType: Error$1.EMEFailedToUpdateSessionWithReceivedLicenseKeys,
	        keySystem: LEGACY_FAIRPLAY_KEY_SYSTEM
	      });
	      cov_1a1lzszcbn().s[54]++;
	      emeError(error, metadata);
	      cov_1a1lzszcbn().s[55]++;
	      reject(`KeySession error: code ${error.code}, systemCode ${error.systemCode}`);
	    });
	  });
	};

	cov_1a1lzszcbn().s[56]++;
	const defaultGetCertificate = (keySystem, fairplayOptions) => {
	  cov_1a1lzszcbn().f[7]++;
	  cov_1a1lzszcbn().s[57]++;
	  return (emeOptions, callback) => {
	    cov_1a1lzszcbn().f[8]++;
	    const headers = (cov_1a1lzszcbn().s[58]++, mergeAndRemoveNull(emeOptions.emeHeaders, fairplayOptions.certificateHeaders));
	    cov_1a1lzszcbn().s[59]++;
	    videojs__default["default"].xhr({
	      uri: fairplayOptions.certificateUri,
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem
	      },
	      headers
	    }, httpResponseHandler((err, license) => {
	      cov_1a1lzszcbn().f[9]++;
	      cov_1a1lzszcbn().s[60]++;

	      if (err) {
	        cov_1a1lzszcbn().b[4][0]++;
	        cov_1a1lzszcbn().s[61]++;
	        callback(err);
	        cov_1a1lzszcbn().s[62]++;
	        return;
	      } else {
	        cov_1a1lzszcbn().b[4][1]++;
	      } // in this case, license is still the raw ArrayBuffer,
	      // (we don't want httpResponseHandler to decode it)
	      // convert it into Uint8Array as expected


	      cov_1a1lzszcbn().s[63]++;
	      callback(null, new Uint8Array(license));
	    }));
	  };
	};
	cov_1a1lzszcbn().s[64]++;
	const defaultGetContentId = (emeOptions, initDataString) => {
	  cov_1a1lzszcbn().f[10]++;
	  cov_1a1lzszcbn().s[65]++;
	  return getHostnameFromUri(initDataString);
	};
	cov_1a1lzszcbn().s[66]++;
	const defaultGetLicense$1 = (keySystem, fairplayOptions) => {
	  cov_1a1lzszcbn().f[11]++;
	  cov_1a1lzszcbn().s[67]++;
	  return (emeOptions, contentId, keyMessage, callback) => {
	    cov_1a1lzszcbn().f[12]++;
	    const headers = (cov_1a1lzszcbn().s[68]++, mergeAndRemoveNull({
	      'Content-type': 'application/octet-stream'
	    }, emeOptions.emeHeaders, fairplayOptions.licenseHeaders));
	    cov_1a1lzszcbn().s[69]++;
	    videojs__default["default"].xhr({
	      uri: (cov_1a1lzszcbn().b[5][0]++, fairplayOptions.licenseUri) || (cov_1a1lzszcbn().b[5][1]++, fairplayOptions.url),
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem,
	        contentId
	      },
	      body: keyMessage,
	      headers
	    }, httpResponseHandler(callback, true));
	  };
	};
	cov_1a1lzszcbn().s[70]++;

	const fairplay = ({
	  video,
	  initData,
	  options,
	  eventBus,
	  emeError
	}) => {
	  cov_1a1lzszcbn().f[13]++;
	  const fairplayOptions = (cov_1a1lzszcbn().s[71]++, options.keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM]);
	  const getCertificate = (cov_1a1lzszcbn().s[72]++, (cov_1a1lzszcbn().b[6][0]++, fairplayOptions.getCertificate) || (cov_1a1lzszcbn().b[6][1]++, defaultGetCertificate(LEGACY_FAIRPLAY_KEY_SYSTEM, fairplayOptions)));
	  const getContentId = (cov_1a1lzszcbn().s[73]++, (cov_1a1lzszcbn().b[7][0]++, fairplayOptions.getContentId) || (cov_1a1lzszcbn().b[7][1]++, defaultGetContentId));
	  const getLicense = (cov_1a1lzszcbn().s[74]++, (cov_1a1lzszcbn().b[8][0]++, fairplayOptions.getLicense) || (cov_1a1lzszcbn().b[8][1]++, defaultGetLicense$1(LEGACY_FAIRPLAY_KEY_SYSTEM, fairplayOptions)));
	  cov_1a1lzszcbn().s[75]++;
	  return new Promise((resolve, reject) => {
	    cov_1a1lzszcbn().f[14]++;
	    cov_1a1lzszcbn().s[76]++;
	    getCertificate(options, (err, cert) => {
	      cov_1a1lzszcbn().f[15]++;
	      cov_1a1lzszcbn().s[77]++;

	      if (err) {
	        cov_1a1lzszcbn().b[9][0]++;
	        const metadata = (cov_1a1lzszcbn().s[78]++, {
	          errorType: Error$1.EMEFailedToSetServerCertificate,
	          keySystem: LEGACY_FAIRPLAY_KEY_SYSTEM
	        });
	        cov_1a1lzszcbn().s[79]++;
	        emeError(err, metadata);
	        cov_1a1lzszcbn().s[80]++;
	        reject(err);
	        cov_1a1lzszcbn().s[81]++;
	        return;
	      } else {
	        cov_1a1lzszcbn().b[9][1]++;
	      }

	      cov_1a1lzszcbn().s[82]++;
	      resolve(cert);
	    });
	  }).then(cert => {
	    cov_1a1lzszcbn().f[16]++;
	    cov_1a1lzszcbn().s[83]++;
	    return addKey({
	      video,
	      cert,
	      initData,
	      getLicense,
	      options,
	      contentId: getContentId(options, uint16ArrayToString(initData)),
	      eventBus,
	      emeError
	    });
	  });
	};

	function cov_sy19jzxsc() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/eme.js";
	  var hash = "8d7314bd9f8992dc10e2e79d07d75057d3e17efc";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/eme.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 13,
	          column: 28
	        },
	        end: {
	          line: 13,
	          column: 68
	        }
	      },
	      "1": {
	        start: {
	          line: 13,
	          column: 37
	        },
	        end: {
	          line: 13,
	          column: 68
	        }
	      },
	      "2": {
	        start: {
	          line: 25,
	          column: 37
	        },
	        end: {
	          line: 31,
	          column: 1
	        }
	      },
	      "3": {
	        start: {
	          line: 26,
	          column: 2
	        },
	        end: {
	          line: 28,
	          column: 3
	        }
	      },
	      "4": {
	        start: {
	          line: 27,
	          column: 4
	        },
	        end: {
	          line: 27,
	          column: 11
	        }
	      },
	      "5": {
	        start: {
	          line: 30,
	          column: 2
	        },
	        end: {
	          line: 30,
	          column: 30
	        }
	      },
	      "6": {
	        start: {
	          line: 44,
	          column: 42
	        },
	        end: {
	          line: 91,
	          column: 1
	        }
	      },
	      "7": {
	        start: {
	          line: 45,
	          column: 2
	        },
	        end: {
	          line: 47,
	          column: 3
	        }
	      },
	      "8": {
	        start: {
	          line: 46,
	          column: 4
	        },
	        end: {
	          line: 46,
	          column: 52
	        }
	      },
	      "9": {
	        start: {
	          line: 49,
	          column: 21
	        },
	        end: {
	          line: 49,
	          column: 51
	        }
	      },
	      "10": {
	        start: {
	          line: 50,
	          column: 33
	        },
	        end: {
	          line: 50,
	          column: 35
	        }
	      },
	      "11": {
	        start: {
	          line: 51,
	          column: 24
	        },
	        end: {
	          line: 53,
	          column: 34
	        }
	      },
	      "12": {
	        start: {
	          line: 54,
	          column: 27
	        },
	        end: {
	          line: 54,
	          column: 60
	        }
	      },
	      "13": {
	        start: {
	          line: 55,
	          column: 26
	        },
	        end: {
	          line: 55,
	          column: 58
	        }
	      },
	      "14": {
	        start: {
	          line: 56,
	          column: 27
	        },
	        end: {
	          line: 58,
	          column: 37
	        }
	      },
	      "15": {
	        start: {
	          line: 59,
	          column: 26
	        },
	        end: {
	          line: 59,
	          column: 58
	        }
	      },
	      "16": {
	        start: {
	          line: 60,
	          column: 26
	        },
	        end: {
	          line: 60,
	          column: 58
	        }
	      },
	      "17": {
	        start: {
	          line: 62,
	          column: 2
	        },
	        end: {
	          line: 70,
	          column: 3
	        }
	      },
	      "18": {
	        start: {
	          line: 63,
	          column: 4
	        },
	        end: {
	          line: 69,
	          column: 6
	        }
	      },
	      "19": {
	        start: {
	          line: 72,
	          column: 2
	        },
	        end: {
	          line: 80,
	          column: 3
	        }
	      },
	      "20": {
	        start: {
	          line: 73,
	          column: 4
	        },
	        end: {
	          line: 79,
	          column: 6
	        }
	      },
	      "21": {
	        start: {
	          line: 82,
	          column: 2
	        },
	        end: {
	          line: 84,
	          column: 3
	        }
	      },
	      "22": {
	        start: {
	          line: 83,
	          column: 4
	        },
	        end: {
	          line: 83,
	          column: 61
	        }
	      },
	      "23": {
	        start: {
	          line: 86,
	          column: 2
	        },
	        end: {
	          line: 88,
	          column: 3
	        }
	      },
	      "24": {
	        start: {
	          line: 87,
	          column: 4
	        },
	        end: {
	          line: 87,
	          column: 57
	        }
	      },
	      "25": {
	        start: {
	          line: 90,
	          column: 2
	        },
	        end: {
	          line: 90,
	          column: 34
	        }
	      },
	      "26": {
	        start: {
	          line: 93,
	          column: 37
	        },
	        end: {
	          line: 112,
	          column: 1
	        }
	      },
	      "27": {
	        start: {
	          line: 99,
	          column: 2
	        },
	        end: {
	          line: 109,
	          column: 5
	        }
	      },
	      "28": {
	        start: {
	          line: 100,
	          column: 36
	        },
	        end: {
	          line: 100,
	          column: 96
	        }
	      },
	      "29": {
	        start: {
	          line: 102,
	          column: 4
	        },
	        end: {
	          line: 108,
	          column: 5
	        }
	      },
	      "30": {
	        start: {
	          line: 103,
	          column: 6
	        },
	        end: {
	          line: 104,
	          column: 89
	        }
	      },
	      "31": {
	        start: {
	          line: 106,
	          column: 6
	        },
	        end: {
	          line: 107,
	          column: 90
	        }
	      },
	      "32": {
	        start: {
	          line: 107,
	          column: 8
	        },
	        end: {
	          line: 107,
	          column: 88
	        }
	      },
	      "33": {
	        start: {
	          line: 111,
	          column: 2
	        },
	        end: {
	          line: 111,
	          column: 17
	        }
	      },
	      "34": {
	        start: {
	          line: 114,
	          column: 30
	        },
	        end: {
	          line: 304,
	          column: 1
	        }
	      },
	      "35": {
	        start: {
	          line: 126,
	          column: 6
	        },
	        end: {
	          line: 126,
	          column: 20
	        }
	      },
	      "36": {
	        start: {
	          line: 128,
	          column: 20
	        },
	        end: {
	          line: 128,
	          column: 21
	        }
	      },
	      "37": {
	        start: {
	          line: 131,
	          column: 2
	        },
	        end: {
	          line: 146,
	          column: 5
	        }
	      },
	      "38": {
	        start: {
	          line: 132,
	          column: 4
	        },
	        end: {
	          line: 145,
	          column: 5
	        }
	      },
	      "39": {
	        start: {
	          line: 134,
	          column: 6
	        },
	        end: {
	          line: 139,
	          column: 15
	        }
	      },
	      "40": {
	        start: {
	          line: 135,
	          column: 8
	        },
	        end: {
	          line: 135,
	          column: 22
	        }
	      },
	      "41": {
	        start: {
	          line: 136,
	          column: 8
	        },
	        end: {
	          line: 138,
	          column: 9
	        }
	      },
	      "42": {
	        start: {
	          line: 137,
	          column: 10
	        },
	        end: {
	          line: 137,
	          column: 36
	        }
	      },
	      "43": {
	        start: {
	          line: 141,
	          column: 6
	        },
	        end: {
	          line: 144,
	          column: 9
	        }
	      },
	      "44": {
	        start: {
	          line: 142,
	          column: 8
	        },
	        end: {
	          line: 142,
	          column: 34
	        }
	      },
	      "45": {
	        start: {
	          line: 143,
	          column: 8
	        },
	        end: {
	          line: 143,
	          column: 24
	        }
	      },
	      "46": {
	        start: {
	          line: 148,
	          column: 2
	        },
	        end: {
	          line: 303,
	          column: 3
	        }
	      },
	      "47": {
	        start: {
	          line: 149,
	          column: 23
	        },
	        end: {
	          line: 149,
	          column: 48
	        }
	      },
	      "48": {
	        start: {
	          line: 151,
	          column: 34
	        },
	        end: {
	          line: 174,
	          column: 5
	        }
	      },
	      "49": {
	        start: {
	          line: 152,
	          column: 6
	        },
	        end: {
	          line: 152,
	          column: 65
	        }
	      },
	      "50": {
	        start: {
	          line: 153,
	          column: 6
	        },
	        end: {
	          line: 173,
	          column: 9
	        }
	      },
	      "51": {
	        start: {
	          line: 157,
	          column: 8
	        },
	        end: {
	          line: 159,
	          column: 9
	        }
	      },
	      "52": {
	        start: {
	          line: 158,
	          column: 10
	        },
	        end: {
	          line: 158,
	          column: 17
	        }
	      },
	      "53": {
	        start: {
	          line: 161,
	          column: 8
	        },
	        end: {
	          line: 164,
	          column: 11
	        }
	      },
	      "54": {
	        start: {
	          line: 165,
	          column: 8
	        },
	        end: {
	          line: 165,
	          column: 32
	        }
	      },
	      "55": {
	        start: {
	          line: 167,
	          column: 25
	        },
	        end: {
	          line: 170,
	          column: 9
	        }
	      },
	      "56": {
	        start: {
	          line: 172,
	          column: 8
	        },
	        end: {
	          line: 172,
	          column: 34
	        }
	      },
	      "57": {
	        start: {
	          line: 176,
	          column: 4
	        },
	        end: {
	          line: 179,
	          column: 7
	        }
	      },
	      "58": {
	        start: {
	          line: 181,
	          column: 4
	        },
	        end: {
	          line: 183,
	          column: 7
	        }
	      },
	      "59": {
	        start: {
	          line: 182,
	          column: 6
	        },
	        end: {
	          line: 182,
	          column: 30
	        }
	      },
	      "60": {
	        start: {
	          line: 185,
	          column: 4
	        },
	        end: {
	          line: 294,
	          column: 7
	        }
	      },
	      "61": {
	        start: {
	          line: 186,
	          column: 6
	        },
	        end: {
	          line: 229,
	          column: 16
	        }
	      },
	      "62": {
	        start: {
	          line: 187,
	          column: 8
	        },
	        end: {
	          line: 190,
	          column: 11
	        }
	      },
	      "63": {
	        start: {
	          line: 192,
	          column: 8
	        },
	        end: {
	          line: 194,
	          column: 9
	        }
	      },
	      "64": {
	        start: {
	          line: 193,
	          column: 10
	        },
	        end: {
	          line: 193,
	          column: 17
	        }
	      },
	      "65": {
	        start: {
	          line: 196,
	          column: 8
	        },
	        end: {
	          line: 208,
	          column: 9
	        }
	      },
	      "66": {
	        start: {
	          line: 197,
	          column: 42
	        },
	        end: {
	          line: 197,
	          column: 73
	        }
	      },
	      "67": {
	        start: {
	          line: 198,
	          column: 48
	        },
	        end: {
	          line: 198,
	          column: 85
	        }
	      },
	      "68": {
	        start: {
	          line: 199,
	          column: 53
	        },
	        end: {
	          line: 199,
	          column: 102
	        }
	      },
	      "69": {
	        start: {
	          line: 200,
	          column: 41
	        },
	        end: {
	          line: 200,
	          column: 88
	        }
	      },
	      "70": {
	        start: {
	          line: 201,
	          column: 42
	        },
	        end: {
	          line: 201,
	          column: 143
	        }
	      },
	      "71": {
	        start: {
	          line: 202,
	          column: 24
	        },
	        end: {
	          line: 202,
	          column: 38
	        }
	      },
	      "72": {
	        start: {
	          line: 204,
	          column: 10
	        },
	        end: {
	          line: 207,
	          column: 11
	        }
	      },
	      "73": {
	        start: {
	          line: 205,
	          column: 12
	        },
	        end: {
	          line: 205,
	          column: 36
	        }
	      },
	      "74": {
	        start: {
	          line: 206,
	          column: 12
	        },
	        end: {
	          line: 206,
	          column: 19
	        }
	      },
	      "75": {
	        start: {
	          line: 210,
	          column: 8
	        },
	        end: {
	          line: 228,
	          column: 13
	        }
	      },
	      "76": {
	        start: {
	          line: 212,
	          column: 12
	        },
	        end: {
	          line: 224,
	          column: 16
	        }
	      },
	      "77": {
	        start: {
	          line: 213,
	          column: 14
	        },
	        end: {
	          line: 216,
	          column: 17
	        }
	      },
	      "78": {
	        start: {
	          line: 218,
	          column: 31
	        },
	        end: {
	          line: 221,
	          column: 15
	        }
	      },
	      "79": {
	        start: {
	          line: 223,
	          column: 14
	        },
	        end: {
	          line: 223,
	          column: 40
	        }
	      },
	      "80": {
	        start: {
	          line: 227,
	          column: 12
	        },
	        end: {
	          line: 227,
	          column: 24
	        }
	      },
	      "81": {
	        start: {
	          line: 231,
	          column: 34
	        },
	        end: {
	          line: 231,
	          column: 53
	        }
	      },
	      "82": {
	        start: {
	          line: 233,
	          column: 6
	        },
	        end: {
	          line: 283,
	          column: 16
	        }
	      },
	      "83": {
	        start: {
	          line: 234,
	          column: 22
	        },
	        end: {
	          line: 234,
	          column: 27
	        }
	      },
	      "84": {
	        start: {
	          line: 237,
	          column: 8
	        },
	        end: {
	          line: 239,
	          column: 9
	        }
	      },
	      "85": {
	        start: {
	          line: 238,
	          column: 10
	        },
	        end: {
	          line: 238,
	          column: 17
	        }
	      },
	      "86": {
	        start: {
	          line: 242,
	          column: 8
	        },
	        end: {
	          line: 245,
	          column: 11
	        }
	      },
	      "87": {
	        start: {
	          line: 249,
	          column: 8
	        },
	        end: {
	          line: 276,
	          column: 11
	        }
	      },
	      "88": {
	        start: {
	          line: 253,
	          column: 10
	        },
	        end: {
	          line: 258,
	          column: 13
	        }
	      },
	      "89": {
	        start: {
	          line: 259,
	          column: 10
	        },
	        end: {
	          line: 275,
	          column: 11
	        }
	      },
	      "90": {
	        start: {
	          line: 264,
	          column: 12
	        },
	        end: {
	          line: 264,
	          column: 27
	        }
	      },
	      "91": {
	        start: {
	          line: 265,
	          column: 12
	        },
	        end: {
	          line: 265,
	          column: 18
	        }
	      },
	      "92": {
	        start: {
	          line: 268,
	          column: 14
	        },
	        end: {
	          line: 269,
	          column: 74
	        }
	      },
	      "93": {
	        start: {
	          line: 273,
	          column: 12
	        },
	        end: {
	          line: 273,
	          column: 45
	        }
	      },
	      "94": {
	        start: {
	          line: 274,
	          column: 12
	        },
	        end: {
	          line: 274,
	          column: 18
	        }
	      },
	      "95": {
	        start: {
	          line: 278,
	          column: 8
	        },
	        end: {
	          line: 282,
	          column: 9
	        }
	      },
	      "96": {
	        start: {
	          line: 281,
	          column: 10
	        },
	        end: {
	          line: 281,
	          column: 34
	        }
	      },
	      "97": {
	        start: {
	          line: 285,
	          column: 6
	        },
	        end: {
	          line: 293,
	          column: 9
	        }
	      },
	      "98": {
	        start: {
	          line: 286,
	          column: 25
	        },
	        end: {
	          line: 289,
	          column: 9
	        }
	      },
	      "99": {
	        start: {
	          line: 291,
	          column: 8
	        },
	        end: {
	          line: 291,
	          column: 34
	        }
	      },
	      "100": {
	        start: {
	          line: 292,
	          column: 8
	        },
	        end: {
	          line: 292,
	          column: 61
	        }
	      },
	      "101": {
	        start: {
	          line: 297,
	          column: 21
	        },
	        end: {
	          line: 300,
	          column: 5
	        }
	      },
	      "102": {
	        start: {
	          line: 302,
	          column: 4
	        },
	        end: {
	          line: 302,
	          column: 30
	        }
	      },
	      "103": {
	        start: {
	          line: 333,
	          column: 26
	        },
	        end: {
	          line: 365,
	          column: 1
	        }
	      },
	      "104": {
	        start: {
	          line: 345,
	          column: 22
	        },
	        end: {
	          line: 355,
	          column: 3
	        }
	      },
	      "105": {
	        start: {
	          line: 357,
	          column: 2
	        },
	        end: {
	          line: 360,
	          column: 3
	        }
	      },
	      "106": {
	        start: {
	          line: 358,
	          column: 4
	        },
	        end: {
	          line: 358,
	          column: 50
	        }
	      },
	      "107": {
	        start: {
	          line: 359,
	          column: 4
	        },
	        end: {
	          line: 359,
	          column: 47
	        }
	      },
	      "108": {
	        start: {
	          line: 362,
	          column: 2
	        },
	        end: {
	          line: 362,
	          column: 45
	        }
	      },
	      "109": {
	        start: {
	          line: 364,
	          column: 2
	        },
	        end: {
	          line: 364,
	          column: 27
	        }
	      },
	      "110": {
	        start: {
	          line: 386,
	          column: 34
	        },
	        end: {
	          line: 438,
	          column: 1
	        }
	      },
	      "111": {
	        start: {
	          line: 395,
	          column: 2
	        },
	        end: {
	          line: 395,
	          column: 43
	        }
	      },
	      "112": {
	        start: {
	          line: 396,
	          column: 19
	        },
	        end: {
	          line: 396,
	          column: 21
	        }
	      },
	      "113": {
	        start: {
	          line: 398,
	          column: 2
	        },
	        end: {
	          line: 407,
	          column: 3
	        }
	      },
	      "114": {
	        start: {
	          line: 399,
	          column: 4
	        },
	        end: {
	          line: 406,
	          column: 8
	        }
	      },
	      "115": {
	        start: {
	          line: 400,
	          column: 23
	        },
	        end: {
	          line: 403,
	          column: 7
	        }
	      },
	      "116": {
	        start: {
	          line: 405,
	          column: 6
	        },
	        end: {
	          line: 405,
	          column: 32
	        }
	      },
	      "117": {
	        start: {
	          line: 409,
	          column: 2
	        },
	        end: {
	          line: 424,
	          column: 3
	        }
	      },
	      "118": {
	        start: {
	          line: 409,
	          column: 15
	        },
	        end: {
	          line: 409,
	          column: 16
	        }
	      },
	      "119": {
	        start: {
	          line: 410,
	          column: 17
	        },
	        end: {
	          line: 410,
	          column: 44
	        }
	      },
	      "120": {
	        start: {
	          line: 412,
	          column: 4
	        },
	        end: {
	          line: 423,
	          column: 8
	        }
	      },
	      "121": {
	        start: {
	          line: 426,
	          column: 2
	        },
	        end: {
	          line: 426,
	          column: 32
	        }
	      },
	      "122": {
	        start: {
	          line: 428,
	          column: 2
	        },
	        end: {
	          line: 435,
	          column: 6
	        }
	      },
	      "123": {
	        start: {
	          line: 429,
	          column: 21
	        },
	        end: {
	          line: 432,
	          column: 5
	        }
	      },
	      "124": {
	        start: {
	          line: 434,
	          column: 4
	        },
	        end: {
	          line: 434,
	          column: 30
	        }
	      },
	      "125": {
	        start: {
	          line: 437,
	          column: 2
	        },
	        end: {
	          line: 437,
	          column: 31
	        }
	      },
	      "126": {
	        start: {
	          line: 440,
	          column: 35
	        },
	        end: {
	          line: 442,
	          column: 1
	        }
	      },
	      "127": {
	        start: {
	          line: 440,
	          column: 68
	        },
	        end: {
	          line: 442,
	          column: 1
	        }
	      },
	      "128": {
	        start: {
	          line: 441,
	          column: 2
	        },
	        end: {
	          line: 441,
	          column: 89
	        }
	      },
	      "129": {
	        start: {
	          line: 444,
	          column: 33
	        },
	        end: {
	          line: 460,
	          column: 1
	        }
	      },
	      "130": {
	        start: {
	          line: 444,
	          column: 66
	        },
	        end: {
	          line: 460,
	          column: 1
	        }
	      },
	      "131": {
	        start: {
	          line: 445,
	          column: 18
	        },
	        end: {
	          line: 449,
	          column: 3
	        }
	      },
	      "132": {
	        start: {
	          line: 451,
	          column: 2
	        },
	        end: {
	          line: 459,
	          column: 42
	        }
	      },
	      "133": {
	        start: {
	          line: 462,
	          column: 28
	        },
	        end: {
	          line: 484,
	          column: 1
	        }
	      },
	      "134": {
	        start: {
	          line: 463,
	          column: 2
	        },
	        end: {
	          line: 483,
	          column: 4
	        }
	      },
	      "135": {
	        start: {
	          line: 464,
	          column: 4
	        },
	        end: {
	          line: 482,
	          column: 7
	        }
	      },
	      "136": {
	        start: {
	          line: 465,
	          column: 23
	        },
	        end: {
	          line: 475,
	          column: 7
	        }
	      },
	      "137": {
	        start: {
	          line: 466,
	          column: 8
	        },
	        end: {
	          line: 468,
	          column: 9
	        }
	      },
	      "138": {
	        start: {
	          line: 467,
	          column: 10
	        },
	        end: {
	          line: 467,
	          column: 79
	        }
	      },
	      "139": {
	        start: {
	          line: 469,
	          column: 8
	        },
	        end: {
	          line: 472,
	          column: 9
	        }
	      },
	      "140": {
	        start: {
	          line: 470,
	          column: 10
	        },
	        end: {
	          line: 470,
	          column: 22
	        }
	      },
	      "141": {
	        start: {
	          line: 471,
	          column: 10
	        },
	        end: {
	          line: 471,
	          column: 17
	        }
	      },
	      "142": {
	        start: {
	          line: 474,
	          column: 8
	        },
	        end: {
	          line: 474,
	          column: 25
	        }
	      },
	      "143": {
	        start: {
	          line: 477,
	          column: 6
	        },
	        end: {
	          line: 481,
	          column: 7
	        }
	      },
	      "144": {
	        start: {
	          line: 478,
	          column: 8
	        },
	        end: {
	          line: 478,
	          column: 82
	        }
	      },
	      "145": {
	        start: {
	          line: 480,
	          column: 8
	        },
	        end: {
	          line: 480,
	          column: 55
	        }
	      },
	      "146": {
	        start: {
	          line: 486,
	          column: 36
	        },
	        end: {
	          line: 524,
	          column: 1
	        }
	      },
	      "147": {
	        start: {
	          line: 487,
	          column: 2
	        },
	        end: {
	          line: 489,
	          column: 3
	        }
	      },
	      "148": {
	        start: {
	          line: 488,
	          column: 4
	        },
	        end: {
	          line: 488,
	          column: 49
	        }
	      },
	      "149": {
	        start: {
	          line: 491,
	          column: 2
	        },
	        end: {
	          line: 493,
	          column: 3
	        }
	      },
	      "150": {
	        start: {
	          line: 492,
	          column: 4
	        },
	        end: {
	          line: 492,
	          column: 55
	        }
	      },
	      "151": {
	        start: {
	          line: 495,
	          column: 2
	        },
	        end: {
	          line: 497,
	          column: 3
	        }
	      },
	      "152": {
	        start: {
	          line: 496,
	          column: 4
	        },
	        end: {
	          line: 496,
	          column: 101
	        }
	      },
	      "153": {
	        start: {
	          line: 499,
	          column: 21
	        },
	        end: {
	          line: 499,
	          column: 51
	        }
	      },
	      "154": {
	        start: {
	          line: 501,
	          column: 2
	        },
	        end: {
	          line: 503,
	          column: 3
	        }
	      },
	      "155": {
	        start: {
	          line: 502,
	          column: 4
	        },
	        end: {
	          line: 502,
	          column: 97
	        }
	      },
	      "156": {
	        start: {
	          line: 505,
	          column: 2
	        },
	        end: {
	          line: 507,
	          column: 3
	        }
	      },
	      "157": {
	        start: {
	          line: 506,
	          column: 4
	        },
	        end: {
	          line: 506,
	          column: 105
	        }
	      },
	      "158": {
	        start: {
	          line: 509,
	          column: 2
	        },
	        end: {
	          line: 511,
	          column: 3
	        }
	      },
	      "159": {
	        start: {
	          line: 510,
	          column: 4
	        },
	        end: {
	          line: 510,
	          column: 64
	        }
	      },
	      "160": {
	        start: {
	          line: 513,
	          column: 2
	        },
	        end: {
	          line: 521,
	          column: 3
	        }
	      },
	      "161": {
	        start: {
	          line: 514,
	          column: 4
	        },
	        end: {
	          line: 520,
	          column: 5
	        }
	      },
	      "162": {
	        start: {
	          line: 515,
	          column: 6
	        },
	        end: {
	          line: 515,
	          column: 92
	        }
	      },
	      "163": {
	        start: {
	          line: 516,
	          column: 11
	        },
	        end: {
	          line: 520,
	          column: 5
	        }
	      },
	      "164": {
	        start: {
	          line: 517,
	          column: 6
	        },
	        end: {
	          line: 517,
	          column: 91
	        }
	      },
	      "165": {
	        start: {
	          line: 519,
	          column: 6
	        },
	        end: {
	          line: 519,
	          column: 83
	        }
	      },
	      "166": {
	        start: {
	          line: 523,
	          column: 2
	        },
	        end: {
	          line: 523,
	          column: 26
	        }
	      },
	      "167": {
	        start: {
	          line: 526,
	          column: 33
	        },
	        end: {
	          line: 630,
	          column: 1
	        }
	      },
	      "168": {
	        start: {
	          line: 537,
	          column: 25
	        },
	        end: {
	          line: 537,
	          column: 42
	        }
	      },
	      "169": {
	        start: {
	          line: 538,
	          column: 20
	        },
	        end: {
	          line: 538,
	          column: 45
	        }
	      },
	      "170": {
	        start: {
	          line: 542,
	          column: 2
	        },
	        end: {
	          line: 549,
	          column: 3
	        }
	      },
	      "171": {
	        start: {
	          line: 543,
	          column: 4
	        },
	        end: {
	          line: 546,
	          column: 6
	        }
	      },
	      "172": {
	        start: {
	          line: 548,
	          column: 4
	        },
	        end: {
	          line: 548,
	          column: 29
	        }
	      },
	      "173": {
	        start: {
	          line: 551,
	          column: 20
	        },
	        end: {
	          line: 552,
	          column: 79
	        }
	      },
	      "174": {
	        start: {
	          line: 554,
	          column: 2
	        },
	        end: {
	          line: 610,
	          column: 3
	        }
	      },
	      "175": {
	        start: {
	          line: 556,
	          column: 4
	        },
	        end: {
	          line: 556,
	          column: 33
	        }
	      },
	      "176": {
	        start: {
	          line: 559,
	          column: 4
	        },
	        end: {
	          line: 559,
	          column: 34
	        }
	      },
	      "177": {
	        start: {
	          line: 563,
	          column: 4
	        },
	        end: {
	          line: 609,
	          column: 7
	        }
	      },
	      "178": {
	        start: {
	          line: 565,
	          column: 6
	        },
	        end: {
	          line: 565,
	          column: 34
	        }
	      },
	      "179": {
	        start: {
	          line: 567,
	          column: 6
	        },
	        end: {
	          line: 570,
	          column: 7
	        }
	      },
	      "180": {
	        start: {
	          line: 568,
	          column: 8
	        },
	        end: {
	          line: 568,
	          column: 33
	        }
	      },
	      "181": {
	        start: {
	          line: 569,
	          column: 8
	        },
	        end: {
	          line: 569,
	          column: 15
	        }
	      },
	      "182": {
	        start: {
	          line: 572,
	          column: 6
	        },
	        end: {
	          line: 581,
	          column: 9
	        }
	      },
	      "183": {
	        start: {
	          line: 573,
	          column: 8
	        },
	        end: {
	          line: 576,
	          column: 9
	        }
	      },
	      "184": {
	        start: {
	          line: 574,
	          column: 10
	        },
	        end: {
	          line: 574,
	          column: 22
	        }
	      },
	      "185": {
	        start: {
	          line: 575,
	          column: 10
	        },
	        end: {
	          line: 575,
	          column: 17
	        }
	      },
	      "186": {
	        start: {
	          line: 578,
	          column: 8
	        },
	        end: {
	          line: 578,
	          column: 27
	        }
	      },
	      "187": {
	        start: {
	          line: 580,
	          column: 8
	        },
	        end: {
	          line: 580,
	          column: 18
	        }
	      },
	      "188": {
	        start: {
	          line: 583,
	          column: 6
	        },
	        end: {
	          line: 583,
	          column: 47
	        }
	      },
	      "189": {
	        start: {
	          line: 585,
	          column: 6
	        },
	        end: {
	          line: 588,
	          column: 9
	        }
	      },
	      "190": {
	        start: {
	          line: 589,
	          column: 6
	        },
	        end: {
	          line: 595,
	          column: 9
	        }
	      },
	      "191": {
	        start: {
	          line: 597,
	          column: 23
	        },
	        end: {
	          line: 600,
	          column: 7
	        }
	      },
	      "192": {
	        start: {
	          line: 602,
	          column: 6
	        },
	        end: {
	          line: 602,
	          column: 30
	        }
	      },
	      "193": {
	        start: {
	          line: 605,
	          column: 6
	        },
	        end: {
	          line: 607,
	          column: 7
	        }
	      },
	      "194": {
	        start: {
	          line: 606,
	          column: 8
	        },
	        end: {
	          line: 606,
	          column: 35
	        }
	      },
	      "195": {
	        start: {
	          line: 608,
	          column: 6
	        },
	        end: {
	          line: 608,
	          column: 82
	        }
	      },
	      "196": {
	        start: {
	          line: 612,
	          column: 2
	        },
	        end: {
	          line: 629,
	          column: 5
	        }
	      },
	      "197": {
	        start: {
	          line: 614,
	          column: 23
	        },
	        end: {
	          line: 615,
	          column: 82
	        }
	      },
	      "198": {
	        start: {
	          line: 617,
	          column: 4
	        },
	        end: {
	          line: 628,
	          column: 7
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 13,
	            column: 28
	          },
	          end: {
	            line: 13,
	            column: 29
	          }
	        },
	        loc: {
	          start: {
	            line: 13,
	            column: 37
	          },
	          end: {
	            line: 13,
	            column: 68
	          }
	        },
	        line: 13
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 25,
	            column: 37
	          },
	          end: {
	            line: 25,
	            column: 38
	          }
	        },
	        loc: {
	          start: {
	            line: 25,
	            column: 57
	          },
	          end: {
	            line: 31,
	            column: 1
	          }
	        },
	        line: 25
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 44,
	            column: 42
	          },
	          end: {
	            line: 44,
	            column: 43
	          }
	        },
	        loc: {
	          start: {
	            line: 44,
	            column: 75
	          },
	          end: {
	            line: 91,
	            column: 1
	          }
	        },
	        line: 44
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 93,
	            column: 37
	          },
	          end: {
	            line: 93,
	            column: 38
	          }
	        },
	        loc: {
	          start: {
	            line: 93,
	            column: 53
	          },
	          end: {
	            line: 112,
	            column: 1
	          }
	        },
	        line: 93
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 99,
	            column: 34
	          },
	          end: {
	            line: 99,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 99,
	            column: 49
	          },
	          end: {
	            line: 109,
	            column: 3
	          }
	        },
	        line: 99
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 106,
	            column: 30
	          },
	          end: {
	            line: 106,
	            column: 31
	          }
	        },
	        loc: {
	          start: {
	            line: 107,
	            column: 8
	          },
	          end: {
	            line: 107,
	            column: 88
	          }
	        },
	        line: 107
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 114,
	            column: 30
	          },
	          end: {
	            line: 114,
	            column: 31
	          }
	        },
	        loc: {
	          start: {
	            line: 114,
	            column: 58
	          },
	          end: {
	            line: 304,
	            column: 1
	          }
	        },
	        line: 114
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 131,
	            column: 21
	          },
	          end: {
	            line: 131,
	            column: 22
	          }
	        },
	        loc: {
	          start: {
	            line: 131,
	            column: 27
	          },
	          end: {
	            line: 146,
	            column: 3
	          }
	        },
	        line: 131
	      },
	      "8": {
	        name: "(anonymous_8)",
	        decl: {
	          start: {
	            line: 134,
	            column: 31
	          },
	          end: {
	            line: 134,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 134,
	            column: 37
	          },
	          end: {
	            line: 139,
	            column: 7
	          }
	        },
	        line: 134
	      },
	      "9": {
	        name: "(anonymous_9)",
	        decl: {
	          start: {
	            line: 141,
	            column: 24
	          },
	          end: {
	            line: 141,
	            column: 25
	          }
	        },
	        loc: {
	          start: {
	            line: 141,
	            column: 30
	          },
	          end: {
	            line: 144,
	            column: 7
	          }
	        },
	        line: 141
	      },
	      "10": {
	        name: "(anonymous_10)",
	        decl: {
	          start: {
	            line: 151,
	            column: 34
	          },
	          end: {
	            line: 151,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 151,
	            column: 40
	          },
	          end: {
	            line: 174,
	            column: 5
	          }
	        },
	        line: 151
	      },
	      "11": {
	        name: "(anonymous_11)",
	        decl: {
	          start: {
	            line: 153,
	            column: 30
	          },
	          end: {
	            line: 153,
	            column: 31
	          }
	        },
	        loc: {
	          start: {
	            line: 153,
	            column: 36
	          },
	          end: {
	            line: 166,
	            column: 7
	          }
	        },
	        line: 153
	      },
	      "12": {
	        name: "(anonymous_12)",
	        decl: {
	          start: {
	            line: 166,
	            column: 15
	          },
	          end: {
	            line: 166,
	            column: 16
	          }
	        },
	        loc: {
	          start: {
	            line: 166,
	            column: 26
	          },
	          end: {
	            line: 173,
	            column: 7
	          }
	        },
	        line: 166
	      },
	      "13": {
	        name: "(anonymous_13)",
	        decl: {
	          start: {
	            line: 181,
	            column: 25
	          },
	          end: {
	            line: 181,
	            column: 26
	          }
	        },
	        loc: {
	          start: {
	            line: 181,
	            column: 31
	          },
	          end: {
	            line: 183,
	            column: 5
	          }
	        },
	        line: 181
	      },
	      "14": {
	        name: "(anonymous_14)",
	        decl: {
	          start: {
	            line: 185,
	            column: 23
	          },
	          end: {
	            line: 185,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 185,
	            column: 44
	          },
	          end: {
	            line: 294,
	            column: 5
	          }
	        },
	        line: 185
	      },
	      "15": {
	        name: "(anonymous_15)",
	        decl: {
	          start: {
	            line: 186,
	            column: 45
	          },
	          end: {
	            line: 186,
	            column: 46
	          }
	        },
	        loc: {
	          start: {
	            line: 186,
	            column: 56
	          },
	          end: {
	            line: 229,
	            column: 7
	          }
	        },
	        line: 186
	      },
	      "16": {
	        name: "(anonymous_16)",
	        decl: {
	          start: {
	            line: 211,
	            column: 16
	          },
	          end: {
	            line: 211,
	            column: 17
	          }
	        },
	        loc: {
	          start: {
	            line: 211,
	            column: 29
	          },
	          end: {
	            line: 225,
	            column: 11
	          }
	        },
	        line: 211
	      },
	      "17": {
	        name: "(anonymous_17)",
	        decl: {
	          start: {
	            line: 212,
	            column: 52
	          },
	          end: {
	            line: 212,
	            column: 53
	          }
	        },
	        loc: {
	          start: {
	            line: 212,
	            column: 58
	          },
	          end: {
	            line: 217,
	            column: 13
	          }
	        },
	        line: 212
	      },
	      "18": {
	        name: "(anonymous_18)",
	        decl: {
	          start: {
	            line: 217,
	            column: 21
	          },
	          end: {
	            line: 217,
	            column: 22
	          }
	        },
	        loc: {
	          start: {
	            line: 217,
	            column: 32
	          },
	          end: {
	            line: 224,
	            column: 13
	          }
	        },
	        line: 217
	      },
	      "19": {
	        name: "(anonymous_19)",
	        decl: {
	          start: {
	            line: 226,
	            column: 17
	          },
	          end: {
	            line: 226,
	            column: 18
	          }
	        },
	        loc: {
	          start: {
	            line: 226,
	            column: 26
	          },
	          end: {
	            line: 228,
	            column: 11
	          }
	        },
	        line: 226
	      },
	      "20": {
	        name: "(anonymous_20)",
	        decl: {
	          start: {
	            line: 233,
	            column: 55
	          },
	          end: {
	            line: 233,
	            column: 56
	          }
	        },
	        loc: {
	          start: {
	            line: 233,
	            column: 66
	          },
	          end: {
	            line: 283,
	            column: 7
	          }
	        },
	        line: 233
	      },
	      "21": {
	        name: "(anonymous_21)",
	        decl: {
	          start: {
	            line: 249,
	            column: 39
	          },
	          end: {
	            line: 249,
	            column: 40
	          }
	        },
	        loc: {
	          start: {
	            line: 249,
	            column: 58
	          },
	          end: {
	            line: 276,
	            column: 9
	          }
	        },
	        line: 249
	      },
	      "22": {
	        name: "(anonymous_22)",
	        decl: {
	          start: {
	            line: 285,
	            column: 63
	          },
	          end: {
	            line: 285,
	            column: 64
	          }
	        },
	        loc: {
	          start: {
	            line: 285,
	            column: 74
	          },
	          end: {
	            line: 293,
	            column: 7
	          }
	        },
	        line: 285
	      },
	      "23": {
	        name: "(anonymous_23)",
	        decl: {
	          start: {
	            line: 333,
	            column: 26
	          },
	          end: {
	            line: 333,
	            column: 27
	          }
	        },
	        loc: {
	          start: {
	            line: 344,
	            column: 6
	          },
	          end: {
	            line: 365,
	            column: 1
	          }
	        },
	        line: 344
	      },
	      "24": {
	        name: "(anonymous_24)",
	        decl: {
	          start: {
	            line: 386,
	            column: 34
	          },
	          end: {
	            line: 386,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 392,
	            column: 6
	          },
	          end: {
	            line: 438,
	            column: 1
	          }
	        },
	        line: 392
	      },
	      "25": {
	        name: "(anonymous_25)",
	        decl: {
	          start: {
	            line: 399,
	            column: 75
	          },
	          end: {
	            line: 399,
	            column: 76
	          }
	        },
	        loc: {
	          start: {
	            line: 399,
	            column: 86
	          },
	          end: {
	            line: 406,
	            column: 5
	          }
	        },
	        line: 399
	      },
	      "26": {
	        name: "(anonymous_26)",
	        decl: {
	          start: {
	            line: 428,
	            column: 59
	          },
	          end: {
	            line: 428,
	            column: 60
	          }
	        },
	        loc: {
	          start: {
	            line: 428,
	            column: 70
	          },
	          end: {
	            line: 435,
	            column: 3
	          }
	        },
	        line: 428
	      },
	      "27": {
	        name: "(anonymous_27)",
	        decl: {
	          start: {
	            line: 440,
	            column: 35
	          },
	          end: {
	            line: 440,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 440,
	            column: 68
	          },
	          end: {
	            line: 442,
	            column: 1
	          }
	        },
	        line: 440
	      },
	      "28": {
	        name: "(anonymous_28)",
	        decl: {
	          start: {
	            line: 440,
	            column: 68
	          },
	          end: {
	            line: 440,
	            column: 69
	          }
	        },
	        loc: {
	          start: {
	            line: 440,
	            column: 106
	          },
	          end: {
	            line: 442,
	            column: 1
	          }
	        },
	        line: 440
	      },
	      "29": {
	        name: "(anonymous_29)",
	        decl: {
	          start: {
	            line: 444,
	            column: 33
	          },
	          end: {
	            line: 444,
	            column: 34
	          }
	        },
	        loc: {
	          start: {
	            line: 444,
	            column: 66
	          },
	          end: {
	            line: 460,
	            column: 1
	          }
	        },
	        line: 444
	      },
	      "30": {
	        name: "(anonymous_30)",
	        decl: {
	          start: {
	            line: 444,
	            column: 66
	          },
	          end: {
	            line: 444,
	            column: 67
	          }
	        },
	        loc: {
	          start: {
	            line: 444,
	            column: 104
	          },
	          end: {
	            line: 460,
	            column: 1
	          }
	        },
	        line: 444
	      },
	      "31": {
	        name: "(anonymous_31)",
	        decl: {
	          start: {
	            line: 462,
	            column: 28
	          },
	          end: {
	            line: 462,
	            column: 29
	          }
	        },
	        loc: {
	          start: {
	            line: 462,
	            column: 67
	          },
	          end: {
	            line: 484,
	            column: 1
	          }
	        },
	        line: 462
	      },
	      "32": {
	        name: "(anonymous_32)",
	        decl: {
	          start: {
	            line: 463,
	            column: 9
	          },
	          end: {
	            line: 463,
	            column: 10
	          }
	        },
	        loc: {
	          start: {
	            line: 463,
	            column: 48
	          },
	          end: {
	            line: 483,
	            column: 3
	          }
	        },
	        line: 463
	      },
	      "33": {
	        name: "(anonymous_33)",
	        decl: {
	          start: {
	            line: 464,
	            column: 23
	          },
	          end: {
	            line: 464,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 464,
	            column: 44
	          },
	          end: {
	            line: 482,
	            column: 5
	          }
	        },
	        line: 464
	      },
	      "34": {
	        name: "(anonymous_34)",
	        decl: {
	          start: {
	            line: 465,
	            column: 23
	          },
	          end: {
	            line: 465,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 465,
	            column: 46
	          },
	          end: {
	            line: 475,
	            column: 7
	          }
	        },
	        line: 465
	      },
	      "35": {
	        name: "(anonymous_35)",
	        decl: {
	          start: {
	            line: 486,
	            column: 36
	          },
	          end: {
	            line: 486,
	            column: 37
	          }
	        },
	        loc: {
	          start: {
	            line: 486,
	            column: 69
	          },
	          end: {
	            line: 524,
	            column: 1
	          }
	        },
	        line: 486
	      },
	      "36": {
	        name: "(anonymous_36)",
	        decl: {
	          start: {
	            line: 526,
	            column: 33
	          },
	          end: {
	            line: 526,
	            column: 34
	          }
	        },
	        loc: {
	          start: {
	            line: 536,
	            column: 6
	          },
	          end: {
	            line: 630,
	            column: 1
	          }
	        },
	        line: 536
	      },
	      "37": {
	        name: "(anonymous_37)",
	        decl: {
	          start: {
	            line: 563,
	            column: 35
	          },
	          end: {
	            line: 563,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 563,
	            column: 56
	          },
	          end: {
	            line: 582,
	            column: 5
	          }
	        },
	        line: 563
	      },
	      "38": {
	        name: "(anonymous_38)",
	        decl: {
	          start: {
	            line: 572,
	            column: 47
	          },
	          end: {
	            line: 572,
	            column: 48
	          }
	        },
	        loc: {
	          start: {
	            line: 572,
	            column: 62
	          },
	          end: {
	            line: 581,
	            column: 7
	          }
	        },
	        line: 572
	      },
	      "39": {
	        name: "(anonymous_39)",
	        decl: {
	          start: {
	            line: 582,
	            column: 12
	          },
	          end: {
	            line: 582,
	            column: 13
	          }
	        },
	        loc: {
	          start: {
	            line: 582,
	            column: 18
	          },
	          end: {
	            line: 584,
	            column: 5
	          }
	        },
	        line: 582
	      },
	      "40": {
	        name: "(anonymous_40)",
	        decl: {
	          start: {
	            line: 584,
	            column: 12
	          },
	          end: {
	            line: 584,
	            column: 13
	          }
	        },
	        loc: {
	          start: {
	            line: 584,
	            column: 34
	          },
	          end: {
	            line: 596,
	            column: 5
	          }
	        },
	        line: 584
	      },
	      "41": {
	        name: "(anonymous_41)",
	        decl: {
	          start: {
	            line: 596,
	            column: 13
	          },
	          end: {
	            line: 596,
	            column: 14
	          }
	        },
	        loc: {
	          start: {
	            line: 596,
	            column: 22
	          },
	          end: {
	            line: 609,
	            column: 5
	          }
	        },
	        line: 596
	      },
	      "42": {
	        name: "(anonymous_42)",
	        decl: {
	          start: {
	            line: 612,
	            column: 31
	          },
	          end: {
	            line: 612,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 612,
	            column: 37
	          },
	          end: {
	            line: 629,
	            column: 3
	          }
	        },
	        line: 612
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 26,
	            column: 2
	          },
	          end: {
	            line: 28,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 26,
	            column: 2
	          },
	          end: {
	            line: 28,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 26,
	            column: 2
	          },
	          end: {
	            line: 28,
	            column: 3
	          }
	        }],
	        line: 26
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 45,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 45,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 45,
	            column: 2
	          },
	          end: {
	            line: 47,
	            column: 3
	          }
	        }],
	        line: 45
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 51,
	            column: 24
	          },
	          end: {
	            line: 53,
	            column: 34
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 51,
	            column: 24
	          },
	          end: {
	            line: 51,
	            column: 54
	          }
	        }, {
	          start: {
	            line: 53,
	            column: 5
	          },
	          end: {
	            line: 53,
	            column: 33
	          }
	        }],
	        line: 51
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 53,
	            column: 5
	          },
	          end: {
	            line: 53,
	            column: 33
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 53,
	            column: 18
	          },
	          end: {
	            line: 53,
	            column: 26
	          }
	        }, {
	          start: {
	            line: 53,
	            column: 29
	          },
	          end: {
	            line: 53,
	            column: 33
	          }
	        }],
	        line: 53
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 56,
	            column: 27
	          },
	          end: {
	            line: 58,
	            column: 37
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 56,
	            column: 27
	          },
	          end: {
	            line: 56,
	            column: 60
	          }
	        }, {
	          start: {
	            line: 58,
	            column: 5
	          },
	          end: {
	            line: 58,
	            column: 36
	          }
	        }],
	        line: 56
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 58,
	            column: 5
	          },
	          end: {
	            line: 58,
	            column: 36
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 58,
	            column: 18
	          },
	          end: {
	            line: 58,
	            column: 29
	          }
	        }, {
	          start: {
	            line: 58,
	            column: 32
	          },
	          end: {
	            line: 58,
	            column: 36
	          }
	        }],
	        line: 58
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 70,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 70,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 70,
	            column: 3
	          }
	        }],
	        line: 62
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 62,
	            column: 6
	          },
	          end: {
	            line: 62,
	            column: 41
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 62,
	            column: 6
	          },
	          end: {
	            line: 62,
	            column: 22
	          }
	        }, {
	          start: {
	            line: 62,
	            column: 26
	          },
	          end: {
	            line: 62,
	            column: 41
	          }
	        }],
	        line: 62
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 66,
	            column: 9
	          },
	          end: {
	            line: 66,
	            column: 66
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 66,
	            column: 28
	          },
	          end: {
	            line: 66,
	            column: 61
	          }
	        }, {
	          start: {
	            line: 66,
	            column: 64
	          },
	          end: {
	            line: 66,
	            column: 66
	          }
	        }],
	        line: 66
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 67,
	            column: 9
	          },
	          end: {
	            line: 67,
	            column: 63
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 67,
	            column: 27
	          },
	          end: {
	            line: 67,
	            column: 58
	          }
	        }, {
	          start: {
	            line: 67,
	            column: 61
	          },
	          end: {
	            line: 67,
	            column: 63
	          }
	        }],
	        line: 67
	      },
	      "10": {
	        loc: {
	          start: {
	            line: 72,
	            column: 2
	          },
	          end: {
	            line: 80,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 72,
	            column: 2
	          },
	          end: {
	            line: 80,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 72,
	            column: 2
	          },
	          end: {
	            line: 80,
	            column: 3
	          }
	        }],
	        line: 72
	      },
	      "11": {
	        loc: {
	          start: {
	            line: 72,
	            column: 6
	          },
	          end: {
	            line: 72,
	            column: 41
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 72,
	            column: 6
	          },
	          end: {
	            line: 72,
	            column: 22
	          }
	        }, {
	          start: {
	            line: 72,
	            column: 26
	          },
	          end: {
	            line: 72,
	            column: 41
	          }
	        }],
	        line: 72
	      },
	      "12": {
	        loc: {
	          start: {
	            line: 76,
	            column: 9
	          },
	          end: {
	            line: 76,
	            column: 66
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 76,
	            column: 28
	          },
	          end: {
	            line: 76,
	            column: 61
	          }
	        }, {
	          start: {
	            line: 76,
	            column: 64
	          },
	          end: {
	            line: 76,
	            column: 66
	          }
	        }],
	        line: 76
	      },
	      "13": {
	        loc: {
	          start: {
	            line: 77,
	            column: 9
	          },
	          end: {
	            line: 77,
	            column: 63
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 77,
	            column: 27
	          },
	          end: {
	            line: 77,
	            column: 58
	          }
	        }, {
	          start: {
	            line: 77,
	            column: 61
	          },
	          end: {
	            line: 77,
	            column: 63
	          }
	        }],
	        line: 77
	      },
	      "14": {
	        loc: {
	          start: {
	            line: 82,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 82,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 82,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        }],
	        line: 82
	      },
	      "15": {
	        loc: {
	          start: {
	            line: 86,
	            column: 2
	          },
	          end: {
	            line: 88,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 86,
	            column: 2
	          },
	          end: {
	            line: 88,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 86,
	            column: 2
	          },
	          end: {
	            line: 88,
	            column: 3
	          }
	        }],
	        line: 86
	      },
	      "16": {
	        loc: {
	          start: {
	            line: 102,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 102,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 102,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        }],
	        line: 102
	      },
	      "17": {
	        loc: {
	          start: {
	            line: 132,
	            column: 4
	          },
	          end: {
	            line: 145,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 132,
	            column: 4
	          },
	          end: {
	            line: 145,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 132,
	            column: 4
	          },
	          end: {
	            line: 145,
	            column: 5
	          }
	        }],
	        line: 132
	      },
	      "18": {
	        loc: {
	          start: {
	            line: 132,
	            column: 8
	          },
	          end: {
	            line: 132,
	            column: 106
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 132,
	            column: 8
	          },
	          end: {
	            line: 132,
	            column: 45
	          }
	        }, {
	          start: {
	            line: 132,
	            column: 49
	          },
	          end: {
	            line: 132,
	            column: 106
	          }
	        }],
	        line: 132
	      },
	      "19": {
	        loc: {
	          start: {
	            line: 136,
	            column: 8
	          },
	          end: {
	            line: 138,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 136,
	            column: 8
	          },
	          end: {
	            line: 138,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 136,
	            column: 8
	          },
	          end: {
	            line: 138,
	            column: 9
	          }
	        }],
	        line: 136
	      },
	      "20": {
	        loc: {
	          start: {
	            line: 157,
	            column: 8
	          },
	          end: {
	            line: 159,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 157,
	            column: 8
	          },
	          end: {
	            line: 159,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 157,
	            column: 8
	          },
	          end: {
	            line: 159,
	            column: 9
	          }
	        }],
	        line: 157
	      },
	      "21": {
	        loc: {
	          start: {
	            line: 192,
	            column: 8
	          },
	          end: {
	            line: 194,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 192,
	            column: 8
	          },
	          end: {
	            line: 194,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 192,
	            column: 8
	          },
	          end: {
	            line: 194,
	            column: 9
	          }
	        }],
	        line: 192
	      },
	      "22": {
	        loc: {
	          start: {
	            line: 192,
	            column: 12
	          },
	          end: {
	            line: 192,
	            column: 94
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 192,
	            column: 12
	          },
	          end: {
	            line: 192,
	            column: 51
	          }
	        }, {
	          start: {
	            line: 192,
	            column: 55
	          },
	          end: {
	            line: 192,
	            column: 94
	          }
	        }],
	        line: 192
	      },
	      "23": {
	        loc: {
	          start: {
	            line: 196,
	            column: 8
	          },
	          end: {
	            line: 208,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 196,
	            column: 8
	          },
	          end: {
	            line: 208,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 196,
	            column: 8
	          },
	          end: {
	            line: 208,
	            column: 9
	          }
	        }],
	        line: 196
	      },
	      "24": {
	        loc: {
	          start: {
	            line: 200,
	            column: 41
	          },
	          end: {
	            line: 200,
	            column: 88
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 200,
	            column: 41
	          },
	          end: {
	            line: 200,
	            column: 61
	          }
	        }, {
	          start: {
	            line: 200,
	            column: 65
	          },
	          end: {
	            line: 200,
	            column: 88
	          }
	        }],
	        line: 200
	      },
	      "25": {
	        loc: {
	          start: {
	            line: 201,
	            column: 42
	          },
	          end: {
	            line: 201,
	            column: 143
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 201,
	            column: 42
	          },
	          end: {
	            line: 201,
	            column: 57
	          }
	        }, {
	          start: {
	            line: 201,
	            column: 61
	          },
	          end: {
	            line: 201,
	            column: 95
	          }
	        }, {
	          start: {
	            line: 201,
	            column: 99
	          },
	          end: {
	            line: 201,
	            column: 143
	          }
	        }],
	        line: 201
	      },
	      "26": {
	        loc: {
	          start: {
	            line: 204,
	            column: 10
	          },
	          end: {
	            line: 207,
	            column: 11
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 204,
	            column: 10
	          },
	          end: {
	            line: 207,
	            column: 11
	          }
	        }, {
	          start: {
	            line: 204,
	            column: 10
	          },
	          end: {
	            line: 207,
	            column: 11
	          }
	        }],
	        line: 204
	      },
	      "27": {
	        loc: {
	          start: {
	            line: 204,
	            column: 14
	          },
	          end: {
	            line: 204,
	            column: 72
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 204,
	            column: 14
	          },
	          end: {
	            line: 204,
	            column: 36
	          }
	        }, {
	          start: {
	            line: 204,
	            column: 40
	          },
	          end: {
	            line: 204,
	            column: 63
	          }
	        }, {
	          start: {
	            line: 204,
	            column: 67
	          },
	          end: {
	            line: 204,
	            column: 72
	          }
	        }],
	        line: 204
	      },
	      "28": {
	        loc: {
	          start: {
	            line: 237,
	            column: 8
	          },
	          end: {
	            line: 239,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 237,
	            column: 8
	          },
	          end: {
	            line: 239,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 237,
	            column: 8
	          },
	          end: {
	            line: 239,
	            column: 9
	          }
	        }],
	        line: 237
	      },
	      "29": {
	        loc: {
	          start: {
	            line: 259,
	            column: 10
	          },
	          end: {
	            line: 275,
	            column: 11
	          }
	        },
	        type: "switch",
	        locations: [{
	          start: {
	            line: 260,
	            column: 10
	          },
	          end: {
	            line: 265,
	            column: 18
	          }
	        }, {
	          start: {
	            line: 266,
	            column: 10
	          },
	          end: {
	            line: 274,
	            column: 18
	          }
	        }],
	        line: 259
	      },
	      "30": {
	        loc: {
	          start: {
	            line: 278,
	            column: 8
	          },
	          end: {
	            line: 282,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 278,
	            column: 8
	          },
	          end: {
	            line: 282,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 278,
	            column: 8
	          },
	          end: {
	            line: 282,
	            column: 9
	          }
	        }],
	        line: 278
	      },
	      "31": {
	        loc: {
	          start: {
	            line: 357,
	            column: 2
	          },
	          end: {
	            line: 360,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 357,
	            column: 2
	          },
	          end: {
	            line: 360,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 357,
	            column: 2
	          },
	          end: {
	            line: 360,
	            column: 3
	          }
	        }],
	        line: 357
	      },
	      "32": {
	        loc: {
	          start: {
	            line: 398,
	            column: 2
	          },
	          end: {
	            line: 407,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 398,
	            column: 2
	          },
	          end: {
	            line: 407,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 398,
	            column: 2
	          },
	          end: {
	            line: 407,
	            column: 3
	          }
	        }],
	        line: 398
	      },
	      "33": {
	        loc: {
	          start: {
	            line: 466,
	            column: 8
	          },
	          end: {
	            line: 468,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 466,
	            column: 8
	          },
	          end: {
	            line: 468,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 466,
	            column: 8
	          },
	          end: {
	            line: 468,
	            column: 9
	          }
	        }],
	        line: 466
	      },
	      "34": {
	        loc: {
	          start: {
	            line: 469,
	            column: 8
	          },
	          end: {
	            line: 472,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 469,
	            column: 8
	          },
	          end: {
	            line: 472,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 469,
	            column: 8
	          },
	          end: {
	            line: 472,
	            column: 9
	          }
	        }],
	        line: 469
	      },
	      "35": {
	        loc: {
	          start: {
	            line: 477,
	            column: 6
	          },
	          end: {
	            line: 481,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 477,
	            column: 6
	          },
	          end: {
	            line: 481,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 477,
	            column: 6
	          },
	          end: {
	            line: 481,
	            column: 7
	          }
	        }],
	        line: 477
	      },
	      "36": {
	        loc: {
	          start: {
	            line: 487,
	            column: 2
	          },
	          end: {
	            line: 489,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 487,
	            column: 2
	          },
	          end: {
	            line: 489,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 487,
	            column: 2
	          },
	          end: {
	            line: 489,
	            column: 3
	          }
	        }],
	        line: 487
	      },
	      "37": {
	        loc: {
	          start: {
	            line: 491,
	            column: 2
	          },
	          end: {
	            line: 493,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 491,
	            column: 2
	          },
	          end: {
	            line: 493,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 491,
	            column: 2
	          },
	          end: {
	            line: 493,
	            column: 3
	          }
	        }],
	        line: 491
	      },
	      "38": {
	        loc: {
	          start: {
	            line: 491,
	            column: 6
	          },
	          end: {
	            line: 491,
	            column: 58
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 491,
	            column: 6
	          },
	          end: {
	            line: 491,
	            column: 27
	          }
	        }, {
	          start: {
	            line: 491,
	            column: 31
	          },
	          end: {
	            line: 491,
	            column: 58
	          }
	        }],
	        line: 491
	      },
	      "39": {
	        loc: {
	          start: {
	            line: 495,
	            column: 2
	          },
	          end: {
	            line: 497,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 495,
	            column: 2
	          },
	          end: {
	            line: 497,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 495,
	            column: 2
	          },
	          end: {
	            line: 497,
	            column: 3
	          }
	        }],
	        line: 495
	      },
	      "40": {
	        loc: {
	          start: {
	            line: 495,
	            column: 6
	          },
	          end: {
	            line: 495,
	            column: 59
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 495,
	            column: 6
	          },
	          end: {
	            line: 495,
	            column: 27
	          }
	        }, {
	          start: {
	            line: 495,
	            column: 31
	          },
	          end: {
	            line: 495,
	            column: 59
	          }
	        }],
	        line: 495
	      },
	      "41": {
	        loc: {
	          start: {
	            line: 501,
	            column: 2
	          },
	          end: {
	            line: 503,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 501,
	            column: 2
	          },
	          end: {
	            line: 503,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 501,
	            column: 2
	          },
	          end: {
	            line: 503,
	            column: 3
	          }
	        }],
	        line: 501
	      },
	      "42": {
	        loc: {
	          start: {
	            line: 501,
	            column: 6
	          },
	          end: {
	            line: 501,
	            column: 87
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 501,
	            column: 6
	          },
	          end: {
	            line: 501,
	            column: 16
	          }
	        }, {
	          start: {
	            line: 501,
	            column: 20
	          },
	          end: {
	            line: 501,
	            column: 51
	          }
	        }, {
	          start: {
	            line: 501,
	            column: 55
	          },
	          end: {
	            line: 501,
	            column: 87
	          }
	        }],
	        line: 501
	      },
	      "43": {
	        loc: {
	          start: {
	            line: 505,
	            column: 2
	          },
	          end: {
	            line: 507,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 505,
	            column: 2
	          },
	          end: {
	            line: 507,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 505,
	            column: 2
	          },
	          end: {
	            line: 507,
	            column: 3
	          }
	        }],
	        line: 505
	      },
	      "44": {
	        loc: {
	          start: {
	            line: 505,
	            column: 6
	          },
	          end: {
	            line: 505,
	            column: 52
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 505,
	            column: 6
	          },
	          end: {
	            line: 505,
	            column: 16
	          }
	        }, {
	          start: {
	            line: 505,
	            column: 20
	          },
	          end: {
	            line: 505,
	            column: 52
	          }
	        }],
	        line: 505
	      },
	      "45": {
	        loc: {
	          start: {
	            line: 509,
	            column: 2
	          },
	          end: {
	            line: 511,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 509,
	            column: 2
	          },
	          end: {
	            line: 511,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 509,
	            column: 2
	          },
	          end: {
	            line: 511,
	            column: 3
	          }
	        }],
	        line: 509
	      },
	      "46": {
	        loc: {
	          start: {
	            line: 509,
	            column: 6
	          },
	          end: {
	            line: 509,
	            column: 50
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 509,
	            column: 6
	          },
	          end: {
	            line: 509,
	            column: 16
	          }
	        }, {
	          start: {
	            line: 509,
	            column: 20
	          },
	          end: {
	            line: 509,
	            column: 50
	          }
	        }],
	        line: 509
	      },
	      "47": {
	        loc: {
	          start: {
	            line: 513,
	            column: 2
	          },
	          end: {
	            line: 521,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 513,
	            column: 2
	          },
	          end: {
	            line: 521,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 513,
	            column: 2
	          },
	          end: {
	            line: 521,
	            column: 3
	          }
	        }],
	        line: 513
	      },
	      "48": {
	        loc: {
	          start: {
	            line: 513,
	            column: 6
	          },
	          end: {
	            line: 513,
	            column: 58
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 513,
	            column: 6
	          },
	          end: {
	            line: 513,
	            column: 26
	          }
	        }, {
	          start: {
	            line: 513,
	            column: 30
	          },
	          end: {
	            line: 513,
	            column: 58
	          }
	        }],
	        line: 513
	      },
	      "49": {
	        loc: {
	          start: {
	            line: 514,
	            column: 4
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 514,
	            column: 4
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 514,
	            column: 4
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        }],
	        line: 514
	      },
	      "50": {
	        loc: {
	          start: {
	            line: 516,
	            column: 11
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 516,
	            column: 11
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 516,
	            column: 11
	          },
	          end: {
	            line: 520,
	            column: 5
	          }
	        }],
	        line: 516
	      },
	      "51": {
	        loc: {
	          start: {
	            line: 551,
	            column: 20
	          },
	          end: {
	            line: 552,
	            column: 79
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 552,
	            column: 4
	          },
	          end: {
	            line: 552,
	            column: 72
	          }
	        }, {
	          start: {
	            line: 552,
	            column: 75
	          },
	          end: {
	            line: 552,
	            column: 79
	          }
	        }],
	        line: 551
	      },
	      "52": {
	        loc: {
	          start: {
	            line: 554,
	            column: 2
	          },
	          end: {
	            line: 610,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 554,
	            column: 2
	          },
	          end: {
	            line: 610,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 554,
	            column: 2
	          },
	          end: {
	            line: 610,
	            column: 3
	          }
	        }],
	        line: 554
	      },
	      "53": {
	        loc: {
	          start: {
	            line: 567,
	            column: 6
	          },
	          end: {
	            line: 570,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 567,
	            column: 6
	          },
	          end: {
	            line: 570,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 567,
	            column: 6
	          },
	          end: {
	            line: 570,
	            column: 7
	          }
	        }],
	        line: 567
	      },
	      "54": {
	        loc: {
	          start: {
	            line: 573,
	            column: 8
	          },
	          end: {
	            line: 576,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 573,
	            column: 8
	          },
	          end: {
	            line: 576,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 573,
	            column: 8
	          },
	          end: {
	            line: 576,
	            column: 9
	          }
	        }],
	        line: 573
	      },
	      "55": {
	        loc: {
	          start: {
	            line: 605,
	            column: 6
	          },
	          end: {
	            line: 607,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 605,
	            column: 6
	          },
	          end: {
	            line: 607,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 605,
	            column: 6
	          },
	          end: {
	            line: 607,
	            column: 7
	          }
	        }],
	        line: 605
	      },
	      "56": {
	        loc: {
	          start: {
	            line: 614,
	            column: 23
	          },
	          end: {
	            line: 615,
	            column: 82
	          }
	        },
	        type: "cond-expr",
	        locations: [{
	          start: {
	            line: 615,
	            column: 6
	          },
	          end: {
	            line: 615,
	            column: 75
	          }
	        }, {
	          start: {
	            line: 615,
	            column: 78
	          },
	          end: {
	            line: 615,
	            column: 82
	          }
	        }],
	        line: 614
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0,
	      "56": 0,
	      "57": 0,
	      "58": 0,
	      "59": 0,
	      "60": 0,
	      "61": 0,
	      "62": 0,
	      "63": 0,
	      "64": 0,
	      "65": 0,
	      "66": 0,
	      "67": 0,
	      "68": 0,
	      "69": 0,
	      "70": 0,
	      "71": 0,
	      "72": 0,
	      "73": 0,
	      "74": 0,
	      "75": 0,
	      "76": 0,
	      "77": 0,
	      "78": 0,
	      "79": 0,
	      "80": 0,
	      "81": 0,
	      "82": 0,
	      "83": 0,
	      "84": 0,
	      "85": 0,
	      "86": 0,
	      "87": 0,
	      "88": 0,
	      "89": 0,
	      "90": 0,
	      "91": 0,
	      "92": 0,
	      "93": 0,
	      "94": 0,
	      "95": 0,
	      "96": 0,
	      "97": 0,
	      "98": 0,
	      "99": 0,
	      "100": 0,
	      "101": 0,
	      "102": 0,
	      "103": 0,
	      "104": 0,
	      "105": 0,
	      "106": 0,
	      "107": 0,
	      "108": 0,
	      "109": 0,
	      "110": 0,
	      "111": 0,
	      "112": 0,
	      "113": 0,
	      "114": 0,
	      "115": 0,
	      "116": 0,
	      "117": 0,
	      "118": 0,
	      "119": 0,
	      "120": 0,
	      "121": 0,
	      "122": 0,
	      "123": 0,
	      "124": 0,
	      "125": 0,
	      "126": 0,
	      "127": 0,
	      "128": 0,
	      "129": 0,
	      "130": 0,
	      "131": 0,
	      "132": 0,
	      "133": 0,
	      "134": 0,
	      "135": 0,
	      "136": 0,
	      "137": 0,
	      "138": 0,
	      "139": 0,
	      "140": 0,
	      "141": 0,
	      "142": 0,
	      "143": 0,
	      "144": 0,
	      "145": 0,
	      "146": 0,
	      "147": 0,
	      "148": 0,
	      "149": 0,
	      "150": 0,
	      "151": 0,
	      "152": 0,
	      "153": 0,
	      "154": 0,
	      "155": 0,
	      "156": 0,
	      "157": 0,
	      "158": 0,
	      "159": 0,
	      "160": 0,
	      "161": 0,
	      "162": 0,
	      "163": 0,
	      "164": 0,
	      "165": 0,
	      "166": 0,
	      "167": 0,
	      "168": 0,
	      "169": 0,
	      "170": 0,
	      "171": 0,
	      "172": 0,
	      "173": 0,
	      "174": 0,
	      "175": 0,
	      "176": 0,
	      "177": 0,
	      "178": 0,
	      "179": 0,
	      "180": 0,
	      "181": 0,
	      "182": 0,
	      "183": 0,
	      "184": 0,
	      "185": 0,
	      "186": 0,
	      "187": 0,
	      "188": 0,
	      "189": 0,
	      "190": 0,
	      "191": 0,
	      "192": 0,
	      "193": 0,
	      "194": 0,
	      "195": 0,
	      "196": 0,
	      "197": 0,
	      "198": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0],
	      "10": [0, 0],
	      "11": [0, 0],
	      "12": [0, 0],
	      "13": [0, 0],
	      "14": [0, 0],
	      "15": [0, 0],
	      "16": [0, 0],
	      "17": [0, 0],
	      "18": [0, 0],
	      "19": [0, 0],
	      "20": [0, 0],
	      "21": [0, 0],
	      "22": [0, 0],
	      "23": [0, 0],
	      "24": [0, 0],
	      "25": [0, 0, 0],
	      "26": [0, 0],
	      "27": [0, 0, 0],
	      "28": [0, 0],
	      "29": [0, 0],
	      "30": [0, 0],
	      "31": [0, 0],
	      "32": [0, 0],
	      "33": [0, 0],
	      "34": [0, 0],
	      "35": [0, 0],
	      "36": [0, 0],
	      "37": [0, 0],
	      "38": [0, 0],
	      "39": [0, 0],
	      "40": [0, 0],
	      "41": [0, 0],
	      "42": [0, 0, 0],
	      "43": [0, 0],
	      "44": [0, 0],
	      "45": [0, 0],
	      "46": [0, 0],
	      "47": [0, 0],
	      "48": [0, 0],
	      "49": [0, 0],
	      "50": [0, 0],
	      "51": [0, 0],
	      "52": [0, 0],
	      "53": [0, 0],
	      "54": [0, 0],
	      "55": [0, 0],
	      "56": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "8d7314bd9f8992dc10e2e79d07d75057d3e17efc"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_sy19jzxsc = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_sy19jzxsc();
	cov_sy19jzxsc().s[0]++;

	const isFairplayKeySystem = str => {
	  cov_sy19jzxsc().f[0]++;
	  cov_sy19jzxsc().s[1]++;
	  return str.startsWith('com.apple.fps');
	};
	/**
	* Trigger an event on the event bus component safely.
	*
	* This is used because there are cases where we can see race conditions
	* between asynchronous operations (like closing a key session) and the
	* availability of the event bus's DOM element.
	*
	* @param  {Component} eventBus
	* @param  {...} args
	*/


	cov_sy19jzxsc().s[2]++;
	const safeTriggerOnEventBus = (eventBus, args) => {
	  cov_sy19jzxsc().f[1]++;
	  cov_sy19jzxsc().s[3]++;

	  if (eventBus.isDisposed()) {
	    cov_sy19jzxsc().b[0][0]++;
	    cov_sy19jzxsc().s[4]++;
	    return;
	  } else {
	    cov_sy19jzxsc().b[0][1]++;
	  }

	  cov_sy19jzxsc().s[5]++;
	  eventBus.trigger(_extends({}, args));
	};
	/**
	* Returns an array of MediaKeySystemConfigurationObjects provided in the keySystem
	* options.
	*
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeysystemconfiguration|MediaKeySystemConfigurationObject}
	*
	* @param {Object} keySystemOptions
	*        Options passed into videojs-contrib-eme for a specific keySystem
	* @return {Object[]}
	*         Array of MediaKeySystemConfigurationObjects
	*/

	cov_sy19jzxsc().s[6]++;
	const getSupportedConfigurations = (keySystem, keySystemOptions) => {
	  cov_sy19jzxsc().f[2]++;
	  cov_sy19jzxsc().s[7]++;

	  if (keySystemOptions.supportedConfigurations) {
	    cov_sy19jzxsc().b[1][0]++;
	    cov_sy19jzxsc().s[8]++;
	    return keySystemOptions.supportedConfigurations;
	  } else {
	    cov_sy19jzxsc().b[1][1]++;
	  }

	  const isFairplay = (cov_sy19jzxsc().s[9]++, isFairplayKeySystem(keySystem));
	  const supportedConfiguration = (cov_sy19jzxsc().s[10]++, {});
	  const initDataTypes = (cov_sy19jzxsc().s[11]++, (cov_sy19jzxsc().b[2][0]++, keySystemOptions.initDataTypes) || (cov_sy19jzxsc().b[2][1]++, // fairplay requires an explicit initDataTypes
	  isFairplay ? (cov_sy19jzxsc().b[3][0]++, ['sinf']) : (cov_sy19jzxsc().b[3][1]++, null)));
	  const audioContentType = (cov_sy19jzxsc().s[12]++, keySystemOptions.audioContentType);
	  const audioRobustness = (cov_sy19jzxsc().s[13]++, keySystemOptions.audioRobustness);
	  const videoContentType = (cov_sy19jzxsc().s[14]++, (cov_sy19jzxsc().b[4][0]++, keySystemOptions.videoContentType) || (cov_sy19jzxsc().b[4][1]++, // fairplay requires an explicit videoCapabilities/videoContentType
	  isFairplay ? (cov_sy19jzxsc().b[5][0]++, 'video/mp4') : (cov_sy19jzxsc().b[5][1]++, null)));
	  const videoRobustness = (cov_sy19jzxsc().s[15]++, keySystemOptions.videoRobustness);
	  const persistentState = (cov_sy19jzxsc().s[16]++, keySystemOptions.persistentState);
	  cov_sy19jzxsc().s[17]++;

	  if ((cov_sy19jzxsc().b[7][0]++, audioContentType) || (cov_sy19jzxsc().b[7][1]++, audioRobustness)) {
	    cov_sy19jzxsc().b[6][0]++;
	    cov_sy19jzxsc().s[18]++;
	    supportedConfiguration.audioCapabilities = [_extends({}, audioContentType ? (cov_sy19jzxsc().b[8][0]++, {
	      contentType: audioContentType
	    }) : (cov_sy19jzxsc().b[8][1]++, {}), audioRobustness ? (cov_sy19jzxsc().b[9][0]++, {
	      robustness: audioRobustness
	    }) : (cov_sy19jzxsc().b[9][1]++, {}))];
	  } else {
	    cov_sy19jzxsc().b[6][1]++;
	  }

	  cov_sy19jzxsc().s[19]++;

	  if ((cov_sy19jzxsc().b[11][0]++, videoContentType) || (cov_sy19jzxsc().b[11][1]++, videoRobustness)) {
	    cov_sy19jzxsc().b[10][0]++;
	    cov_sy19jzxsc().s[20]++;
	    supportedConfiguration.videoCapabilities = [_extends({}, videoContentType ? (cov_sy19jzxsc().b[12][0]++, {
	      contentType: videoContentType
	    }) : (cov_sy19jzxsc().b[12][1]++, {}), videoRobustness ? (cov_sy19jzxsc().b[13][0]++, {
	      robustness: videoRobustness
	    }) : (cov_sy19jzxsc().b[13][1]++, {}))];
	  } else {
	    cov_sy19jzxsc().b[10][1]++;
	  }

	  cov_sy19jzxsc().s[21]++;

	  if (persistentState) {
	    cov_sy19jzxsc().b[14][0]++;
	    cov_sy19jzxsc().s[22]++;
	    supportedConfiguration.persistentState = persistentState;
	  } else {
	    cov_sy19jzxsc().b[14][1]++;
	  }

	  cov_sy19jzxsc().s[23]++;

	  if (initDataTypes) {
	    cov_sy19jzxsc().b[15][0]++;
	    cov_sy19jzxsc().s[24]++;
	    supportedConfiguration.initDataTypes = initDataTypes;
	  } else {
	    cov_sy19jzxsc().b[15][1]++;
	  }

	  cov_sy19jzxsc().s[25]++;
	  return [supportedConfiguration];
	};
	cov_sy19jzxsc().s[26]++;
	const getSupportedKeySystem = keySystems => {
	  cov_sy19jzxsc().f[3]++; // As this happens after the src is set on the video, we rely only on the set src (we
	  // do not change src based on capabilities of the browser in this plugin).

	  let promise;
	  cov_sy19jzxsc().s[27]++;
	  Object.keys(keySystems).forEach(keySystem => {
	    cov_sy19jzxsc().f[4]++;
	    const supportedConfigurations = (cov_sy19jzxsc().s[28]++, getSupportedConfigurations(keySystem, keySystems[keySystem]));
	    cov_sy19jzxsc().s[29]++;

	    if (!promise) {
	      cov_sy19jzxsc().b[16][0]++;
	      cov_sy19jzxsc().s[30]++;
	      promise = window_1.navigator.requestMediaKeySystemAccess(keySystem, supportedConfigurations);
	    } else {
	      cov_sy19jzxsc().b[16][1]++;
	      cov_sy19jzxsc().s[31]++;
	      promise = promise.catch(e => {
	        cov_sy19jzxsc().f[5]++;
	        cov_sy19jzxsc().s[32]++;
	        return window_1.navigator.requestMediaKeySystemAccess(keySystem, supportedConfigurations);
	      });
	    }
	  });
	  cov_sy19jzxsc().s[33]++;
	  return promise;
	};
	cov_sy19jzxsc().s[34]++;
	const makeNewRequest = (player, requestOptions) => {
	  cov_sy19jzxsc().f[6]++;
	  const {
	    mediaKeys,
	    initDataType,
	    initData,
	    options,
	    getLicense,
	    removeSession,
	    eventBus,
	    contentId,
	    emeError,
	    keySystem
	  } = (cov_sy19jzxsc().s[35]++, requestOptions);
	  let timeElapsed = (cov_sy19jzxsc().s[36]++, 0);
	  let pauseTimer;
	  cov_sy19jzxsc().s[37]++;
	  player.on('pause', () => {
	    cov_sy19jzxsc().f[7]++;
	    cov_sy19jzxsc().s[38]++;

	    if ((cov_sy19jzxsc().b[18][0]++, options.limitRenewalsMaxPauseDuration) && (cov_sy19jzxsc().b[18][1]++, typeof options.limitRenewalsMaxPauseDuration === 'number')) {
	      cov_sy19jzxsc().b[17][0]++;
	      cov_sy19jzxsc().s[39]++;
	      pauseTimer = setInterval(() => {
	        cov_sy19jzxsc().f[8]++;
	        cov_sy19jzxsc().s[40]++;
	        timeElapsed++;
	        cov_sy19jzxsc().s[41]++;

	        if (timeElapsed >= options.limitRenewalsMaxPauseDuration) {
	          cov_sy19jzxsc().b[19][0]++;
	          cov_sy19jzxsc().s[42]++;
	          clearInterval(pauseTimer);
	        } else {
	          cov_sy19jzxsc().b[19][1]++;
	        }
	      }, 1000);
	      cov_sy19jzxsc().s[43]++;
	      player.on('play', () => {
	        cov_sy19jzxsc().f[9]++;
	        cov_sy19jzxsc().s[44]++;
	        clearInterval(pauseTimer);
	        cov_sy19jzxsc().s[45]++;
	        timeElapsed = 0;
	      });
	    } else {
	      cov_sy19jzxsc().b[17][1]++;
	    }
	  });
	  cov_sy19jzxsc().s[46]++;

	  try {
	    const keySession = (cov_sy19jzxsc().s[47]++, mediaKeys.createSession());
	    cov_sy19jzxsc().s[48]++;

	    const closeAndRemoveSession = () => {
	      cov_sy19jzxsc().f[10]++;
	      cov_sy19jzxsc().s[49]++;
	      videojs__default["default"].log.debug('Session expired, closing the session.');
	      cov_sy19jzxsc().s[50]++;
	      keySession.close().then(() => {
	        cov_sy19jzxsc().f[11]++;
	        cov_sy19jzxsc().s[51]++; // Because close() is async, this promise could resolve after the
	        // player has been disposed.

	        if (eventBus.isDisposed()) {
	          cov_sy19jzxsc().b[20][0]++;
	          cov_sy19jzxsc().s[52]++;
	          return;
	        } else {
	          cov_sy19jzxsc().b[20][1]++;
	        }

	        cov_sy19jzxsc().s[53]++;
	        safeTriggerOnEventBus(eventBus, {
	          type: 'keysessionclosed',
	          keySession
	        });
	        cov_sy19jzxsc().s[54]++;
	        removeSession(initData);
	      }).catch(error => {
	        cov_sy19jzxsc().f[12]++;
	        const metadata = (cov_sy19jzxsc().s[55]++, {
	          errorType: Error$1.EMEFailedToCloseSession,
	          keySystem
	        });
	        cov_sy19jzxsc().s[56]++;
	        emeError(error, metadata);
	      });
	    };

	    cov_sy19jzxsc().s[57]++;
	    safeTriggerOnEventBus(eventBus, {
	      type: 'keysessioncreated',
	      keySession
	    });
	    cov_sy19jzxsc().s[58]++;
	    player.on('dispose', () => {
	      cov_sy19jzxsc().f[13]++;
	      cov_sy19jzxsc().s[59]++;
	      closeAndRemoveSession();
	    });
	    cov_sy19jzxsc().s[60]++;
	    return new Promise((resolve, reject) => {
	      cov_sy19jzxsc().f[14]++;
	      cov_sy19jzxsc().s[61]++;
	      keySession.addEventListener('message', event => {
	        cov_sy19jzxsc().f[15]++;
	        cov_sy19jzxsc().s[62]++;
	        safeTriggerOnEventBus(eventBus, {
	          type: 'keymessage',
	          messageEvent: event
	        }); // all other types will be handled by keystatuseschange

	        cov_sy19jzxsc().s[63]++;

	        if ((cov_sy19jzxsc().b[22][0]++, event.messageType !== 'license-request') && (cov_sy19jzxsc().b[22][1]++, event.messageType !== 'license-renewal')) {
	          cov_sy19jzxsc().b[21][0]++;
	          cov_sy19jzxsc().s[64]++;
	          return;
	        } else {
	          cov_sy19jzxsc().b[21][1]++;
	        }

	        cov_sy19jzxsc().s[65]++;

	        if (event.messageType === 'license-renewal') {
	          cov_sy19jzxsc().b[23][0]++;
	          const limitRenewalsBeforePlay = (cov_sy19jzxsc().s[66]++, options.limitRenewalsBeforePlay);
	          const limitRenewalsMaxPauseDuration = (cov_sy19jzxsc().s[67]++, options.limitRenewalsMaxPauseDuration);
	          const validLimitRenewalsMaxPauseDuration = (cov_sy19jzxsc().s[68]++, typeof limitRenewalsMaxPauseDuration === 'number');
	          const renewingBeforePlayback = (cov_sy19jzxsc().s[69]++, (cov_sy19jzxsc().b[24][0]++, !player.hasStarted()) && (cov_sy19jzxsc().b[24][1]++, limitRenewalsBeforePlay));
	          const maxPauseDurationReached = (cov_sy19jzxsc().s[70]++, (cov_sy19jzxsc().b[25][0]++, player.paused()) && (cov_sy19jzxsc().b[25][1]++, validLimitRenewalsMaxPauseDuration) && (cov_sy19jzxsc().b[25][2]++, timeElapsed >= limitRenewalsMaxPauseDuration));
	          const ended = (cov_sy19jzxsc().s[71]++, player.ended());
	          cov_sy19jzxsc().s[72]++;

	          if ((cov_sy19jzxsc().b[27][0]++, renewingBeforePlayback) || (cov_sy19jzxsc().b[27][1]++, maxPauseDurationReached) || (cov_sy19jzxsc().b[27][2]++, ended)) {
	            cov_sy19jzxsc().b[26][0]++;
	            cov_sy19jzxsc().s[73]++;
	            closeAndRemoveSession();
	            cov_sy19jzxsc().s[74]++;
	            return;
	          } else {
	            cov_sy19jzxsc().b[26][1]++;
	          }
	        } else {
	          cov_sy19jzxsc().b[23][1]++;
	        }

	        cov_sy19jzxsc().s[75]++;
	        getLicense(options, event.message, contentId).then(license => {
	          cov_sy19jzxsc().f[16]++;
	          cov_sy19jzxsc().s[76]++;
	          resolve(keySession.update(license).then(() => {
	            cov_sy19jzxsc().f[17]++;
	            cov_sy19jzxsc().s[77]++;
	            safeTriggerOnEventBus(eventBus, {
	              type: 'keysessionupdated',
	              keySession
	            });
	          }).catch(error => {
	            cov_sy19jzxsc().f[18]++;
	            const metadata = (cov_sy19jzxsc().s[78]++, {
	              errorType: Error$1.EMEFailedToUpdateSessionWithReceivedLicenseKeys,
	              keySystem
	            });
	            cov_sy19jzxsc().s[79]++;
	            emeError(error, metadata);
	          }));
	        }).catch(err => {
	          cov_sy19jzxsc().f[19]++;
	          cov_sy19jzxsc().s[80]++;
	          reject(err);
	        });
	      }, false);
	      const KEY_STATUSES_CHANGE = (cov_sy19jzxsc().s[81]++, 'keystatuseschange');
	      cov_sy19jzxsc().s[82]++;
	      keySession.addEventListener(KEY_STATUSES_CHANGE, event => {
	        cov_sy19jzxsc().f[20]++;
	        let expired = (cov_sy19jzxsc().s[83]++, false); // Protect from race conditions causing the player to be disposed.

	        cov_sy19jzxsc().s[84]++;

	        if (eventBus.isDisposed()) {
	          cov_sy19jzxsc().b[28][0]++;
	          cov_sy19jzxsc().s[85]++;
	          return;
	        } else {
	          cov_sy19jzxsc().b[28][1]++;
	        } // Re-emit the keystatuseschange event with the entire keyStatusesMap


	        cov_sy19jzxsc().s[86]++;
	        safeTriggerOnEventBus(eventBus, {
	          type: KEY_STATUSES_CHANGE,
	          keyStatuses: keySession.keyStatuses
	        }); // Keep 'keystatuschange' for backward compatibility.
	        // based on https://www.w3.org/TR/encrypted-media/#example-using-all-events

	        cov_sy19jzxsc().s[87]++;
	        keySession.keyStatuses.forEach((status, keyId) => {
	          cov_sy19jzxsc().f[21]++;
	          cov_sy19jzxsc().s[88]++; // Trigger an event so that outside listeners can take action if appropriate.
	          // For instance, the `output-restricted` status should result in an
	          // error being thrown.

	          safeTriggerOnEventBus(eventBus, {
	            keyId,
	            status,
	            target: keySession,
	            type: 'keystatuschange'
	          });
	          cov_sy19jzxsc().s[89]++;

	          switch (status) {
	            case 'expired':
	              cov_sy19jzxsc().b[29][0]++;
	              cov_sy19jzxsc().s[90]++; // If one key is expired in a session, all keys are expired. From
	              // https://www.w3.org/TR/encrypted-media/#dom-mediakeystatus-expired, "All other
	              // keys in the session must have this status."

	              expired = true;
	              cov_sy19jzxsc().s[91]++;
	              break;

	            case 'internal-error':
	              cov_sy19jzxsc().b[29][1]++;
	              const message = (cov_sy19jzxsc().s[92]++, 'Key status reported as "internal-error." Leaving the session open since we ' + 'don\'t have enough details to know if this error is fatal.'); // "This value is not actionable by the application."
	              // https://www.w3.org/TR/encrypted-media/#dom-mediakeystatus-internal-error

	              cov_sy19jzxsc().s[93]++;
	              videojs__default["default"].log.warn(message, event);
	              cov_sy19jzxsc().s[94]++;
	              break;
	          }
	        });
	        cov_sy19jzxsc().s[95]++;

	        if (expired) {
	          cov_sy19jzxsc().b[30][0]++;
	          cov_sy19jzxsc().s[96]++; // Close session and remove it from the session list to ensure that a new
	          // session can be created.

	          closeAndRemoveSession();
	        } else {
	          cov_sy19jzxsc().b[30][1]++;
	        }
	      }, false);
	      cov_sy19jzxsc().s[97]++;
	      keySession.generateRequest(initDataType, initData).catch(error => {
	        cov_sy19jzxsc().f[22]++;
	        const metadata = (cov_sy19jzxsc().s[98]++, {
	          errorType: Error$1.EMEFailedToGenerateLicenseRequest,
	          keySystem
	        });
	        cov_sy19jzxsc().s[99]++;
	        emeError(error, metadata);
	        cov_sy19jzxsc().s[100]++;
	        reject('Unable to create or initialize key session');
	      });
	    });
	  } catch (error) {
	    const metadata = (cov_sy19jzxsc().s[101]++, {
	      errorType: Error$1.EMEFailedToCreateMediaKeySession,
	      keySystem
	    });
	    cov_sy19jzxsc().s[102]++;
	    emeError(error, metadata);
	  }
	};
	/*
	* Creates a new media key session if media keys are available, otherwise queues the
	* session creation for when the media keys are available.
	*
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeysession|MediaKeySession}
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeys|MediaKeys}
	*
	* @function addSession
	* @param {Object} video
	*        Target video element
	* @param {string} initDataType
	*        The type of init data provided
	* @param {Uint8Array} initData
	*        The media's init data
	* @param {Object} options
	*        Options provided to the plugin for this key system
	* @param {function()} [getLicense]
	*        User provided function to retrieve a license
	* @param {function()} removeSession
	*        Function to remove the persisted session on key expiration so that a new session
	*        may be created
	* @param {Object} eventBus
	*        Event bus for any events pertinent to users
	* @return {Promise}
	*         A resolved promise if session is waiting for media keys, or a promise for the
	*         session creation if media keys are available
	*/

	cov_sy19jzxsc().s[103]++;
	const addSession = ({
	  player,
	  video,
	  initDataType,
	  initData,
	  options,
	  getLicense,
	  contentId,
	  removeSession,
	  eventBus,
	  emeError
	}) => {
	  cov_sy19jzxsc().f[23]++;
	  const sessionData = (cov_sy19jzxsc().s[104]++, {
	    initDataType,
	    initData,
	    options,
	    getLicense,
	    removeSession,
	    eventBus,
	    contentId,
	    emeError,
	    keySystem: video.keySystem
	  });
	  cov_sy19jzxsc().s[105]++;

	  if (video.mediaKeysObject) {
	    cov_sy19jzxsc().b[31][0]++;
	    cov_sy19jzxsc().s[106]++;
	    sessionData.mediaKeys = video.mediaKeysObject;
	    cov_sy19jzxsc().s[107]++;
	    return makeNewRequest(player, sessionData);
	  } else {
	    cov_sy19jzxsc().b[31][1]++;
	  }

	  cov_sy19jzxsc().s[108]++;
	  video.pendingSessionData.push(sessionData);
	  cov_sy19jzxsc().s[109]++;
	  return Promise.resolve();
	};
	/*
	* Given media keys created from a key system access object, check for any session data
	* that was queued and create new sessions for each.
	*
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeysystemaccess|MediaKeySystemAccess}
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeysession|MediaKeySession}
	* @see {@link https://www.w3.org/TR/encrypted-media/#dom-mediakeys|MediaKeys}
	*
	* @function addPendingSessions
	* @param {Object} video
	*        Target video element
	* @param {string} [certificate]
	*        The server certificate (if used)
	* @param {Object} createdMediaKeys
	*        Media keys to use for session creation
	* @return {Promise}
	*         A promise containing new session creations and setting of media keys on the
	*         video object
	*/

	cov_sy19jzxsc().s[110]++;
	const addPendingSessions = ({
	  player,
	  video,
	  certificate,
	  createdMediaKeys,
	  emeError
	}) => {
	  cov_sy19jzxsc().f[24]++;
	  cov_sy19jzxsc().s[111]++; // save media keys on the video element to act as a reference for other functions so
	  // that they don't recreate the keys

	  video.mediaKeysObject = createdMediaKeys;
	  const promises = (cov_sy19jzxsc().s[112]++, []);
	  cov_sy19jzxsc().s[113]++;

	  if (certificate) {
	    cov_sy19jzxsc().b[32][0]++;
	    cov_sy19jzxsc().s[114]++;
	    promises.push(createdMediaKeys.setServerCertificate(certificate).catch(error => {
	      cov_sy19jzxsc().f[25]++;
	      const metadata = (cov_sy19jzxsc().s[115]++, {
	        errorType: Error$1.EMEFailedToSetServerCertificate,
	        keySystem: video.keySystem
	      });
	      cov_sy19jzxsc().s[116]++;
	      emeError(error, metadata);
	    }));
	  } else {
	    cov_sy19jzxsc().b[32][1]++;
	  }

	  cov_sy19jzxsc().s[117]++;

	  for (let i = (cov_sy19jzxsc().s[118]++, 0); i < video.pendingSessionData.length; i++) {
	    const data = (cov_sy19jzxsc().s[119]++, video.pendingSessionData[i]);
	    cov_sy19jzxsc().s[120]++;
	    promises.push(makeNewRequest(player, {
	      mediaKeys: video.mediaKeysObject,
	      initDataType: data.initDataType,
	      initData: data.initData,
	      options: data.options,
	      getLicense: data.getLicense,
	      removeSession: data.removeSession,
	      eventBus: data.eventBus,
	      contentId: data.contentId,
	      emeError: data.emeError,
	      keySystem: video.keySystem
	    }));
	  }

	  cov_sy19jzxsc().s[121]++;
	  video.pendingSessionData = [];
	  cov_sy19jzxsc().s[122]++;
	  promises.push(video.setMediaKeys(createdMediaKeys).catch(error => {
	    cov_sy19jzxsc().f[26]++;
	    const metadata = (cov_sy19jzxsc().s[123]++, {
	      errorType: Error$1.EMEFailedToAttachMediaKeysToVideoElement,
	      keySystem: video.keySystem
	    });
	    cov_sy19jzxsc().s[124]++;
	    emeError(error, metadata);
	  }));
	  cov_sy19jzxsc().s[125]++;
	  return Promise.all(promises);
	};
	cov_sy19jzxsc().s[126]++;

	const defaultPlayreadyGetLicense = (keySystem, keySystemOptions) => {
	  cov_sy19jzxsc().f[27]++;
	  cov_sy19jzxsc().s[127]++;
	  return (emeOptions, keyMessage, callback) => {
	    cov_sy19jzxsc().f[28]++;
	    cov_sy19jzxsc().s[128]++;
	    requestPlayreadyLicense(keySystem, keySystemOptions, keyMessage, emeOptions, callback);
	  };
	};

	cov_sy19jzxsc().s[129]++;
	const defaultGetLicense = (keySystem, keySystemOptions) => {
	  cov_sy19jzxsc().f[29]++;
	  cov_sy19jzxsc().s[130]++;
	  return (emeOptions, keyMessage, callback) => {
	    cov_sy19jzxsc().f[30]++;
	    const headers = (cov_sy19jzxsc().s[131]++, mergeAndRemoveNull({
	      'Content-type': 'application/octet-stream'
	    }, emeOptions.emeHeaders, keySystemOptions.licenseHeaders));
	    cov_sy19jzxsc().s[132]++;
	    videojs__default["default"].xhr({
	      uri: keySystemOptions.url,
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem
	      },
	      body: keyMessage,
	      headers
	    }, httpResponseHandler(callback, true));
	  };
	};
	cov_sy19jzxsc().s[133]++;

	const promisifyGetLicense = (keySystem, getLicenseFn, eventBus) => {
	  cov_sy19jzxsc().f[31]++;
	  cov_sy19jzxsc().s[134]++;
	  return (emeOptions, keyMessage, contentId) => {
	    cov_sy19jzxsc().f[32]++;
	    cov_sy19jzxsc().s[135]++;
	    return new Promise((resolve, reject) => {
	      cov_sy19jzxsc().f[33]++;
	      cov_sy19jzxsc().s[136]++;

	      const callback = function (err, license) {
	        cov_sy19jzxsc().f[34]++;
	        cov_sy19jzxsc().s[137]++;

	        if (eventBus) {
	          cov_sy19jzxsc().b[33][0]++;
	          cov_sy19jzxsc().s[138]++;
	          safeTriggerOnEventBus(eventBus, {
	            type: 'licenserequestattempted'
	          });
	        } else {
	          cov_sy19jzxsc().b[33][1]++;
	        }

	        cov_sy19jzxsc().s[139]++;

	        if (err) {
	          cov_sy19jzxsc().b[34][0]++;
	          cov_sy19jzxsc().s[140]++;
	          reject(err);
	          cov_sy19jzxsc().s[141]++;
	          return;
	        } else {
	          cov_sy19jzxsc().b[34][1]++;
	        }

	        cov_sy19jzxsc().s[142]++;
	        resolve(license);
	      };

	      cov_sy19jzxsc().s[143]++;

	      if (isFairplayKeySystem(keySystem)) {
	        cov_sy19jzxsc().b[35][0]++;
	        cov_sy19jzxsc().s[144]++;
	        getLicenseFn(emeOptions, contentId, new Uint8Array(keyMessage), callback);
	      } else {
	        cov_sy19jzxsc().b[35][1]++;
	        cov_sy19jzxsc().s[145]++;
	        getLicenseFn(emeOptions, keyMessage, callback);
	      }
	    });
	  };
	};

	cov_sy19jzxsc().s[146]++;

	const standardizeKeySystemOptions = (keySystem, keySystemOptions) => {
	  cov_sy19jzxsc().f[35]++;
	  cov_sy19jzxsc().s[147]++;

	  if (typeof keySystemOptions === 'string') {
	    cov_sy19jzxsc().b[36][0]++;
	    cov_sy19jzxsc().s[148]++;
	    keySystemOptions = {
	      url: keySystemOptions
	    };
	  } else {
	    cov_sy19jzxsc().b[36][1]++;
	  }

	  cov_sy19jzxsc().s[149]++;

	  if ((cov_sy19jzxsc().b[38][0]++, !keySystemOptions.url) && (cov_sy19jzxsc().b[38][1]++, keySystemOptions.licenseUri)) {
	    cov_sy19jzxsc().b[37][0]++;
	    cov_sy19jzxsc().s[150]++;
	    keySystemOptions.url = keySystemOptions.licenseUri;
	  } else {
	    cov_sy19jzxsc().b[37][1]++;
	  }

	  cov_sy19jzxsc().s[151]++;

	  if ((cov_sy19jzxsc().b[40][0]++, !keySystemOptions.url) && (cov_sy19jzxsc().b[40][1]++, !keySystemOptions.getLicense)) {
	    cov_sy19jzxsc().b[39][0]++;
	    cov_sy19jzxsc().s[152]++;
	    throw new Error(`Missing url/licenseUri or getLicense in ${keySystem} keySystem configuration.`);
	  } else {
	    cov_sy19jzxsc().b[39][1]++;
	  }

	  const isFairplay = (cov_sy19jzxsc().s[153]++, isFairplayKeySystem(keySystem));
	  cov_sy19jzxsc().s[154]++;

	  if ((cov_sy19jzxsc().b[42][0]++, isFairplay) && (cov_sy19jzxsc().b[42][1]++, keySystemOptions.certificateUri) && (cov_sy19jzxsc().b[42][2]++, !keySystemOptions.getCertificate)) {
	    cov_sy19jzxsc().b[41][0]++;
	    cov_sy19jzxsc().s[155]++;
	    keySystemOptions.getCertificate = defaultGetCertificate(keySystem, keySystemOptions);
	  } else {
	    cov_sy19jzxsc().b[41][1]++;
	  }

	  cov_sy19jzxsc().s[156]++;

	  if ((cov_sy19jzxsc().b[44][0]++, isFairplay) && (cov_sy19jzxsc().b[44][1]++, !keySystemOptions.getCertificate)) {
	    cov_sy19jzxsc().b[43][0]++;
	    cov_sy19jzxsc().s[157]++;
	    throw new Error(`Missing getCertificate or certificateUri in ${keySystem} keySystem configuration.`);
	  } else {
	    cov_sy19jzxsc().b[43][1]++;
	  }

	  cov_sy19jzxsc().s[158]++;

	  if ((cov_sy19jzxsc().b[46][0]++, isFairplay) && (cov_sy19jzxsc().b[46][1]++, !keySystemOptions.getContentId)) {
	    cov_sy19jzxsc().b[45][0]++;
	    cov_sy19jzxsc().s[159]++;
	    keySystemOptions.getContentId = defaultGetContentId;
	  } else {
	    cov_sy19jzxsc().b[45][1]++;
	  }

	  cov_sy19jzxsc().s[160]++;

	  if ((cov_sy19jzxsc().b[48][0]++, keySystemOptions.url) && (cov_sy19jzxsc().b[48][1]++, !keySystemOptions.getLicense)) {
	    cov_sy19jzxsc().b[47][0]++;
	    cov_sy19jzxsc().s[161]++;

	    if (keySystem === 'com.microsoft.playready') {
	      cov_sy19jzxsc().b[49][0]++;
	      cov_sy19jzxsc().s[162]++;
	      keySystemOptions.getLicense = defaultPlayreadyGetLicense(keySystem, keySystemOptions);
	    } else {
	      cov_sy19jzxsc().b[49][1]++;
	      cov_sy19jzxsc().s[163]++;

	      if (isFairplay) {
	        cov_sy19jzxsc().b[50][0]++;
	        cov_sy19jzxsc().s[164]++;
	        keySystemOptions.getLicense = defaultGetLicense$1(keySystem, keySystemOptions);
	      } else {
	        cov_sy19jzxsc().b[50][1]++;
	        cov_sy19jzxsc().s[165]++;
	        keySystemOptions.getLicense = defaultGetLicense(keySystem, keySystemOptions);
	      }
	    }
	  } else {
	    cov_sy19jzxsc().b[47][1]++;
	  }

	  cov_sy19jzxsc().s[166]++;
	  return keySystemOptions;
	};

	cov_sy19jzxsc().s[167]++;
	const standard5July2016 = ({
	  player,
	  video,
	  initDataType,
	  initData,
	  keySystemAccess,
	  options,
	  removeSession,
	  eventBus,
	  emeError
	}) => {
	  cov_sy19jzxsc().f[36]++;
	  let keySystemPromise = (cov_sy19jzxsc().s[168]++, Promise.resolve());
	  const keySystem = (cov_sy19jzxsc().s[169]++, keySystemAccess.keySystem);
	  let keySystemOptions; // try catch so that we return a promise rejection

	  cov_sy19jzxsc().s[170]++;

	  try {
	    cov_sy19jzxsc().s[171]++;
	    keySystemOptions = standardizeKeySystemOptions(keySystem, options.keySystems[keySystem]);
	  } catch (e) {
	    cov_sy19jzxsc().s[172]++;
	    return Promise.reject(e);
	  }

	  const contentId = (cov_sy19jzxsc().s[173]++, keySystemOptions.getContentId ? (cov_sy19jzxsc().b[51][0]++, keySystemOptions.getContentId(options, uint8ArrayToString(initData))) : (cov_sy19jzxsc().b[51][1]++, null));
	  cov_sy19jzxsc().s[174]++;

	  if (typeof video.mediaKeysObject === 'undefined') {
	    cov_sy19jzxsc().b[52][0]++;
	    cov_sy19jzxsc().s[175]++; // Prevent entering this path again.

	    video.mediaKeysObject = null; // Will store all initData until the MediaKeys is ready.

	    cov_sy19jzxsc().s[176]++;
	    video.pendingSessionData = [];
	    let certificate;
	    cov_sy19jzxsc().s[177]++;
	    keySystemPromise = new Promise((resolve, reject) => {
	      cov_sy19jzxsc().f[37]++;
	      cov_sy19jzxsc().s[178]++; // save key system for adding sessions

	      video.keySystem = keySystem;
	      cov_sy19jzxsc().s[179]++;

	      if (!keySystemOptions.getCertificate) {
	        cov_sy19jzxsc().b[53][0]++;
	        cov_sy19jzxsc().s[180]++;
	        resolve(keySystemAccess);
	        cov_sy19jzxsc().s[181]++;
	        return;
	      } else {
	        cov_sy19jzxsc().b[53][1]++;
	      }

	      cov_sy19jzxsc().s[182]++;
	      keySystemOptions.getCertificate(options, (err, cert) => {
	        cov_sy19jzxsc().f[38]++;
	        cov_sy19jzxsc().s[183]++;

	        if (err) {
	          cov_sy19jzxsc().b[54][0]++;
	          cov_sy19jzxsc().s[184]++;
	          reject(err);
	          cov_sy19jzxsc().s[185]++;
	          return;
	        } else {
	          cov_sy19jzxsc().b[54][1]++;
	        }

	        cov_sy19jzxsc().s[186]++;
	        certificate = cert;
	        cov_sy19jzxsc().s[187]++;
	        resolve();
	      });
	    }).then(() => {
	      cov_sy19jzxsc().f[39]++;
	      cov_sy19jzxsc().s[188]++;
	      return keySystemAccess.createMediaKeys();
	    }).then(createdMediaKeys => {
	      cov_sy19jzxsc().f[40]++;
	      cov_sy19jzxsc().s[189]++;
	      safeTriggerOnEventBus(eventBus, {
	        type: 'keysystemaccesscomplete',
	        mediaKeys: createdMediaKeys
	      });
	      cov_sy19jzxsc().s[190]++;
	      return addPendingSessions({
	        player,
	        video,
	        certificate,
	        createdMediaKeys,
	        emeError
	      });
	    }).catch(err => {
	      cov_sy19jzxsc().f[41]++;
	      const metadata = (cov_sy19jzxsc().s[191]++, {
	        errorType: Error$1.EMEFailedToCreateMediaKeys,
	        keySystem
	      });
	      cov_sy19jzxsc().s[192]++;
	      emeError(err, metadata); // if we have a specific error message, use it, otherwise show a more
	      // generic one

	      cov_sy19jzxsc().s[193]++;

	      if (err) {
	        cov_sy19jzxsc().b[55][0]++;
	        cov_sy19jzxsc().s[194]++;
	        return Promise.reject(err);
	      } else {
	        cov_sy19jzxsc().b[55][1]++;
	      }

	      cov_sy19jzxsc().s[195]++;
	      return Promise.reject('Failed to create and initialize a MediaKeys object');
	    });
	  } else {
	    cov_sy19jzxsc().b[52][1]++;
	  }

	  cov_sy19jzxsc().s[196]++;
	  return keySystemPromise.then(() => {
	    cov_sy19jzxsc().f[42]++; // if key system has not been determined then addSession doesn't need getLicense

	    const getLicense = (cov_sy19jzxsc().s[197]++, video.keySystem ? (cov_sy19jzxsc().b[56][0]++, promisifyGetLicense(keySystem, keySystemOptions.getLicense, eventBus)) : (cov_sy19jzxsc().b[56][1]++, null));
	    cov_sy19jzxsc().s[198]++;
	    return addSession({
	      player,
	      video,
	      initDataType,
	      initData,
	      options,
	      getLicense,
	      contentId,
	      removeSession,
	      eventBus,
	      emeError
	    });
	  });
	};

	const stringToArrayBuffer = string => {
	  const buffer = new ArrayBuffer(string.length * 2);
	  const typedArray = new Uint16Array(buffer);

	  for (let i = 0; i < string.length; i++) {
	    typedArray[i] = string.charCodeAt(i);
	  }

	  return buffer;
	};
	const getMockEventBus = () => {
	  const calls = [];
	  const mockEventBus = {
	    calls,
	    trigger: event => {
	      calls.push(event);
	    },
	    isDisposed: () => {
	      return false;
	    }
	  };
	  return mockEventBus;
	};

	const getMockSession = () => {
	  const mockSession = {
	    addEventListener: (type, listener) => mockSession.listeners.push({
	      type,
	      listener
	    }),

	    generateRequest(initDataType, initData) {
	      // noop
	      return new Promise((resolve, reject) => resolve());
	    },

	    keyStatuses: new Map(),
	    close: () => {
	      mockSession.numCloses++; // fake a promise for easy testing

	      return {
	        then: nextCall => {
	          nextCall();
	          return Promise.resolve();
	        }
	      };
	    },
	    numCloses: 0,
	    listeners: []
	  };
	  return mockSession;
	};

	const resolveReject = (rejectVariable, rejectMessage) => {
	  return new Promise((resolve, reject) => {
	    if (rejectVariable) {
	      reject(rejectMessage);
	      return;
	    }

	    resolve();
	  });
	};

	QUnit__default["default"].module('videojs-contrib-eme eme', {
	  beforeEach() {
	    this.fixture = document_1.getElementById('qunit-fixture');
	    this.video = document_1.createElement('video');
	    this.fixture.appendChild(this.video);
	    this.player = videojs__default["default"](this.video);
	    this.origXhr = videojs__default["default"].xhr;
	  },

	  afterEach() {
	    videojs__default["default"].xhr = this.origXhr;
	  }

	});
	QUnit__default["default"].test('keystatuseschange triggers keystatuschange on eventBus for each key', function (assert) {
	  const callCount = {
	    total: 0,
	    1: {},
	    2: {},
	    3: {},
	    4: {},
	    5: {}
	  };
	  const initData = new Uint8Array([1, 2, 3]);
	  const mockSession = getMockSession();
	  const eventBus = {
	    trigger: event => {
	      if (typeof event === 'string' || event.type !== 'keystatuschange') {
	        return;
	      }

	      if (!callCount[event.keyId][event.status]) {
	        callCount[event.keyId][event.status] = 0;
	      }

	      callCount[event.keyId][event.status]++;
	      callCount.total++;
	    },
	    isDisposed: () => {
	      return false;
	    }
	  };
	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    initDataType: '',
	    initData,
	    options: {},

	    getLicense() {},

	    removeSession() {},

	    eventBus,

	    emeError() {}

	  });
	  assert.equal(mockSession.listeners.length, 2, 'added listeners');
	  assert.equal(mockSession.listeners[1].type, 'keystatuseschange', 'added keystatuseschange listener'); // no key statuses

	  mockSession.listeners[1].listener();
	  assert.equal(callCount.total, 0, 'no events dispatched yet');
	  mockSession.keyStatuses.set(1, 'unrecognized');
	  mockSession.keyStatuses.set(2, 'expired');
	  mockSession.keyStatuses.set(3, 'internal-error');
	  mockSession.keyStatuses.set(4, 'output-restricted');
	  mockSession.keyStatuses.set(5, 'output-restricted');
	  mockSession.listeners[1].listener();
	  assert.equal(callCount[1].unrecognized, 1, 'dispatched `unrecognized` key status for key 1');
	  assert.equal(callCount[2].expired, 1, 'dispatched `expired` key status for key 2');
	  assert.equal(callCount[3]['internal-error'], 1, 'dispatched `internal-error` key status for key 3');
	  assert.equal(callCount[4]['output-restricted'], 1, 'dispatched `output-restricted` key status for key 4');
	  assert.equal(callCount[5]['output-restricted'], 1, 'dispatched `output-restricted` key status for key 5');
	  assert.equal(callCount.total, 5, '5 keystatuschange events received so far'); // Change a single key and check that it's triggered for all keys

	  mockSession.keyStatuses.set(1, 'usable');
	  mockSession.listeners[1].listener();
	  assert.equal(callCount[1].usable, 1, 'dispatched `usable` key status for key 1');
	  assert.equal(callCount[2].expired, 2, 'dispatched `expired` key status for key 2');
	  assert.equal(callCount[3]['internal-error'], 2, 'dispatched `internal-error` key status for key 3');
	  assert.equal(callCount[4]['output-restricted'], 2, 'dispatched `output-restricted` key status for key 4');
	  assert.equal(callCount[5]['output-restricted'], 2, 'dispatched `output-restricted` key status for key 5');
	  assert.equal(callCount.total, 10, '10 keystatuschange events received so far'); // Change the key statuses and recheck

	  mockSession.keyStatuses.set(1, 'output-downscaled');
	  mockSession.keyStatuses.set(2, 'released');
	  mockSession.keyStatuses.set(3, 'usable');
	  mockSession.keyStatuses.set(4, 'status-pending');
	  mockSession.keyStatuses.set(5, 'usable');
	  mockSession.listeners[1].listener();
	  assert.equal(callCount[1]['output-downscaled'], 1, 'dispatched `output-downscaled` key status for key 1');
	  assert.equal(callCount[2].released, 1, 'dispatched `released` key status for key 2');
	  assert.equal(callCount[3].usable, 1, 'dispatched `usable` key status for key 3');
	  assert.equal(callCount[4]['status-pending'], 1, 'dispatched `status-pending` key status for key 4');
	  assert.equal(callCount[5].usable, 1, 'dispatched `usable` key status for key 5');
	  assert.equal(callCount.total, 15, '15 keystatuschange events received so far');
	});
	QUnit__default["default"].test('keystatuseschange with expired key closes', function (assert) {
	  const removeSessionCalls = []; // once the eme module gets the removeSession function, the session argument is already
	  // bound to the function (note that it's a custom session maintained by the plugin, not
	  // the native session), so only initData is passed

	  const removeSession = initData => removeSessionCalls.push(initData);

	  const initData = new Uint8Array([1, 2, 3]);
	  const mockSession = getMockSession();
	  const eventBus = {
	    trigger: name => {},
	    isDisposed: () => {
	      return false;
	    }
	  };
	  let creates = 0;
	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => {
	        creates++;
	        return mockSession;
	      }
	    },
	    initDataType: '',
	    initData,
	    options: {},

	    getLicense() {},

	    removeSession,
	    eventBus
	  });
	  assert.equal(creates, 1, 'created session');
	  assert.equal(mockSession.listeners.length, 2, 'added listeners');
	  assert.equal(mockSession.listeners[1].type, 'keystatuseschange', 'added keystatuseschange listener');
	  assert.equal(mockSession.numCloses, 0, 'no session close calls');
	  assert.equal(removeSessionCalls.length, 0, 'no removeSession calls'); // no key statuses

	  mockSession.listeners[1].listener();
	  assert.equal(mockSession.numCloses, 0, 'no session close calls');
	  assert.equal(removeSessionCalls.length, 0, 'no removeSession calls');
	  mockSession.keyStatuses.set(1, 'unrecognized');
	  mockSession.listeners[1].listener();
	  assert.equal(mockSession.numCloses, 0, 'no session close calls');
	  assert.equal(removeSessionCalls.length, 0, 'no removeSession calls');
	  mockSession.keyStatuses.set(2, 'expired');
	  mockSession.listeners[1].listener();
	  assert.equal(mockSession.numCloses, 1, 'closed session'); // close promise is fake and resolves synchronously, so we can assert removes
	  // synchronously

	  assert.equal(removeSessionCalls.length, 1, 'called remove session');
	  assert.equal(removeSessionCalls[0], initData, 'called to remove session with initData');
	  assert.equal(creates, 1, 'no new session created');
	});
	QUnit__default["default"].test('sessions are closed and removed on `ended` after expiry', function (assert) {
	  const done = assert.async();
	  let getLicenseCalls = 0;
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',

	        getLicense(emeOptions, keyMessage, callback) {
	          getLicenseCalls++;
	        }

	      }
	    }
	  };
	  const removeSessionCalls = []; // once the eme module gets the removeSession function, the session argument is already
	  // bound to the function (note that it's a custom session maintained by the plugin, not
	  // the native session), so only initData is passed

	  const removeSession = initData => removeSessionCalls.push(initData);

	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.resolve({
	        setServerCertificate: () => Promise.resolve(),
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              if (event === 'message') {
	                setTimeout(() => {
	                  callback({
	                    message: 'whatever',
	                    messageType: 'license-renewal'
	                  });
	                  assert.equal(getLicenseCalls, 0, 'did not call getLicense');
	                  assert.equal(removeSessionCalls.length, 1, 'session is removed');
	                  done();
	                });
	              }
	            },
	            keyStatuses: [],
	            generateRequest: () => Promise.resolve(),
	            close: () => {
	              return {
	                then: nextCall => {
	                  nextCall();
	                  return Promise.resolve();
	                }
	              };
	            }
	          };
	        }
	      });
	    }
	  };
	  const video = {
	    setMediaKeys: () => Promise.resolve()
	  };

	  this.player.ended = () => true;

	  standard5July2016({
	    player: this.player,
	    video,
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus(),
	    removeSession
	  });
	});
	QUnit__default["default"].test('keystatuseschange with internal-error logs a warning', function (assert) {
	  const origWarn = videojs__default["default"].log.warn;
	  const initData = new Uint8Array([1, 2, 3]);
	  const mockSession = getMockSession();
	  const warnCalls = [];
	  const eventBus = {
	    trigger: name => {},
	    isDisposed: () => {
	      return false;
	    }
	  };

	  videojs__default["default"].log.warn = (...args) => warnCalls.push(args);

	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    initDataType: '',
	    initData,
	    options: {},

	    getLicense() {},

	    removeSession() {},

	    eventBus
	  });
	  assert.equal(mockSession.listeners.length, 2, 'added listeners');
	  assert.equal(mockSession.listeners[1].type, 'keystatuseschange', 'added keystatuseschange listener'); // no key statuses

	  mockSession.listeners[1].listener();
	  assert.equal(warnCalls.length, 0, 'no warn logs');
	  mockSession.keyStatuses.set(1, 'internal-error');
	  const keyStatusChangeEvent = {};
	  mockSession.listeners[1].listener(keyStatusChangeEvent);
	  assert.equal(warnCalls.length, 1, 'one warn log');
	  assert.equal(warnCalls[0][0], 'Key status reported as "internal-error." Leaving the session open ' + 'since we don\'t have enough details to know if this error is fatal.', 'logged correct warning');
	  assert.equal(warnCalls[0][1], keyStatusChangeEvent, 'logged event object');
	  videojs__default["default"].log.warn = origWarn;
	});
	QUnit__default["default"].test('accepts a license URL as an option', function (assert) {
	  const done = assert.async();
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  const mockSession = getMockSession();
	  const mockEventBus = getMockEventBus();
	  const mockMessageEvent = {
	    type: 'message',
	    message: 'the-message',
	    messageType: 'license-request'
	  };

	  videojs__default["default"].xhr = options => {
	    xhrCalls.push(options);
	  };

	  const createSession = () => mockSession;

	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return {
	        createSession
	      };
	    }
	  };
	  standard5July2016({
	    player: this.player,
	    keySystemAccess,
	    video: {
	      setMediaKeys: createdMediaKeys => Promise.resolve(createdMediaKeys)
	    },
	    initDataType: '',
	    initData: '',
	    options: {
	      keySystems: {
	        'com.widevine.alpha': 'some-url'
	      }
	    },
	    eventBus: mockEventBus
	  }).catch(e => {});
	  setTimeout(() => {
	    assert.equal(mockSession.listeners.length, 2, 'added listeners');
	    assert.equal(mockSession.listeners[0].type, 'message', 'added message listener'); // Simulate 'message' event

	    mockSession.listeners[0].listener(mockMessageEvent);
	    assert.equal(mockEventBus.calls[0].type, 'keysystemaccesscomplete', 'keysystemaccesscomplete fired');
	    assert.deepEqual(mockEventBus.calls[0].mediaKeys, {
	      createSession
	    }, 'keysystemaccesscomplete payload fired');
	    assert.equal(mockEventBus.calls[1].type, 'keysessioncreated', 'keysessioncreated fired');
	    assert.equal(mockEventBus.calls[1].keySession, mockSession, 'keysessioncreated payload fired');
	    assert.equal(mockEventBus.calls[2].type, 'keymessage', 'keymessage event type is expected type');
	    assert.equal(mockEventBus.calls[2].messageEvent, mockMessageEvent, 'keymessage event is expected message event');
	    assert.equal(xhrCalls.length, 1, 'made one XHR');
	    assert.deepEqual(xhrCalls[0], {
	      uri: 'some-url',
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem: 'com.widevine.alpha'
	      },
	      body: 'the-message',
	      headers: {
	        'Content-type': 'application/octet-stream'
	      }
	    }, 'made request with proper options');
	    videojs__default["default"].xhr = origXhr;
	    done();
	  });
	});
	QUnit__default["default"].test('accepts a license URL as property', function (assert) {
	  const done = assert.async();
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  const mockSession = getMockSession();
	  const mockEventBus = getMockEventBus();

	  const createSession = () => mockSession;

	  const mockMessageEvent = {
	    type: 'message',
	    message: 'the-message',
	    messageType: 'license-request'
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return {
	        createSession
	      };
	    }
	  };

	  videojs__default["default"].xhr = options => {
	    xhrCalls.push(options);
	  };

	  standard5July2016({
	    player: this.player,
	    keySystemAccess,
	    video: {
	      setMediaKeys: createdMediaKeys => Promise.resolve(createdMediaKeys)
	    },
	    initDataType: '',
	    initData: '',
	    options: {
	      keySystems: {
	        'com.widevine.alpha': {
	          url: 'some-url'
	        }
	      }
	    },
	    eventBus: mockEventBus
	  }).catch(e => {});
	  setTimeout(() => {
	    assert.equal(mockSession.listeners.length, 2, 'added listeners');
	    assert.equal(mockSession.listeners[0].type, 'message', 'added message listener'); // Simulate 'message' event

	    mockSession.listeners[0].listener(mockMessageEvent);
	    assert.equal(mockEventBus.calls[0].type, 'keysystemaccesscomplete', 'keysystemaccesscomplete fired');
	    assert.deepEqual(mockEventBus.calls[0].mediaKeys, {
	      createSession
	    }, 'keysystemaccesscomplete payload');
	    assert.equal(mockEventBus.calls[1].type, 'keysessioncreated', 'keymessage fired');
	    assert.equal(mockEventBus.calls[2].messageEvent, mockMessageEvent, 'keymessage event is expected message event');
	    assert.equal(xhrCalls.length, 1, 'made one XHR');
	    assert.deepEqual(xhrCalls[0], {
	      uri: 'some-url',
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem: 'com.widevine.alpha'
	      },
	      body: 'the-message',
	      headers: {
	        'Content-type': 'application/octet-stream'
	      }
	    }, 'made request with proper options');
	    videojs__default["default"].xhr = origXhr;
	    done();
	  });
	});
	QUnit__default["default"].test('5 July 2016 lifecycle', function (assert) {
	  assert.expect(34);
	  let errors = 0;
	  const done = assert.async();
	  const callbacks = {};
	  const callCounts = {
	    getCertificate: 0,
	    getLicense: 0,
	    createSession: 0,
	    keySessionGenerateRequest: 0,
	    keySessionUpdate: 0,
	    createMediaKeys: 0,
	    licenseRequestAttempts: 0,
	    keysessionUpdatedEvent: 0
	  };

	  const getCertificate = (emeOptions, callback) => {
	    callCounts.getCertificate++;
	    callbacks.getCertificate = callback;
	  };

	  const getLicense = (emeOptions, keyMessage, callback) => {
	    callCounts.getLicense++;
	    callbacks.getLicense = callback;
	  };

	  let setMediaKeys;
	  const video = {
	    setMediaKeys: mediaKeys => {
	      setMediaKeys = mediaKeys;
	      return Promise.resolve(mediaKeys);
	    }
	  };
	  const options = {
	    keySystems: {
	      'org.w3.clearkey': {
	        getCertificate,
	        getLicense
	      }
	    }
	  };
	  const eventBus = {
	    trigger: event => {
	      const name = typeof event === 'string' ? event : event.type;

	      if (name === 'licenserequestattempted') {
	        callCounts.licenseRequestAttempts++;
	      }

	      if (name === 'keysessionupdated') {
	        callCounts.keysessionUpdatedEvent++;
	      }
	    },
	    isDisposed: () => {
	      return false;
	    }
	  };
	  const keySessionEventListeners = {};
	  const mediaKeys = {
	    createSession: () => {
	      callCounts.createSession++;
	      return {
	        addEventListener: (name, callback) => {
	          keySessionEventListeners[name] = callback;
	        },
	        generateRequest: () => {
	          callCounts.keySessionGenerateRequest++;
	          return new Promise(() => {});
	        },
	        update: () => {
	          callCounts.keySessionUpdate++;
	          return Promise.resolve();
	        },
	        close: () => {}
	      };
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'org.w3.clearkey',
	    createMediaKeys: () => {
	      callCounts.createMediaKeys++;
	      return mediaKeys;
	    }
	  };
	  standard5July2016({
	    player: this.player,
	    video,
	    initDataType: '',
	    initData: '',
	    keySystemAccess,
	    options,
	    eventBus
	  }).then(() => done()).catch(() => errors++); // Step 1: get certificate

	  assert.equal(callCounts.getCertificate, 1, 'certificate requested');
	  assert.equal(callCounts.createMediaKeys, 0, 'media keys not created');
	  assert.notEqual(mediaKeys, setMediaKeys, 'media keys not yet set');
	  assert.equal(callCounts.createSession, 0, 'key session not created');
	  assert.equal(callCounts.keySessionGenerateRequest, 0, 'key session request not made');
	  assert.equal(callCounts.getLicense, 0, 'license not requested');
	  assert.equal(callCounts.keySessionUpdate, 0, 'key session not updated');
	  assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	  callbacks.getCertificate(null, ''); // getCertificate promise resolution

	  setTimeout(() => {
	    // Step 2: create media keys, set them, and generate key session request
	    assert.equal(callCounts.getCertificate, 1, 'certificate requested');
	    assert.equal(callCounts.createMediaKeys, 1, 'media keys created');
	    assert.equal(mediaKeys, setMediaKeys, 'media keys set');
	    assert.equal(callCounts.createSession, 1, 'key session created');
	    assert.equal(callCounts.keySessionGenerateRequest, 1, 'key session request made');
	    assert.equal(callCounts.getLicense, 0, 'license not requested');
	    assert.equal(callCounts.keySessionUpdate, 0, 'key session not updated');
	    assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	    keySessionEventListeners.message({
	      messageType: 'license-request'
	    }); // Step 3: get license

	    assert.equal(callCounts.getCertificate, 1, 'certificate requested');
	    assert.equal(callCounts.createMediaKeys, 1, 'media keys created');
	    assert.equal(mediaKeys, setMediaKeys, 'media keys set');
	    assert.equal(callCounts.createSession, 1, 'key session created');
	    assert.equal(callCounts.keySessionGenerateRequest, 1, 'key session request made');
	    assert.equal(callCounts.getLicense, 1, 'license requested');
	    assert.equal(callCounts.keySessionUpdate, 0, 'key session not updated');
	    assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	    callbacks.getLicense(); // getLicense promise resolution

	    setTimeout(() => {
	      // Step 4: update key session
	      assert.equal(callCounts.getCertificate, 1, 'certificate requested');
	      assert.equal(callCounts.createMediaKeys, 1, 'media keys created');
	      assert.equal(mediaKeys, setMediaKeys, 'media keys set');
	      assert.equal(callCounts.createSession, 1, 'key session created');
	      assert.equal(callCounts.keySessionGenerateRequest, 1, 'key session request made');
	      assert.equal(callCounts.getLicense, 1, 'license requested');
	      assert.equal(callCounts.keySessionUpdate, 1, 'key session updated');
	      assert.equal(callCounts.licenseRequestAttempts, 1, 'license request event triggered');
	      assert.equal(callCounts.keysessionUpdatedEvent, 1, 'keysessionupdated event fired once');
	      assert.equal(errors, 0, 'no errors occurred');
	    });
	  });
	}); // Skip this test in Safari, getSupportedKeySystem is never used in Safari.

	if (!videojs__default["default"].browser.IS_ANY_SAFARI) {
	  QUnit__default["default"].test('getSupportedKeySystem error', function (assert) {
	    const done = assert.async(1);
	    getSupportedKeySystem({
	      'un.supported.keysystem': {}
	    }).catch(err => {
	      assert.equal(err.name, 'NotSupportedError', 'keysystem access request fails');
	      done();
	    });
	  });
	}

	QUnit__default["default"].test('errors when missing url/licenseUri or getLicense', function (assert) {
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {}
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha'
	  };
	  const done = assert.async(1);
	  standard5July2016({
	    player: this.player,
	    video: {},
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus()
	  }).catch(err => {
	    assert.equal(err, 'Error: Missing url/licenseUri or getLicense in com.widevine.alpha keySystem configuration.', 'correct error message');
	    done();
	  });
	});
	QUnit__default["default"].test('errors when missing certificateUri and getCertificate for fairplay', function (assert) {
	  const options = {
	    keySystems: {
	      'com.apple.fps': {
	        url: 'fake-url'
	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.apple.fps'
	  };
	  const done = assert.async();
	  standard5July2016({
	    player: this.player,
	    video: {},
	    keySystemAccess,
	    options
	  }).catch(err => {
	    assert.equal(err, 'Error: Missing getCertificate or certificateUri in com.apple.fps keySystem configuration.', 'correct error message');
	    done();
	  });
	});
	QUnit__default["default"].test('rejects promise when getCertificate throws error', function (assert) {
	  const getCertificate = (options, callback) => {
	    callback('error fetching certificate');
	  };

	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',
	        getCertificate
	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha'
	  };
	  const done = assert.async(1);
	  const expectedError = 'error fetching certificate';

	  const emeError = (error, metadata) => {
	    assert.equal(error, expectedError, 'emeError called with expected message');
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'emeError called with expected type');
	    assert.equal(metadata.keySystem, 'com.widevine.alpha', 'emeError called with expected type');
	  };

	  standard5July2016({
	    player: this.player,
	    video: {},
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, expectedError, 'correct error message');
	    done();
	  });
	});
	QUnit__default["default"].test('rejects promise when createMediaKeys rejects', function (assert) {
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': 'some-url'
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.reject();
	    }
	  };
	  const done = assert.async(1);

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'emeError called with expected errorType');
	    assert.equal(metadata.keySystem, 'com.widevine.alpha', 'emeError called with expected keySystem');
	  };

	  standard5July2016({
	    player: this.player,
	    video: {},
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'Failed to create and initialize a MediaKeys object', 'uses generic message');
	    done();
	  });
	});
	QUnit__default["default"].test('rejects promise when createMediaKeys rejects', function (assert) {
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': 'some-url'
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.reject('failed creating mediaKeys');
	    }
	  };
	  const done = assert.async(1);
	  const expectedError = 'failed creating mediaKeys';

	  const emeError = (error, metadata) => {
	    assert.equal(error, expectedError, 'emeError called with expected error');
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'emeError called with expected errorType');
	    assert.equal(metadata.keySystem, 'com.widevine.alpha', 'emeError called with expected keySystem');
	  };

	  standard5July2016({
	    player: this.player,
	    video: {},
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, expectedError, 'uses specific error when given');
	    done();
	  });
	});
	QUnit__default["default"].test('rejects promise when addPendingSessions rejects', function (assert) {
	  let rejectSetServerCertificate = true;
	  const rejectGenerateRequest = true;
	  let rejectSetMediaKeys = true;
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',
	        getCertificate: (emeOptions, callback) => {
	          callback(null, 'some certificate');
	        }
	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.resolve({
	        setServerCertificate: () => resolveReject(rejectSetServerCertificate, 'setServerCertificate failed'),
	        createSession: () => {
	          return {
	            addEventListener: () => {},
	            generateRequest: () => resolveReject(rejectGenerateRequest, 'generateRequest failed'),
	            close: () => {}
	          };
	        }
	      });
	    }
	  };
	  const video = {
	    setMediaKeys: () => resolveReject(rejectSetMediaKeys, 'setMediaKeys failed')
	  };
	  const done = assert.async(3);
	  const callbacks = [];
	  const expectedErrors = [{
	    error: 'setServerCertificate failed',
	    errorType: videojs__default["default"].Error.EMEFailedToSetServerCertificate
	  }, {
	    error: 'setMediaKeys failed',
	    errorType: videojs__default["default"].Error.EMEFailedToAttachMediaKeysToVideoElement
	  }, {
	    error: 'generateRequest failed',
	    errorType: videojs__default["default"].Error.EMEFailedToGenerateLicenseRequest
	  }];

	  const test = (errMessage, testDescription) => {
	    let expectedErrorsLength = 0;
	    const emeErrors = [];
	    video.mediaKeysObject = undefined;
	    standard5July2016({
	      player: this.player,
	      video,
	      keySystemAccess,
	      options,
	      eventBus: getMockEventBus(),
	      emeError: (error, metadata) => {
	        expectedErrorsLength++;
	        emeErrors.push({
	          error,
	          errorType: metadata.errorType
	        });
	      }
	    }).catch(err => {
	      assert.equal(err, errMessage, testDescription);
	      assert.equal(emeErrors.length, expectedErrorsLength, 'emeError called expected number of times');

	      for (let i = 0; i < expectedErrors.length; i++) {
	        assert.equal(emeErrors[i].error, expectedErrors[i].error, 'expected eme error');
	        assert.equal(emeErrors[i].errorType, expectedErrors[i].errorType, 'expected eme errorType');
	      }

	      expectedErrors.shift();
	      done();

	      if (callbacks[0]) {
	        callbacks.shift()();
	      }
	    });
	  };

	  callbacks.push(() => {
	    rejectSetServerCertificate = false;
	    test('Unable to create or initialize key session', 'second promise fails');
	  });
	  callbacks.push(() => {
	    rejectSetMediaKeys = false;
	    test('Unable to create or initialize key session', 'third promise fails');
	  });
	  test('Unable to create or initialize key session', 'first promise fails');
	});
	QUnit__default["default"].test('getLicense not called for messageType that isnt license-request or license-renewal', function (assert) {
	  const done = assert.async();
	  let getLicenseCalls = 0;
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',

	        getLicense(emeOptions, keyMessage, callback) {
	          getLicenseCalls++;
	        }

	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.resolve({
	        setServerCertificate: () => Promise.resolve(),
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              if (event === 'message') {
	                setTimeout(() => {
	                  callback({
	                    message: 'whatever',
	                    messageType: 'do-not-request-license'
	                  });
	                  assert.equal(getLicenseCalls, 0, 'did not call getLicense');
	                  done();
	                });
	              }
	            },
	            keyStatuses: [],
	            generateRequest: () => Promise.resolve(),
	            close: () => {}
	          };
	        }
	      });
	    }
	  };
	  const video = {
	    setMediaKeys: () => Promise.resolve()
	  };
	  standard5July2016({
	    player: this.player,
	    video,
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus()
	  });
	});
	QUnit__default["default"].test('getLicense promise rejection', function (assert) {
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',

	        getLicense(emeOptions, keyMessage, callback) {
	          callback('error getting license');
	        }

	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.resolve({
	        setServerCertificate: () => Promise.resolve(),
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              setTimeout(() => {
	                callback({
	                  message: 'whatever',
	                  messageType: 'license-request'
	                });
	              });
	            },
	            keyStatuses: [],
	            generateRequest: () => Promise.resolve(),
	            close: () => {}
	          };
	        }
	      });
	    }
	  };
	  const video = {
	    setMediaKeys: () => Promise.resolve()
	  };
	  const done = assert.async(1);
	  standard5July2016({
	    player: this.player,
	    video,
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus()
	  }).catch(err => {
	    assert.equal(err, 'error getting license', 'correct error message');
	    done();
	  });
	});
	QUnit__default["default"].test('getLicense calls back with error for 400 and 500 status codes', function (assert) {
	  const getLicenseCallback = sinon__default["default"].spy();
	  const getLicense = defaultGetLicense('', {});

	  function toArrayBuffer(obj) {
	    const json = JSON.stringify(obj);
	    const buffer = new ArrayBuffer(json.length);
	    const bufferView = new Uint8Array(buffer);

	    for (let i = 0; i < json.length; i++) {
	      bufferView[i] = json.charCodeAt(i);
	    }

	    return buffer;
	  }

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 400
	    }, toArrayBuffer({
	      body: 'some-body'
	    }));
	  };

	  getLicense({}, null, getLicenseCallback);

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 500
	    }, toArrayBuffer({
	      body: 'some-body'
	    }));
	  };

	  getLicense({}, null, getLicenseCallback);

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 599
	    }, toArrayBuffer({
	      body: 'some-body'
	    }));
	  };

	  getLicense({}, null, getLicenseCallback);
	  assert.equal(getLicenseCallback.callCount, 3, 'correct callcount');
	  assert.ok(getLicenseCallback.alwaysCalledWith({
	    cause: JSON.stringify({
	      body: 'some-body'
	    })
	  }), 'getLicense callback called with correct error');
	});
	QUnit__default["default"].test('getLicense calls back with response body for non-400/500 status codes', function (assert) {
	  const getLicenseCallback = sinon__default["default"].spy();
	  const getLicense = defaultGetLicense('', {});

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 200
	    }, {
	      body: 'some-body'
	    });
	  };

	  getLicense({}, null, getLicenseCallback);

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 399
	    }, {
	      body: 'some-body'
	    });
	  };

	  getLicense({}, null, getLicenseCallback);

	  videojs__default["default"].xhr = (params, callback) => {
	    return callback(null, {
	      statusCode: 600
	    }, {
	      body: 'some-body'
	    });
	  };

	  getLicense({}, null, getLicenseCallback);
	  assert.equal(getLicenseCallback.callCount, 3, 'correct callcount');
	  assert.equal(getLicenseCallback.alwaysCalledWith(null, {
	    body: 'some-body'
	  }), true, 'getLicense callback called with correct args');
	});
	QUnit__default["default"].test('keySession.update promise rejection', function (assert) {
	  const options = {
	    keySystems: {
	      'com.widevine.alpha': {
	        url: 'some-url',

	        getLicense(emeOptions, keyMessage, callback) {
	          callback(null, 'license');
	        }

	      }
	    }
	  };
	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return Promise.resolve({
	        setServerCertificate: () => Promise.resolve(),
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              setTimeout(() => {
	                callback({
	                  messageType: 'license-request',
	                  message: 'whatever'
	                });
	              });
	            },
	            keyStatuses: [],
	            generateRequest: () => Promise.resolve(),
	            update: () => Promise.reject('keySession update failed'),
	            close: () => {}
	          };
	        }
	      });
	    }
	  };
	  const video = {
	    setMediaKeys: () => Promise.resolve()
	  };
	  const done = assert.async(1);

	  const emeError = (error, metadata) => {
	    assert.equal(error, 'keySession update failed', 'correct error message');
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToUpdateSessionWithReceivedLicenseKeys, 'errorType is correct');
	    assert.equal(metadata.keySystem, 'com.widevine.alpha', 'keySystem is correct');
	    done();
	  };

	  standard5July2016({
	    player: this.player,
	    video,
	    keySystemAccess,
	    options,
	    eventBus: getMockEventBus(),
	    emeError
	  });
	});
	QUnit__default["default"].test('emeHeaders option sets headers on default license xhr request', function (assert) {
	  const done = assert.async();
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  const mockSession = getMockSession();
	  const mockEventBus = getMockEventBus();
	  const mockMessageEvent = {
	    type: 'message',
	    message: 'the-message',
	    messageType: 'license-request'
	  };

	  const createSession = () => mockSession;

	  videojs__default["default"].xhr = options => {
	    xhrCalls.push(options);
	  };

	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return {
	        createSession
	      };
	    }
	  };
	  standard5July2016({
	    player: this.player,
	    keySystemAccess,
	    video: {
	      setMediaKeys: createdMediaKeys => Promise.resolve(createdMediaKeys)
	    },
	    initDataType: '',
	    initData: '',
	    options: {
	      keySystems: {
	        'com.widevine.alpha': 'some-url'
	      },
	      emeHeaders: {
	        'Some-Header': 'some-header-value'
	      }
	    },
	    eventBus: mockEventBus
	  }).catch(e => {});
	  setTimeout(() => {
	    // Simulate 'message' event
	    mockSession.listeners[0].listener(mockMessageEvent);
	    assert.equal(mockEventBus.calls[0].type, 'keysystemaccesscomplete', 'keysystemaccesscomplete fired');
	    assert.deepEqual(mockEventBus.calls[0].mediaKeys, {
	      createSession
	    }, 'keysystemaccesscomplete payload');
	    assert.equal(mockEventBus.calls[1].type, 'keysessioncreated', 'keymessage fired');
	    assert.equal(mockEventBus.calls[2].messageEvent, mockMessageEvent, 'keymessage event is expected message event');
	    assert.equal(xhrCalls.length, 1, 'made one XHR');
	    assert.deepEqual(xhrCalls[0], {
	      uri: 'some-url',
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem: 'com.widevine.alpha'
	      },
	      body: 'the-message',
	      headers: {
	        'Content-type': 'application/octet-stream',
	        'Some-Header': 'some-header-value'
	      }
	    }, 'made request with proper emeHeaders option value');
	    videojs__default["default"].xhr = origXhr;
	    done();
	  });
	});
	QUnit__default["default"].test('licenseHeaders keySystems property overrides emeHeaders value', function (assert) {
	  const done = assert.async();
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  const mockSession = getMockSession();
	  const mockEventBus = getMockEventBus();
	  const mockMessageEvent = {
	    type: 'message',
	    message: 'the-message',
	    messageType: 'license-request'
	  };

	  const createSession = () => mockSession;

	  videojs__default["default"].xhr = options => {
	    xhrCalls.push(options);
	  };

	  const keySystemAccess = {
	    keySystem: 'com.widevine.alpha',
	    createMediaKeys: () => {
	      return {
	        createSession
	      };
	    }
	  };
	  standard5July2016({
	    player: this.player,
	    keySystemAccess,
	    video: {
	      setMediaKeys: createdMediaKeys => Promise.resolve(createdMediaKeys)
	    },
	    initDataType: '',
	    initData: '',
	    options: {
	      keySystems: {
	        'com.widevine.alpha': {
	          url: 'some-url',
	          licenseHeaders: {
	            'Some-Header': 'priority-header-value'
	          }
	        }
	      },
	      emeHeaders: {
	        'Some-Header': 'lower-priority-header-value'
	      }
	    },
	    eventBus: mockEventBus
	  }).catch(e => {});
	  setTimeout(() => {
	    // Simulate 'message' event
	    mockSession.listeners[0].listener(mockMessageEvent);
	    assert.equal(mockEventBus.calls[0].type, 'keysystemaccesscomplete', 'keysystemaccesscomplete fired');
	    assert.deepEqual(mockEventBus.calls[0].mediaKeys, {
	      createSession
	    }, 'keysystemaccesscomplete payload');
	    assert.equal(mockEventBus.calls[1].type, 'keysessioncreated', 'keymessage fired');
	    assert.equal(mockEventBus.calls[1].keySession, mockSession, 'keymessage payload');
	    assert.equal(mockEventBus.calls[2].type, 'keymessage', 'keymessage event is expected message event');
	    assert.equal(mockEventBus.calls[2].messageEvent, mockMessageEvent, 'keymessage event is expected message event');
	    assert.equal(xhrCalls.length, 1, 'made one XHR');
	    assert.deepEqual(xhrCalls[0], {
	      uri: 'some-url',
	      method: 'POST',
	      responseType: 'arraybuffer',
	      requestType: 'license',
	      metadata: {
	        keySystem: 'com.widevine.alpha'
	      },
	      body: 'the-message',
	      headers: {
	        'Content-type': 'application/octet-stream',
	        'Some-Header': 'priority-header-value'
	      }
	    }, 'made request with proper licenseHeaders value');
	    videojs__default["default"].xhr = origXhr;
	    done();
	  });
	});
	QUnit__default["default"].test('sets required fairplay defaults if not explicitly configured', function (assert) {
	  const origRequestMediaKeySystemAccess = window_1.navigator.requestMediaKeySystemAccess;

	  window_1.navigator.requestMediaKeySystemAccess = (keySystem, systemOptions) => {
	    assert.ok(systemOptions[0].initDataTypes.indexOf('sinf') !== -1, 'includes required initDataType');
	    assert.ok(systemOptions[0].videoCapabilities[0].contentType.indexOf('video/mp4') !== -1, 'includes required video contentType');
	  };

	  getSupportedKeySystem({
	    'com.apple.fps': {}
	  });
	  window_1.requestMediaKeySystemAccess = origRequestMediaKeySystemAccess;
	});
	QUnit__default["default"].test('makeNewRequest triggers keysessioncreated', function (assert) {
	  const done = assert.async();
	  const mockSession = getMockSession();
	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    eventBus: {
	      trigger: event => {
	        if (event.type === 'keysessioncreated') {
	          assert.ok(true, 'got a keysessioncreated event');
	          done();
	        }
	      },
	      isDisposed: () => {
	        return false;
	      }
	    }
	  });
	});
	QUnit__default["default"].test.skip('keySession is closed when player is disposed', function (assert) {
	  const mockSession = getMockSession();
	  const done = assert.async();
	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    eventBus: {
	      trigger: event => {
	        if (event.type === 'keysessionclosed') {
	          assert.ok(true, 'got a keysessionclosed event');
	          done();
	        }
	      },
	      isDisposed: () => {
	        return false;
	      }
	    }
	  });
	  assert.equal(mockSession.numCloses, 0, 'no close() calls initially');
	  this.player.dispose();
	  assert.equal(mockSession.numCloses, 1, 'close() called once after dipose');
	});
	QUnit__default["default"].test('emeError is called when keySession.close fails', function (assert) {
	  const mockSession = getMockSession();
	  const done = assert.async();
	  const expectedErrorMessage = 'Failed to close session';

	  mockSession.close = () => {
	    return Promise.reject(expectedErrorMessage);
	  };

	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    eventBus: {
	      trigger: () => {},
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError: (error, metadata) => {
	      assert.equal(error, expectedErrorMessage, 'expected eme error message');
	      assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCloseSession, 'expected eme error type');
	      done();
	    }
	  });
	  this.player.dispose();
	});
	QUnit__default["default"].test('emeError called when session.generateRequest fails', function (assert) {
	  const mockSession = getMockSession();
	  const done = assert.async();
	  const expectedErrorMessage = 'generate request failed';

	  mockSession.generateRequest = () => {
	    return Promise.reject(expectedErrorMessage);
	  };

	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => mockSession
	    },
	    eventBus: {
	      trigger: () => {},
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError: (error, metadata) => {
	      assert.equal(error, expectedErrorMessage, 'expected eme error message');
	      assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToGenerateLicenseRequest, 'expected eme error type');
	    }
	  }).catch(error => {
	    assert.equal(error, 'Unable to create or initialize key session', 'expected message');
	    done();
	  });
	});
	QUnit__default["default"].test('emeError called when mediaKeys.createSession fails', function (assert) {
	  const done = assert.async();
	  const expectedError = new Error('session could not be created');
	  makeNewRequest(this.player, {
	    mediaKeys: {
	      createSession: () => {
	        throw expectedError;
	      }
	    },
	    eventBus: {
	      trigger: () => {}
	    },
	    emeError: (error, metadata) => {
	      assert.equal(error, expectedError, 'expected eme error message');
	      assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeySession, 'expected eme error type');
	      done();
	    }
	  });
	});
	QUnit__default["default"].module('session management', {
	  beforeEach() {
	    this.fixture = document_1.getElementById('qunit-fixture');
	    this.video = document_1.createElement('video');
	    this.fixture.appendChild(this.video);
	    this.player = videojs__default["default"](this.video);
	  }

	});
	QUnit__default["default"].test('addSession saves options', function (assert) {
	  const video = {
	    pendingSessionData: []
	  };
	  const initDataType = 'temporary';
	  const initData = new Uint8Array();
	  const options = {
	    some: 'option'
	  };

	  const getLicense = () => '';

	  const removeSession = () => '';

	  const eventBus = {
	    trigger: () => {}
	  };
	  const contentId = null;

	  const emeError = () => {};

	  addSession({
	    video,
	    contentId,
	    initDataType,
	    initData,
	    options,
	    getLicense,
	    removeSession,
	    eventBus,
	    emeError
	  });
	  assert.deepEqual(video.pendingSessionData, [{
	    initDataType,
	    initData,
	    options,
	    getLicense,
	    removeSession,
	    eventBus,
	    contentId,
	    emeError,
	    keySystem: undefined
	  }], 'saved options into pendingSessionData array');
	});
	QUnit__default["default"].test('addPendingSessions reuses saved options', function (assert) {
	  assert.expect(5);
	  const done = assert.async();
	  const options = {
	    some: 'option'
	  };

	  const getLicense = (emeOptions, message) => {
	    assert.deepEqual(emeOptions, options, 'used pending session data options');
	    return Promise.resolve('license');
	  };

	  const eventListeners = [];
	  const pendingSessionData = [{
	    initDataType: 'temporary',
	    initData: new Uint8Array(),
	    options,
	    getLicense,
	    removeSession: () => '',
	    eventBus: {
	      trigger: () => {},
	      isDisposed: () => {
	        return false;
	      }
	    }
	  }];
	  const video = {
	    pendingSessionData,
	    // internal API, not used in this test
	    setMediaKeys: () => Promise.resolve()
	  };
	  const createdMediaKeys = {
	    createSession: () => {
	      return {
	        addEventListener: (event, callback) => eventListeners.push({
	          event,
	          callback
	        }),
	        generateRequest: (initDataType, initData) => {
	          assert.equal(initDataType, pendingSessionData[0].initDataType, 'generateRequest received correct initDataType');
	          assert.equal(initData, pendingSessionData[0].initData, 'generateRequest received correct initData');
	          assert.equal(eventListeners.length, 2, 'added two event listeners');
	          assert.equal(eventListeners[0].event, 'message', 'added listener for message event'); // callback should call getLicense, which continues this test

	          eventListeners[0].callback({
	            messageType: 'license-request',
	            message: 'test message'
	          });
	          return Promise.resolve();
	        },
	        // this call and everything after is beyond the scope of this test
	        update: () => Promise.resolve(),
	        close: () => {}
	      };
	    }
	  };
	  return addPendingSessions({
	    player: this.player,
	    video,
	    createdMediaKeys
	  }).then((resolve, reject) => {
	    done();
	  });
	});
	QUnit__default["default"].module('videojs-contrib-eme getSupportedConfigurations', {
	  beforeEach() {
	    this.fixture = document_1.getElementById('qunit-fixture');
	    this.video = document_1.createElement('video');
	    this.fixture.appendChild(this.video);
	    this.player = videojs__default["default"](this.video);
	  }

	});
	QUnit__default["default"].test('includes audio and video content types', function (assert) {
	  assert.deepEqual(getSupportedConfigurations('com.widevine.alpha', {
	    audioContentType: 'audio/mp4; codecs="mp4a.40.2"',
	    videoContentType: 'video/mp4; codecs="avc1.42E01E"'
	  }), [{
	    audioCapabilities: [{
	      contentType: 'audio/mp4; codecs="mp4a.40.2"'
	    }],
	    videoCapabilities: [{
	      contentType: 'video/mp4; codecs="avc1.42E01E"'
	    }]
	  }], 'included audio and video content types');
	});
	QUnit__default["default"].test('includes audio and video robustness', function (assert) {
	  assert.deepEqual(getSupportedConfigurations('com.widevine.alpha', {
	    audioRobustness: 'SW_SECURE_CRYPTO',
	    videoRobustness: 'SW_SECURE_CRYPTO'
	  }), [{
	    audioCapabilities: [{
	      robustness: 'SW_SECURE_CRYPTO'
	    }],
	    videoCapabilities: [{
	      robustness: 'SW_SECURE_CRYPTO'
	    }]
	  }], 'included audio and video robustness');
	});
	QUnit__default["default"].test('includes audio and video content types and robustness', function (assert) {
	  assert.deepEqual(getSupportedConfigurations('com.widevine.alpha', {
	    audioContentType: 'audio/mp4; codecs="mp4a.40.2"',
	    audioRobustness: 'SW_SECURE_CRYPTO',
	    videoContentType: 'video/mp4; codecs="avc1.42E01E"',
	    videoRobustness: 'SW_SECURE_CRYPTO'
	  }), [{
	    audioCapabilities: [{
	      contentType: 'audio/mp4; codecs="mp4a.40.2"',
	      robustness: 'SW_SECURE_CRYPTO'
	    }],
	    videoCapabilities: [{
	      contentType: 'video/mp4; codecs="avc1.42E01E"',
	      robustness: 'SW_SECURE_CRYPTO'
	    }]
	  }], 'included audio and video content types and robustness');
	});
	QUnit__default["default"].test('includes persistentState', function (assert) {
	  assert.deepEqual(getSupportedConfigurations('com.widevine.alpha', {
	    persistentState: 'optional'
	  }), [{
	    persistentState: 'optional'
	  }], 'included persistentState');
	});
	QUnit__default["default"].test('uses supportedConfigurations directly if provided', function (assert) {
	  assert.deepEqual(getSupportedConfigurations('com.widevine.alpha', {
	    supportedConfigurations: [{
	      initDataTypes: ['cenc'],
	      audioCapabilities: [{
	        contentType: 'audio/mp4; codecs="mp4a.40.2"',
	        robustness: 'SW_SECURE_CRYPTO',
	        extraOption: 'audio-extra'
	      }],
	      videoCapabilities: [{
	        contentType: 'video/mp4; codecs="avc1.42E01E"',
	        robustness: 'SW_SECURE_CRYPTO',
	        extraOption: 'video-extra'
	      }]
	    }],
	    // should not be used
	    audioContentType: 'audio/mp4; codecs="mp4a.40.5"',
	    audioRobustness: 'HW_SECURE_CRYPTO',
	    videoContentType: 'video/mp4; codecs="avc1.42001e"',
	    videoRobustness: 'HW_SECURE_CRYPTO'
	  }), [{
	    initDataTypes: ['cenc'],
	    audioCapabilities: [{
	      contentType: 'audio/mp4; codecs="mp4a.40.2"',
	      robustness: 'SW_SECURE_CRYPTO',
	      extraOption: 'audio-extra'
	    }],
	    videoCapabilities: [{
	      contentType: 'video/mp4; codecs="avc1.42E01E"',
	      robustness: 'SW_SECURE_CRYPTO',
	      extraOption: 'video-extra'
	    }]
	  }], 'used supportedConfigurations directly');
	});

	function cov_tnex2gw6q() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/ms-prefixed.js";
	  var hash = "d96fb3986b79d726fdeabb86e684f7420296325e";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/ms-prefixed.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 15,
	          column: 36
	        },
	        end: {
	          line: 15,
	          column: 61
	        }
	      },
	      "1": {
	        start: {
	          line: 17,
	          column: 31
	        },
	        end: {
	          line: 85,
	          column: 1
	        }
	      },
	      "2": {
	        start: {
	          line: 18,
	          column: 25
	        },
	        end: {
	          line: 18,
	          column: 65
	        }
	      },
	      "3": {
	        start: {
	          line: 20,
	          column: 2
	        },
	        end: {
	          line: 45,
	          column: 3
	        }
	      },
	      "4": {
	        start: {
	          line: 21,
	          column: 4
	        },
	        end: {
	          line: 43,
	          column: 7
	        }
	      },
	      "5": {
	        start: {
	          line: 22,
	          column: 6
	        },
	        end: {
	          line: 35,
	          column: 7
	        }
	      },
	      "6": {
	        start: {
	          line: 23,
	          column: 25
	        },
	        end: {
	          line: 26,
	          column: 9
	        }
	      },
	      "7": {
	        start: {
	          line: 28,
	          column: 8
	        },
	        end: {
	          line: 28,
	          column: 32
	        }
	      },
	      "8": {
	        start: {
	          line: 29,
	          column: 8
	        },
	        end: {
	          line: 33,
	          column: 11
	        }
	      },
	      "9": {
	        start: {
	          line: 34,
	          column: 8
	        },
	        end: {
	          line: 34,
	          column: 15
	        }
	      },
	      "10": {
	        start: {
	          line: 37,
	          column: 6
	        },
	        end: {
	          line: 37,
	          column: 26
	        }
	      },
	      "11": {
	        start: {
	          line: 39,
	          column: 6
	        },
	        end: {
	          line: 42,
	          column: 9
	        }
	      },
	      "12": {
	        start: {
	          line: 44,
	          column: 4
	        },
	        end: {
	          line: 44,
	          column: 11
	        }
	      },
	      "13": {
	        start: {
	          line: 47,
	          column: 2
	        },
	        end: {
	          line: 51,
	          column: 3
	        }
	      },
	      "14": {
	        start: {
	          line: 48,
	          column: 4
	        },
	        end: {
	          line: 48,
	          column: 47
	        }
	      },
	      "15": {
	        start: {
	          line: 49,
	          column: 9
	        },
	        end: {
	          line: 51,
	          column: 3
	        }
	      },
	      "16": {
	        start: {
	          line: 50,
	          column: 4
	        },
	        end: {
	          line: 50,
	          column: 26
	        }
	      },
	      "17": {
	        start: {
	          line: 53,
	          column: 2
	        },
	        end: {
	          line: 55,
	          column: 3
	        }
	      },
	      "18": {
	        start: {
	          line: 54,
	          column: 4
	        },
	        end: {
	          line: 54,
	          column: 48
	        }
	      },
	      "19": {
	        start: {
	          line: 57,
	          column: 19
	        },
	        end: {
	          line: 78,
	          column: 3
	        }
	      },
	      "20": {
	        start: {
	          line: 58,
	          column: 4
	        },
	        end: {
	          line: 60,
	          column: 5
	        }
	      },
	      "21": {
	        start: {
	          line: 59,
	          column: 6
	        },
	        end: {
	          line: 59,
	          column: 75
	        }
	      },
	      "22": {
	        start: {
	          line: 62,
	          column: 4
	        },
	        end: {
	          line: 75,
	          column: 5
	        }
	      },
	      "23": {
	        start: {
	          line: 63,
	          column: 23
	        },
	        end: {
	          line: 66,
	          column: 7
	        }
	      },
	      "24": {
	        start: {
	          line: 68,
	          column: 6
	        },
	        end: {
	          line: 68,
	          column: 30
	        }
	      },
	      "25": {
	        start: {
	          line: 69,
	          column: 6
	        },
	        end: {
	          line: 73,
	          column: 9
	        }
	      },
	      "26": {
	        start: {
	          line: 74,
	          column: 6
	        },
	        end: {
	          line: 74,
	          column: 13
	        }
	      },
	      "27": {
	        start: {
	          line: 77,
	          column: 4
	        },
	        end: {
	          line: 77,
	          column: 49
	        }
	      },
	      "28": {
	        start: {
	          line: 80,
	          column: 2
	        },
	        end: {
	          line: 84,
	          column: 3
	        }
	      },
	      "29": {
	        start: {
	          line: 81,
	          column: 4
	        },
	        end: {
	          line: 81,
	          column: 73
	        }
	      },
	      "30": {
	        start: {
	          line: 83,
	          column: 4
	        },
	        end: {
	          line: 83,
	          column: 109
	        }
	      },
	      "31": {
	        start: {
	          line: 87,
	          column: 29
	        },
	        end: {
	          line: 145,
	          column: 1
	        }
	      },
	      "32": {
	        start: {
	          line: 89,
	          column: 18
	        },
	        end: {
	          line: 89,
	          column: 67
	        }
	      },
	      "33": {
	        start: {
	          line: 91,
	          column: 2
	        },
	        end: {
	          line: 100,
	          column: 3
	        }
	      },
	      "34": {
	        start: {
	          line: 92,
	          column: 18
	        },
	        end: {
	          line: 92,
	          column: 60
	        }
	      },
	      "35": {
	        start: {
	          line: 93,
	          column: 21
	        },
	        end: {
	          line: 96,
	          column: 5
	        }
	      },
	      "36": {
	        start: {
	          line: 98,
	          column: 4
	        },
	        end: {
	          line: 98,
	          column: 30
	        }
	      },
	      "37": {
	        start: {
	          line: 99,
	          column: 4
	        },
	        end: {
	          line: 99,
	          column: 16
	        }
	      },
	      "38": {
	        start: {
	          line: 102,
	          column: 2
	        },
	        end: {
	          line: 105,
	          column: 5
	        }
	      },
	      "39": {
	        start: {
	          line: 116,
	          column: 2
	        },
	        end: {
	          line: 122,
	          column: 5
	        }
	      },
	      "40": {
	        start: {
	          line: 117,
	          column: 4
	        },
	        end: {
	          line: 120,
	          column: 7
	        }
	      },
	      "41": {
	        start: {
	          line: 121,
	          column: 4
	        },
	        end: {
	          line: 121,
	          column: 65
	        }
	      },
	      "42": {
	        start: {
	          line: 124,
	          column: 2
	        },
	        end: {
	          line: 137,
	          column: 5
	        }
	      },
	      "43": {
	        start: {
	          line: 125,
	          column: 21
	        },
	        end: {
	          line: 128,
	          column: 5
	        }
	      },
	      "44": {
	        start: {
	          line: 130,
	          column: 4
	        },
	        end: {
	          line: 130,
	          column: 38
	        }
	      },
	      "45": {
	        start: {
	          line: 131,
	          column: 4
	        },
	        end: {
	          line: 136,
	          column: 7
	        }
	      },
	      "46": {
	        start: {
	          line: 139,
	          column: 2
	        },
	        end: {
	          line: 144,
	          column: 5
	        }
	      },
	      "47": {
	        start: {
	          line: 140,
	          column: 4
	        },
	        end: {
	          line: 143,
	          column: 7
	        }
	      },
	      "48": {
	        start: {
	          line: 153,
	          column: 2
	        },
	        end: {
	          line: 155,
	          column: 3
	        }
	      },
	      "49": {
	        start: {
	          line: 154,
	          column: 4
	        },
	        end: {
	          line: 154,
	          column: 24
	        }
	      },
	      "50": {
	        start: {
	          line: 157,
	          column: 2
	        },
	        end: {
	          line: 168,
	          column: 3
	        }
	      },
	      "51": {
	        start: {
	          line: 158,
	          column: 4
	        },
	        end: {
	          line: 158,
	          column: 71
	        }
	      },
	      "52": {
	        start: {
	          line: 160,
	          column: 21
	        },
	        end: {
	          line: 163,
	          column: 5
	        }
	      },
	      "53": {
	        start: {
	          line: 165,
	          column: 4
	        },
	        end: {
	          line: 165,
	          column: 26
	        }
	      },
	      "54": {
	        start: {
	          line: 166,
	          column: 4
	        },
	        end: {
	          line: 167,
	          column: 29
	        }
	      },
	      "55": {
	        start: {
	          line: 170,
	          column: 2
	        },
	        end: {
	          line: 170,
	          column: 62
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 17,
	            column: 31
	          },
	          end: {
	            line: 17,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 17,
	            column: 80
	          },
	          end: {
	            line: 85,
	            column: 1
	          }
	        },
	        line: 17
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 21,
	            column: 81
	          },
	          end: {
	            line: 21,
	            column: 82
	          }
	        },
	        loc: {
	          start: {
	            line: 21,
	            column: 95
	          },
	          end: {
	            line: 43,
	            column: 5
	          }
	        },
	        line: 21
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 57,
	            column: 19
	          },
	          end: {
	            line: 57,
	            column: 20
	          }
	        },
	        loc: {
	          start: {
	            line: 57,
	            column: 42
	          },
	          end: {
	            line: 78,
	            column: 3
	          }
	        },
	        line: 57
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 87,
	            column: 29
	          },
	          end: {
	            line: 87,
	            column: 30
	          }
	        },
	        loc: {
	          start: {
	            line: 87,
	            column: 79
	          },
	          end: {
	            line: 145,
	            column: 1
	          }
	        },
	        line: 87
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 116,
	            column: 43
	          },
	          end: {
	            line: 116,
	            column: 44
	          }
	        },
	        loc: {
	          start: {
	            line: 116,
	            column: 54
	          },
	          end: {
	            line: 122,
	            column: 3
	          }
	        },
	        line: 116
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 124,
	            column: 41
	          },
	          end: {
	            line: 124,
	            column: 42
	          }
	        },
	        loc: {
	          start: {
	            line: 124,
	            column: 52
	          },
	          end: {
	            line: 137,
	            column: 3
	          }
	        },
	        line: 124
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 139,
	            column: 41
	          },
	          end: {
	            line: 139,
	            column: 42
	          }
	        },
	        loc: {
	          start: {
	            line: 139,
	            column: 47
	          },
	          end: {
	            line: 144,
	            column: 3
	          }
	        },
	        line: 139
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 147,
	            column: 15
	          },
	          end: {
	            line: 147,
	            column: 16
	          }
	        },
	        loc: {
	          start: {
	            line: 147,
	            column: 67
	          },
	          end: {
	            line: 171,
	            column: 1
	          }
	        },
	        line: 147
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 20,
	            column: 2
	          },
	          end: {
	            line: 45,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 20,
	            column: 2
	          },
	          end: {
	            line: 45,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 20,
	            column: 2
	          },
	          end: {
	            line: 45,
	            column: 3
	          }
	        }],
	        line: 20
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 22,
	            column: 6
	          },
	          end: {
	            line: 35,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 22,
	            column: 6
	          },
	          end: {
	            line: 35,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 22,
	            column: 6
	          },
	          end: {
	            line: 35,
	            column: 7
	          }
	        }],
	        line: 22
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 47,
	            column: 2
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 47,
	            column: 2
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 47,
	            column: 2
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        }],
	        line: 47
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 49,
	            column: 9
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 49,
	            column: 9
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 49,
	            column: 9
	          },
	          end: {
	            line: 51,
	            column: 3
	          }
	        }],
	        line: 49
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 53,
	            column: 2
	          },
	          end: {
	            line: 55,
	            column: 3
	          }
	        }],
	        line: 53
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 58,
	            column: 4
	          },
	          end: {
	            line: 60,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 58,
	            column: 4
	          },
	          end: {
	            line: 60,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 58,
	            column: 4
	          },
	          end: {
	            line: 60,
	            column: 5
	          }
	        }],
	        line: 58
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 62,
	            column: 4
	          },
	          end: {
	            line: 75,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 62,
	            column: 4
	          },
	          end: {
	            line: 75,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 62,
	            column: 4
	          },
	          end: {
	            line: 75,
	            column: 5
	          }
	        }],
	        line: 62
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 80,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 80,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 80,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        }],
	        line: 80
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 91,
	            column: 2
	          },
	          end: {
	            line: 100,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 91,
	            column: 2
	          },
	          end: {
	            line: 100,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 91,
	            column: 2
	          },
	          end: {
	            line: 100,
	            column: 3
	          }
	        }],
	        line: 91
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 153,
	            column: 2
	          },
	          end: {
	            line: 155,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 153,
	            column: 2
	          },
	          end: {
	            line: 155,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 153,
	            column: 2
	          },
	          end: {
	            line: 155,
	            column: 3
	          }
	        }],
	        line: 153
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "d96fb3986b79d726fdeabb86e684f7420296325e"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_tnex2gw6q = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_tnex2gw6q();
	const PLAYREADY_KEY_SYSTEM = (cov_tnex2gw6q().s[0]++, 'com.microsoft.playready');
	cov_tnex2gw6q().s[1]++;
	const addKeyToSession = (options, session, event, eventBus, emeError) => {
	  cov_tnex2gw6q().f[0]++;
	  let playreadyOptions = (cov_tnex2gw6q().s[2]++, options.keySystems[PLAYREADY_KEY_SYSTEM]);
	  cov_tnex2gw6q().s[3]++;

	  if (typeof playreadyOptions.getKey === 'function') {
	    cov_tnex2gw6q().b[0][0]++;
	    cov_tnex2gw6q().s[4]++;
	    playreadyOptions.getKey(options, event.destinationURL, event.message.buffer, (err, key) => {
	      cov_tnex2gw6q().f[1]++;
	      cov_tnex2gw6q().s[5]++;

	      if (err) {
	        cov_tnex2gw6q().b[1][0]++;
	        const metadata = (cov_tnex2gw6q().s[6]++, {
	          errorType: Error$1.EMEFailedToRequestMediaKeySystemAccess,
	          config: getMediaKeySystemConfigurations(options.keySystems)
	        });
	        cov_tnex2gw6q().s[7]++;
	        emeError(err, metadata);
	        cov_tnex2gw6q().s[8]++;
	        safeTriggerOnEventBus(eventBus, {
	          message: 'Unable to get key: ' + err,
	          target: session,
	          type: 'mskeyerror'
	        });
	        cov_tnex2gw6q().s[9]++;
	        return;
	      } else {
	        cov_tnex2gw6q().b[1][1]++;
	      }

	      cov_tnex2gw6q().s[10]++;
	      session.update(key);
	      cov_tnex2gw6q().s[11]++;
	      safeTriggerOnEventBus(eventBus, {
	        type: 'keysessionupdated',
	        keySession: session
	      });
	    });
	    cov_tnex2gw6q().s[12]++;
	    return;
	  } else {
	    cov_tnex2gw6q().b[0][1]++;
	  }

	  cov_tnex2gw6q().s[13]++;

	  if (typeof playreadyOptions === 'string') {
	    cov_tnex2gw6q().b[2][0]++;
	    cov_tnex2gw6q().s[14]++;
	    playreadyOptions = {
	      url: playreadyOptions
	    };
	  } else {
	    cov_tnex2gw6q().b[2][1]++;
	    cov_tnex2gw6q().s[15]++;

	    if (typeof playreadyOptions === 'boolean') {
	      cov_tnex2gw6q().b[3][0]++;
	      cov_tnex2gw6q().s[16]++;
	      playreadyOptions = {};
	    } else {
	      cov_tnex2gw6q().b[3][1]++;
	    }
	  }

	  cov_tnex2gw6q().s[17]++;

	  if (!playreadyOptions.url) {
	    cov_tnex2gw6q().b[4][0]++;
	    cov_tnex2gw6q().s[18]++;
	    playreadyOptions.url = event.destinationURL;
	  } else {
	    cov_tnex2gw6q().b[4][1]++;
	  }

	  cov_tnex2gw6q().s[19]++;

	  const callback = (err, responseBody) => {
	    cov_tnex2gw6q().f[2]++;
	    cov_tnex2gw6q().s[20]++;

	    if (eventBus) {
	      cov_tnex2gw6q().b[5][0]++;
	      cov_tnex2gw6q().s[21]++;
	      safeTriggerOnEventBus(eventBus, {
	        type: 'licenserequestattempted'
	      });
	    } else {
	      cov_tnex2gw6q().b[5][1]++;
	    }

	    cov_tnex2gw6q().s[22]++;

	    if (err) {
	      cov_tnex2gw6q().b[6][0]++;
	      const metadata = (cov_tnex2gw6q().s[23]++, {
	        errorType: Error$1.EMEFailedToGenerateLicenseRequest,
	        keySystem: PLAYREADY_KEY_SYSTEM
	      });
	      cov_tnex2gw6q().s[24]++;
	      emeError(err, metadata);
	      cov_tnex2gw6q().s[25]++;
	      safeTriggerOnEventBus(eventBus, {
	        message: 'Unable to request key from url: ' + playreadyOptions.url,
	        target: session,
	        type: 'mskeyerror'
	      });
	      cov_tnex2gw6q().s[26]++;
	      return;
	    } else {
	      cov_tnex2gw6q().b[6][1]++;
	    }

	    cov_tnex2gw6q().s[27]++;
	    session.update(new Uint8Array(responseBody));
	  };

	  cov_tnex2gw6q().s[28]++;

	  if (playreadyOptions.getLicense) {
	    cov_tnex2gw6q().b[7][0]++;
	    cov_tnex2gw6q().s[29]++;
	    playreadyOptions.getLicense(options, event.message.buffer, callback);
	  } else {
	    cov_tnex2gw6q().b[7][1]++;
	    cov_tnex2gw6q().s[30]++;
	    requestPlayreadyLicense(PLAYREADY_KEY_SYSTEM, playreadyOptions, event.message.buffer, options, callback);
	  }
	};
	cov_tnex2gw6q().s[31]++;
	const createSession = (video, initData, options, eventBus, emeError) => {
	  cov_tnex2gw6q().f[3]++; // Note: invalid mime type passed here throws a NotSupportedError

	  const session = (cov_tnex2gw6q().s[32]++, video.msKeys.createSession('video/mp4', initData));
	  cov_tnex2gw6q().s[33]++;

	  if (!session) {
	    cov_tnex2gw6q().b[8][0]++;
	    const error = (cov_tnex2gw6q().s[34]++, new Error('Could not create key session.'));
	    const metadata = (cov_tnex2gw6q().s[35]++, {
	      errorType: Error$1.EMEFailedToCreateMediaKeySession,
	      keySystem: PLAYREADY_KEY_SYSTEM
	    });
	    cov_tnex2gw6q().s[36]++;
	    emeError(error, metadata);
	    cov_tnex2gw6q().s[37]++;
	    throw error;
	  } else {
	    cov_tnex2gw6q().b[8][1]++;
	  }

	  cov_tnex2gw6q().s[38]++;
	  safeTriggerOnEventBus(eventBus, {
	    type: 'keysessioncreated',
	    keySession: session
	  }); // Note that mskeymessage may not always be called for PlayReady:
	  //
	  // "If initData contains a PlayReady object that contains an OnDemand header, only a
	  // keyAdded event is returned (as opposed to a keyMessage event as described in the
	  // Encrypted Media Extension draft). Similarly, if initData contains a PlayReady object
	  // that contains a key identifier in the hashed data storage (HDS), only a keyAdded
	  // event is returned."
	  // eslint-disable-next-line max-len
	  // @see [PlayReady License Acquisition]{@link https://msdn.microsoft.com/en-us/library/dn468979.aspx}

	  cov_tnex2gw6q().s[39]++;
	  session.addEventListener('mskeymessage', event => {
	    cov_tnex2gw6q().f[4]++;
	    cov_tnex2gw6q().s[40]++;
	    safeTriggerOnEventBus(eventBus, {
	      type: 'keymessage',
	      messageEvent: event
	    });
	    cov_tnex2gw6q().s[41]++;
	    addKeyToSession(options, session, event, eventBus, emeError);
	  });
	  cov_tnex2gw6q().s[42]++;
	  session.addEventListener('mskeyerror', event => {
	    cov_tnex2gw6q().f[5]++;
	    const metadata = (cov_tnex2gw6q().s[43]++, {
	      errorType: Error$1.EMEFailedToCreateMediaKeySession,
	      keySystem: PLAYREADY_KEY_SYSTEM
	    });
	    cov_tnex2gw6q().s[44]++;
	    emeError(session.error, metadata);
	    cov_tnex2gw6q().s[45]++;
	    safeTriggerOnEventBus(eventBus, {
	      message: 'Unexpected key error from key session with ' + `code: ${session.error.code} and systemCode: ${session.error.systemCode}`,
	      target: session,
	      type: 'mskeyerror'
	    });
	  });
	  cov_tnex2gw6q().s[46]++;
	  session.addEventListener('mskeyadded', () => {
	    cov_tnex2gw6q().f[6]++;
	    cov_tnex2gw6q().s[47]++;
	    safeTriggerOnEventBus(eventBus, {
	      target: session,
	      type: 'mskeyadded'
	    });
	  });
	};
	var msPrefixed = (({
	  video,
	  initData,
	  options,
	  eventBus,
	  emeError
	}) => {
	  cov_tnex2gw6q().f[7]++;
	  cov_tnex2gw6q().s[48]++; // Although by the standard examples the presence of video.msKeys is checked first to
	  // verify that we aren't trying to create a new session when one already exists, here
	  // sessions are managed earlier (on the player.eme object), meaning that at this point
	  // any existing keys should be cleaned up.
	  // TODO: Will this break rotation? Is it safe?

	  if (video.msKeys) {
	    cov_tnex2gw6q().b[9][0]++;
	    cov_tnex2gw6q().s[49]++;
	    delete video.msKeys;
	  } else {
	    cov_tnex2gw6q().b[9][1]++;
	  }

	  cov_tnex2gw6q().s[50]++;

	  try {
	    cov_tnex2gw6q().s[51]++;
	    video.msSetMediaKeys(new window_1.MSMediaKeys(PLAYREADY_KEY_SYSTEM));
	  } catch (e) {
	    const metadata = (cov_tnex2gw6q().s[52]++, {
	      errorType: Error$1.EMEFailedToCreateMediaKeys,
	      keySystem: PLAYREADY_KEY_SYSTEM
	    });
	    cov_tnex2gw6q().s[53]++;
	    emeError(e, metadata);
	    cov_tnex2gw6q().s[54]++;
	    throw new Error('Unable to create media keys for PlayReady key system. ' + 'Error: ' + e.message);
	  }

	  cov_tnex2gw6q().s[55]++;
	  createSession(video, initData, options, eventBus, emeError);
	});

	var version = "5.5.1";

	function cov_jwgp8nce4() {
	  var path = "/Users/harishaswaminathan/videojs-contrib-eme/src/plugin.js";
	  var hash = "1abe61db4977c92c0f4037befb3221f94bfbd759";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/harishaswaminathan/videojs-contrib-eme/src/plugin.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 17,
	          column: 26
	        },
	        end: {
	          line: 43,
	          column: 1
	        }
	      },
	      "1": {
	        start: {
	          line: 18,
	          column: 2
	        },
	        end: {
	          line: 40,
	          column: 3
	        }
	      },
	      "2": {
	        start: {
	          line: 18,
	          column: 15
	        },
	        end: {
	          line: 18,
	          column: 16
	        }
	      },
	      "3": {
	        start: {
	          line: 21,
	          column: 4
	        },
	        end: {
	          line: 23,
	          column: 5
	        }
	      },
	      "4": {
	        start: {
	          line: 22,
	          column: 6
	        },
	        end: {
	          line: 22,
	          column: 15
	        }
	      },
	      "5": {
	        start: {
	          line: 34,
	          column: 26
	        },
	        end: {
	          line: 34,
	          column: 63
	        }
	      },
	      "6": {
	        start: {
	          line: 35,
	          column: 27
	        },
	        end: {
	          line: 35,
	          column: 52
	        }
	      },
	      "7": {
	        start: {
	          line: 37,
	          column: 4
	        },
	        end: {
	          line: 39,
	          column: 5
	        }
	      },
	      "8": {
	        start: {
	          line: 38,
	          column: 6
	        },
	        end: {
	          line: 38,
	          column: 18
	        }
	      },
	      "9": {
	        start: {
	          line: 42,
	          column: 2
	        },
	        end: {
	          line: 42,
	          column: 15
	        }
	      },
	      "10": {
	        start: {
	          line: 45,
	          column: 29
	        },
	        end: {
	          line: 52,
	          column: 1
	        }
	      },
	      "11": {
	        start: {
	          line: 46,
	          column: 2
	        },
	        end: {
	          line: 51,
	          column: 3
	        }
	      },
	      "12": {
	        start: {
	          line: 46,
	          column: 15
	        },
	        end: {
	          line: 46,
	          column: 16
	        }
	      },
	      "13": {
	        start: {
	          line: 47,
	          column: 4
	        },
	        end: {
	          line: 50,
	          column: 5
	        }
	      },
	      "14": {
	        start: {
	          line: 48,
	          column: 6
	        },
	        end: {
	          line: 48,
	          column: 28
	        }
	      },
	      "15": {
	        start: {
	          line: 49,
	          column: 6
	        },
	        end: {
	          line: 49,
	          column: 13
	        }
	      },
	      "16": {
	        start: {
	          line: 55,
	          column: 2
	        },
	        end: {
	          line: 58,
	          column: 3
	        }
	      },
	      "17": {
	        start: {
	          line: 57,
	          column: 4
	        },
	        end: {
	          line: 57,
	          column: 29
	        }
	      },
	      "18": {
	        start: {
	          line: 62,
	          column: 2
	        },
	        end: {
	          line: 65,
	          column: 3
	        }
	      },
	      "19": {
	        start: {
	          line: 63,
	          column: 4
	        },
	        end: {
	          line: 63,
	          column: 124
	        }
	      },
	      "20": {
	        start: {
	          line: 64,
	          column: 4
	        },
	        end: {
	          line: 64,
	          column: 29
	        }
	      },
	      "21": {
	        start: {
	          line: 67,
	          column: 17
	        },
	        end: {
	          line: 67,
	          column: 31
	        }
	      },
	      "22": {
	        start: {
	          line: 69,
	          column: 2
	        },
	        end: {
	          line: 110,
	          column: 5
	        }
	      },
	      "23": {
	        start: {
	          line: 70,
	          column: 22
	        },
	        end: {
	          line: 70,
	          column: 47
	        }
	      },
	      "24": {
	        start: {
	          line: 73,
	          column: 4
	        },
	        end: {
	          line: 76,
	          column: 5
	        }
	      },
	      "25": {
	        start: {
	          line: 75,
	          column: 6
	        },
	        end: {
	          line: 75,
	          column: 52
	        }
	      },
	      "26": {
	        start: {
	          line: 83,
	          column: 4
	        },
	        end: {
	          line: 89,
	          column: 5
	        }
	      },
	      "27": {
	        start: {
	          line: 88,
	          column: 6
	        },
	        end: {
	          line: 88,
	          column: 31
	        }
	      },
	      "28": {
	        start: {
	          line: 91,
	          column: 4
	        },
	        end: {
	          line: 91,
	          column: 32
	        }
	      },
	      "29": {
	        start: {
	          line: 92,
	          column: 4
	        },
	        end: {
	          line: 102,
	          column: 7
	        }
	      },
	      "30": {
	        start: {
	          line: 104,
	          column: 21
	        },
	        end: {
	          line: 107,
	          column: 5
	        }
	      },
	      "31": {
	        start: {
	          line: 109,
	          column: 4
	        },
	        end: {
	          line: 109,
	          column: 30
	        }
	      },
	      "32": {
	        start: {
	          line: 113,
	          column: 40
	        },
	        end: {
	          line: 130,
	          column: 1
	        }
	      },
	      "33": {
	        start: {
	          line: 114,
	          column: 2
	        },
	        end: {
	          line: 117,
	          column: 3
	        }
	      },
	      "34": {
	        start: {
	          line: 116,
	          column: 4
	        },
	        end: {
	          line: 116,
	          column: 29
	        }
	      },
	      "35": {
	        start: {
	          line: 123,
	          column: 2
	        },
	        end: {
	          line: 129,
	          column: 5
	        }
	      },
	      "36": {
	        start: {
	          line: 132,
	          column: 36
	        },
	        end: {
	          line: 175,
	          column: 1
	        }
	      },
	      "37": {
	        start: {
	          line: 133,
	          column: 2
	        },
	        end: {
	          line: 136,
	          column: 3
	        }
	      },
	      "38": {
	        start: {
	          line: 135,
	          column: 4
	        },
	        end: {
	          line: 135,
	          column: 11
	        }
	      },
	      "39": {
	        start: {
	          line: 146,
	          column: 2
	        },
	        end: {
	          line: 152,
	          column: 3
	        }
	      },
	      "40": {
	        start: {
	          line: 146,
	          column: 40
	        },
	        end: {
	          line: 146,
	          column: 64
	        }
	      },
	      "41": {
	        start: {
	          line: 151,
	          column: 4
	        },
	        end: {
	          line: 151,
	          column: 11
	        }
	      },
	      "42": {
	        start: {
	          line: 154,
	          column: 17
	        },
	        end: {
	          line: 154,
	          column: 31
	        }
	      },
	      "43": {
	        start: {
	          line: 157,
	          column: 2
	        },
	        end: {
	          line: 160,
	          column: 3
	        }
	      },
	      "44": {
	        start: {
	          line: 159,
	          column: 4
	        },
	        end: {
	          line: 159,
	          column: 61
	        }
	      },
	      "45": {
	        start: {
	          line: 162,
	          column: 2
	        },
	        end: {
	          line: 164,
	          column: 3
	        }
	      },
	      "46": {
	        start: {
	          line: 163,
	          column: 4
	        },
	        end: {
	          line: 163,
	          column: 11
	        }
	      },
	      "47": {
	        start: {
	          line: 166,
	          column: 2
	        },
	        end: {
	          line: 166,
	          column: 47
	        }
	      },
	      "48": {
	        start: {
	          line: 168,
	          column: 2
	        },
	        end: {
	          line: 174,
	          column: 5
	        }
	      },
	      "49": {
	        start: {
	          line: 177,
	          column: 26
	        },
	        end: {
	          line: 179,
	          column: 1
	        }
	      },
	      "50": {
	        start: {
	          line: 178,
	          column: 2
	        },
	        end: {
	          line: 178,
	          column: 59
	        }
	      },
	      "51": {
	        start: {
	          line: 189,
	          column: 29
	        },
	        end: {
	          line: 196,
	          column: 1
	        }
	      },
	      "52": {
	        start: {
	          line: 190,
	          column: 14
	        },
	        end: {
	          line: 190,
	          column: 26
	        }
	      },
	      "53": {
	        start: {
	          line: 192,
	          column: 2
	        },
	        end: {
	          line: 195,
	          column: 3
	        }
	      },
	      "54": {
	        start: {
	          line: 193,
	          column: 4
	        },
	        end: {
	          line: 193,
	          column: 31
	        }
	      },
	      "55": {
	        start: {
	          line: 194,
	          column: 4
	        },
	        end: {
	          line: 194,
	          column: 29
	        }
	      },
	      "56": {
	        start: {
	          line: 206,
	          column: 31
	        },
	        end: {
	          line: 237,
	          column: 1
	        }
	      },
	      "57": {
	        start: {
	          line: 207,
	          column: 2
	        },
	        end: {
	          line: 236,
	          column: 4
	        }
	      },
	      "58": {
	        start: {
	          line: 208,
	          column: 18
	        },
	        end: {
	          line: 211,
	          column: 5
	        }
	      },
	      "59": {
	        start: {
	          line: 213,
	          column: 4
	        },
	        end: {
	          line: 229,
	          column: 5
	        }
	      },
	      "60": {
	        start: {
	          line: 214,
	          column: 6
	        },
	        end: {
	          line: 214,
	          column: 31
	        }
	      },
	      "61": {
	        start: {
	          line: 215,
	          column: 11
	        },
	        end: {
	          line: 229,
	          column: 5
	        }
	      },
	      "62": {
	        start: {
	          line: 216,
	          column: 6
	        },
	        end: {
	          line: 218,
	          column: 7
	        }
	      },
	      "63": {
	        start: {
	          line: 217,
	          column: 8
	        },
	        end: {
	          line: 217,
	          column: 41
	        }
	      },
	      "64": {
	        start: {
	          line: 219,
	          column: 6
	        },
	        end: {
	          line: 223,
	          column: 7
	        }
	      },
	      "65": {
	        start: {
	          line: 222,
	          column: 8
	        },
	        end: {
	          line: 222,
	          column: 37
	        }
	      },
	      "66": {
	        start: {
	          line: 224,
	          column: 6
	        },
	        end: {
	          line: 226,
	          column: 7
	        }
	      },
	      "67": {
	        start: {
	          line: 225,
	          column: 8
	        },
	        end: {
	          line: 225,
	          column: 45
	        }
	      },
	      "68": {
	        start: {
	          line: 228,
	          column: 6
	        },
	        end: {
	          line: 228,
	          column: 37
	        }
	      },
	      "69": {
	        start: {
	          line: 231,
	          column: 4
	        },
	        end: {
	          line: 233,
	          column: 5
	        }
	      },
	      "70": {
	        start: {
	          line: 232,
	          column: 6
	        },
	        end: {
	          line: 232,
	          column: 32
	        }
	      },
	      "71": {
	        start: {
	          line: 235,
	          column: 4
	        },
	        end: {
	          line: 235,
	          column: 24
	        }
	      },
	      "72": {
	        start: {
	          line: 250,
	          column: 22
	        },
	        end: {
	          line: 330,
	          column: 1
	        }
	      },
	      "73": {
	        start: {
	          line: 251,
	          column: 2
	        },
	        end: {
	          line: 253,
	          column: 3
	        }
	      },
	      "74": {
	        start: {
	          line: 252,
	          column: 4
	        },
	        end: {
	          line: 252,
	          column: 11
	        }
	      },
	      "75": {
	        start: {
	          line: 255,
	          column: 2
	        },
	        end: {
	          line: 255,
	          column: 24
	        }
	      },
	      "76": {
	        start: {
	          line: 257,
	          column: 2
	        },
	        end: {
	          line: 329,
	          column: 3
	        }
	      },
	      "77": {
	        start: {
	          line: 258,
	          column: 35
	        },
	        end: {
	          line: 267,
	          column: 5
	        }
	      },
	      "78": {
	        start: {
	          line: 259,
	          column: 33
	        },
	        end: {
	          line: 263,
	          column: 7
	        }
	      },
	      "79": {
	        start: {
	          line: 265,
	          column: 6
	        },
	        end: {
	          line: 265,
	          column: 28
	        }
	      },
	      "80": {
	        start: {
	          line: 266,
	          column: 6
	        },
	        end: {
	          line: 266,
	          column: 120
	        }
	      },
	      "81": {
	        start: {
	          line: 269,
	          column: 4
	        },
	        end: {
	          line: 294,
	          column: 5
	        }
	      },
	      "82": {
	        start: {
	          line: 276,
	          column: 6
	        },
	        end: {
	          line: 284,
	          column: 9
	        }
	      },
	      "83": {
	        start: {
	          line: 277,
	          column: 8
	        },
	        end: {
	          line: 277,
	          column: 24
	        }
	      },
	      "84": {
	        start: {
	          line: 278,
	          column: 8
	        },
	        end: {
	          line: 283,
	          column: 11
	        }
	      },
	      "85": {
	        start: {
	          line: 279,
	          column: 10
	        },
	        end: {
	          line: 282,
	          column: 11
	        }
	      },
	      "86": {
	        start: {
	          line: 280,
	          column: 12
	        },
	        end: {
	          line: 280,
	          column: 37
	        }
	      },
	      "87": {
	        start: {
	          line: 281,
	          column: 12
	        },
	        end: {
	          line: 281,
	          column: 27
	        }
	      },
	      "88": {
	        start: {
	          line: 285,
	          column: 6
	        },
	        end: {
	          line: 293,
	          column: 9
	        }
	      },
	      "89": {
	        start: {
	          line: 286,
	          column: 24
	        },
	        end: {
	          line: 286,
	          column: 42
	        }
	      },
	      "90": {
	        start: {
	          line: 287,
	          column: 46
	        },
	        end: {
	          line: 287,
	          column: 83
	        }
	      },
	      "91": {
	        start: {
	          line: 289,
	          column: 8
	        },
	        end: {
	          line: 292,
	          column: 9
	        }
	      },
	      "92": {
	        start: {
	          line: 290,
	          column: 10
	        },
	        end: {
	          line: 290,
	          column: 25
	        }
	      },
	      "93": {
	        start: {
	          line: 291,
	          column: 10
	        },
	        end: {
	          line: 291,
	          column: 35
	        }
	      },
	      "94": {
	        start: {
	          line: 298,
	          column: 4
	        },
	        end: {
	          line: 302,
	          column: 7
	        }
	      },
	      "95": {
	        start: {
	          line: 299,
	          column: 6
	        },
	        end: {
	          line: 299,
	          column: 66
	        }
	      },
	      "96": {
	        start: {
	          line: 300,
	          column: 6
	        },
	        end: {
	          line: 300,
	          column: 28
	        }
	      },
	      "97": {
	        start: {
	          line: 301,
	          column: 6
	        },
	        end: {
	          line: 301,
	          column: 107
	        }
	      },
	      "98": {
	        start: {
	          line: 303,
	          column: 9
	        },
	        end: {
	          line: 329,
	          column: 3
	        }
	      },
	      "99": {
	        start: {
	          line: 304,
	          column: 4
	        },
	        end: {
	          line: 304,
	          column: 36
	        }
	      },
	      "100": {
	        start: {
	          line: 305,
	          column: 9
	        },
	        end: {
	          line: 329,
	          column: 3
	        }
	      },
	      "101": {
	        start: {
	          line: 311,
	          column: 4
	        },
	        end: {
	          line: 319,
	          column: 7
	        }
	      },
	      "102": {
	        start: {
	          line: 312,
	          column: 6
	        },
	        end: {
	          line: 312,
	          column: 66
	        }
	      },
	      "103": {
	        start: {
	          line: 313,
	          column: 6
	        },
	        end: {
	          line: 313,
	          column: 28
	        }
	      },
	      "104": {
	        start: {
	          line: 314,
	          column: 6
	        },
	        end: {
	          line: 318,
	          column: 7
	        }
	      },
	      "105": {
	        start: {
	          line: 315,
	          column: 8
	        },
	        end: {
	          line: 315,
	          column: 101
	        }
	      },
	      "106": {
	        start: {
	          line: 317,
	          column: 8
	        },
	        end: {
	          line: 317,
	          column: 24
	        }
	      },
	      "107": {
	        start: {
	          line: 320,
	          column: 31
	        },
	        end: {
	          line: 322,
	          column: 5
	        }
	      },
	      "108": {
	        start: {
	          line: 321,
	          column: 6
	        },
	        end: {
	          line: 321,
	          column: 22
	        }
	      },
	      "109": {
	        start: {
	          line: 324,
	          column: 4
	        },
	        end: {
	          line: 324,
	          column: 54
	        }
	      },
	      "110": {
	        start: {
	          line: 326,
	          column: 4
	        },
	        end: {
	          line: 328,
	          column: 7
	        }
	      },
	      "111": {
	        start: {
	          line: 327,
	          column: 6
	        },
	        end: {
	          line: 327,
	          column: 57
	        }
	      },
	      "112": {
	        start: {
	          line: 344,
	          column: 12
	        },
	        end: {
	          line: 499,
	          column: 1
	        }
	      },
	      "113": {
	        start: {
	          line: 345,
	          column: 17
	        },
	        end: {
	          line: 345,
	          column: 21
	        }
	      },
	      "114": {
	        start: {
	          line: 346,
	          column: 19
	        },
	        end: {
	          line: 346,
	          column: 42
	        }
	      },
	      "115": {
	        start: {
	          line: 348,
	          column: 2
	        },
	        end: {
	          line: 348,
	          column: 54
	        }
	      },
	      "116": {
	        start: {
	          line: 348,
	          column: 21
	        },
	        end: {
	          line: 348,
	          column: 52
	        }
	      },
	      "117": {
	        start: {
	          line: 351,
	          column: 2
	        },
	        end: {
	          line: 498,
	          column: 4
	        }
	      },
	      "118": {
	        start: {
	          line: 357,
	          column: 6
	        },
	        end: {
	          line: 357,
	          column: 38
	        }
	      },
	      "119": {
	        start: {
	          line: 372,
	          column: 31
	        },
	        end: {
	          line: 376,
	          column: 7
	        }
	      },
	      "120": {
	        start: {
	          line: 379,
	          column: 33
	        },
	        end: {
	          line: 383,
	          column: 7
	        }
	      },
	      "121": {
	        start: {
	          line: 385,
	          column: 6
	        },
	        end: {
	          line: 385,
	          column: 28
	        }
	      },
	      "122": {
	        start: {
	          line: 387,
	          column: 6
	        },
	        end: {
	          line: 422,
	          column: 7
	        }
	      },
	      "123": {
	        start: {
	          line: 388,
	          column: 8
	        },
	        end: {
	          line: 395,
	          column: 13
	        }
	      },
	      "124": {
	        start: {
	          line: 389,
	          column: 22
	        },
	        end: {
	          line: 389,
	          column: 32
	        }
	      },
	      "125": {
	        start: {
	          line: 391,
	          column: 12
	        },
	        end: {
	          line: 391,
	          column: 28
	        }
	      },
	      "126": {
	        start: {
	          line: 392,
	          column: 12
	        },
	        end: {
	          line: 394,
	          column: 13
	        }
	      },
	      "127": {
	        start: {
	          line: 393,
	          column: 14
	        },
	        end: {
	          line: 393,
	          column: 30
	        }
	      },
	      "128": {
	        start: {
	          line: 396,
	          column: 13
	        },
	        end: {
	          line: 422,
	          column: 7
	        }
	      },
	      "129": {
	        start: {
	          line: 397,
	          column: 29
	        },
	        end: {
	          line: 408,
	          column: 9
	        }
	      },
	      "130": {
	        start: {
	          line: 398,
	          column: 10
	        },
	        end: {
	          line: 398,
	          column: 55
	        }
	      },
	      "131": {
	        start: {
	          line: 399,
	          column: 10
	        },
	        end: {
	          line: 399,
	          column: 55
	        }
	      },
	      "132": {
	        start: {
	          line: 400,
	          column: 10
	        },
	        end: {
	          line: 407,
	          column: 11
	        }
	      },
	      "133": {
	        start: {
	          line: 401,
	          column: 12
	        },
	        end: {
	          line: 401,
	          column: 41
	        }
	      },
	      "134": {
	        start: {
	          line: 402,
	          column: 12
	        },
	        end: {
	          line: 404,
	          column: 13
	        }
	      },
	      "135": {
	        start: {
	          line: 403,
	          column: 14
	        },
	        end: {
	          line: 403,
	          column: 38
	        }
	      },
	      "136": {
	        start: {
	          line: 406,
	          column: 12
	        },
	        end: {
	          line: 406,
	          column: 23
	        }
	      },
	      "137": {
	        start: {
	          line: 410,
	          column: 8
	        },
	        end: {
	          line: 410,
	          column: 53
	        }
	      },
	      "138": {
	        start: {
	          line: 411,
	          column: 8
	        },
	        end: {
	          line: 411,
	          column: 53
	        }
	      },
	      "139": {
	        start: {
	          line: 412,
	          column: 8
	        },
	        end: {
	          line: 421,
	          column: 9
	        }
	      },
	      "140": {
	        start: {
	          line: 413,
	          column: 10
	        },
	        end: {
	          line: 413,
	          column: 114
	        }
	      },
	      "141": {
	        start: {
	          line: 415,
	          column: 10
	        },
	        end: {
	          line: 415,
	          column: 55
	        }
	      },
	      "142": {
	        start: {
	          line: 416,
	          column: 10
	        },
	        end: {
	          line: 416,
	          column: 55
	        }
	      },
	      "143": {
	        start: {
	          line: 417,
	          column: 10
	        },
	        end: {
	          line: 417,
	          column: 26
	        }
	      },
	      "144": {
	        start: {
	          line: 418,
	          column: 10
	        },
	        end: {
	          line: 420,
	          column: 11
	        }
	      },
	      "145": {
	        start: {
	          line: 419,
	          column: 12
	        },
	        end: {
	          line: 419,
	          column: 28
	        }
	      },
	      "146": {
	        start: {
	          line: 425,
	          column: 23
	        },
	        end: {
	          line: 434,
	          column: 7
	        }
	      },
	      "147": {
	        start: {
	          line: 426,
	          column: 8
	        },
	        end: {
	          line: 426,
	          column: 71
	        }
	      },
	      "148": {
	        start: {
	          line: 429,
	          column: 8
	        },
	        end: {
	          line: 429,
	          column: 30
	        }
	      },
	      "149": {
	        start: {
	          line: 430,
	          column: 8
	        },
	        end: {
	          line: 433,
	          column: 13
	        }
	      },
	      "150": {
	        start: {
	          line: 432,
	          column: 12
	        },
	        end: {
	          line: 432,
	          column: 28
	        }
	      },
	      "151": {
	        start: {
	          line: 436,
	          column: 40
	        },
	        end: {
	          line: 471,
	          column: 7
	        }
	      },
	      "152": {
	        start: {
	          line: 437,
	          column: 42
	        },
	        end: {
	          line: 437,
	          column: 94
	        }
	      },
	      "153": {
	        start: {
	          line: 438,
	          column: 20
	        },
	        end: {
	          line: 438,
	          column: 32
	        }
	      },
	      "154": {
	        start: {
	          line: 441,
	          column: 8
	        },
	        end: {
	          line: 441,
	          column: 68
	        }
	      },
	      "155": {
	        start: {
	          line: 445,
	          column: 8
	        },
	        end: {
	          line: 450,
	          column: 9
	        }
	      },
	      "156": {
	        start: {
	          line: 446,
	          column: 10
	        },
	        end: {
	          line: 449,
	          column: 12
	        }
	      },
	      "157": {
	        start: {
	          line: 457,
	          column: 8
	        },
	        end: {
	          line: 470,
	          column: 9
	        }
	      },
	      "158": {
	        start: {
	          line: 460,
	          column: 10
	        },
	        end: {
	          line: 460,
	          column: 65
	        }
	      },
	      "159": {
	        start: {
	          line: 461,
	          column: 10
	        },
	        end: {
	          line: 465,
	          column: 40
	        }
	      },
	      "160": {
	        start: {
	          line: 462,
	          column: 12
	        },
	        end: {
	          line: 462,
	          column: 63
	        }
	      },
	      "161": {
	        start: {
	          line: 463,
	          column: 12
	        },
	        end: {
	          line: 463,
	          column: 53
	        }
	      },
	      "162": {
	        start: {
	          line: 464,
	          column: 12
	        },
	        end: {
	          line: 464,
	          column: 28
	        }
	      },
	      "163": {
	        start: {
	          line: 469,
	          column: 10
	        },
	        end: {
	          line: 469,
	          column: 26
	        }
	      },
	      "164": {
	        start: {
	          line: 473,
	          column: 25
	        },
	        end: {
	          line: 473,
	          column: 41
	        }
	      },
	      "165": {
	        start: {
	          line: 477,
	          column: 6
	        },
	        end: {
	          line: 477,
	          column: 80
	        }
	      },
	      "166": {
	        start: {
	          line: 479,
	          column: 42
	        },
	        end: {
	          line: 488,
	          column: 7
	        }
	      },
	      "167": {
	        start: {
	          line: 481,
	          column: 8
	        },
	        end: {
	          line: 481,
	          column: 59
	        }
	      },
	      "168": {
	        start: {
	          line: 483,
	          column: 8
	        },
	        end: {
	          line: 485,
	          column: 9
	        }
	      },
	      "169": {
	        start: {
	          line: 484,
	          column: 10
	        },
	        end: {
	          line: 484,
	          column: 87
	        }
	      },
	      "170": {
	        start: {
	          line: 487,
	          column: 8
	        },
	        end: {
	          line: 487,
	          column: 28
	        }
	      },
	      "171": {
	        start: {
	          line: 491,
	          column: 6
	        },
	        end: {
	          line: 491,
	          column: 56
	        }
	      },
	      "172": {
	        start: {
	          line: 494,
	          column: 6
	        },
	        end: {
	          line: 494,
	          column: 41
	        }
	      },
	      "173": {
	        start: {
	          line: 502,
	          column: 0
	        },
	        end: {
	          line: 502,
	          column: 35
	        }
	      },
	      "174": {
	        start: {
	          line: 505,
	          column: 0
	        },
	        end: {
	          line: 505,
	          column: 21
	        }
	      },
	      "175": {
	        start: {
	          line: 508,
	          column: 0
	        },
	        end: {
	          line: 508,
	          column: 22
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 17,
	            column: 26
	          },
	          end: {
	            line: 17,
	            column: 27
	          }
	        },
	        loc: {
	          start: {
	            line: 17,
	            column: 50
	          },
	          end: {
	            line: 43,
	            column: 1
	          }
	        },
	        line: 17
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 45,
	            column: 29
	          },
	          end: {
	            line: 45,
	            column: 30
	          }
	        },
	        loc: {
	          start: {
	            line: 45,
	            column: 53
	          },
	          end: {
	            line: 52,
	            column: 1
	          }
	        },
	        line: 45
	      },
	      "2": {
	        name: "handleEncryptedEvent",
	        decl: {
	          start: {
	            line: 54,
	            column: 16
	          },
	          end: {
	            line: 54,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 54,
	            column: 91
	          },
	          end: {
	            line: 111,
	            column: 1
	          }
	        },
	        line: 54
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 69,
	            column: 56
	          },
	          end: {
	            line: 69,
	            column: 57
	          }
	        },
	        loc: {
	          start: {
	            line: 69,
	            column: 77
	          },
	          end: {
	            line: 103,
	            column: 3
	          }
	        },
	        line: 69
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 103,
	            column: 11
	          },
	          end: {
	            line: 103,
	            column: 12
	          }
	        },
	        loc: {
	          start: {
	            line: 103,
	            column: 22
	          },
	          end: {
	            line: 110,
	            column: 3
	          }
	        },
	        line: 103
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 113,
	            column: 40
	          },
	          end: {
	            line: 113,
	            column: 41
	          }
	        },
	        loc: {
	          start: {
	            line: 113,
	            column: 80
	          },
	          end: {
	            line: 130,
	            column: 1
	          }
	        },
	        line: 113
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 132,
	            column: 36
	          },
	          end: {
	            line: 132,
	            column: 37
	          }
	        },
	        loc: {
	          start: {
	            line: 132,
	            column: 86
	          },
	          end: {
	            line: 175,
	            column: 1
	          }
	        },
	        line: 132
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 146,
	            column: 22
	          },
	          end: {
	            line: 146,
	            column: 23
	          }
	        },
	        loc: {
	          start: {
	            line: 146,
	            column: 40
	          },
	          end: {
	            line: 146,
	            column: 64
	          }
	        },
	        line: 146
	      },
	      "8": {
	        name: "(anonymous_8)",
	        decl: {
	          start: {
	            line: 177,
	            column: 26
	          },
	          end: {
	            line: 177,
	            column: 27
	          }
	        },
	        loc: {
	          start: {
	            line: 177,
	            column: 38
	          },
	          end: {
	            line: 179,
	            column: 1
	          }
	        },
	        line: 177
	      },
	      "9": {
	        name: "(anonymous_9)",
	        decl: {
	          start: {
	            line: 189,
	            column: 29
	          },
	          end: {
	            line: 189,
	            column: 30
	          }
	        },
	        loc: {
	          start: {
	            line: 189,
	            column: 41
	          },
	          end: {
	            line: 196,
	            column: 1
	          }
	        },
	        line: 189
	      },
	      "10": {
	        name: "(anonymous_10)",
	        decl: {
	          start: {
	            line: 206,
	            column: 31
	          },
	          end: {
	            line: 206,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 206,
	            column: 43
	          },
	          end: {
	            line: 237,
	            column: 1
	          }
	        },
	        line: 206
	      },
	      "11": {
	        name: "(anonymous_11)",
	        decl: {
	          start: {
	            line: 207,
	            column: 9
	          },
	          end: {
	            line: 207,
	            column: 10
	          }
	        },
	        loc: {
	          start: {
	            line: 207,
	            column: 33
	          },
	          end: {
	            line: 236,
	            column: 3
	          }
	        },
	        line: 207
	      },
	      "12": {
	        name: "(anonymous_12)",
	        decl: {
	          start: {
	            line: 250,
	            column: 22
	          },
	          end: {
	            line: 250,
	            column: 23
	          }
	        },
	        loc: {
	          start: {
	            line: 250,
	            column: 44
	          },
	          end: {
	            line: 330,
	            column: 1
	          }
	        },
	        line: 250
	      },
	      "13": {
	        name: "(anonymous_13)",
	        decl: {
	          start: {
	            line: 258,
	            column: 35
	          },
	          end: {
	            line: 258,
	            column: 36
	          }
	        },
	        loc: {
	          start: {
	            line: 258,
	            column: 41
	          },
	          end: {
	            line: 267,
	            column: 5
	          }
	        },
	        line: 258
	      },
	      "14": {
	        name: "(anonymous_14)",
	        decl: {
	          start: {
	            line: 276,
	            column: 25
	          },
	          end: {
	            line: 276,
	            column: 26
	          }
	        },
	        loc: {
	          start: {
	            line: 276,
	            column: 30
	          },
	          end: {
	            line: 284,
	            column: 7
	          }
	        },
	        line: 276
	      },
	      "15": {
	        name: "(anonymous_15)",
	        decl: {
	          start: {
	            line: 278,
	            column: 37
	          },
	          end: {
	            line: 278,
	            column: 38
	          }
	        },
	        loc: {
	          start: {
	            line: 278,
	            column: 44
	          },
	          end: {
	            line: 283,
	            column: 9
	          }
	        },
	        line: 278
	      },
	      "16": {
	        name: "(anonymous_16)",
	        decl: {
	          start: {
	            line: 285,
	            column: 24
	          },
	          end: {
	            line: 285,
	            column: 25
	          }
	        },
	        loc: {
	          start: {
	            line: 285,
	            column: 30
	          },
	          end: {
	            line: 293,
	            column: 7
	          }
	        },
	        line: 285
	      },
	      "17": {
	        name: "(anonymous_17)",
	        decl: {
	          start: {
	            line: 298,
	            column: 51
	          },
	          end: {
	            line: 298,
	            column: 52
	          }
	        },
	        loc: {
	          start: {
	            line: 298,
	            column: 62
	          },
	          end: {
	            line: 302,
	            column: 5
	          }
	        },
	        line: 298
	      },
	      "18": {
	        name: "(anonymous_18)",
	        decl: {
	          start: {
	            line: 311,
	            column: 51
	          },
	          end: {
	            line: 311,
	            column: 52
	          }
	        },
	        loc: {
	          start: {
	            line: 311,
	            column: 62
	          },
	          end: {
	            line: 319,
	            column: 5
	          }
	        },
	        line: 311
	      },
	      "19": {
	        name: "(anonymous_19)",
	        decl: {
	          start: {
	            line: 320,
	            column: 31
	          },
	          end: {
	            line: 320,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 320,
	            column: 42
	          },
	          end: {
	            line: 322,
	            column: 5
	          }
	        },
	        line: 320
	      },
	      "20": {
	        name: "(anonymous_20)",
	        decl: {
	          start: {
	            line: 326,
	            column: 25
	          },
	          end: {
	            line: 326,
	            column: 26
	          }
	        },
	        loc: {
	          start: {
	            line: 326,
	            column: 31
	          },
	          end: {
	            line: 328,
	            column: 5
	          }
	        },
	        line: 326
	      },
	      "21": {
	        name: "(anonymous_21)",
	        decl: {
	          start: {
	            line: 344,
	            column: 12
	          },
	          end: {
	            line: 344,
	            column: 13
	          }
	        },
	        loc: {
	          start: {
	            line: 344,
	            column: 35
	          },
	          end: {
	            line: 499,
	            column: 1
	          }
	        },
	        line: 344
	      },
	      "22": {
	        name: "(anonymous_22)",
	        decl: {
	          start: {
	            line: 348,
	            column: 15
	          },
	          end: {
	            line: 348,
	            column: 16
	          }
	        },
	        loc: {
	          start: {
	            line: 348,
	            column: 21
	          },
	          end: {
	            line: 348,
	            column: 52
	          }
	        },
	        line: 348
	      },
	      "23": {
	        name: "(anonymous_23)",
	        decl: {
	          start: {
	            line: 356,
	            column: 4
	          },
	          end: {
	            line: 356,
	            column: 5
	          }
	        },
	        loc: {
	          start: {
	            line: 356,
	            column: 24
	          },
	          end: {
	            line: 358,
	            column: 5
	          }
	        },
	        line: 356
	      },
	      "24": {
	        name: "(anonymous_24)",
	        decl: {
	          start: {
	            line: 369,
	            column: 4
	          },
	          end: {
	            line: 369,
	            column: 5
	          }
	        },
	        loc: {
	          start: {
	            line: 369,
	            column: 100
	          },
	          end: {
	            line: 423,
	            column: 5
	          }
	        },
	        line: 369
	      },
	      "25": {
	        name: "(anonymous_25)",
	        decl: {
	          start: {
	            line: 369,
	            column: 52
	          },
	          end: {
	            line: 369,
	            column: 53
	          }
	        },
	        loc: {
	          start: {
	            line: 369,
	            column: 63
	          },
	          end: {
	            line: 369,
	            column: 65
	          }
	        },
	        line: 369
	      },
	      "26": {
	        name: "(anonymous_26)",
	        decl: {
	          start: {
	            line: 389,
	            column: 16
	          },
	          end: {
	            line: 389,
	            column: 17
	          }
	        },
	        loc: {
	          start: {
	            line: 389,
	            column: 22
	          },
	          end: {
	            line: 389,
	            column: 32
	          }
	        },
	        line: 389
	      },
	      "27": {
	        name: "(anonymous_27)",
	        decl: {
	          start: {
	            line: 390,
	            column: 17
	          },
	          end: {
	            line: 390,
	            column: 18
	          }
	        },
	        loc: {
	          start: {
	            line: 390,
	            column: 28
	          },
	          end: {
	            line: 395,
	            column: 11
	          }
	        },
	        line: 390
	      },
	      "28": {
	        name: "(anonymous_28)",
	        decl: {
	          start: {
	            line: 397,
	            column: 29
	          },
	          end: {
	            line: 397,
	            column: 30
	          }
	        },
	        loc: {
	          start: {
	            line: 397,
	            column: 40
	          },
	          end: {
	            line: 408,
	            column: 9
	          }
	        },
	        line: 397
	      },
	      "29": {
	        name: "(anonymous_29)",
	        decl: {
	          start: {
	            line: 424,
	            column: 4
	          },
	          end: {
	            line: 424,
	            column: 5
	          }
	        },
	        loc: {
	          start: {
	            line: 424,
	            column: 25
	          },
	          end: {
	            line: 495,
	            column: 5
	          }
	        },
	        line: 424
	      },
	      "30": {
	        name: "(anonymous_30)",
	        decl: {
	          start: {
	            line: 425,
	            column: 23
	          },
	          end: {
	            line: 425,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 425,
	            column: 34
	          },
	          end: {
	            line: 434,
	            column: 7
	          }
	        },
	        line: 425
	      },
	      "31": {
	        name: "(anonymous_31)",
	        decl: {
	          start: {
	            line: 431,
	            column: 17
	          },
	          end: {
	            line: 431,
	            column: 18
	          }
	        },
	        loc: {
	          start: {
	            line: 431,
	            column: 28
	          },
	          end: {
	            line: 433,
	            column: 11
	          }
	        },
	        line: 431
	      },
	      "32": {
	        name: "(anonymous_32)",
	        decl: {
	          start: {
	            line: 436,
	            column: 40
	          },
	          end: {
	            line: 436,
	            column: 41
	          }
	        },
	        loc: {
	          start: {
	            line: 436,
	            column: 51
	          },
	          end: {
	            line: 471,
	            column: 7
	          }
	        },
	        line: 436
	      },
	      "33": {
	        name: "(anonymous_33)",
	        decl: {
	          start: {
	            line: 461,
	            column: 64
	          },
	          end: {
	            line: 461,
	            column: 65
	          }
	        },
	        loc: {
	          start: {
	            line: 461,
	            column: 70
	          },
	          end: {
	            line: 465,
	            column: 11
	          }
	        },
	        line: 461
	      },
	      "34": {
	        name: "(anonymous_34)",
	        decl: {
	          start: {
	            line: 479,
	            column: 42
	          },
	          end: {
	            line: 479,
	            column: 43
	          }
	        },
	        loc: {
	          start: {
	            line: 479,
	            column: 48
	          },
	          end: {
	            line: 488,
	            column: 7
	          }
	        },
	        line: 479
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 21,
	            column: 4
	          },
	          end: {
	            line: 23,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 21,
	            column: 4
	          },
	          end: {
	            line: 23,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 21,
	            column: 4
	          },
	          end: {
	            line: 23,
	            column: 5
	          }
	        }],
	        line: 21
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 37,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 37,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 37,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        }],
	        line: 37
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 47,
	            column: 4
	          },
	          end: {
	            line: 50,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 47,
	            column: 4
	          },
	          end: {
	            line: 50,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 47,
	            column: 4
	          },
	          end: {
	            line: 50,
	            column: 5
	          }
	        }],
	        line: 47
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 55,
	            column: 2
	          },
	          end: {
	            line: 58,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 55,
	            column: 2
	          },
	          end: {
	            line: 58,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 55,
	            column: 2
	          },
	          end: {
	            line: 58,
	            column: 3
	          }
	        }],
	        line: 55
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 55,
	            column: 6
	          },
	          end: {
	            line: 55,
	            column: 37
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 55,
	            column: 6
	          },
	          end: {
	            line: 55,
	            column: 14
	          }
	        }, {
	          start: {
	            line: 55,
	            column: 18
	          },
	          end: {
	            line: 55,
	            column: 37
	          }
	        }],
	        line: 55
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 65,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 65,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 62,
	            column: 2
	          },
	          end: {
	            line: 65,
	            column: 3
	          }
	        }],
	        line: 62
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 73,
	            column: 4
	          },
	          end: {
	            line: 76,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 73,
	            column: 4
	          },
	          end: {
	            line: 76,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 73,
	            column: 4
	          },
	          end: {
	            line: 76,
	            column: 5
	          }
	        }],
	        line: 73
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 73,
	            column: 8
	          },
	          end: {
	            line: 74,
	            column: 42
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 73,
	            column: 8
	          },
	          end: {
	            line: 73,
	            column: 37
	          }
	        }, {
	          start: {
	            line: 74,
	            column: 8
	          },
	          end: {
	            line: 74,
	            column: 42
	          }
	        }],
	        line: 73
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 83,
	            column: 4
	          },
	          end: {
	            line: 89,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 83,
	            column: 4
	          },
	          end: {
	            line: 89,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 83,
	            column: 4
	          },
	          end: {
	            line: 89,
	            column: 5
	          }
	        }],
	        line: 83
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 83,
	            column: 8
	          },
	          end: {
	            line: 83,
	            column: 51
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 83,
	            column: 8
	          },
	          end: {
	            line: 83,
	            column: 38
	          }
	        }, {
	          start: {
	            line: 83,
	            column: 42
	          },
	          end: {
	            line: 83,
	            column: 51
	          }
	        }],
	        line: 83
	      },
	      "10": {
	        loc: {
	          start: {
	            line: 114,
	            column: 2
	          },
	          end: {
	            line: 117,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 114,
	            column: 2
	          },
	          end: {
	            line: 117,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 114,
	            column: 2
	          },
	          end: {
	            line: 117,
	            column: 3
	          }
	        }],
	        line: 114
	      },
	      "11": {
	        loc: {
	          start: {
	            line: 114,
	            column: 6
	          },
	          end: {
	            line: 114,
	            column: 95
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 114,
	            column: 6
	          },
	          end: {
	            line: 114,
	            column: 25
	          }
	        }, {
	          start: {
	            line: 114,
	            column: 29
	          },
	          end: {
	            line: 114,
	            column: 76
	          }
	        }, {
	          start: {
	            line: 114,
	            column: 80
	          },
	          end: {
	            line: 114,
	            column: 95
	          }
	        }],
	        line: 114
	      },
	      "12": {
	        loc: {
	          start: {
	            line: 133,
	            column: 2
	          },
	          end: {
	            line: 136,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 133,
	            column: 2
	          },
	          end: {
	            line: 136,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 133,
	            column: 2
	          },
	          end: {
	            line: 136,
	            column: 3
	          }
	        }],
	        line: 133
	      },
	      "13": {
	        loc: {
	          start: {
	            line: 133,
	            column: 6
	          },
	          end: {
	            line: 133,
	            column: 70
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 133,
	            column: 6
	          },
	          end: {
	            line: 133,
	            column: 25
	          }
	        }, {
	          start: {
	            line: 133,
	            column: 29
	          },
	          end: {
	            line: 133,
	            column: 70
	          }
	        }],
	        line: 133
	      },
	      "14": {
	        loc: {
	          start: {
	            line: 146,
	            column: 2
	          },
	          end: {
	            line: 152,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 146,
	            column: 2
	          },
	          end: {
	            line: 152,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 146,
	            column: 2
	          },
	          end: {
	            line: 152,
	            column: 3
	          }
	        }],
	        line: 146
	      },
	      "15": {
	        loc: {
	          start: {
	            line: 146,
	            column: 40
	          },
	          end: {
	            line: 146,
	            column: 64
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 146,
	            column: 40
	          },
	          end: {
	            line: 146,
	            column: 43
	          }
	        }, {
	          start: {
	            line: 146,
	            column: 47
	          },
	          end: {
	            line: 146,
	            column: 64
	          }
	        }],
	        line: 146
	      },
	      "16": {
	        loc: {
	          start: {
	            line: 157,
	            column: 2
	          },
	          end: {
	            line: 160,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 157,
	            column: 2
	          },
	          end: {
	            line: 160,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 157,
	            column: 2
	          },
	          end: {
	            line: 160,
	            column: 3
	          }
	        }],
	        line: 157
	      },
	      "17": {
	        loc: {
	          start: {
	            line: 157,
	            column: 6
	          },
	          end: {
	            line: 158,
	            column: 51
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 157,
	            column: 6
	          },
	          end: {
	            line: 157,
	            column: 46
	          }
	        }, {
	          start: {
	            line: 158,
	            column: 6
	          },
	          end: {
	            line: 158,
	            column: 51
	          }
	        }],
	        line: 157
	      },
	      "18": {
	        loc: {
	          start: {
	            line: 162,
	            column: 2
	          },
	          end: {
	            line: 164,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 162,
	            column: 2
	          },
	          end: {
	            line: 164,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 162,
	            column: 2
	          },
	          end: {
	            line: 164,
	            column: 3
	          }
	        }],
	        line: 162
	      },
	      "19": {
	        loc: {
	          start: {
	            line: 192,
	            column: 2
	          },
	          end: {
	            line: 195,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 192,
	            column: 2
	          },
	          end: {
	            line: 195,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 192,
	            column: 2
	          },
	          end: {
	            line: 195,
	            column: 3
	          }
	        }],
	        line: 192
	      },
	      "20": {
	        loc: {
	          start: {
	            line: 213,
	            column: 4
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 213,
	            column: 4
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 213,
	            column: 4
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        }],
	        line: 213
	      },
	      "21": {
	        loc: {
	          start: {
	            line: 215,
	            column: 11
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 215,
	            column: 11
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 215,
	            column: 11
	          },
	          end: {
	            line: 229,
	            column: 5
	          }
	        }],
	        line: 215
	      },
	      "22": {
	        loc: {
	          start: {
	            line: 216,
	            column: 6
	          },
	          end: {
	            line: 218,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 216,
	            column: 6
	          },
	          end: {
	            line: 218,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 216,
	            column: 6
	          },
	          end: {
	            line: 218,
	            column: 7
	          }
	        }],
	        line: 216
	      },
	      "23": {
	        loc: {
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 223,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 223,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 223,
	            column: 7
	          }
	        }],
	        line: 219
	      },
	      "24": {
	        loc: {
	          start: {
	            line: 219,
	            column: 10
	          },
	          end: {
	            line: 221,
	            column: 37
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 219,
	            column: 10
	          },
	          end: {
	            line: 219,
	            column: 24
	          }
	        }, {
	          start: {
	            line: 220,
	            column: 11
	          },
	          end: {
	            line: 220,
	            column: 32
	          }
	        }, {
	          start: {
	            line: 221,
	            column: 11
	          },
	          end: {
	            line: 221,
	            column: 36
	          }
	        }],
	        line: 219
	      },
	      "25": {
	        loc: {
	          start: {
	            line: 224,
	            column: 6
	          },
	          end: {
	            line: 226,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 224,
	            column: 6
	          },
	          end: {
	            line: 226,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 224,
	            column: 6
	          },
	          end: {
	            line: 226,
	            column: 7
	          }
	        }],
	        line: 224
	      },
	      "26": {
	        loc: {
	          start: {
	            line: 231,
	            column: 4
	          },
	          end: {
	            line: 233,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 231,
	            column: 4
	          },
	          end: {
	            line: 233,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 231,
	            column: 4
	          },
	          end: {
	            line: 233,
	            column: 5
	          }
	        }],
	        line: 231
	      },
	      "27": {
	        loc: {
	          start: {
	            line: 251,
	            column: 2
	          },
	          end: {
	            line: 253,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 251,
	            column: 2
	          },
	          end: {
	            line: 253,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 251,
	            column: 2
	          },
	          end: {
	            line: 253,
	            column: 3
	          }
	        }],
	        line: 251
	      },
	      "28": {
	        loc: {
	          start: {
	            line: 257,
	            column: 2
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 257,
	            column: 2
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 257,
	            column: 2
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }],
	        line: 257
	      },
	      "29": {
	        loc: {
	          start: {
	            line: 269,
	            column: 4
	          },
	          end: {
	            line: 294,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 269,
	            column: 4
	          },
	          end: {
	            line: 294,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 269,
	            column: 4
	          },
	          end: {
	            line: 294,
	            column: 5
	          }
	        }],
	        line: 269
	      },
	      "30": {
	        loc: {
	          start: {
	            line: 279,
	            column: 10
	          },
	          end: {
	            line: 282,
	            column: 11
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 279,
	            column: 10
	          },
	          end: {
	            line: 282,
	            column: 11
	          }
	        }, {
	          start: {
	            line: 279,
	            column: 10
	          },
	          end: {
	            line: 282,
	            column: 11
	          }
	        }],
	        line: 279
	      },
	      "31": {
	        loc: {
	          start: {
	            line: 279,
	            column: 14
	          },
	          end: {
	            line: 279,
	            column: 58
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 279,
	            column: 14
	          },
	          end: {
	            line: 279,
	            column: 22
	          }
	        }, {
	          start: {
	            line: 279,
	            column: 26
	          },
	          end: {
	            line: 279,
	            column: 58
	          }
	        }],
	        line: 279
	      },
	      "32": {
	        loc: {
	          start: {
	            line: 289,
	            column: 8
	          },
	          end: {
	            line: 292,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 289,
	            column: 8
	          },
	          end: {
	            line: 292,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 289,
	            column: 8
	          },
	          end: {
	            line: 292,
	            column: 9
	          }
	        }],
	        line: 289
	      },
	      "33": {
	        loc: {
	          start: {
	            line: 289,
	            column: 12
	          },
	          end: {
	            line: 289,
	            column: 97
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 289,
	            column: 12
	          },
	          end: {
	            line: 289,
	            column: 44
	          }
	        }, {
	          start: {
	            line: 289,
	            column: 48
	          },
	          end: {
	            line: 289,
	            column: 97
	          }
	        }],
	        line: 289
	      },
	      "34": {
	        loc: {
	          start: {
	            line: 303,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 303,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 303,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }],
	        line: 303
	      },
	      "35": {
	        loc: {
	          start: {
	            line: 305,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 305,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 305,
	            column: 9
	          },
	          end: {
	            line: 329,
	            column: 3
	          }
	        }],
	        line: 305
	      },
	      "36": {
	        loc: {
	          start: {
	            line: 344,
	            column: 21
	          },
	          end: {
	            line: 344,
	            column: 33
	          }
	        },
	        type: "default-arg",
	        locations: [{
	          start: {
	            line: 344,
	            column: 31
	          },
	          end: {
	            line: 344,
	            column: 33
	          }
	        }],
	        line: 344
	      },
	      "37": {
	        loc: {
	          start: {
	            line: 369,
	            column: 24
	          },
	          end: {
	            line: 369,
	            column: 39
	          }
	        },
	        type: "default-arg",
	        locations: [{
	          start: {
	            line: 369,
	            column: 37
	          },
	          end: {
	            line: 369,
	            column: 39
	          }
	        }],
	        line: 369
	      },
	      "38": {
	        loc: {
	          start: {
	            line: 369,
	            column: 41
	          },
	          end: {
	            line: 369,
	            column: 65
	          }
	        },
	        type: "default-arg",
	        locations: [{
	          start: {
	            line: 369,
	            column: 52
	          },
	          end: {
	            line: 369,
	            column: 65
	          }
	        }],
	        line: 369
	      },
	      "39": {
	        loc: {
	          start: {
	            line: 369,
	            column: 67
	          },
	          end: {
	            line: 369,
	            column: 98
	          }
	        },
	        type: "default-arg",
	        locations: [{
	          start: {
	            line: 369,
	            column: 93
	          },
	          end: {
	            line: 369,
	            column: 98
	          }
	        }],
	        line: 369
	      },
	      "40": {
	        loc: {
	          start: {
	            line: 387,
	            column: 6
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 387,
	            column: 6
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 387,
	            column: 6
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        }],
	        line: 387
	      },
	      "41": {
	        loc: {
	          start: {
	            line: 392,
	            column: 12
	          },
	          end: {
	            line: 394,
	            column: 13
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 392,
	            column: 12
	          },
	          end: {
	            line: 394,
	            column: 13
	          }
	        }, {
	          start: {
	            line: 392,
	            column: 12
	          },
	          end: {
	            line: 394,
	            column: 13
	          }
	        }],
	        line: 392
	      },
	      "42": {
	        loc: {
	          start: {
	            line: 396,
	            column: 13
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 396,
	            column: 13
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 396,
	            column: 13
	          },
	          end: {
	            line: 422,
	            column: 7
	          }
	        }],
	        line: 396
	      },
	      "43": {
	        loc: {
	          start: {
	            line: 400,
	            column: 10
	          },
	          end: {
	            line: 407,
	            column: 11
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 400,
	            column: 10
	          },
	          end: {
	            line: 407,
	            column: 11
	          }
	        }, {
	          start: {
	            line: 400,
	            column: 10
	          },
	          end: {
	            line: 407,
	            column: 11
	          }
	        }],
	        line: 400
	      },
	      "44": {
	        loc: {
	          start: {
	            line: 402,
	            column: 12
	          },
	          end: {
	            line: 404,
	            column: 13
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 402,
	            column: 12
	          },
	          end: {
	            line: 404,
	            column: 13
	          }
	        }, {
	          start: {
	            line: 402,
	            column: 12
	          },
	          end: {
	            line: 404,
	            column: 13
	          }
	        }],
	        line: 402
	      },
	      "45": {
	        loc: {
	          start: {
	            line: 418,
	            column: 10
	          },
	          end: {
	            line: 420,
	            column: 11
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 418,
	            column: 10
	          },
	          end: {
	            line: 420,
	            column: 11
	          }
	        }, {
	          start: {
	            line: 418,
	            column: 10
	          },
	          end: {
	            line: 420,
	            column: 11
	          }
	        }],
	        line: 418
	      },
	      "46": {
	        loc: {
	          start: {
	            line: 437,
	            column: 42
	          },
	          end: {
	            line: 437,
	            column: 94
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 437,
	            column: 42
	          },
	          end: {
	            line: 437,
	            column: 86
	          }
	        }, {
	          start: {
	            line: 437,
	            column: 90
	          },
	          end: {
	            line: 437,
	            column: 94
	          }
	        }],
	        line: 437
	      },
	      "47": {
	        loc: {
	          start: {
	            line: 441,
	            column: 36
	          },
	          end: {
	            line: 441,
	            column: 67
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 441,
	            column: 36
	          },
	          end: {
	            line: 441,
	            column: 61
	          }
	        }, {
	          start: {
	            line: 441,
	            column: 65
	          },
	          end: {
	            line: 441,
	            column: 67
	          }
	        }],
	        line: 441
	      },
	      "48": {
	        loc: {
	          start: {
	            line: 445,
	            column: 8
	          },
	          end: {
	            line: 450,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 445,
	            column: 8
	          },
	          end: {
	            line: 450,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 445,
	            column: 8
	          },
	          end: {
	            line: 450,
	            column: 9
	          }
	        }],
	        line: 445
	      },
	      "49": {
	        loc: {
	          start: {
	            line: 457,
	            column: 8
	          },
	          end: {
	            line: 470,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 457,
	            column: 8
	          },
	          end: {
	            line: 470,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 457,
	            column: 8
	          },
	          end: {
	            line: 470,
	            column: 9
	          }
	        }],
	        line: 457
	      },
	      "50": {
	        loc: {
	          start: {
	            line: 483,
	            column: 8
	          },
	          end: {
	            line: 485,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 483,
	            column: 8
	          },
	          end: {
	            line: 485,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 483,
	            column: 8
	          },
	          end: {
	            line: 485,
	            column: 9
	          }
	        }],
	        line: 483
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0,
	      "56": 0,
	      "57": 0,
	      "58": 0,
	      "59": 0,
	      "60": 0,
	      "61": 0,
	      "62": 0,
	      "63": 0,
	      "64": 0,
	      "65": 0,
	      "66": 0,
	      "67": 0,
	      "68": 0,
	      "69": 0,
	      "70": 0,
	      "71": 0,
	      "72": 0,
	      "73": 0,
	      "74": 0,
	      "75": 0,
	      "76": 0,
	      "77": 0,
	      "78": 0,
	      "79": 0,
	      "80": 0,
	      "81": 0,
	      "82": 0,
	      "83": 0,
	      "84": 0,
	      "85": 0,
	      "86": 0,
	      "87": 0,
	      "88": 0,
	      "89": 0,
	      "90": 0,
	      "91": 0,
	      "92": 0,
	      "93": 0,
	      "94": 0,
	      "95": 0,
	      "96": 0,
	      "97": 0,
	      "98": 0,
	      "99": 0,
	      "100": 0,
	      "101": 0,
	      "102": 0,
	      "103": 0,
	      "104": 0,
	      "105": 0,
	      "106": 0,
	      "107": 0,
	      "108": 0,
	      "109": 0,
	      "110": 0,
	      "111": 0,
	      "112": 0,
	      "113": 0,
	      "114": 0,
	      "115": 0,
	      "116": 0,
	      "117": 0,
	      "118": 0,
	      "119": 0,
	      "120": 0,
	      "121": 0,
	      "122": 0,
	      "123": 0,
	      "124": 0,
	      "125": 0,
	      "126": 0,
	      "127": 0,
	      "128": 0,
	      "129": 0,
	      "130": 0,
	      "131": 0,
	      "132": 0,
	      "133": 0,
	      "134": 0,
	      "135": 0,
	      "136": 0,
	      "137": 0,
	      "138": 0,
	      "139": 0,
	      "140": 0,
	      "141": 0,
	      "142": 0,
	      "143": 0,
	      "144": 0,
	      "145": 0,
	      "146": 0,
	      "147": 0,
	      "148": 0,
	      "149": 0,
	      "150": 0,
	      "151": 0,
	      "152": 0,
	      "153": 0,
	      "154": 0,
	      "155": 0,
	      "156": 0,
	      "157": 0,
	      "158": 0,
	      "159": 0,
	      "160": 0,
	      "161": 0,
	      "162": 0,
	      "163": 0,
	      "164": 0,
	      "165": 0,
	      "166": 0,
	      "167": 0,
	      "168": 0,
	      "169": 0,
	      "170": 0,
	      "171": 0,
	      "172": 0,
	      "173": 0,
	      "174": 0,
	      "175": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0],
	      "10": [0, 0],
	      "11": [0, 0, 0],
	      "12": [0, 0],
	      "13": [0, 0],
	      "14": [0, 0],
	      "15": [0, 0],
	      "16": [0, 0],
	      "17": [0, 0],
	      "18": [0, 0],
	      "19": [0, 0],
	      "20": [0, 0],
	      "21": [0, 0],
	      "22": [0, 0],
	      "23": [0, 0],
	      "24": [0, 0, 0],
	      "25": [0, 0],
	      "26": [0, 0],
	      "27": [0, 0],
	      "28": [0, 0],
	      "29": [0, 0],
	      "30": [0, 0],
	      "31": [0, 0],
	      "32": [0, 0],
	      "33": [0, 0],
	      "34": [0, 0],
	      "35": [0, 0],
	      "36": [0],
	      "37": [0],
	      "38": [0],
	      "39": [0],
	      "40": [0, 0],
	      "41": [0, 0],
	      "42": [0, 0],
	      "43": [0, 0],
	      "44": [0, 0],
	      "45": [0, 0],
	      "46": [0, 0],
	      "47": [0, 0],
	      "48": [0, 0],
	      "49": [0, 0],
	      "50": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "1abe61db4977c92c0f4037befb3221f94bfbd759"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});

	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }

	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_jwgp8nce4 = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}

	cov_jwgp8nce4();
	cov_jwgp8nce4().s[0]++;
	const hasSession = (sessions, initData) => {
	  cov_jwgp8nce4().f[0]++;
	  cov_jwgp8nce4().s[1]++;

	  for (let i = (cov_jwgp8nce4().s[2]++, 0); i < sessions.length; i++) {
	    cov_jwgp8nce4().s[3]++; // Other types of sessions may be in the sessions array that don't store the initData
	    // (for instance, PlayReady sessions on IE11).

	    if (!sessions[i].initData) {
	      cov_jwgp8nce4().b[0][0]++;
	      cov_jwgp8nce4().s[4]++;
	      continue;
	    } else {
	      cov_jwgp8nce4().b[0][1]++;
	    } // initData should be an ArrayBuffer by the spec:
	    // eslint-disable-next-line max-len
	    // @see [Media Encrypted Event initData Spec]{@link https://www.w3.org/TR/encrypted-media/#mediaencryptedeventinit}
	    //
	    // However, on some browsers it may come back with a typed array view of the buffer.
	    // This is the case for IE11, however, since IE11 sessions are handled differently
	    // (following the msneedkey PlayReady path), this coversion may not be important. It
	    // is safe though, and might be a good idea to retain in the short term (until we have
	    // catalogued the full range of browsers and their implementations).


	    const sessionBuffer = (cov_jwgp8nce4().s[5]++, arrayBufferFrom(sessions[i].initData));
	    const initDataBuffer = (cov_jwgp8nce4().s[6]++, arrayBufferFrom(initData));
	    cov_jwgp8nce4().s[7]++;

	    if (arrayBuffersEqual(sessionBuffer, initDataBuffer)) {
	      cov_jwgp8nce4().b[1][0]++;
	      cov_jwgp8nce4().s[8]++;
	      return true;
	    } else {
	      cov_jwgp8nce4().b[1][1]++;
	    }
	  }

	  cov_jwgp8nce4().s[9]++;
	  return false;
	};
	cov_jwgp8nce4().s[10]++;
	const removeSession = (sessions, initData) => {
	  cov_jwgp8nce4().f[1]++;
	  cov_jwgp8nce4().s[11]++;

	  for (let i = (cov_jwgp8nce4().s[12]++, 0); i < sessions.length; i++) {
	    cov_jwgp8nce4().s[13]++;

	    if (sessions[i].initData === initData) {
	      cov_jwgp8nce4().b[2][0]++;
	      cov_jwgp8nce4().s[14]++;
	      sessions.splice(i, 1);
	      cov_jwgp8nce4().s[15]++;
	      return;
	    } else {
	      cov_jwgp8nce4().b[2][1]++;
	    }
	  }
	};
	function handleEncryptedEvent(player, event, options, sessions, eventBus, emeError) {
	  cov_jwgp8nce4().f[2]++;
	  cov_jwgp8nce4().s[16]++;

	  if ((cov_jwgp8nce4().b[4][0]++, !options) || (cov_jwgp8nce4().b[4][1]++, !options.keySystems)) {
	    cov_jwgp8nce4().b[3][0]++;
	    cov_jwgp8nce4().s[17]++; // return silently since it may be handled by a different system

	    return Promise.resolve();
	  } else {
	    cov_jwgp8nce4().b[3][1]++;
	  } // Legacy fairplay is the keysystem 'com.apple.fps.1_0'.
	  // If we are using this keysystem we want to use WebkitMediaKeys.
	  // This can be initialized manually with initLegacyFairplay().


	  cov_jwgp8nce4().s[18]++;

	  if (options.keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM]) {
	    cov_jwgp8nce4().b[5][0]++;
	    cov_jwgp8nce4().s[19]++;
	    videojs__default["default"].log.debug('eme', `Ignoring \'encrypted\' event, using legacy fairplay keySystem ${LEGACY_FAIRPLAY_KEY_SYSTEM}`);
	    cov_jwgp8nce4().s[20]++;
	    return Promise.resolve();
	  } else {
	    cov_jwgp8nce4().b[5][1]++;
	  }

	  let initData = (cov_jwgp8nce4().s[21]++, event.initData);
	  cov_jwgp8nce4().s[22]++;
	  return getSupportedKeySystem(options.keySystems).then(keySystemAccess => {
	    cov_jwgp8nce4().f[3]++;
	    const keySystem = (cov_jwgp8nce4().s[23]++, keySystemAccess.keySystem); // Use existing init data from options if provided

	    cov_jwgp8nce4().s[24]++;

	    if ((cov_jwgp8nce4().b[7][0]++, options.keySystems[keySystem]) && (cov_jwgp8nce4().b[7][1]++, options.keySystems[keySystem].pssh)) {
	      cov_jwgp8nce4().b[6][0]++;
	      cov_jwgp8nce4().s[25]++;
	      initData = options.keySystems[keySystem].pssh;
	    } else {
	      cov_jwgp8nce4().b[6][1]++;
	    } // "Initialization Data must be a fixed value for a given set of stream(s) or media
	    // data. It must only contain information related to the keys required to play a given
	    // set of stream(s) or media data."
	    // eslint-disable-next-line max-len
	    // @see [Initialization Data Spec]{@link https://www.w3.org/TR/encrypted-media/#initialization-data}


	    cov_jwgp8nce4().s[26]++;

	    if ((cov_jwgp8nce4().b[9][0]++, hasSession(sessions, initData)) || (cov_jwgp8nce4().b[9][1]++, !initData)) {
	      cov_jwgp8nce4().b[8][0]++;
	      cov_jwgp8nce4().s[27]++; // TODO convert to videojs.log.debug and add back in
	      // https://github.com/videojs/video.js/pull/4780
	      // videojs.log('eme',
	      //             'Already have a configured session for init data, ignoring event.');

	      return Promise.resolve();
	    } else {
	      cov_jwgp8nce4().b[8][1]++;
	    }

	    cov_jwgp8nce4().s[28]++;
	    sessions.push({
	      initData
	    });
	    cov_jwgp8nce4().s[29]++;
	    return standard5July2016({
	      player,
	      video: event.target,
	      initDataType: event.initDataType,
	      initData,
	      keySystemAccess,
	      options,
	      removeSession: removeSession.bind(null, sessions),
	      eventBus,
	      emeError
	    });
	  }).catch(error => {
	    cov_jwgp8nce4().f[4]++;
	    const metadata = (cov_jwgp8nce4().s[30]++, {
	      errorType: Error$1.EMEFailedToRequestMediaKeySystemAccess,
	      config: getMediaKeySystemConfigurations(options.keySystems)
	    });
	    cov_jwgp8nce4().s[31]++;
	    emeError(error, metadata);
	  });
	}
	cov_jwgp8nce4().s[32]++;
	const handleWebKitNeedKeyEvent = (event, options, eventBus, emeError) => {
	  cov_jwgp8nce4().f[5]++;
	  cov_jwgp8nce4().s[33]++;

	  if ((cov_jwgp8nce4().b[11][0]++, !options.keySystems) || (cov_jwgp8nce4().b[11][1]++, !options.keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM]) || (cov_jwgp8nce4().b[11][2]++, !event.initData)) {
	    cov_jwgp8nce4().b[10][0]++;
	    cov_jwgp8nce4().s[34]++; // return silently since it may be handled by a different system

	    return Promise.resolve();
	  } else {
	    cov_jwgp8nce4().b[10][1]++;
	  } // From Apple's example Safari FairPlay integration code, webkitneedkey is not repeated
	  // for the same content. Unless documentation is found to present the opposite, handle
	  // all webkitneedkey events the same (even if they are repeated).


	  cov_jwgp8nce4().s[35]++;
	  return fairplay({
	    video: event.target,
	    initData: event.initData,
	    options,
	    eventBus,
	    emeError
	  });
	};
	cov_jwgp8nce4().s[36]++;
	const handleMsNeedKeyEvent = (event, options, sessions, eventBus, emeError) => {
	  cov_jwgp8nce4().f[6]++;
	  cov_jwgp8nce4().s[37]++;

	  if ((cov_jwgp8nce4().b[13][0]++, !options.keySystems) || (cov_jwgp8nce4().b[13][1]++, !options.keySystems[PLAYREADY_KEY_SYSTEM])) {
	    cov_jwgp8nce4().b[12][0]++;
	    cov_jwgp8nce4().s[38]++; // return silently since it may be handled by a different system

	    return;
	  } else {
	    cov_jwgp8nce4().b[12][1]++;
	  } // "With PlayReady content protection, your Web app must handle the first needKey event,
	  // but it must then ignore any other needKey event that occurs."
	  // eslint-disable-next-line max-len
	  // @see [PlayReady License Acquisition]{@link https://msdn.microsoft.com/en-us/library/dn468979.aspx}
	  //
	  // Usually (and as per the example in the link above) this is determined by checking for
	  // the existence of video.msKeys. However, since the video element may be reused, it's
	  // easier to directly manage the session.


	  cov_jwgp8nce4().s[39]++;

	  if (sessions.reduce((acc, session) => {
	    cov_jwgp8nce4().f[7]++;
	    cov_jwgp8nce4().s[40]++;
	    return (cov_jwgp8nce4().b[15][0]++, acc) || (cov_jwgp8nce4().b[15][1]++, session.playready);
	  }, false)) {
	    cov_jwgp8nce4().b[14][0]++;
	    cov_jwgp8nce4().s[41]++; // TODO convert to videojs.log.debug and add back in
	    // https://github.com/videojs/video.js/pull/4780
	    // videojs.log('eme',
	    //             'An \'msneedkey\' event was receieved earlier, ignoring event.');

	    return;
	  } else {
	    cov_jwgp8nce4().b[14][1]++;
	  }

	  let initData = (cov_jwgp8nce4().s[42]++, event.initData); // Use existing init data from options if provided

	  cov_jwgp8nce4().s[43]++;

	  if ((cov_jwgp8nce4().b[17][0]++, options.keySystems[PLAYREADY_KEY_SYSTEM]) && (cov_jwgp8nce4().b[17][1]++, options.keySystems[PLAYREADY_KEY_SYSTEM].pssh)) {
	    cov_jwgp8nce4().b[16][0]++;
	    cov_jwgp8nce4().s[44]++;
	    initData = options.keySystems[PLAYREADY_KEY_SYSTEM].pssh;
	  } else {
	    cov_jwgp8nce4().b[16][1]++;
	  }

	  cov_jwgp8nce4().s[45]++;

	  if (!initData) {
	    cov_jwgp8nce4().b[18][0]++;
	    cov_jwgp8nce4().s[46]++;
	    return;
	  } else {
	    cov_jwgp8nce4().b[18][1]++;
	  }

	  cov_jwgp8nce4().s[47]++;
	  sessions.push({
	    playready: true,
	    initData
	  });
	  cov_jwgp8nce4().s[48]++;
	  msPrefixed({
	    video: event.target,
	    initData,
	    options,
	    eventBus,
	    emeError
	  });
	};
	cov_jwgp8nce4().s[49]++;
	const getOptions = player => {
	  cov_jwgp8nce4().f[8]++;
	  cov_jwgp8nce4().s[50]++;
	  return merge(player.currentSource(), player.eme.options);
	};
	/**
	* Configure a persistent sessions array and activeSrc property to ensure we properly
	* handle each independent source's events. Should be run on any encrypted or needkey
	* style event to ensure that the sessions reflect the active source.
	*
	* @function setupSessions
	* @param    {Player} player
	*/

	cov_jwgp8nce4().s[51]++;
	const setupSessions = player => {
	  cov_jwgp8nce4().f[9]++;
	  const src = (cov_jwgp8nce4().s[52]++, player.src());
	  cov_jwgp8nce4().s[53]++;

	  if (src !== player.eme.activeSrc) {
	    cov_jwgp8nce4().b[19][0]++;
	    cov_jwgp8nce4().s[54]++;
	    player.eme.activeSrc = src;
	    cov_jwgp8nce4().s[55]++;
	    player.eme.sessions = [];
	  } else {
	    cov_jwgp8nce4().b[19][1]++;
	  }
	};
	/**
	* Construct a simple function that can be used to dispatch EME errors on the
	* player directly, such as providing it to a `.catch()`.
	*
	* @function emeErrorHandler
	* @param    {Player} player
	* @return   {Function}
	*/

	cov_jwgp8nce4().s[56]++;
	const emeErrorHandler = player => {
	  cov_jwgp8nce4().f[10]++;
	  cov_jwgp8nce4().s[57]++;
	  return (objOrErr, metadata) => {
	    cov_jwgp8nce4().f[11]++;
	    const error = (cov_jwgp8nce4().s[58]++, {
	      // MEDIA_ERR_ENCRYPTED is code 5
	      code: 5
	    });
	    cov_jwgp8nce4().s[59]++;

	    if (typeof objOrErr === 'string') {
	      cov_jwgp8nce4().b[20][0]++;
	      cov_jwgp8nce4().s[60]++;
	      error.message = objOrErr;
	    } else {
	      cov_jwgp8nce4().b[20][1]++;
	      cov_jwgp8nce4().s[61]++;

	      if (objOrErr) {
	        cov_jwgp8nce4().b[21][0]++;
	        cov_jwgp8nce4().s[62]++;

	        if (objOrErr.message) {
	          cov_jwgp8nce4().b[22][0]++;
	          cov_jwgp8nce4().s[63]++;
	          error.message = objOrErr.message;
	        } else {
	          cov_jwgp8nce4().b[22][1]++;
	        }

	        cov_jwgp8nce4().s[64]++;

	        if ((cov_jwgp8nce4().b[24][0]++, objOrErr.cause) && ((cov_jwgp8nce4().b[24][1]++, objOrErr.cause.length) || (cov_jwgp8nce4().b[24][2]++, objOrErr.cause.byteLength))) {
	          cov_jwgp8nce4().b[23][0]++;
	          cov_jwgp8nce4().s[65]++;
	          error.cause = objOrErr.cause;
	        } else {
	          cov_jwgp8nce4().b[23][1]++;
	        }

	        cov_jwgp8nce4().s[66]++;

	        if (objOrErr.keySystem) {
	          cov_jwgp8nce4().b[25][0]++;
	          cov_jwgp8nce4().s[67]++;
	          error.keySystem = objOrErr.keySystem;
	        } else {
	          cov_jwgp8nce4().b[25][1]++;
	        } // pass along original error object.


	        cov_jwgp8nce4().s[68]++;
	        error.originalError = objOrErr;
	      } else {
	        cov_jwgp8nce4().b[21][1]++;
	      }
	    }

	    cov_jwgp8nce4().s[69]++;

	    if (metadata) {
	      cov_jwgp8nce4().b[26][0]++;
	      cov_jwgp8nce4().s[70]++;
	      error.metadata = metadata;
	    } else {
	      cov_jwgp8nce4().b[26][1]++;
	    }

	    cov_jwgp8nce4().s[71]++;
	    player.error(error);
	  };
	};
	/**
	* Function to invoke when the player is ready.
	*
	* This is a great place for your plugin to initialize itself. When this
	* function is called, the player will have its DOM and child components
	* in place.
	*
	* @function onPlayerReady
	* @param    {Player} player
	* @param    {Function} emeError
	*/

	cov_jwgp8nce4().s[72]++;

	const onPlayerReady = (player, emeError) => {
	  cov_jwgp8nce4().f[12]++;
	  cov_jwgp8nce4().s[73]++;

	  if (player.$('.vjs-tech').tagName.toLowerCase() !== 'video') {
	    cov_jwgp8nce4().b[27][0]++;
	    cov_jwgp8nce4().s[74]++;
	    return;
	  } else {
	    cov_jwgp8nce4().b[27][1]++;
	  }

	  cov_jwgp8nce4().s[75]++;
	  setupSessions(player);
	  cov_jwgp8nce4().s[76]++;

	  if (window_1.MediaKeys) {
	    cov_jwgp8nce4().b[28][0]++;
	    cov_jwgp8nce4().s[77]++;

	    const sendMockEncryptedEvent = () => {
	      cov_jwgp8nce4().f[13]++;
	      const mockEncryptedEvent = (cov_jwgp8nce4().s[78]++, {
	        initDataType: 'cenc',
	        initData: null,
	        target: player.tech_.el_
	      });
	      cov_jwgp8nce4().s[79]++;
	      setupSessions(player);
	      cov_jwgp8nce4().s[80]++;
	      handleEncryptedEvent(player, mockEncryptedEvent, getOptions(player), player.eme.sessions, player.tech_, emeError);
	    };

	    cov_jwgp8nce4().s[81]++;

	    if (videojs__default["default"].browser.IS_FIREFOX) {
	      cov_jwgp8nce4().b[29][0]++; // Unlike Chrome, Firefox doesn't receive an `encrypted` event on
	      // replay and seek-back after content ends and `handleEncryptedEvent` is never called.
	      // So a fake encrypted event is necessary here.

	      let handled;
	      cov_jwgp8nce4().s[82]++;
	      player.on('ended', () => {
	        cov_jwgp8nce4().f[14]++;
	        cov_jwgp8nce4().s[83]++;
	        handled = false;
	        cov_jwgp8nce4().s[84]++;
	        player.one(['seek', 'play'], e => {
	          cov_jwgp8nce4().f[15]++;
	          cov_jwgp8nce4().s[85]++;

	          if ((cov_jwgp8nce4().b[31][0]++, !handled) && (cov_jwgp8nce4().b[31][1]++, player.eme.sessions.length === 0)) {
	            cov_jwgp8nce4().b[30][0]++;
	            cov_jwgp8nce4().s[86]++;
	            sendMockEncryptedEvent();
	            cov_jwgp8nce4().s[87]++;
	            handled = true;
	          } else {
	            cov_jwgp8nce4().b[30][1]++;
	          }
	        });
	      });
	      cov_jwgp8nce4().s[88]++;
	      player.on('play', () => {
	        cov_jwgp8nce4().f[16]++;
	        const options = (cov_jwgp8nce4().s[89]++, player.eme.options);
	        const limitRenewalsMaxPauseDuration = (cov_jwgp8nce4().s[90]++, options.limitRenewalsMaxPauseDuration);
	        cov_jwgp8nce4().s[91]++;

	        if ((cov_jwgp8nce4().b[33][0]++, player.eme.sessions.length === 0) && (cov_jwgp8nce4().b[33][1]++, typeof limitRenewalsMaxPauseDuration === 'number')) {
	          cov_jwgp8nce4().b[32][0]++;
	          cov_jwgp8nce4().s[92]++;
	          handled = true;
	          cov_jwgp8nce4().s[93]++;
	          sendMockEncryptedEvent();
	        } else {
	          cov_jwgp8nce4().b[32][1]++;
	        }
	      });
	    } else {
	      cov_jwgp8nce4().b[29][1]++;
	    } // Support EME 05 July 2016
	    // Chrome 42+, Firefox 47+, Edge, Safari 12.1+ on macOS 10.14+


	    cov_jwgp8nce4().s[94]++;
	    player.tech_.el_.addEventListener('encrypted', event => {
	      cov_jwgp8nce4().f[17]++;
	      cov_jwgp8nce4().s[95]++;
	      videojs__default["default"].log.debug('eme', 'Received an \'encrypted\' event');
	      cov_jwgp8nce4().s[96]++;
	      setupSessions(player);
	      cov_jwgp8nce4().s[97]++;
	      handleEncryptedEvent(player, event, getOptions(player), player.eme.sessions, player.tech_, emeError);
	    });
	  } else {
	    cov_jwgp8nce4().b[28][1]++;
	    cov_jwgp8nce4().s[98]++;

	    if (window_1.WebKitMediaKeys) {
	      cov_jwgp8nce4().b[34][0]++;
	      cov_jwgp8nce4().s[99]++;
	      player.eme.initLegacyFairplay();
	    } else {
	      cov_jwgp8nce4().b[34][1]++;
	      cov_jwgp8nce4().s[100]++;

	      if (window_1.MSMediaKeys) {
	        cov_jwgp8nce4().b[35][0]++;
	        cov_jwgp8nce4().s[101]++; // IE11 Windows 8.1+
	        // Since IE11 doesn't support promises, we have to use a combination of
	        // try/catch blocks and event handling to simulate promise rejection.
	        // Functionally speaking, there should be no discernible difference between
	        // the behavior of IE11 and those of other browsers.

	        player.tech_.el_.addEventListener('msneedkey', event => {
	          cov_jwgp8nce4().f[18]++;
	          cov_jwgp8nce4().s[102]++;
	          videojs__default["default"].log.debug('eme', 'Received an \'msneedkey\' event');
	          cov_jwgp8nce4().s[103]++;
	          setupSessions(player);
	          cov_jwgp8nce4().s[104]++;

	          try {
	            cov_jwgp8nce4().s[105]++;
	            handleMsNeedKeyEvent(event, getOptions(player), player.eme.sessions, player.tech_, emeError);
	          } catch (error) {
	            cov_jwgp8nce4().s[106]++;
	            emeError(error);
	          }
	        });
	        cov_jwgp8nce4().s[107]++;

	        const msKeyErrorCallback = error => {
	          cov_jwgp8nce4().f[19]++;
	          cov_jwgp8nce4().s[108]++;
	          emeError(error);
	        };

	        cov_jwgp8nce4().s[109]++;
	        player.tech_.on('mskeyerror', msKeyErrorCallback); // TODO: refactor this plugin so it can use a plugin dispose

	        cov_jwgp8nce4().s[110]++;
	        player.on('dispose', () => {
	          cov_jwgp8nce4().f[20]++;
	          cov_jwgp8nce4().s[111]++;
	          player.tech_.off('mskeyerror', msKeyErrorCallback);
	        });
	      } else {
	        cov_jwgp8nce4().b[35][1]++;
	      }
	    }
	  }
	};
	/**
	* A video.js plugin.
	*
	* In the plugin function, the value of `this` is a video.js `Player`
	* instance. You cannot rely on the player being in a "ready" state here,
	* depending on how the plugin is invoked. This may or may not be important
	* to you; if not, remove the wait for "ready"!
	*
	* @function eme
	* @param    {Object} [options={}]
	*           An object of options left to the plugin author to define.
	*/


	cov_jwgp8nce4().s[112]++;

	const eme = function (options = (cov_jwgp8nce4().b[36][0]++, {})) {
	  cov_jwgp8nce4().f[21]++;
	  const player = (cov_jwgp8nce4().s[113]++, this);
	  const emeError = (cov_jwgp8nce4().s[114]++, emeErrorHandler(player));
	  cov_jwgp8nce4().s[115]++;
	  player.ready(() => {
	    cov_jwgp8nce4().f[22]++;
	    cov_jwgp8nce4().s[116]++;
	    return onPlayerReady(player, emeError);
	  }); // Plugin API

	  cov_jwgp8nce4().s[117]++;
	  player.eme = {
	    /**
	    * For manual setup for eme listeners (for example: after player.reset call)
	    * basically for any cases when player.tech.el is changed
	    */
	    setupEmeListeners() {
	      cov_jwgp8nce4().f[23]++;
	      cov_jwgp8nce4().s[118]++;
	      onPlayerReady(player, emeError);
	    },

	    /**
	    * Sets up MediaKeys on demand
	    * Works around https://bugs.chromium.org/p/chromium/issues/detail?id=895449
	    *
	    * @function initializeMediaKeys
	    * @param    {Object} [emeOptions={}]
	    *           An object of eme plugin options.
	    * @param    {Function} [callback=function(){}]
	    * @param    {boolean} [suppressErrorIfPossible=false]
	    */
	    initializeMediaKeys(emeOptions = (cov_jwgp8nce4().b[37][0]++, {}), callback = (cov_jwgp8nce4().b[38][0]++, function () {
	      cov_jwgp8nce4().f[25]++;
	    }), suppressErrorIfPossible = (cov_jwgp8nce4().b[39][0]++, false)) {
	      cov_jwgp8nce4().f[24]++; // TODO: this should be refactored and renamed to be less tied
	      // to encrypted events

	      const mergedEmeOptions = (cov_jwgp8nce4().s[119]++, merge(player.currentSource(), options, emeOptions)); // fake an encrypted event for handleEncryptedEvent

	      const mockEncryptedEvent = (cov_jwgp8nce4().s[120]++, {
	        initDataType: 'cenc',
	        initData: null,
	        target: player.tech_.el_
	      });
	      cov_jwgp8nce4().s[121]++;
	      setupSessions(player);
	      cov_jwgp8nce4().s[122]++;

	      if (window_1.MediaKeys) {
	        cov_jwgp8nce4().b[40][0]++;
	        cov_jwgp8nce4().s[123]++;
	        handleEncryptedEvent(player, mockEncryptedEvent, mergedEmeOptions, player.eme.sessions, player.tech_, emeError).then(() => {
	          cov_jwgp8nce4().f[26]++;
	          cov_jwgp8nce4().s[124]++;
	          return callback();
	        }).catch(error => {
	          cov_jwgp8nce4().f[27]++;
	          cov_jwgp8nce4().s[125]++;
	          callback(error);
	          cov_jwgp8nce4().s[126]++;

	          if (!suppressErrorIfPossible) {
	            cov_jwgp8nce4().b[41][0]++;
	            cov_jwgp8nce4().s[127]++;
	            emeError(error);
	          } else {
	            cov_jwgp8nce4().b[41][1]++;
	          }
	        });
	      } else {
	        cov_jwgp8nce4().b[40][1]++;
	        cov_jwgp8nce4().s[128]++;

	        if (window_1.MSMediaKeys) {
	          cov_jwgp8nce4().b[42][0]++;
	          cov_jwgp8nce4().s[129]++;

	          const msKeyHandler = event => {
	            cov_jwgp8nce4().f[28]++;
	            cov_jwgp8nce4().s[130]++;
	            player.tech_.off('mskeyadded', msKeyHandler);
	            cov_jwgp8nce4().s[131]++;
	            player.tech_.off('mskeyerror', msKeyHandler);
	            cov_jwgp8nce4().s[132]++;

	            if (event.type === 'mskeyerror') {
	              cov_jwgp8nce4().b[43][0]++;
	              cov_jwgp8nce4().s[133]++;
	              callback(event.target.error);
	              cov_jwgp8nce4().s[134]++;

	              if (!suppressErrorIfPossible) {
	                cov_jwgp8nce4().b[44][0]++;
	                cov_jwgp8nce4().s[135]++;
	                emeError(event.message);
	              } else {
	                cov_jwgp8nce4().b[44][1]++;
	              }
	            } else {
	              cov_jwgp8nce4().b[43][1]++;
	              cov_jwgp8nce4().s[136]++;
	              callback();
	            }
	          };

	          cov_jwgp8nce4().s[137]++;
	          player.tech_.one('mskeyadded', msKeyHandler);
	          cov_jwgp8nce4().s[138]++;
	          player.tech_.one('mskeyerror', msKeyHandler);
	          cov_jwgp8nce4().s[139]++;

	          try {
	            cov_jwgp8nce4().s[140]++;
	            handleMsNeedKeyEvent(mockEncryptedEvent, mergedEmeOptions, player.eme.sessions, player.tech_, emeError);
	          } catch (error) {
	            cov_jwgp8nce4().s[141]++;
	            player.tech_.off('mskeyadded', msKeyHandler);
	            cov_jwgp8nce4().s[142]++;
	            player.tech_.off('mskeyerror', msKeyHandler);
	            cov_jwgp8nce4().s[143]++;
	            callback(error);
	            cov_jwgp8nce4().s[144]++;

	            if (!suppressErrorIfPossible) {
	              cov_jwgp8nce4().b[45][0]++;
	              cov_jwgp8nce4().s[145]++;
	              emeError(error);
	            } else {
	              cov_jwgp8nce4().b[45][1]++;
	            }
	          }
	        } else {
	          cov_jwgp8nce4().b[42][1]++;
	        }
	      }
	    },

	    initLegacyFairplay() {
	      cov_jwgp8nce4().f[29]++;
	      cov_jwgp8nce4().s[146]++;

	      const handleFn = event => {
	        cov_jwgp8nce4().f[30]++;
	        cov_jwgp8nce4().s[147]++;
	        videojs__default["default"].log.debug('eme', 'Received a \'webkitneedkey\' event'); // TODO it's possible that the video state must be cleared if reusing the same video
	        // element between sources

	        cov_jwgp8nce4().s[148]++;
	        setupSessions(player);
	        cov_jwgp8nce4().s[149]++;
	        handleWebKitNeedKeyEvent(event, getOptions(player), player.tech_, emeError).catch(error => {
	          cov_jwgp8nce4().f[31]++;
	          cov_jwgp8nce4().s[150]++;
	          emeError(error);
	        });
	      };

	      cov_jwgp8nce4().s[151]++;

	      const webkitNeedKeyEventHandler = event => {
	        cov_jwgp8nce4().f[32]++;
	        const firstWebkitneedkeyTimeout = (cov_jwgp8nce4().s[152]++, (cov_jwgp8nce4().b[46][0]++, getOptions(player).firstWebkitneedkeyTimeout) || (cov_jwgp8nce4().b[46][1]++, 1000));
	        const src = (cov_jwgp8nce4().s[153]++, player.src()); // on source change or first startup reset webkitneedkey options.

	        cov_jwgp8nce4().s[154]++;
	        player.eme.webkitneedkey_ = (cov_jwgp8nce4().b[47][0]++, player.eme.webkitneedkey_) || (cov_jwgp8nce4().b[47][1]++, {}); // if the source changed we need to handle the first event again.
	        // track source changes internally.

	        cov_jwgp8nce4().s[155]++;

	        if (player.eme.webkitneedkey_.src !== src) {
	          cov_jwgp8nce4().b[48][0]++;
	          cov_jwgp8nce4().s[156]++;
	          player.eme.webkitneedkey_ = {
	            handledFirstEvent: false,
	            src
	          };
	        } else {
	          cov_jwgp8nce4().b[48][1]++;
	        } // It's possible that at the start of playback a rendition switch
	        // on a small player in safari's HLS implementation will cause
	        // two webkitneedkey events to occur. We want to make sure to cancel
	        // our first existing request if we get another within 1 second. This
	        // prevents a non-fatal player error from showing up due to a
	        // request failure.


	        cov_jwgp8nce4().s[157]++;

	        if (!player.eme.webkitneedkey_.handledFirstEvent) {
	          cov_jwgp8nce4().b[49][0]++;
	          cov_jwgp8nce4().s[158]++; // clear the old timeout so that a new one can be created
	          // with the new rendition's event data

	          player.clearTimeout(player.eme.webkitneedkey_.timeout);
	          cov_jwgp8nce4().s[159]++;
	          player.eme.webkitneedkey_.timeout = player.setTimeout(() => {
	            cov_jwgp8nce4().f[33]++;
	            cov_jwgp8nce4().s[160]++;
	            player.eme.webkitneedkey_.handledFirstEvent = true;
	            cov_jwgp8nce4().s[161]++;
	            player.eme.webkitneedkey_.timeout = null;
	            cov_jwgp8nce4().s[162]++;
	            handleFn(event);
	          }, firstWebkitneedkeyTimeout); // after we have a verified first request, we will request on
	          // every other event like normal.
	        } else {
	          cov_jwgp8nce4().b[49][1]++;
	          cov_jwgp8nce4().s[163]++;
	          handleFn(event);
	        }
	      };

	      let videoElement = (cov_jwgp8nce4().s[164]++, player.tech_.el_); // Support Safari EME with FairPlay
	      // (also used in early Chrome or Chrome with EME disabled flag)

	      cov_jwgp8nce4().s[165]++;
	      videoElement.addEventListener('webkitneedkey', webkitNeedKeyEventHandler);
	      cov_jwgp8nce4().s[166]++;

	      const cleanupWebkitNeedKeyHandler = () => {
	        cov_jwgp8nce4().f[34]++;
	        cov_jwgp8nce4().s[167]++; // no need in auto-cleanup if manual clean is called

	        player.off('dispose', cleanupWebkitNeedKeyHandler); // check for null, if manual cleanup is called multiple times for any reason

	        cov_jwgp8nce4().s[168]++;

	        if (videoElement !== null) {
	          cov_jwgp8nce4().b[50][0]++;
	          cov_jwgp8nce4().s[169]++;
	          videoElement.removeEventListener('webkitneedkey', webkitNeedKeyEventHandler);
	        } else {
	          cov_jwgp8nce4().b[50][1]++;
	        }

	        cov_jwgp8nce4().s[170]++;
	        videoElement = null;
	      }; // auto-cleanup:


	      cov_jwgp8nce4().s[171]++;
	      player.on('dispose', cleanupWebkitNeedKeyHandler); // returning for manual cleanup

	      cov_jwgp8nce4().s[172]++;
	      return cleanupWebkitNeedKeyHandler;
	    },

	    detectSupportedCDMs,
	    options
	  };
	}; // Register the plugin with video.js.


	cov_jwgp8nce4().s[173]++;
	videojs__default["default"].registerPlugin('eme', eme); // contrib-eme specific error const

	cov_jwgp8nce4().s[174]++;
	eme.Error = Error$1; // Include the version number.

	cov_jwgp8nce4().s[175]++;
	eme.VERSION = version;

	const Player = videojs__default["default"].getComponent('Player');

	function noop() {}

	QUnit__default["default"].test('the environment is sane', function (assert) {
	  assert.strictEqual(typeof Array.isArray, 'function', 'es5 exists');
	  assert.strictEqual(typeof sinon__default["default"], 'object', 'sinon exists');
	  assert.strictEqual(typeof videojs__default["default"], 'function', 'videojs exists');
	  assert.strictEqual(typeof eme, 'function', 'plugin is a function');
	});
	QUnit__default["default"].module('videojs-contrib-eme', {
	  beforeEach() {
	    // Mock the environment's timers because certain things - particularly
	    // player readiness - are asynchronous in video.js 5. This MUST come
	    // before any player is created; otherwise, timers could get created
	    // with the actual timer methods!
	    this.clock = sinon__default["default"].useFakeTimers();
	    this.fixture = document_1.getElementById('qunit-fixture');
	    this.video = document_1.createElement('video');
	    this.fixture.appendChild(this.video);
	    this.player = videojs__default["default"](this.video);
	    this.origRequestMediaKeySystemAccess = window_1.navigator.requestMediaKeySystemAccess;

	    window_1.navigator.requestMediaKeySystemAccess = (keySystem, options) => {
	      return Promise.resolve({
	        keySystem: 'org.w3.clearkey',
	        createMediaKeys: () => {
	          return {
	            createSession: () => new videojs__default["default"].EventTarget()
	          };
	        }
	      });
	    };
	  },

	  afterEach() {
	    window_1.navigator.requestMediaKeySystemAccess = this.origRequestMediaKeySystemAccess;
	    this.clock.restore();
	  }

	});
	QUnit__default["default"].test('registers itself with video.js', function (assert) {
	  assert.strictEqual(typeof Player.prototype.eme, 'function', 'videojs-contrib-eme plugin was registered');
	});
	QUnit__default["default"].test('exposes options', function (assert) {
	  assert.notOk(this.player.eme.options, 'options is unavailable at start');
	  this.player.eme();
	  assert.deepEqual(this.player.eme.options, {}, 'options defaults to empty object once initialized');
	  this.video = document_1.createElement('video');
	  this.video.setAttribute('data-setup', JSON.stringify({
	    plugins: {
	      eme: {
	        applicationId: 'application-id',
	        publisherId: 'publisher-id'
	      }
	    }
	  }));
	  this.fixture.appendChild(this.video);
	  this.player = videojs__default["default"](this.video);
	  assert.ok(this.player.eme.options, 'exposes options');
	  assert.strictEqual(this.player.eme.options.applicationId, 'application-id', 'exposes applicationId');
	  assert.strictEqual(this.player.eme.options.publisherId, 'publisher-id', 'exposes publisherId');
	});
	QUnit__default["default"].test('exposes detectSupportedCDMs()', function (assert) {
	  assert.notOk(this.player.eme.detectSupportedCDMs, 'detectSupportedCDMs is unavailable at start');
	  this.player.eme();
	  assert.ok(this.player.eme.detectSupportedCDMs, 'detectSupportedCDMs is available after initialization');
	}); // skip test for prefix-only Safari

	if (!window_1.MediaKeys) {
	  QUnit__default["default"].test('initializeMediaKeys standard', function (assert) {
	    assert.expect(9);
	    const done = assert.async();
	    const initData = new Uint8Array([1, 2, 3]).buffer;
	    let errors = 0;
	    const options = {
	      keySystems: {
	        'org.w3.clearkey': {
	          pssh: initData
	        }
	      }
	    };

	    const callback = error => {
	      const sessions = this.player.eme.sessions;
	      assert.equal(sessions.length, 1, 'created a session when keySystems in options');
	      assert.deepEqual(sessions[0].initData, initData, 'captured initData in the session');
	      assert.equal(error, 'Error: Missing url/licenseUri or getLicense in com.widevine.alpha configuration.', 'callback receives error');
	    };

	    this.player.eme();
	    this.player.on('error', () => {
	      errors++;
	      assert.equal(errors, 1, 'error triggered only once');
	      assert.equal(this.player.error().message, 'Missing url/licenseUri or getLicense in com.widevine.alpha configuration.', 'error is called on player');
	      this.player.error(null);
	    });
	    this.player.eme.initializeMediaKeys(options, callback); // need to clear sessions to have the error trigger again

	    this.player.eme.sessions = [];
	    this.player.eme.initializeMediaKeys(options, callback, true);
	    setTimeout(() => {
	      assert.equal(this.player.error(), null, 'no error called on player with suppressError = true');
	      done();
	    });
	    this.clock.tick(1);
	  });
	}

	QUnit__default["default"].test.skip('initializeMediaKeys ms-prefix', function (assert) {
	  assert.expect(19);
	  const done = assert.async(); // stub setMediaKeys

	  const setMediaKeys = this.player.tech_.el_.setMediaKeys;
	  let throwError = true;
	  let errors = 0;
	  let keySession;
	  let errorMessage;
	  const origMediaKeys = window_1.MediaKeys;
	  const origWebKitMediaKeys = window_1.WebKitMediaKeys;
	  window_1.MediaKeys = undefined;
	  window_1.WebKitMediaKeys = undefined;

	  if (!window_1.MSMediaKeys) {
	    window_1.MSMediaKeys = function () {};
	  }

	  this.player.tech_.el_.setMediaKeys = null;

	  if (!this.player.tech_.el_.msSetMediaKeys) {
	    this.player.tech_.el_.msSetMediaKeys = () => {
	      this.player.tech_.el_.msKeys = {
	        createSession: () => {
	          if (throwError) {
	            throw new Error('error creating keySession');
	          } else {
	            keySession = new videojs__default["default"].EventTarget();
	            return keySession;
	          }
	        }
	      };
	    };
	  }

	  const initData = new Uint8Array([1, 2, 3]).buffer;
	  const options = {
	    keySystems: {
	      'com.microsoft.playready': {
	        pssh: initData
	      }
	    }
	  };

	  const callback = error => {
	    const sessions = this.player.eme.sessions;
	    assert.equal(sessions.length, 1, 'created a session when keySystems in options');
	    assert.deepEqual(sessions[0].initData, initData, 'captured initData in the session');
	    assert.notEqual(error, undefined, 'callback receives error');
	  };

	  const reset = () => {
	    this.player.eme.sessions = [];
	    keySession = null;
	  };

	  const asyncKeySessionError = () => {
	    if (keySession) {
	      // we stubbed the keySession
	      setTimeout(() => {
	        keySession.error = {
	          code: 1,
	          systemCode: 2
	        };
	        keySession.trigger({
	          target: keySession,
	          type: 'mskeyerror'
	        });
	      });
	      this.clock.tick(1);
	    }
	  };

	  this.player.eme();
	  this.player.on('error', () => {
	    errors++;
	    assert.equal(this.player.error().message, errorMessage, 'error is called on player');
	    this.player.error(null);
	  }); // sync error thrown by handleMsNeedKeyEvent

	  errorMessage = 'error creating keySession';
	  this.player.eme.initializeMediaKeys(options, callback);
	  reset();
	  this.player.eme.initializeMediaKeys(options, callback, true);
	  reset(); // async error event on key session

	  throwError = false;
	  errorMessage = 'Unexpected key error from key session with code: 1 and systemCode: 2';
	  this.player.eme.initializeMediaKeys(options, callback);
	  asyncKeySessionError();
	  reset();
	  this.player.eme.initializeMediaKeys(options, callback, true);
	  asyncKeySessionError();
	  reset();
	  setTimeout(() => {
	    // `error` will be called on the player 3 times, because a key session
	    // error can't be suppressed on IE11
	    assert.equal(errors, 5, 'error called on player 3 times');
	    assert.equal(this.player.error(), null, 'no error called on player with suppressError = true');
	    window_1.MediaKeys = origMediaKeys;
	    window_1.WebKitMediaKeys = origWebKitMediaKeys;
	    done();
	  });
	  this.clock.tick(1);
	  this.player.tech_.el_.msSetMediaKeys = null;
	  this.player.tech_.el_.setMediaKeys = setMediaKeys;
	});
	QUnit__default["default"].test('tech error listener is removed on dispose', function (assert) {
	  const done = assert.async(1);
	  let called = 0;
	  const origMediaKeys = window_1.MediaKeys;
	  const origWebKitMediaKeys = window_1.WebKitMediaKeys;
	  window_1.MediaKeys = undefined;
	  window_1.WebKitMediaKeys = undefined;

	  if (!window_1.MSMediaKeys) {
	    window_1.MSMediaKeys = noop.bind(this);
	  }

	  this.player.error = error => {
	    assert.equal(error.originalError.type, 'mskeyerror', 'is expected error type');
	    called++;
	  };

	  this.player.eme();
	  this.player.ready(() => {
	    assert.equal(called, 0, 'never called');
	    this.player.tech_.trigger('mskeyerror');
	    assert.equal(called, 1, 'called once');
	    this.player.dispose();
	    this.player.tech_.trigger('mskeyerror');
	    assert.equal(called, 1, 'not called after player disposal');
	    this.player.error = undefined;
	    window_1.MediaKeys = origMediaKeys;
	    window_1.WebKitMediaKeys = origWebKitMediaKeys;
	    done();
	  });
	  this.clock.tick(1);
	});
	QUnit__default["default"].test('only registers for spec-compliant events even if legacy APIs are available', function (assert) {
	  const done = assert.async(1);
	  const origMediaKeys = window_1.MediaKeys;
	  const origMSMediaKeys = window_1.MSMediaKeys;
	  const origWebKitMediaKeys = window_1.WebKitMediaKeys;
	  const events = {
	    encrypted: 0,
	    msneedkey: 0,
	    webkitneedkey: 0
	  };
	  this.player.tech_.el_ = {
	    addEventListener: e => events[e]++,
	    hasAttribute: () => false
	  };
	  window_1.MediaKeys = noop;
	  window_1.MSMediaKeys = noop;
	  window_1.WebKitMediaKeys = noop;
	  this.player.eme();
	  this.player.ready(() => {
	    assert.equal(events.encrypted, 1, 'registers for encrypted events');
	    assert.equal(events.msneedkey, 0, "doesn't register for msneedkey events");
	    assert.equal(events.webkitneedkey, 0, "doesn't register for webkitneedkey events");
	    window_1.MediaKeys = origMediaKeys;
	    window_1.MSMediaKeys = origMSMediaKeys;
	    window_1.WebKitMediaKeys = origWebKitMediaKeys;
	    done();
	  });
	  this.clock.tick(1);
	});
	QUnit__default["default"].module('plugin guard functions', {
	  beforeEach() {
	    this.fixture = document_1.getElementById('qunit-fixture');
	    this.video = document_1.createElement('video');
	    this.fixture.appendChild(this.video);
	    this.player = videojs__default["default"](this.video);
	    this.options = {
	      keySystems: {
	        'org.w3.clearkey': {
	          url: 'some-url'
	        }
	      }
	    };
	    this.origXhr = videojs__default["default"].xhr;

	    videojs__default["default"].xhr = (params, callback) => {
	      return callback(null, {
	        statusCode: 200
	      }, new Uint8Array([0, 1, 2, 3]).buffer);
	    };

	    this.initData1 = new Uint8Array([1, 2, 3]).buffer;
	    this.initData2 = new Uint8Array([4, 5, 6]).buffer;
	    this.event1 = {
	      // mock video target to prevent errors since it's a pain to mock out the continuation
	      // of functionality on a successful pass through of the guards
	      target: {},
	      initData: this.initData1
	    };
	    this.event2 = {
	      target: {},
	      initData: this.initData2
	    };

	    if (!window_1.MSMediaKeys) {
	      window_1.MSMediaKeys = noop.bind(this);
	    }

	    if (!window_1.WebKitMediaKeys) {
	      window_1.WebKitMediaKeys = noop.bind(this);
	    }

	    this.origRequestMediaKeySystemAccess = window_1.navigator.requestMediaKeySystemAccess;

	    window_1.navigator.requestMediaKeySystemAccess = (keySystem, options) => {
	      return Promise.resolve({
	        keySystem: 'org.w3.clearkey',
	        createMediaKeys: () => {
	          return {
	            createSession: () => new videojs__default["default"].EventTarget()
	          };
	        }
	      });
	    };
	  },

	  afterEach() {
	    window_1.navigator.requestMediaKeySystemAccess = this.origRequestMediaKeySystemAccess;
	    videojs__default["default"].xhr = this.origXhr;
	  }

	});
	QUnit__default["default"].test('handleEncryptedEvent checks for required options', function (assert) {
	  const done = assert.async();
	  const sessions = [];
	  handleEncryptedEvent(this.player, this.event1, {}, sessions).then(() => {
	    assert.equal(sessions.length, 0, 'did not create a session when no options');
	    done();
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent checks for legacy fairplay', function (assert) {
	  const done = assert.async();
	  const sessions = [];
	  const options = {
	    keySystems: {
	      'com.apple.fps.1_0': {
	        url: 'some-url'
	      }
	    }
	  };
	  handleEncryptedEvent(this.player, this.event1, options, sessions).then(() => {
	    assert.equal(sessions.length, 0, 'did not create a session when no options');
	    done();
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent checks for required init data', function (assert) {
	  const done = assert.async();
	  const sessions = [];
	  handleEncryptedEvent(this.player, {
	    target: {},
	    initData: null
	  }, this.options, sessions).then(() => {
	    assert.equal(sessions.length, 0, 'did not create a session when no init data');
	    done();
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent creates session', function (assert) {
	  const done = assert.async();
	  const sessions = []; // testing the rejection path because this isn't a real session

	  handleEncryptedEvent(this.player, this.event1, this.options, sessions).catch(() => {
	    assert.equal(sessions.length, 1, 'created a session when keySystems in options');
	    assert.equal(sessions[0].initData, this.initData1, 'captured initData in the session');
	    done();
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent creates new session for new init data', function (assert) {
	  const done = assert.async();
	  const sessions = []; // testing the rejection path because this isn't a real session

	  handleEncryptedEvent(this.player, this.event1, this.options, sessions).catch(() => {
	    return handleEncryptedEvent(this.player, this.event2, this.options, sessions).catch(() => {
	      assert.equal(sessions.length, 2, 'created a new session when new init data');
	      assert.equal(sessions[0].initData, this.initData1, 'retained session init data');
	      assert.equal(sessions[1].initData, this.initData2, 'added new session init data');
	      done();
	    });
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent doesn\'t create duplicate sessions', function (assert) {
	  const done = assert.async();
	  const sessions = []; // testing the rejection path because this isn't a real session

	  handleEncryptedEvent(this.player, this.event1, this.options, sessions).catch(() => {
	    return handleEncryptedEvent(this.player, this.event2, this.options, sessions).catch(() => {
	      return handleEncryptedEvent(this.player, this.event2, this.options, sessions).then(() => {
	        assert.equal(sessions.length, 2, 'no new session when same init data');
	        assert.equal(sessions[0].initData, this.initData1, 'retained session init data');
	        assert.equal(sessions[1].initData, this.initData2, 'retained session init data');
	        done();
	      });
	    });
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent uses predefined init data', function (assert) {
	  const done = assert.async();
	  const options = {
	    keySystems: {
	      'org.w3.clearkey': {
	        pssh: this.initData1
	      }
	    }
	  };
	  const sessions = []; // testing the rejection path because this isn't a real session

	  handleEncryptedEvent(this.player, this.event2, options, sessions).catch(() => {
	    assert.equal(sessions.length, 1, 'created a session when keySystems in options');
	    assert.deepEqual(sessions[0].initData, this.initData1, 'captured initData in the session');
	    done();
	  });
	});
	QUnit__default["default"].test('handleEncryptedEvent called explicitly on replay or seekback after `ended` if browser is Firefox ', function (assert) {
	  const done = assert.async();
	  this.clock = sinon__default["default"].useFakeTimers();
	  videojs__default["default"].browser = {
	    IS_FIREFOX: true
	  };
	  this.player.eme();
	  this.player.trigger('ready');
	  this.player.trigger('play');
	  handleEncryptedEvent = sinon__default["default"].spy();
	  this.clock.tick(1);
	  this.player.trigger('ended');
	  this.clock.tick(1);
	  this.player.trigger('play');
	  assert.ok(handleEncryptedEvent.calledOnce, 'HandleEncryptedEvent called if play fires after ended');
	  handleEncryptedEvent.resetHistory();
	  this.player.trigger('ended');
	  this.player.trigger('seek');
	  assert.ok(handleEncryptedEvent.calledOnce, 'HandleEncryptedEvent called if seek fires after ended');
	  handleEncryptedEvent.resetHistory();
	  this.player.trigger('ended');
	  this.player.trigger('seek');
	  this.player.eme.sessions.push({});
	  this.player.trigger('play');
	  assert.ok(handleEncryptedEvent.calledOnce, 'HandleEncryptedEvent only called once if seek and play both fire after ended');
	  handleEncryptedEvent.resetHistory();
	  sinon__default["default"].restore();
	  done();
	});
	QUnit__default["default"].test('handleMsNeedKeyEvent uses predefined init data', function (assert) {
	  const options = {
	    keySystems: {
	      'com.microsoft.playready': {
	        pssh: this.initData1
	      }
	    }
	  };
	  const sessions = [];
	  this.event2.target = {
	    msSetMediaKeys: () => {
	      this.event2.target.msKeys = {
	        createSession: () => new videojs__default["default"].EventTarget()
	      };
	    }
	  };
	  handleMsNeedKeyEvent(this.event2, options, sessions, getMockEventBus());
	  assert.equal(sessions.length, 1, 'created a session when keySystems in options');
	  assert.deepEqual(sessions[0].initData, this.initData1, 'captured initData in the session');
	  this.event2.target = {};
	});
	QUnit__default["default"].test('handleMsNeedKeyEvent checks for required options', function (assert) {
	  const event = {
	    initData: new Uint8Array([1, 2, 3]),
	    // mock video target to prevent errors since it's a pain to mock out the continuation
	    // of functionality on a successful pass through of the guards
	    target: {
	      msSetMediaKeys() {
	        this.msKeys = {
	          createSession: () => new videojs__default["default"].EventTarget()
	        };
	      }

	    }
	  };
	  let options = {};
	  const sessions = [];
	  const mockEventBus = getMockEventBus();
	  handleMsNeedKeyEvent(event, options, sessions, mockEventBus);
	  assert.equal(sessions.length, 0, 'no session created when no options');
	  options = {
	    keySystems: {}
	  };
	  handleMsNeedKeyEvent(event, options, sessions, mockEventBus);
	  assert.equal(sessions.length, 0, 'no session created when no PlayReady key system');
	  options = {
	    keySystems: {
	      'com.microsoft.notplayready': true
	    }
	  };
	  handleMsNeedKeyEvent(event, options, sessions, mockEventBus);
	  assert.equal(sessions.length, 0, 'no session created when no proper PlayReady key system');
	  options = {
	    keySystems: {
	      'com.microsoft.playready': true
	    }
	  };
	  handleMsNeedKeyEvent(event, options, sessions, mockEventBus);
	  assert.equal(sessions.length, 1, 'session created');
	  assert.ok(sessions[0].playready, 'created a PlayReady session');
	  const createdSession = sessions[0]; // even when there's new init data, we should not create a new session

	  event.initData = new Uint8Array([4, 5, 6]);
	  handleMsNeedKeyEvent(event, options, sessions, mockEventBus);
	  assert.equal(sessions.length, 1, 'no new session created');
	  assert.equal(sessions[0], createdSession, 'did not replace session');
	});
	QUnit__default["default"].test('handleMsNeedKeyEvent checks for required init data', function (assert) {
	  const event = {
	    // mock video target to prevent errors since it's a pain to mock out the continuation
	    // of functionality on a successful pass through of the guards
	    target: {},
	    initData: null
	  };
	  const options = {
	    keySystems: {
	      'com.microsoft.playready': true
	    }
	  };
	  const sessions = [];
	  handleMsNeedKeyEvent(event, options, sessions, getMockEventBus());
	  assert.equal(sessions.length, 0, 'no session created when no init data');
	});
	QUnit__default["default"].test('handleWebKitNeedKeyEvent checks for required options', function (assert) {
	  const event = {
	    initData: new Uint8Array([1, 2, 3, 4]),
	    target: {
	      webkitSetMediaKeys: noop
	    }
	  };
	  const done = assert.async(4);
	  let options = {};
	  handleWebKitNeedKeyEvent(event, options).then(val => {
	    assert.equal(val, undefined, 'resolves an empty promise when no options');
	    done();
	  });
	  options = {
	    keySystems: {}
	  };
	  handleWebKitNeedKeyEvent(event, options, {}, () => {}).then(val => {
	    assert.equal(val, undefined, 'resolves an empty promise when no FairPlay key system');
	    done();
	  });
	  options = {
	    keySystems: {
	      'com.apple.notfps.1_0': {}
	    }
	  };
	  handleWebKitNeedKeyEvent(event, options, {}, () => {}).then(val => {
	    assert.equal(val, undefined, 'resolves an empty promise when no proper FairPlay key system');
	    done();
	  });
	  options = {
	    keySystems: {
	      'com.apple.fps.1_0': {}
	    }
	  };
	  const promise = handleWebKitNeedKeyEvent(event, options, {}, () => {});
	  promise.catch(err => {
	    assert.equal(err, 'Could not create key session', 'expected error message');
	    done();
	  });
	  assert.ok(promise, 'returns promise when proper FairPlay key system');
	});
	QUnit__default["default"].test('handleWebKitNeedKeyEvent checks for required init data', function (assert) {
	  const done = assert.async();
	  const event = {
	    initData: null
	  };
	  const options = {
	    keySystems: {
	      'com.apple.fps.1_0': {}
	    }
	  };
	  handleWebKitNeedKeyEvent(event, options).then(val => {
	    assert.equal(val, undefined, 'resolves an empty promise when no init data');
	    done();
	  });
	});
	QUnit__default["default"].module('plugin isolated functions');
	QUnit__default["default"].test('hasSession determines if a session exists', function (assert) {
	  // cases in spec (where initData should always be an ArrayBuffer)
	  const initData = new Uint8Array([1, 2, 3]).buffer;
	  assert.notOk(hasSession([], initData), 'false when no sessions');
	  assert.ok(hasSession([{
	    initData
	  }], initData), 'true when initData is present in a session');
	  assert.ok(hasSession([{}, {
	    initData: new Uint8Array([1, 2, 3]).buffer
	  }], initData), 'true when same initData contents present in a session');
	  assert.notOk(hasSession([{
	    initData: new Uint8Array([1, 2]).buffer
	  }], initData), 'false when initData contents not present in a session'); // cases outside of spec (where initData is not always an ArrayBuffer)

	  assert.ok(hasSession([{
	    initData: new Uint8Array([1, 2, 3])
	  }], initData), 'true even if session initData is a typed array and initData is an ArrayBuffer');
	  assert.ok(hasSession([{
	    initData: new Uint8Array([1, 2, 3]).buffer
	  }], new Uint8Array([1, 2, 3])), 'true even if session initData is an ArrayBuffer and initData is a typed array');
	  assert.ok(hasSession([{
	    initData: new Uint8Array([1, 2, 3])
	  }], new Uint8Array([1, 2, 3])), 'true even if both session initData and initData are typed arrays');
	});
	QUnit__default["default"].test('setupSessions sets up sessions for new sources', function (assert) {
	  // mock the player with an eme plugin object attached to it
	  let src = 'some-src';
	  const player = {
	    eme: {},
	    src: () => src
	  };
	  setupSessions(player);
	  assert.ok(Array.isArray(player.eme.sessions), 'creates a sessions array when none exist');
	  assert.equal(player.eme.sessions.length, 0, 'sessions array is empty');
	  assert.equal(player.eme.activeSrc, 'some-src', 'set activeSrc property');
	  setupSessions(player);
	  assert.equal(player.eme.sessions.length, 0, 'sessions array is still empty');
	  assert.equal(player.eme.activeSrc, 'some-src', 'activeSrc property did not change');
	  player.eme.sessions.push({});
	  src = 'other-src';
	  setupSessions(player);
	  assert.equal(player.eme.sessions.length, 0, 'sessions array reset');
	  assert.equal(player.eme.activeSrc, 'other-src', 'activeSrc property changed');
	  player.eme.sessions.push({});
	  setupSessions(player);
	  assert.equal(player.eme.sessions.length, 1, 'sessions array unchanged');
	  assert.equal(player.eme.activeSrc, 'other-src', 'activeSrc property unchanged');
	});
	QUnit__default["default"].test('getOptions prioritizes eme options over source options', function (assert) {
	  const player = {
	    eme: {
	      options: {
	        keySystems: {
	          keySystem1: {
	            audioContentType: 'audio-content-type',
	            videoContentType: 'video-content-type'
	          },
	          keySystem3: {
	            licenseUrl: 'license-url-3'
	          }
	        },
	        extraOption: 'extra-option'
	      }
	    },

	    currentSource() {
	      return {
	        keySystems: {
	          keySystem1: {
	            licenseUrl: 'license-url-1',
	            videoContentType: 'source-video-content-type'
	          },
	          keySystem2: {
	            licenseUrl: 'license-url-2'
	          }
	        },
	        type: 'application/dash+xml'
	      };
	    }

	  };
	  assert.deepEqual(getOptions(player), {
	    keySystems: {
	      keySystem1: {
	        audioContentType: 'audio-content-type',
	        videoContentType: 'video-content-type',
	        licenseUrl: 'license-url-1'
	      },
	      keySystem2: {
	        licenseUrl: 'license-url-2'
	      },
	      keySystem3: {
	        licenseUrl: 'license-url-3'
	      }
	    },
	    type: 'application/dash+xml',
	    extraOption: 'extra-option'
	  }, 'updates source options with eme options');
	});
	QUnit__default["default"].test('removeSession removes sessions', function (assert) {
	  const initData1 = new Uint8Array([1, 2, 3]);
	  const initData2 = new Uint8Array([2, 3, 4]);
	  const initData3 = new Uint8Array([3, 4, 5]);
	  const sessions = [{
	    initData: initData1
	  }, {
	    initData: initData2
	  }, {
	    initData: initData3
	  }];
	  removeSession(sessions, initData2);
	  assert.deepEqual(sessions, [{
	    initData: initData1
	  }, {
	    initData: initData3
	  }], 'removed session with initData');
	  removeSession(sessions, null);
	  assert.deepEqual(sessions, [{
	    initData: initData1
	  }, {
	    initData: initData3
	  }], 'does nothing when passed null');
	  removeSession(sessions, new Uint8Array([6, 7, 8]));
	  assert.deepEqual(sessions, [{
	    initData: initData1
	  }, {
	    initData: initData3
	  }], 'does nothing when passed non-matching initData');
	  removeSession(sessions, new Uint8Array([1, 2, 3]));
	  assert.deepEqual(sessions, [{
	    initData: initData1
	  }, {
	    initData: initData3
	  }], 'did not remove session because initData is not the same reference');
	  removeSession(sessions, initData1);
	  assert.deepEqual(sessions, [{
	    initData: initData3
	  }], 'removed session with initData');
	  removeSession(sessions, initData3);
	  assert.deepEqual(sessions, [], 'removed session with initData');
	  removeSession(sessions, initData2);
	  assert.deepEqual(sessions, [], 'does nothing when no sessions');
	});
	QUnit__default["default"].test('emeError properly handles various parameter types', function (assert) {
	  let errorObj;
	  const player = {
	    tech_: {
	      el_: new videojs__default["default"].EventTarget()
	    },
	    error: obj => {
	      errorObj = obj;
	    }
	  };
	  const emeError = emeErrorHandler(player);
	  emeError(undefined);
	  assert.equal(errorObj.message, null, 'null error message');
	  emeError({});
	  assert.equal(errorObj.message, null, 'null error message');
	  emeError(new Error('some error'));
	  assert.equal(errorObj.message, 'some error', 'use error text when error');
	  emeError('some string');
	  assert.equal(errorObj.message, 'some string', 'use string when string');
	  emeError({
	    type: 'mskeyerror',
	    message: 'some event'
	  });
	  assert.equal(errorObj.message, 'some event', 'use message property when object has it');
	  const metadata = {
	    errorType: 'foo',
	    keySystem: 'bar',
	    config: {
	      'com.apple.fps.1_0': {
	        certificateUri: 'foo.bar.certificate',
	        licenseUri: 'bar.foo.license'
	      }
	    }
	  };
	  const errorString = 'string error';
	  emeError(errorString, metadata);
	  assert.equal(errorObj.message, errorString, 'error message is expected value');
	  assert.equal(errorObj.metadata, metadata, 'metadata object is expected value');
	  const mockErrorObject = {
	    type: 'foo',
	    message: errorString
	  };
	  emeError(mockErrorObject, metadata);
	  assert.equal(errorObj.originalError, mockErrorObject, 'originalError object is added to new errorObject');
	  assert.equal(errorObj.message, errorString, 'error message is expected value');
	  assert.equal(errorObj.metadata, metadata, 'metadata object is expected value');
	});

	const license = 'this is a license';
	const challengeElement = `
  <?xml version="1.0" encoding="utf-8"?>
  <soap:Envelope
    xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema">
    <soap:Body>
      <AcquireLicenseResponse xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols">
        <AcquireLicenseResult>
          <Response xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols/messages">
            <LicenseResponse xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols">
              <Version>1</Version>
              <Licenses>
                <License>${license}</License>
              </Licenses>
            </LicenseResponse>
          </Response>
        </AcquireLicenseResult>
      </AcquireLicenseResponse>
    </soap:Body>
  </soap:Envelope>`;
	const defaultHeaders = [{
	  name: 'Content-Type',
	  value: 'text/xml; charset=utf-8'
	}, {
	  name: 'SOAPAction',
	  value: '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	}];

	const createHeaders = headers => {
	  return headers.reduce((acc, header) => {
	    return acc + `
      <HttpHeader>
        <name>${header.name}</name>
        <value>${header.value}</value>
      </HttpHeader>
    `;
	  }, '');
	};

	const createMessageBuffer = headers => {
	  headers = headers || defaultHeaders; // can't use TextEncoder because Safari doesn't support it

	  return stringToArrayBuffer(`
    <PlayReadyKeyMessage type="LicenseAcquisition">
      <LicenseAcquisition Version="1">
        <Challenge encoding="base64encoded">${window_1.btoa(challengeElement)}</Challenge>
        <HttpHeaders>${createHeaders(headers)}</HttpHeaders>
      </LicenseAcquisition>
    </PlayReadyKeyMessage>`);
	};
	const unwrappedPlayreadyMessage = `
<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <AcquireLicense xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols">
      <challenge>
        <Challenge xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols/messages">
          <LA xmlns="http://schemas.microsoft.com/DRM/2007/03/protocols" Id="SignedData" xml:space="preserve"><Version>1</Version><ContentHeader><WRMHEADER xmlns="http://schemas.microsoft.com/DRM/2007/03/PlayReadyHeader" version="4.0.0.0"><DATA><PROTECTINFO><KEYLEN>16</KEYLEN><ALGID>AESCTR</ALGID></PROTECTINFO><KID>U24lieXb6USvujjSyhfRdg==</KID><CHECKSUM>TKWDEqady2g=</CHECKSUM><LA_URL>https://foo.bar.license</LA_URL></DATA></WRMHEADER></ContentHeader><CLIENTINFO><CLIENTVERSION>4.2.0.5545</CLIENTVERSION></CLIENTINFO><RevocationLists><RevListInfo><ListID>ioydTlK2p0WXkWklprR5Hw==</ListID><Version>13</Version></RevListInfo><RevListInfo><ListID>Ef/RUojT3U6Ct2jqTCChbA==</ListID><Version>68</Version></RevListInfo></RevocationLists><LicenseNonce>U9WysleTindM/gVQyExDdw==</LicenseNonce><ClientTime>1706149441</ClientTime> <EncryptedData xmlns="http://www.w3.org/2001/04/xmlenc#" Type="http://www.w3.org/2001/04/xmlenc#Element"><EncryptionMethod Algorithm="http://www.w3.org/2001/04/xmlenc#aes128-cbc"></EncryptionMethod><KeyInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><EncryptedKey xmlns="http://www.w3.org/2001/04/xmlenc#"><EncryptionMethod Algorithm="http://schemas.microsoft.com/DRM/2007/03/protocols#ecc256"></EncryptionMethod><KeyInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><KeyName>WMRMServer</KeyName></KeyInfo><CipherData><CipherValue>barfoobarfoo</CipherValue></CipherData></EncryptedKey></KeyInfo><CipherData><CipherValue>foocipherbarcipher</CipherValue></CipherData></EncryptedData></LA>
          <Signature xmlns="http://www.w3.org/2000/09/xmldsig#">
            <SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#">
              <CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod>
              <SignatureMethod Algorithm="http://schemas.microsoft.com/DRM/2007/03/protocols#ecdsa-sha256"></SignatureMethod>
              <Reference URI="#SignedData">
                <DigestMethod Algorithm="http://schemas.microsoft.com/DRM/2007/03/protocols#sha256"></DigestMethod>
                <DigestValue>FL7P8/ITc+xFvUeoyMRq2JnNbJuhhKINsXtdDuM1Y78=</DigestValue>
              </Reference>
            </SignedInfo>
            <SignatureValue>Ocy3UTUu52QI0MIzdftANLQgJM3SsP6E2XvPlKYzQBtvscJbm/uTi38zrfY2RBU3FJZLtcj0O72lb5Mq5/CNJA==</SignatureValue>
            <KeyInfo xmlns="http://www.w3.org/2000/09/xmldsig#">
              <KeyValue>
                <ECCKeyValue>
                  <PublicKey>nxbw6pwjF4fF5sEqM23KU54ifXrRvejWK5GVdjdzCMY3dvjdp7Ho5h5YiZ34xOSAUHJsZwa4DW+P6XFIDauDzg==</PublicKey>
                </ECCKeyValue>
              </KeyValue>
            </KeyInfo>
          </Signature>
        </Challenge>
      </challenge>
    </AcquireLicense>
  </soap:Body>
</soap:Envelope>
`;

	QUnit__default["default"].module('videojs-contrib-eme ms-prefixed', {
	  beforeEach() {
	    this.origMSMediaKeys = window_1.MSMediaKeys;

	    window_1.MSMediaKeys = function () {};

	    const session = new videojs__default["default"].EventTarget();
	    session.keys = [];

	    session.update = key => session.keys.push(key); // mock the video since the APIs won't be available on non IE11 browsers


	    const video = {
	      msSetMediaKeys: () => {
	        video.msKeys = {
	          createSession: () => this.session
	        };
	      }
	    };
	    this.session = session;
	    this.video = video;
	  },

	  afterEach() {
	    window_1.MSMediaKeys = this.origMSMediaKeys;
	  }

	});
	QUnit__default["default"].test('overwrites msKeys', function (assert) {
	  const origMsKeys = {};
	  this.video.msKeys = origMsKeys;
	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': true
	      }
	    },
	    eventBus: getMockEventBus()
	  });
	  assert.notEqual(this.video.msKeys, origMsKeys, 'overwrote msKeys');
	});
	QUnit__default["default"].test('error thrown when creating keys bubbles up', function (assert) {
	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'errorType is expected value');
	  };

	  window_1.MSMediaKeys = function () {
	    throw new Error('error');
	  };

	  assert.throws(() => msPrefixed({
	    video: this.video,
	    emeError
	  }), new Error('Unable to create media keys for PlayReady key system. Error: error'), 'error is thrown with proper message');
	});
	QUnit__default["default"].test('createSession throws unknown error', function (assert) {
	  const video = {
	    msSetMediaKeys: () => {
	      video.msKeys = {
	        createSession: () => {
	          throw new Error('whatever');
	        }
	      };
	    }
	  };
	  assert.throws(() => msPrefixed({
	    video
	  }), new Error('whatever'), 'error is thrown with proper message');
	});
	QUnit__default["default"].test('throws error if session was not created', function (assert) {
	  const video = {
	    msSetMediaKeys: () => {
	      video.msKeys = {
	        createSession: () => null
	      };
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeySession, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'errorType is expected value');
	  };

	  assert.throws(() => msPrefixed({
	    video,
	    emeError
	  }), new Error('Could not create key session.'), 'error is thrown with proper message');
	});
	QUnit__default["default"].test('throws error on keysession mskeyerror event', function (assert) {
	  let errorMessage;

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeySession, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': true
	      }
	    },
	    eventBus: {
	      trigger: event => {
	        errorMessage = typeof event === 'string' ? event : event.message;
	      },
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError
	  });
	  this.session.error = {
	    code: 5,
	    systemCode: 9
	  };
	  this.session.trigger('mskeyerror');
	  assert.equal(errorMessage, 'Unexpected key error from key session with code: 5 and systemCode: 9', 'error is thrown with proper message');
	});
	QUnit__default["default"].test('calls getKey when provided on key message', function (assert) {
	  let passedOptions = null;
	  let passedDestinationURL = null;
	  let passedBuffer = null;
	  let passedCallback = null;

	  let getKeyCallback = callback => {
	    callback(null, 'a key');
	  };

	  let errorMessage;
	  const emeOptions = {
	    keySystems: {
	      'com.microsoft.playready': {
	        getKey: (options, destinationURL, buffer, callback) => {
	          passedOptions = options;
	          passedDestinationURL = destinationURL;
	          passedBuffer = buffer;
	          passedCallback = callback;
	          getKeyCallback(callback);
	        }
	      }
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToRequestMediaKeySystemAccess, 'errorType is expected value');
	    assert.deepEqual(metadata.config, [{}], 'keySystem is expected value');
	  };

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: emeOptions,
	    eventBus: {
	      trigger: event => {
	        errorMessage = typeof event === 'string' ? event : event.message;
	      },
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError
	  });
	  assert.notOk(passedOptions, 'getKey not called');
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'url',
	    message: {
	      buffer: 'buffer'
	    }
	  });
	  assert.equal(passedOptions, emeOptions, 'getKey called with options');
	  assert.equal(passedDestinationURL, 'url', 'getKey called with destinationURL');
	  assert.equal(passedBuffer, 'buffer', 'getKey called with buffer');
	  assert.equal(typeof passedCallback, 'function', 'getKey called with callback');
	  assert.equal(this.session.keys.length, 1, 'added key to session');
	  assert.equal(this.session.keys[0], 'a key', 'added correct key to session');

	  getKeyCallback = callback => {
	    callback('an error', 'an errored key');
	  };

	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'url',
	    message: {
	      buffer: 'buffer'
	    }
	  });
	  assert.equal(errorMessage, 'Unable to get key: an error', 'fires mskeyerror on eventBus when callback has an error');
	  assert.equal(this.session.keys.length, 1, 'did not add a new key');
	});
	QUnit__default["default"].test('makes request when nothing provided on key message', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  let errorMessage;

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToGenerateLicenseRequest, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  videojs__default["default"].xhr = (config, callback) => xhrCalls.push({
	    config,
	    callback
	  });

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': true
	      }
	    },
	    eventBus: {
	      trigger: event => {
	        if (typeof event === 'object' && event.type === 'mskeyerror') {
	          errorMessage = event.message;
	        }
	      },
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError
	  });
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'destination-url',
	    message: {
	      buffer: createMessageBuffer()
	    }
	  });
	  assert.equal(xhrCalls.length, 1, 'one xhr request');
	  assert.equal(xhrCalls[0].config.uri, 'destination-url', 'made request to destinationURL');
	  assert.deepEqual(xhrCalls[0].config.headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'uses headers from message');
	  assert.equal(xhrCalls[0].config.body, challengeElement, 'sends the challenge element');
	  assert.equal(xhrCalls[0].config.method, 'post', 'request is a post');
	  assert.equal(xhrCalls[0].config.responseType, 'arraybuffer', 'responseType is an arraybuffer');
	  const response = {
	    body: stringToArrayBuffer('key value')
	  };
	  xhrCalls[0].callback('an error', response, response.body);
	  assert.equal(errorMessage, 'Unable to request key from url: destination-url', 'triggers mskeyerror on event bus when callback has an error');
	  assert.equal(this.session.keys.length, 0, 'no key added to session');
	  xhrCalls[0].callback(null, response, response.body);
	  assert.equal(this.session.keys.length, 1, 'key added to session');
	  assert.deepEqual(this.session.keys[0], new Uint8Array(response.body), 'correct key added to session');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('makes request on key message when empty object provided in options', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];

	  videojs__default["default"].xhr = (config, callback) => xhrCalls.push({
	    config,
	    callback
	  });

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': {}
	      }
	    },
	    eventBus: getMockEventBus()
	  });
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'destination-url',
	    message: {
	      buffer: createMessageBuffer()
	    }
	  });
	  assert.equal(xhrCalls.length, 1, 'one xhr request');
	  assert.equal(xhrCalls[0].config.uri, 'destination-url', 'made request to destinationURL');
	  assert.deepEqual(xhrCalls[0].config.headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'uses headers from message');
	  assert.equal(xhrCalls[0].config.body, challengeElement, 'sends the challenge element');
	  assert.equal(xhrCalls[0].config.method, 'post', 'request is a post');
	  assert.equal(xhrCalls[0].config.responseType, 'arraybuffer', 'responseType is an arraybuffer');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('makes request with provided url string on key message', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  let errorMessage;

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToGenerateLicenseRequest, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  videojs__default["default"].xhr = (config, callback) => xhrCalls.push({
	    config,
	    callback
	  });

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': 'provided-url'
	      }
	    },
	    eventBus: {
	      trigger: event => {
	        if (typeof event === 'object' && event.type === 'mskeyerror') {
	          errorMessage = event.message;
	        }
	      },
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError
	  });
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'destination-url',
	    message: {
	      buffer: createMessageBuffer([{
	        name: 'Content-Type',
	        value: 'text/xml; charset=utf-8'
	      }, {
	        name: 'SOAPAction',
	        value: '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	      }])
	    }
	  });
	  assert.equal(xhrCalls.length, 1, 'one xhr request');
	  assert.equal(xhrCalls[0].config.uri, 'provided-url', 'made request to provided-url');
	  assert.deepEqual(xhrCalls[0].config.headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'uses headers from message');
	  assert.equal(xhrCalls[0].config.body, challengeElement, 'sends the challenge element');
	  assert.equal(xhrCalls[0].config.method, 'post', 'request is a post');
	  assert.equal(xhrCalls[0].config.responseType, 'arraybuffer', 'responseType is an arraybuffer');
	  const response = {
	    body: stringToArrayBuffer('key value')
	  };
	  xhrCalls[0].callback('an error', response, response.body);
	  assert.equal(errorMessage, 'Unable to request key from url: provided-url', 'triggers mskeyerror on event bus when callback has an error');
	  assert.equal(this.session.keys.length, 0, 'no key added to session');
	  xhrCalls[0].callback(null, response, response.body);
	  assert.equal(this.session.keys.length, 1, 'key added to session');
	  assert.deepEqual(this.session.keys[0], new Uint8Array(response.body), 'correct key added to session');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('makes request with provided url on key message', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const xhrCalls = [];
	  const callCounts = {
	    licenseRequestAttempts: 0
	  };
	  let errorMessage;

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToGenerateLicenseRequest, 'errorType is expected value');
	    assert.equal(metadata.keySystem, PLAYREADY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  videojs__default["default"].xhr = (config, callback) => xhrCalls.push({
	    config,
	    callback
	  });

	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': {
	          url: 'provided-url'
	        }
	      }
	    },
	    eventBus: {
	      trigger: event => {
	        if (event.type === 'licenserequestattempted') {
	          callCounts.licenseRequestAttempts++;
	        } else if (typeof event === 'object' && event.type === 'mskeyerror') {
	          errorMessage = event.message;
	        }
	      },
	      isDisposed: () => {
	        return false;
	      }
	    },
	    emeError
	  });
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'destination-url',
	    message: {
	      buffer: createMessageBuffer([{
	        name: 'Content-Type',
	        value: 'text/xml; charset=utf-8'
	      }, {
	        name: 'SOAPAction',
	        value: '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	      }])
	    }
	  });
	  assert.equal(xhrCalls.length, 1, 'one xhr request');
	  assert.equal(xhrCalls[0].config.uri, 'provided-url', 'made request to provided-url');
	  assert.deepEqual(xhrCalls[0].config.headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'uses headers from message');
	  assert.equal(xhrCalls[0].config.body, challengeElement, 'sends the challenge element');
	  assert.equal(xhrCalls[0].config.method, 'post', 'request is a post');
	  assert.equal(xhrCalls[0].config.responseType, 'arraybuffer', 'responseType is an arraybuffer');
	  assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	  const response = {
	    body: stringToArrayBuffer('key value')
	  };
	  xhrCalls[0].callback('an error', response, response.body);
	  assert.equal(callCounts.licenseRequestAttempts, 1, 'license request event triggered');
	  assert.equal(errorMessage, 'Unable to request key from url: provided-url', 'triggers mskeyerror on event bus when callback has an error');
	  assert.equal(this.session.keys.length, 0, 'no key added to session');
	  xhrCalls[0].callback(null, response, response.body);
	  assert.equal(callCounts.licenseRequestAttempts, 2, 'second license request event triggered');
	  assert.equal(this.session.keys.length, 1, 'key added to session');
	  assert.deepEqual(this.session.keys[0], new Uint8Array(response.body), 'correct key added to session');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('will use a custom getLicense method if one is provided', function (assert) {
	  let callCount = 0;
	  msPrefixed({
	    video: this.video,
	    initData: '',
	    options: {
	      keySystems: {
	        'com.microsoft.playready': {
	          getLicense() {
	            callCount++;
	          }

	        }
	      }
	    },
	    eventBus: getMockEventBus()
	  });
	  const buffer = createMessageBuffer([{
	    name: 'Content-Type',
	    value: 'text/xml; charset=utf-8'
	  }, {
	    name: 'SOAPAction',
	    value: '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }]);
	  this.session.trigger({
	    type: 'mskeymessage',
	    destinationURL: 'destination-url',
	    message: {
	      buffer
	    }
	  });
	  assert.equal(callCount, 1, 'getLicense was called');
	});
	QUnit__default["default"].test('createSession triggers keysessioncreated', function (assert) {
	  const addEventListener = () => {};

	  const video = {
	    msKeys: {
	      createSession: () => {
	        return {
	          addEventListener
	        };
	      }
	    }
	  };
	  const eventBus = getMockEventBus();
	  createSession(video, '', {}, eventBus);
	  assert.equal(eventBus.calls.length, 1, 'one event triggered');
	  assert.equal(eventBus.calls[0].type, 'keysessioncreated', 'triggered keysessioncreated event');
	  assert.deepEqual(eventBus.calls[0].keySession, {
	    addEventListener
	  }, 'keysessioncreated payload');
	});

	QUnit__default["default"].module('utils');
	QUnit__default["default"].test('arrayBuffersEqual checks if two array buffers are equal', function (assert) {
	  assert.ok(arrayBuffersEqual(new ArrayBuffer(3), new ArrayBuffer(3)), 'same size empty array buffers are equal');
	  assert.notOk(arrayBuffersEqual(new ArrayBuffer(2), new ArrayBuffer(3)), 'different size empty array buffers are not equal');
	  const arrayBuffer = new ArrayBuffer(10);
	  assert.ok(arrayBuffersEqual(arrayBuffer, arrayBuffer), 'same array buffer is equal');
	  assert.ok(arrayBuffersEqual(new Uint8Array([1, 2, 3]).buffer, new Uint8Array([1, 2, 3]).buffer), 'array buffers with same content are equal');
	  assert.notOk(arrayBuffersEqual(new Uint8Array([1, 2, 3]).buffer, new Uint8Array([1, 2, 4]).buffer), 'array buffers with different content are not equal');
	  assert.notOk(arrayBuffersEqual(new Uint8Array([1, 2, 3]).buffer, new Uint8Array([1, 2]).buffer), 'array buffers with different content lengths are not equal');
	});
	QUnit__default["default"].test('arrayBufferFrom returns buffer from typed arrays', function (assert) {
	  const uint8Array = new Uint8Array([1, 2, 3]);
	  let buffer = arrayBufferFrom(uint8Array);
	  assert.ok(buffer instanceof ArrayBuffer, 'returned an ArrayBuffer');
	  assert.equal(buffer, uint8Array.buffer, 'buffer is the Uint8Array\'s buffer');
	  const uint16Array = new Uint16Array([4, 5, 6]);
	  buffer = arrayBufferFrom(uint16Array);
	  assert.ok(buffer instanceof ArrayBuffer, 'returned an ArrayBuffer');
	  assert.equal(buffer, uint16Array.buffer, 'buffer is the Uint16Array\'s buffer');
	  buffer = arrayBufferFrom(buffer);
	  assert.ok(buffer instanceof ArrayBuffer, 'buffer is still an ArrayBuffer');
	  assert.equal(buffer, uint16Array.buffer, 'buffer is the same buffer');
	});
	QUnit__default["default"].test('mergeAndRemoveNull removes property if value is null', function (assert) {
	  const object1 = {
	    a: 'a',
	    b: 'b',
	    c: 'c'
	  };
	  const object2 = {
	    a: 'A',
	    b: null
	  };
	  const resultObj = mergeAndRemoveNull(object1, object2);
	  assert.deepEqual(resultObj, {
	    a: 'A',
	    c: 'c'
	  }, 'successfully merged and removed null property');
	});
	QUnit__default["default"].test('getMediaKeySystemConfigurations returns MediaKeySystemConfiguration array', function (assert) {
	  const config = getMediaKeySystemConfigurations({
	    'com.widevine.alpha': {
	      audioContentType: 'audio/mp4; codecs="mp4a.40.2"',
	      audioRobustness: 'SW_SECURE_CRYPTO',
	      videoContentType: 'video/mp4; codecs="avc1.42E01E"',
	      videoRobustness: 'SW_SECURE_CRYPTO'
	    }
	  });
	  const expectedConfig = [{
	    audioCapabilities: [{
	      contentType: 'audio/mp4; codecs=\"mp4a.40.2\"',
	      robustness: 'SW_SECURE_CRYPTO'
	    }],
	    videoCapabilities: [{
	      contentType: 'video/mp4; codecs=\"avc1.42E01E\"',
	      robustness: 'SW_SECURE_CRYPTO'
	    }]
	  }];
	  assert.deepEqual(config, expectedConfig, 'getMediaKeysystemConfigurations returns expected values');
	});

	QUnit__default["default"].module('videojs-contrib-eme fairplay', {
	  beforeEach() {
	    this.origXhr = videojs__default["default"].xhr;

	    videojs__default["default"].xhr = (params, callback) => {
	      return callback(null, {
	        statusCode: 200
	      }, new Uint8Array([0, 1, 2, 3]).buffer);
	    };
	  },

	  afterEach() {
	    videojs__default["default"].xhr = this.origXhr;
	  }

	});
	QUnit__default["default"].test('lifecycle', function (assert) {
	  assert.expect(23);
	  const done = assert.async();
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const callbacks = {};
	  const callCounts = {
	    getCertificate: 0,
	    getLicense: 0,
	    updateKeySession: 0,
	    createSession: 0,
	    licenseRequestAttempts: 0
	  };

	  const getCertificate = (emeOptions, callback) => {
	    callCounts.getCertificate++;
	    callbacks.getCertificate = callback;
	  };

	  const getLicense = (emeOptions, contentId, keyMessage, callback) => {
	    callCounts.getLicense++;
	    callbacks.getLicense = callback;
	  };

	  const options = {
	    keySystems: {
	      'com.apple.fps.1_0': {
	        getCertificate,
	        getLicense,
	        // not needed due to mocking
	        getContentId: () => 'some content id'
	      }
	    }
	  };
	  const eventBus = {
	    trigger: event => {
	      if (event.type === 'licenserequestattempted') {
	        callCounts.licenseRequestAttempts++;
	      }
	    },
	    isDisposed: () => {
	      return false;
	    }
	  }; // trap event listeners

	  const keySessionEventListeners = {};

	  const updateKeySession = key => {
	    callCounts.updateKeySession++;
	  };

	  let onKeySessionCreated;

	  const createSession = (type, concatenatedData) => {
	    callCounts.createSession++;
	    return {
	      addEventListener: (name, callback) => {
	        keySessionEventListeners[name] = callback;

	        if (name === 'webkitkeyerror') {
	          // Since we don't have a way of executing code at the end of addKey's promise,
	          // we assume that adding the listener for webkitkeyerror is the last run code
	          // within the promise.
	          onKeySessionCreated();
	        }
	      },
	      update: updateKeySession
	    };
	  }; // mock webkitKeys to avoid browser specific calls and enable us to verify ordering


	  const video = {
	    webkitKeys: {
	      createSession
	    }
	  };
	  fairplay({
	    video,
	    initData,
	    options,
	    eventBus
	  }).then(() => {
	    done();
	  }); // Step 1: getCertificate

	  assert.equal(callCounts.getCertificate, 1, 'getCertificate has been called');
	  assert.equal(callCounts.createSession, 0, 'a key session has not been created');
	  assert.equal(callCounts.getLicense, 0, 'getLicense has not been called');
	  assert.equal(callCounts.updateKeySession, 0, 'updateKeySession has not been called');
	  assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	  callbacks.getCertificate(null, new Uint16Array([4, 5, 6, 7]).buffer);

	  onKeySessionCreated = () => {
	    // Step 2: create a key session
	    assert.equal(callCounts.getCertificate, 1, 'getCertificate has been called');
	    assert.equal(callCounts.createSession, 1, 'a key session has been created');
	    assert.equal(callCounts.getLicense, 0, 'getLicense has not been called');
	    assert.equal(callCounts.updateKeySession, 0, 'updateKeySession has not been called');
	    assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	    assert.ok(keySessionEventListeners.webkitkeymessage, 'added an event listener for webkitkeymessage');
	    assert.ok(keySessionEventListeners.webkitkeyadded, 'added an event listener for webkitkeyadded');
	    assert.ok(keySessionEventListeners.webkitkeyerror, 'added an event listener for webkitkeyerror');
	    keySessionEventListeners.webkitkeymessage({}); // Step 3: get the key on webkitkeymessage

	    assert.equal(callCounts.getCertificate, 1, 'getCertificate has been called');
	    assert.equal(callCounts.createSession, 1, 'a key session has been created');
	    assert.equal(callCounts.getLicense, 1, 'getLicense has been called');
	    assert.equal(callCounts.updateKeySession, 0, 'updateKeySession has not been called');
	    assert.equal(callCounts.licenseRequestAttempts, 0, 'license request event not triggered (since no callback yet)');
	    callbacks.getLicense(null, []); // Step 4: update the key session with the key

	    assert.equal(callCounts.getCertificate, 1, 'getCertificate has been called');
	    assert.equal(callCounts.createSession, 1, 'a key session has been created');
	    assert.equal(callCounts.getLicense, 1, 'getLicense has been called');
	    assert.equal(callCounts.updateKeySession, 1, 'updateKeySession has been called');
	    assert.equal(callCounts.licenseRequestAttempts, 1, 'license request event triggered');
	    keySessionEventListeners.webkitkeyadded();
	  };
	});
	QUnit__default["default"].test('error in getCertificate rejects promise', function (assert) {
	  const keySystems = {};
	  const done = assert.async(1);

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToSetServerCertificate, 'errorType is expected value');
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {
	    getCertificate: (options, callback) => {
	      callback('error in getCertificate');
	    }
	  };
	  fairplay({
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'error in getCertificate', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('error in WebKitMediaKeys rejects promise', function (assert) {
	  const keySystems = {};
	  const done = assert.async(1);
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const video = {
	    webkitSetMediaKeys: () => {}
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'errorType is expected value');
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  window_1.WebKitMediaKeys = () => {
	    throw new Error('unsupported keySystem');
	  };

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {};
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'Could not create MediaKeys', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('error in webkitSetMediaKeys rejects promise', function (assert) {
	  const keySystems = {};
	  const done = assert.async(1);
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const video = {
	    webkitSetMediaKeys: () => {
	      throw new Error('MediaKeys unusable');
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeys, 'errorType is expected value');
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  window_1.WebKitMediaKeys = function () {};

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {};
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'Could not create MediaKeys', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('error in webkitKeys.createSession rejects promise', function (assert) {
	  const keySystems = {};
	  const done = assert.async(1);
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const video = {
	    webkitSetMediaKeys: () => {
	      video.webkitKeys = {
	        createSession: () => {
	          throw new Error('invalid mimeType or initData');
	        }
	      };
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToCreateMediaKeySession, 'errorType is expected value');
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  window_1.WebKitMediaKeys = function () {};

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {};
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'Could not create key session', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('error in getLicense rejects promise', function (assert) {
	  const keySystems = {};
	  const done = assert.async(1);
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const video = {
	    webkitSetMediaKeys: () => {
	      video.webkitKeys = {
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              if (event === 'webkitkeymessage') {
	                callback({
	                  message: 'whatever'
	                });
	              }
	            }
	          };
	        }
	      };
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  window_1.WebKitMediaKeys = function () {};

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {
	    getLicense: (options, contentId, message, callback) => {
	      callback('error in getLicense');
	    }
	  };
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'error in getLicense', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('keysessioncreated fired on key session created', function (assert) {
	  const keySystems = {};
	  const done = assert.async();
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  let sessionCreated = false;

	  const addEventListener = () => {};

	  const video = {
	    webkitSetMediaKeys: () => {
	      video.webkitKeys = {
	        createSession: () => {
	          sessionCreated = true;
	          return {
	            addEventListener
	          };
	        }
	      };
	    }
	  };
	  const eventBus = {
	    trigger: event => {
	      if (event.type === 'keysessioncreated') {
	        assert.ok(sessionCreated, 'keysessioncreated fired after session created');
	        assert.deepEqual(event.keySession, {
	          addEventListener
	        }, 'keySession payload passed with event');
	        done();
	      }
	    },
	    isDisposed: () => {
	      return false;
	    }
	  };

	  window_1.WebKitMediaKeys = function () {};

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {
	    licenseUri: 'some-url',
	    certificateUri: 'some-other-url'
	  };
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus
	  });
	});
	QUnit__default["default"].test('a webkitkeyerror rejects promise', function (assert) {
	  let keySession;
	  const keySystems = {};
	  const done = assert.async(1);
	  const initData = new Uint8Array([1, 2, 3, 4]).buffer;
	  const video = {
	    webkitSetMediaKeys: () => {
	      video.webkitKeys = {
	        createSession: () => {
	          return {
	            addEventListener: (event, callback) => {
	              if (event === 'webkitkeyerror') {
	                callback('webkitkeyerror');
	              }
	            },
	            error: {
	              code: 0,
	              systemCode: 1
	            }
	          };
	        }
	      };
	    }
	  };

	  const emeError = (_, metadata) => {
	    assert.equal(metadata.errorType, videojs__default["default"].Error.EMEFailedToUpdateSessionWithReceivedLicenseKeys, 'errorType is expected value');
	    assert.equal(metadata.keySystem, LEGACY_FAIRPLAY_KEY_SYSTEM, 'keySystem is expected value');
	  };

	  window_1.WebKitMediaKeys = function () {};

	  keySystems[LEGACY_FAIRPLAY_KEY_SYSTEM] = {
	    getLicense: (options, contentId, message, callback) => {
	      callback(null);
	      keySession.trigger('webkitkeyerror');
	    }
	  };
	  fairplay({
	    video,
	    initData,
	    options: {
	      keySystems
	    },
	    eventBus: getMockEventBus(),
	    emeError
	  }).catch(err => {
	    assert.equal(err, 'KeySession error: code 0, systemCode 1', 'message is good');
	    done();
	  });
	});
	QUnit__default["default"].test('emeHeaders sent with license and certificate requests', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const emeOptions = {
	    emeHeaders: {
	      'Some-Header': 'some-header-value'
	    }
	  };
	  const fairplayOptions = {
	    licenseUri: 'some-url',
	    certificateUri: 'some-other-url'
	  };
	  const xhrCalls = [];

	  videojs__default["default"].xhr = xhrOptions => {
	    xhrCalls.push(xhrOptions);
	  };

	  const getLicense = defaultGetLicense$1('', fairplayOptions);
	  const getCertificate = defaultGetCertificate('', fairplayOptions);
	  getLicense(emeOptions, 'contentId');
	  getCertificate(emeOptions);
	  assert.equal(xhrCalls.length, 2, 'made two XHR requests');
	  assert.deepEqual(xhrCalls[0], {
	    uri: 'some-url',
	    method: 'POST',
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: '',
	      contentId: 'contentId'
	    },
	    body: undefined,
	    headers: {
	      'Content-type': 'application/octet-stream',
	      'Some-Header': 'some-header-value'
	    }
	  }, 'made license request with proper emeHeaders value');
	  assert.deepEqual(xhrCalls[1], {
	    uri: 'some-other-url',
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: ''
	    },
	    headers: {
	      'Some-Header': 'some-header-value'
	    }
	  }, 'made certificate request with proper emeHeaders value');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('licenseHeaders and certificateHeaders properties override emeHeaders value', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const emeOptions = {
	    emeHeaders: {
	      'Some-Header': 'some-header-value'
	    }
	  };
	  const fairplayOptions = {
	    licenseUri: 'some-url',
	    certificateUri: 'some-other-url',
	    licenseHeaders: {
	      'Some-Header': 'higher-priority-license-header'
	    },
	    certificateHeaders: {
	      'Some-Header': 'higher-priority-cert-header'
	    }
	  };
	  const xhrCalls = [];

	  videojs__default["default"].xhr = xhrOptions => {
	    xhrCalls.push(xhrOptions);
	  };

	  const getLicense = defaultGetLicense$1('', fairplayOptions);
	  const getCertificate = defaultGetCertificate('', fairplayOptions);
	  getLicense(emeOptions, 'contentId');
	  getCertificate(emeOptions);
	  assert.equal(xhrCalls.length, 2, 'made two XHR requests');
	  assert.deepEqual(xhrCalls[0], {
	    uri: 'some-url',
	    method: 'POST',
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: '',
	      contentId: 'contentId'
	    },
	    body: undefined,
	    headers: {
	      'Content-type': 'application/octet-stream',
	      'Some-Header': 'higher-priority-license-header'
	    }
	  }, 'made license request with proper licenseHeaders value');
	  assert.deepEqual(xhrCalls[1], {
	    uri: 'some-other-url',
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: ''
	    },
	    headers: {
	      'Some-Header': 'higher-priority-cert-header'
	    }
	  }, 'made certificate request with proper certificateHeaders value');
	  videojs__default["default"].xhr = origXhr;
	});

	QUnit__default["default"].module('playready');
	QUnit__default["default"].test('getMessageContents parses message contents', function (assert) {
	  const {
	    headers,
	    message
	  } = getMessageContents(createMessageBuffer());
	  assert.deepEqual(headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'parses headers');
	  assert.deepEqual(message, challengeElement, 'parses challenge element');
	});
	QUnit__default["default"].test('getMessageContents parses utf-8 contents', function (assert) {
	  const encoder = new TextEncoder();
	  const encodedMessageData = encoder.encode(unwrappedPlayreadyMessage);
	  const {
	    headers,
	    message
	  } = getMessageContents(encodedMessageData);
	  assert.deepEqual(headers, {
	    'Content-Type': 'text/xml; charset=utf-8',
	    'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"'
	  }, 'parses headers');
	  assert.deepEqual(message, encodedMessageData, 'parses challenge element');
	});
	QUnit__default["default"].test('emeHeaders sent with license requests', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const emeOptions = {
	    emeHeaders: {
	      'Some-Header': 'some-header-value'
	    }
	  };
	  const keySystemOptions = {
	    url: 'some-url',
	    licenseHeaders: {}
	  };
	  const xhrCalls = [];

	  videojs__default["default"].xhr = xhrOptions => {
	    xhrCalls.push(xhrOptions);
	  };

	  requestPlayreadyLicense('com.microsoft.playready', keySystemOptions, createMessageBuffer(), emeOptions);
	  assert.equal(xhrCalls.length, 1, 'made one XHR');
	  assert.deepEqual(xhrCalls[0], {
	    uri: 'some-url',
	    method: 'post',
	    headers: {
	      'Content-Type': 'text/xml; charset=utf-8',
	      'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"',
	      'Some-Header': 'some-header-value'
	    },
	    body: challengeElement,
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: 'com.microsoft.playready'
	    }
	  }, 'license request sent with correct headers');
	  videojs__default["default"].xhr = origXhr;
	});
	QUnit__default["default"].test('licenseHeaders property overrides emeHeaders', function (assert) {
	  const origXhr = videojs__default["default"].xhr;
	  const emeOptions = {
	    emeHeaders: {
	      'Some-Header': 'some-header-value'
	    }
	  };
	  const keySystemOptions = {
	    url: 'some-url',
	    licenseHeaders: {
	      'Some-Header': 'priority-header-value'
	    }
	  };
	  const xhrCalls = [];

	  videojs__default["default"].xhr = xhrOptions => {
	    xhrCalls.push(xhrOptions);
	  };

	  requestPlayreadyLicense('com.microsoft.playready', keySystemOptions, createMessageBuffer(), emeOptions);
	  assert.equal(xhrCalls.length, 1, 'made one XHR');
	  assert.deepEqual(xhrCalls[0], {
	    uri: 'some-url',
	    method: 'post',
	    headers: {
	      'Content-Type': 'text/xml; charset=utf-8',
	      'SOAPAction': '"http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense"',
	      'Some-Header': 'priority-header-value'
	    },
	    body: challengeElement,
	    responseType: 'arraybuffer',
	    requestType: 'license',
	    metadata: {
	      keySystem: 'com.microsoft.playready'
	    }
	  }, 'license request sent with correct headers');
	  videojs__default["default"].xhr = origXhr;
	});

})(QUnit, videojs, sinon);
